# This script is not intended to be executed directly.  It is sourced by test-runner.sh and most functions you see here are defined in test-tools.sh
# The variables EXENAME, EXEBASE, OKDIR, and EXEDIR are defined externally.

beginTestBlock  # Begin a group of tests.

runMake -r @EXE EnergyPlot  # run `make` for the main exe and any other listed programs

EXT=.ct  # set extension for @OKFILE and @OUTFILE placeholders (defaults for runDiff)

# Test bifold_without_options.
runFullTest 'without_options'  $DOUBLESEQ @OUT.ct

# Test bifold_dna_option.
runFullTest 'dna_option'  $DOUBLESEQ @OUT.ct -d

# Test bifold_intramolecular_option.
runFullTest 'intramolecular_option'  $DOUBLESEQ @OUT.ct -i

# Test bifold_loop_option.
runFullTest 'loop_option'  $DOUBLESEQ @OUT.ct -l 5

# Test bifold_max_structures_option.
runFullTest 'max_structures_option'  $DOUBLESEQ @OUT.ct -m 2

# Test bifold_percent_difference_option.
runFullTest 'percent_difference_option'  $DOUBLESEQ @OUT.ct -p 1

SAV_FILE=${EXEBASE}_sav_plot.fsv # Define temp folding sav file.

# Test bifold_save_file_option.
runFullTest 'save_file_option'  $DOUBLESEQ @OUT.ct -s $SAV_FILE

# Test bifold_sav_plot (The save plot generated by the save file option).
initTest 'sav_plot' && { # skip this block if the test is excluded.
  [[ -f $SAV_FILE ]] || runTest @EXE $DOUBLESEQ @OUT.ct -s $SAV_FILE # Create the save file (just in case the previous test was excluded etc)
  runTest EnergyPlot $SAV_FILE @OUT.ps
  addTestOuput $SAV_FILE # mark this file as test output (for proper cleanup)
  replaceInFiles "$SAV_FILE" "[FILENAME]" @OUT.ps # replaces bifold_sav_plot.fsv or bifold-smp_sav_plot.fsv with just "[FILENAME]" so that -smp and serial output is identical.
  runDiff @OUT.ps @OKDIR/bifold_sav_plot.ps
endTest; }

# Test bifold_temperature_option.
runFullTest 'temperature_option'  $DOUBLESEQ @OUT.ct -t 250

# Test bifold_window_size_option.
runFullTest 'window_size_option'  $DOUBLESEQ @OUT.ct -w 20

endTestBlock # End a group of tests. Also cleans up orphaned files etc.
