# This script processes RNA.i to find all of the %included c++ header files (.h).
# It then parses each header to make a list of all functions that have default arguments.
# Then for each one, SWIG instructions are created so that ONLY the version with ALL
# arguments is used. This is done mainly to keep the swig files cleaner.

swigInput="$1"
relativeDir=$(dirname "$1")

echo '// ***** DO NOT EDIT THIS FILE. **** '
echo '// This file is generated by a script (remove-default-args.sh) and will be overwritten.'
echo '// This file includes instructions so that SWIG does not create wrappers for functions with default arguments.'
echo '// Only the overload containing all arguments is wrapped.'

IFS=$'\n' files=( $(perl -ne 's/\s*%include\s*"([^"]+\.h)"/\1/ and print "$1\n"' "$swigInput") )
for f in "${files[@]}"; do
    # s/^[^\/]*\s(\w+\s*\([^;]+=[^;]+\)\s*;.*)/\1/  - A regex used to search each line in the file.
    # s/         (                           )/\1/  - If the regex matches, store the section matched by the pattern inside parentheses as "$1" for use in the subsequent code.
    #   ^[^\/]*\s                                   - Do not allow slashes (/) to preceed the function name
    #             \w+\s*\(                          - Find a function name (containing only letters, numbers and underscore) followed by optional whitespace and an open parens
    #                     [^;]+=[^;]+               - Find X=Y anywhere inside the function arguments. No not allow semicolons inside the function arguments.
    #                                \)\s*;.*       - The arguments must be followed by a close parens, optional whitepsace, and a semicolon. Other characters (e.g. comments) can follow the function def. 
    perl -ne 'if (s/^[^\/]*\s(\w+\s*\([^();]+=[^;()]+\)\s*;)\s*(?:\/.*)?/\1/) {  
        $s=$1;
        print "%ignore $s\n"; 
        $s=~s/\s*=[^,)]+//g; 
        print "%rename(\"%s\") $s\n"; 
    }' "$relativeDir/$f"
done
