/* Generated By:JavaCC: Do not edit this line. ParseException.java Version 6.0 */
/* JavaCCOptions:KEEP_LINE_COL=null */
 package ur_rna.GUITester.ScriptParser;

import static ur_rna.Utilities.Strings.escapeStringLiteral;

/**
 * This exception is thrown when parse errors are encountered.
 * You can explicitly create objects of this exception type by
 * calling the method generateParseException in the generated
 * parser.
 * <p>
 * You can modify this class to customize your error reporting
 * mechanisms so long as you retain the public fields.
 */
public class ParseException extends Exception {
    /**
     * The version identifier for this Serializable class.
     * Increment only if the <i>serialized</i> form of the
     * class changes.
     */
    private static final long serialVersionUID = 1L;
    /**
     * The end of line string for this machine.
     */
    protected static String EOL = System.getProperty("line.separator", "\n");

    /**
     * This constructor is used by the method "generateParseException"
     * in the generated parser.  Calling this constructor generates
     * a new object of this type with the fields "currentToken",
     * "expectedTokenSequences", and "tokenImage" set.
     */
    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(buildMessage(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
        currentToken = currentTokenVal;
        expectedTokenSequences = expectedTokenSequencesVal;
        tokenImage = tokenImageVal;
    }

    /**
     * The following constructors are for use by you for whatever
     * purpose you can think of.  Constructing the exception in this
     * manner makes the exception behave in the normal way - i.e., as
     * documented in the class "Throwable".  The fields "errorToken",
     * "expectedTokenSequences", and "tokenImage" do not contain
     * relevant information.  The JavaCC generated code does not use
     * these constructors.
     */

    public ParseException() {
        super();
    }

    /** Constructor with message. */
    public ParseException(String message) {
        super(message);
    }

    /** Constructor with message. */
    public ParseException(String message, Throwable cause) {
        super(message, cause);
    }



    /**
     * This is the last token that has been consumed successfully.  If
     * this object has been created due to a parse error, the token
     * followng this token will (therefore) be the first error token.
     */
    public Token currentToken;

    /**
     * Each entry in this array is an array of integers.  Each array
     * of integers represents a sequence of tokens (by their ordinal
     * values) that is expected at this point of the parse.
     */
    public int[][] expectedTokenSequences;

    /**
     * This is a reference to the "tokenImage" array of the generated
     * parser within which the parse error occurred.  This array is
     * defined in the generated ...Constants interface.
     */
    public String[] tokenImage;

    /**
     * It uses "currentToken" and "expectedTokenSequences" to generate a parse
     * error message and returns it.  If this object has been created
     * due to a parse error, and you do not catch it (it gets thrown
     * from the parser) the correct error message
     * gets displayed.
     */
    private static String buildMessage(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        String eol = System.getProperty("line.separator", "\n");
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        for (int i = 0; i < expectedTokenSequences.length; i++) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            for (int j = 0; j < expectedTokenSequences[i].length; j++) {
                expected.append(tokenImage[expectedTokenSequences[i][j]]).append(' ');
            }
            if (expectedTokenSequences[i][expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(eol).append("    ");
        }

        StringBuilder sb = new StringBuilder();
        sb.append("Encountered \"");
        Token tok = currentToken.next;
        for (int i = 0; i < maxSize; i++) {
            if (i != 0) sb.append(" ");
            if (tok.kind == 0) {
                sb.append(tokenImage[0]);
                break;
            }
            sb.append(" " + tokenImage[tok.kind]);
            sb.append(" \"");
            sb.append(escapeStringLiteral(tok.image));
            sb.append(" \"");
            tok = tok.next;
        }
        sb.append("\" at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn);
        sb.append("." + eol);
        if (expectedTokenSequences.length == 1) {
            sb.append("Was expecting:" + eol + "    ");
        } else {
            sb.append("Was expecting one of:" + eol + "    ");
        }
        sb.append(expected);
        return sb.toString();
    }
}
