/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;

public class JFlatButton
extends JButton {
    private String link;
    private URI linkURI;

    public JFlatButton(Icon icon) {
        super(icon);
        this.makeFlat();
    }

    public JFlatButton(String string) {
        super(string);
        this.makeFlat();
    }

    public JFlatButton(Action action) {
        super(action);
        this.makeFlat();
    }

    public JFlatButton(String string, Icon icon) {
        super(string, icon);
        this.makeFlat();
    }

    public JFlatButton() {
        this.makeFlat();
    }

    private void makeFlat() {
        this.setFocusPainted(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setOpaque(false);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.linkURI != null) {
            try {
                Desktop.getDesktop().browse(this.linkURI);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        super.fireActionPerformed(actionEvent);
    }

    public void setLink(String string) {
        this.link = string;
        try {
            this.linkURI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.linkURI = null;
        }
    }

    public String getLink() {
        return this.link;
    }

    public URI getLinkUri() {
        return this.linkURI;
    }

    public void setLinkUri(URI uRI) {
        this.linkURI = uRI;
        this.link = uRI.toString();
    }
}

