/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;

public class FileDialog
extends JFileChooser {
    private static final String DEFAULT_CONTEXT = "(default)";
    public static final String PREFS = "recent-file-locations";
    private static FileFilter lastChosenFilter;
    private boolean fileShouldExist;
    private boolean isCurDirSet;
    private String context;
    private static HashMap<String, File> recentDirs;
    private boolean modifyDir = true;
    private static Preferences recentPathPreferences;
    private Component owner;

    public static void loadRecentPaths() {
        FileDialog.loadRecentPaths(null);
    }

    public static void loadRecentPaths(Preferences preferences) {
        try {
            if (preferences == null) {
                preferences = FileDialog.getDefaultPreferenceStorage();
            }
            Preferences preferences2 = recentPathPreferences = preferences;
            if (recentDirs == null) {
                recentDirs = new HashMap();
            } else {
                recentDirs.clear();
            }
            for (String string : preferences2.keys()) {
                FileDialog.setRecentDir(string, preferences2.get(string, null));
            }
            if (FileDialog.getRecentDir(null, true) == null) {
                FileDialog.setRecentDir(null, PathTools.getHomeDir());
            }
        }
        catch (BackingStoreException backingStoreException) {
            AppLog.getDefault().error("Failed to load recent paths.", backingStoreException);
        }
    }

    public static void saveRecentPaths() {
        FileDialog.saveRecentPaths(recentPathPreferences);
    }

    public static void saveRecentPaths(Preferences preferences) {
        try {
            if (preferences == null) {
                preferences = FileDialog.getDefaultPreferenceStorage();
            }
            for (String string : recentDirs.keySet()) {
                File file = recentDirs.get(string);
                if (file == null) continue;
                preferences.put(string, file.toString());
            }
            preferences.flush();
        }
        catch (Exception exception) {
            AppLog.getDefault().error("Failed to save recent paths.", exception);
        }
    }

    private static Preferences getDefaultPreferenceStorage() {
        return Preferences.userNodeForPackage(FileDialog.class).node(PREFS);
    }

    public static File getRecentDir(String string) {
        return FileDialog.getRecentDir(string, false, null);
    }

    public static File getRecentDirOrDefault(String string, boolean bl) {
        return FileDialog.getRecentDir(string, bl, recentDirs.get(DEFAULT_CONTEXT));
    }

    public static File getRecentDir(String string, boolean bl) {
        return FileDialog.getRecentDir(string, bl, null);
    }

    public static File getRecentDir(String string, boolean bl, File file) {
        File file2;
        if (recentDirs == null) {
            FileDialog.loadRecentPaths();
        }
        if (Strings.isEmpty(string)) {
            string = DEFAULT_CONTEXT;
        }
        if ((file2 = recentDirs.get(string)) == null || bl && !file2.exists()) {
            return file;
        }
        return file2;
    }

    public static void setRecentDir(String string, String string2) {
        FileDialog.setRecentDir(string, PathTools.fileFromPath(string2));
    }

    public static void setRecentDir(String string, File file) {
        if (recentDirs == null) {
            FileDialog.loadRecentPaths();
        }
        if (Strings.isEmpty(string)) {
            string = DEFAULT_CONTEXT;
        }
        if (file == null && !string.equals(DEFAULT_CONTEXT)) {
            recentDirs.remove(string);
        } else {
            recentDirs.put(string, file);
        }
        FileDialog.saveRecentPaths();
    }

    public FileDialog() {
        this(2, null, null);
    }

    public FileDialog(boolean bl, String string, String string2) {
        this(bl ? 1 : 0, string, string2);
    }

    public FileDialog(int n, String string, String string2) {
        super.addPropertyChangeListener("fileFilterChanged", propertyChangeEvent -> this.filterChanged(propertyChangeEvent));
        super.setDialogType(n);
        super.setFileSelectionMode(0);
        if (string == null || string.trim().length() == 0) {
            super.setAcceptAllFileFilterUsed(true);
        } else {
            super.setAcceptAllFileFilterUsed(false);
            this.addFilters(string);
        }
        if (string2 != null && string2.length() != 0) {
            super.setDialogTitle(string2);
        }
        this.setFileShouldExist(n == 0);
    }

    private void filterChanged(PropertyChangeEvent propertyChangeEvent) {
        String[] stringArray;
        FileNameExtensionFilter fileNameExtensionFilter;
        if (this.getDialogType() != 1) {
            return;
        }
        if (!(this.getUI() instanceof BasicFileChooserUI)) {
            return;
        }
        BasicFileChooserUI basicFileChooserUI = (BasicFileChooserUI)this.getUI();
        String string = basicFileChooserUI.getFileName();
        if (Strings.isEmpty(string)) {
            return;
        }
        PathTools.FileName fileName = PathTools.parse(string);
        FileFilter fileFilter = (FileFilter)propertyChangeEvent.getNewValue();
        if (fileFilter instanceof FileNameExtensionFilter && !(fileNameExtensionFilter = (FileNameExtensionFilter)fileFilter).accept(new File(string)) && (stringArray = fileNameExtensionFilter.getExtensions()).length != 0) {
            basicFileChooserUI.setFileName(fileName.baseName() + '.' + stringArray[0]);
        }
    }

    public static File getDefaultDir() {
        return FileDialog.getRecentDir(null, true, PathTools.getHomeDir());
    }

    public static void setDefaultDir(File file) {
        FileDialog.setRecentDir(null, file);
    }

    public FileDialog setDefaultFile(String string) {
        return this.setDefaultFile(PathTools.fileFromPath(string, false));
    }

    public FileDialog setDefaultFile(File file) {
        if (file == null || file.isDirectory()) {
            this.setStartDir(file);
        } else {
            super.setSelectedFile(file);
            File file2 = file.getParentFile();
            if (file2 != null && file2.exists()) {
                this.setStartDir(file2);
            }
            this.setFilterFromFile(file);
        }
        return this;
    }

    public FileDialog setFilterIndex(int n) {
        this.setFileFilter(this.getChoosableFileFilters()[n]);
        return this;
    }

    public FileDialog setFilterFromFile(File file) {
        FileFilter fileFilter = this.findMatchingFilter(file);
        if (fileFilter != null && !fileFilter.accept(new File(""))) {
            this.setFileFilter(fileFilter);
        }
        return this;
    }

    private FileFilter findMatchingFilter(File file) {
        for (FileFilter fileFilter : super.getChoosableFileFilters()) {
            if (!fileFilter.accept(file)) continue;
            return fileFilter;
        }
        return null;
    }

    public FileDialog setFilterFromExt(String string) {
        if (string == null) {
            this.setFileFilter(null);
        } else {
            for (FileFilter fileFilter : super.getChoosableFileFilters()) {
                if (!(fileFilter instanceof FileNameExtensionFilter)) continue;
                for (String string2 : ((FileNameExtensionFilter)fileFilter).getExtensions()) {
                    if (!string.equalsIgnoreCase(string2)) continue;
                    this.setFileFilter(fileFilter);
                    return this;
                }
            }
        }
        return this;
    }

    public FileDialog setStartDir(String string) {
        return this.setStartDir(string == null ? null : new File(string));
    }

    public FileDialog setStartDir(File file) {
        this.isCurDirSet = true;
        super.setCurrentDirectory(file);
        return this;
    }

    public boolean modifyDir() {
        return this.modifyDir;
    }

    public FileDialog setModifyDir(boolean bl) {
        this.modifyDir = bl;
        return this;
    }

    public File showFileDialog(Component component) {
        int n;
        File file = FileDialog.getRecentDir(this.context, true);
        if (file == null) {
            file = this.getDialogType() == 1 ? PathTools.getHomeDir() : FileDialog.getDefaultDir();
        }
        if (!this.isCurDirSet && file != null) {
            this.setCurrentDirectory(file);
        }
        if ((n = super.showDialog(component, this.getApproveButtonText())) != 0) {
            return null;
        }
        if (this.modifyDir) {
            FileDialog.setRecentDir(this.context, this.getCurrentDirectory());
        }
        return this.getSelectedFile();
    }

    public FileDialog setContext(String string) {
        this.context = string;
        return this;
    }

    public String getContext() {
        return this.context;
    }

    public FileDialog setButtonText(String string) {
        this.setApproveButtonText(string);
        return this;
    }

    public FileDialog addFilters(String string) {
        String[] stringArray = string.split("\\|");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (string2.length() == 0) continue;
            if (string2.equals("*")) {
                super.setAcceptAllFileFilterUsed(true);
                if (stringArray.length <= i + 1 || !stringArray[i + 1].equals("*")) continue;
                ++i;
                continue;
            }
            if (stringArray.length <= ++i) {
                throw new IllegalArgumentException("Wrong number of filter components. Each filter description must have a corresponding list of extensions.\nExample: \"JPEG Image|jpg;jpeg|PNG Image|png|*\"\nAttempted: " + string);
            }
            CharSequence[] charSequenceArray = stringArray[i].split(";");
            string2 = string2 + String.format(" (*.%s)", String.join((CharSequence)", *.", charSequenceArray));
            this.addChoosableFileFilter(new FileNameExtensionFilter(string2, (String[])charSequenceArray));
        }
        return this;
    }

    public FileDialog clearFilters() {
        this.setAcceptAllFileFilterUsed(false);
        super.resetChoosableFileFilters();
        return this;
    }

    public static String getSaveName(String string, String string2, String string3, String string4, Component component) {
        return FileDialog.getSaveName(string, string2, string3, string4, component, null);
    }

    public static String getSaveName(String string, String string2, String string3, String string4, Component component, String string5) {
        return FileDialog.getFileName(true, component, string3, string2, string, string4, false, string5);
    }

    public static String getSaveName(String string) {
        return FileDialog.getSaveName(string, null);
    }

    public static String getSaveName(String string, String string2) {
        return FileDialog.getSaveName(string, string2, null, null, null);
    }

    public static String getOpenName(String string, String string2, String string3, String string4, Component component) {
        return FileDialog.getFileName(false, component, string3, string2, string, string4);
    }

    public static String getOpenName(String string) {
        return FileDialog.getOpenName(string, null);
    }

    public static String getOpenName(String string, String string2) {
        return FileDialog.getOpenName(string, string2, null, null, null);
    }

    public static String getFileName(boolean bl, Component component, String string, String string2, String string3, String string4) {
        return FileDialog.getFileName(bl, component, string, string2, string3, string4, false, null);
    }

    public static String getFileName(boolean bl, Component component, String string, String string2, String string3, String string4, boolean bl2, String string5) {
        File file;
        FileDialog fileDialog = new FileDialog(bl, string3, string);
        if (component != null) {
            fileDialog.setOwner(component);
        }
        if (string4 == null) {
            string4 = string;
        }
        if (string4 != null) {
            fileDialog.setContext(string4);
        }
        if (!Strings.isEmpty(string5)) {
            fileDialog.setFilterFromExt(string5);
        }
        if (string2 != null) {
            fileDialog.setDefaultFile(string2);
        }
        if (bl2) {
            fileDialog.setModifyDir(false);
        }
        if ((file = fileDialog.showFileDialog(component)) == null) {
            return null;
        }
        lastChosenFilter = fileDialog.getFileFilter();
        return file.getAbsolutePath();
    }

    public static FileFilter getLastChosenFilter() {
        return lastChosenFilter;
    }

    public boolean getFileShouldExist() {
        return this.fileShouldExist;
    }

    public void setFileShouldExist(boolean bl) {
        this.fileShouldExist = bl;
    }

    public String getDefaultExtension() {
        FileNameExtensionFilter fileNameExtensionFilter;
        String[] stringArray;
        FileFilter fileFilter = this.getFileFilter();
        if (fileFilter instanceof FileNameExtensionFilter && (stringArray = (fileNameExtensionFilter = (FileNameExtensionFilter)fileFilter).getExtensions()).length != 0) {
            return stringArray[0];
        }
        return "";
    }

    public boolean passesFilter(File file) {
        FileFilter fileFilter = this.getFileFilter();
        return fileFilter == null || fileFilter.accept(file);
    }

    @Override
    public File getSelectedFile() {
        File file = super.getSelectedFile();
        if (file == null || file.exists()) {
            return file;
        }
        if (!this.passesFilter(file)) {
            file = new File(file.getPath() + "." + this.getDefaultExtension());
        }
        return file;
    }

    @Override
    public void approveSelection() {
        File file = this.getSelectedFile();
        if (file == null) {
            JOptionPane.showMessageDialog(null, "Please select a file.", null, 1);
            return;
        }
        if (!file.exists() && this.getFileShouldExist()) {
            JOptionPane.showMessageDialog(null, "The specified file does not exist: \n" + file.getPath(), null, 1);
            return;
        }
        if (file.exists() && this.getDialogType() == 1) {
            int n = JOptionPane.showConfirmDialog(this, "The file exists, overwrite?\n\nDetails:\nFile: " + file.getPath(), "Existing file", 1);
            switch (n) {
                case 0: {
                    super.approveSelection();
                    return;
                }
                case 1: {
                    return;
                }
                case -1: {
                    return;
                }
                case 2: {
                    this.cancelSelection();
                    return;
                }
            }
        }
        super.approveSelection();
    }

    public void setOwner(Component component) {
        this.owner = component;
    }

    public Component getOwner() {
        return this.owner;
    }
}

