/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Component;
import java.awt.Container;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import ur_rna.Utilities.Strings;

public abstract class Components {
    public static Component[] EMPTY_COMPONENT_ARRAY = new Component[0];
    public static List<Component> EMPTY_COMPONENT_LIST = Collections.emptyList();

    public static void addAll(Container container, Component[] componentArray) {
        for (Component component : componentArray) {
            container.add(component);
        }
    }

    public static void addAll(Container container, Iterable<? extends Component> iterable) {
        for (Component component : iterable) {
            container.add(component);
        }
    }

    public static boolean isAncestor(Component component, Container container) {
        if (component == container) {
            return true;
        }
        for (Container container2 = component.getParent(); container2 != null; container2 = container2.getParent()) {
            if (container2 != container) continue;
            return true;
        }
        return false;
    }

    public static String getNameOrText(Component component) {
        String string = component.getName();
        if (!Strings.isEmpty(string)) {
            return string;
        }
        if (component instanceof AbstractButton) {
            string = ((AbstractButton)component).getText();
            if (!Strings.isEmpty(string)) {
                return string;
            }
            string = ((AbstractButton)component).getActionCommand();
            if (!Strings.isEmpty(string)) {
                return string;
            }
        }
        return null;
    }
}

