/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class ActionHelper {
    public static final int COMMAND_MODIFIER_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public static void addAction(JComponent jComponent, String string, final Consumer<ActionEvent> consumer) {
        jComponent.getActionMap().put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                consumer.accept(actionEvent);
            }
        });
    }

    public static void addKeyBinding(JComponent jComponent, char c, String string) {
        ActionHelper.addKeyBinding(jComponent, KeyStroke.getKeyStroke((int)c, COMMAND_MODIFIER_MASK), string, KeyBindFocus.Child);
    }

    public static void addKeyBinding(JComponent jComponent, int n, int n2, String string) {
        ActionHelper.addKeyBinding(jComponent, KeyStroke.getKeyStroke(n, n2), string, KeyBindFocus.Child);
    }

    public static void addKeyBinding(JComponent jComponent, KeyStroke keyStroke, String string) {
        ActionHelper.addKeyBinding(jComponent, keyStroke, string, KeyBindFocus.Child);
    }

    public static void addKeyBinding(JComponent jComponent, KeyStroke keyStroke, String string, KeyBindFocus keyBindFocus) {
        jComponent.getInputMap(keyBindFocus.value).put(keyStroke, string);
    }

    public static void addKeyAction(JComponent jComponent, KeyStroke keyStroke, String string, Consumer<ActionEvent> consumer) {
        ActionHelper.addKeyAction(jComponent, keyStroke, string, consumer, KeyBindFocus.Child);
    }

    public static void addKeyAction(JComponent jComponent, KeyStroke keyStroke, String string, Consumer<ActionEvent> consumer, KeyBindFocus keyBindFocus) {
        ActionHelper.addAction(jComponent, string, consumer);
        ActionHelper.addKeyBinding(jComponent, keyStroke, string, keyBindFocus);
    }

    public static enum KeyBindFocus {
        Self(0),
        Window(2),
        Child(1);

        public final int value;

        private KeyBindFocus(int n2) {
            this.value = n2;
        }
    }
}

