/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.geom;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Vec2D
extends Point2D.Double
implements Cloneable {
    public static final double TwoPI = Math.PI * 2;
    private static final double toStringRoundFactor = 1.0E7;

    public Vec2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vec2D() {
    }

    public Vec2D(Point2D point2D) {
        this.x = point2D.getX();
        this.y = point2D.getY();
    }

    public Vec2D(Point2D point2D, Point2D point2D2) {
        this.x = point2D2.getX() - point2D.getX();
        this.y = point2D2.getY() - point2D.getY();
    }

    public static Vec2D fromAngle(double d) {
        return new Vec2D(Math.cos(d), Math.sin(d));
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSqr() {
        return this.x * this.x + this.y * this.y;
    }

    public Vec2D add(Point2D point2D) {
        this.x += point2D.getX();
        this.y += point2D.getY();
        return this;
    }

    public Vec2D add(double d, double d2) {
        this.x += d;
        this.y += d2;
        return this;
    }

    public Vec2D addScaled(Point2D point2D, double d) {
        this.x += point2D.getX() * d;
        this.y += point2D.getY() * d;
        return this;
    }

    public Vec2D subtr(Point2D point2D) {
        this.x -= point2D.getX();
        this.y -= point2D.getY();
        return this;
    }

    public Vec2D multiply(Point2D point2D) {
        this.x *= point2D.getX();
        this.y *= point2D.getY();
        return this;
    }

    public double dot(Vec2D vec2D) {
        return this.x * vec2D.x + this.y * vec2D.y;
    }

    public double dot(Point2D point2D, Point2D point2D2) {
        return this.x * (point2D.getX() - point2D2.getX()) + this.y * (point2D.getY() - point2D2.getY());
    }

    public Vec2D negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vec2D normalize() {
        double d = this.length();
        this.x /= d;
        this.y /= d;
        return this;
    }

    public Vec2D normalize(double d, double d2) {
        double d3 = this.length();
        if (d3 < 1.0E-12) {
            this.x = d;
            this.y = d2;
        } else {
            this.x /= d3;
            this.y /= d3;
        }
        return this;
    }

    public double getAngle() {
        return Math.atan2(this.y, this.x);
    }

    public Vec2D getPointAlong(Point2D point2D, double d) {
        return this.clone().setLength(d).add(point2D);
    }

    public Vec2D getPointAlongScaled(Point2D point2D, double d) {
        return this.clone().scale(d).add(point2D);
    }

    public Point toPoint() {
        return new Point((int)this.x, (int)this.y);
    }

    public Point2D.Float toPointF() {
        return new Point2D.Float((float)this.x, (float)this.y);
    }

    public Line2D toLine() {
        return new Line2D.Double(0.0, 0.0, this.x, this.y);
    }

    public Line2D toLine(Point2D point2D) {
        return new Line2D.Double(point2D.getX(), point2D.getY(), point2D.getX() + this.x, point2D.getY() + this.y);
    }

    public Line2D toLine(Point2D point2D, double d) {
        double d2 = this.length();
        return new Line2D.Double(point2D.getX(), point2D.getY(), point2D.getX() + this.x * d / d2, point2D.getY() + this.y * d / d2);
    }

    public Vec2D scale(double d) {
        this.x *= d;
        this.y *= d;
        return this;
    }

    public Vec2D scale(double d, double d2) {
        this.x *= d;
        this.y *= d2;
        return this;
    }

    public Vec2D setLength(double d) {
        this.scale(d / this.length());
        return this;
    }

    public Vec2D transform(AffineTransform affineTransform) {
        double d = this.x * affineTransform.getScaleX() + this.y * affineTransform.getShearX() + affineTransform.getTranslateX();
        double d2 = this.y * affineTransform.getScaleY() + this.x * affineTransform.getShearY() + affineTransform.getTranslateY();
        this.x = d;
        this.y = d2;
        return this;
    }

    public Vec2D rotate90() {
        return this.setTo(-this.y, this.x);
    }

    public Vec2D rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.x;
        this.x = this.x * d2 - this.y * d3;
        this.y = d4 * d3 + this.y * d2;
        return this;
    }

    public Vec2D setTo(double d, double d2) {
        this.x = d;
        this.y = d2;
        return this;
    }

    public Vec2D setTo(Point2D point2D) {
        this.x = point2D.getX();
        this.y = point2D.getY();
        return this;
    }

    public Vec2D setTo(Vec2D vec2D) {
        this.x = vec2D.x;
        this.y = vec2D.y;
        return this;
    }

    public Vec2D getMidpoint(Point2D point2D) {
        return new Vec2D((this.x + point2D.getX()) / 2.0, (this.y + point2D.getY()) / 2.0);
    }

    public static Vec2D getMidpoint(Point2D point2D, Point2D point2D2) {
        return new Vec2D((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
    }

    public static Vec2D getPointBetween(Point2D point2D, Point2D point2D2, double d) {
        return new Vec2D(point2D.getX() + (point2D2.getX() - point2D.getX()) * d, point2D.getY() + (point2D2.getY() - point2D.getY()) * d);
    }

    public static double distance(Point2D point2D, Point2D point2D2) {
        double d = point2D.getX() - point2D2.getX();
        double d2 = point2D.getY() - point2D2.getY();
        return Math.sqrt(d * d + d2 * d2);
    }

    public static double distanceSq(Point2D point2D, Point2D point2D2) {
        double d = point2D.getX() - point2D2.getX();
        double d2 = point2D.getY() - point2D2.getY();
        return d * d + d2 * d2;
    }

    public Vec2D getAdded(Point2D point2D) {
        return this.clone().add(point2D);
    }

    public Vec2D getSubtr(Point2D point2D) {
        return this.clone().subtr(point2D);
    }

    public Vec2D getMultiplied(Point2D point2D) {
        return this.clone().multiply(point2D);
    }

    public Vec2D getNegated() {
        return this.clone().negate();
    }

    public Vec2D getNormalized() {
        return this.clone().normalize();
    }

    public Vec2D getScaled(double d) {
        return this.clone().scale(d);
    }

    public Vec2D getScaled(double d, double d2) {
        return this.clone().scale(d, d2);
    }

    public Vec2D getTransformed(AffineTransform affineTransform) {
        return this.clone().transform(affineTransform);
    }

    public Vec2D getRotated90() {
        return new Vec2D(-this.y, this.x);
    }

    public Vec2D getRotated(double d) {
        return this.clone().rotate(d);
    }

    @Override
    public Vec2D clone() {
        return (Vec2D)super.clone();
    }

    public double angleBetween(Vec2D vec2D) {
        return Math.acos(this.dot(vec2D) / Math.sqrt(this.lengthSqr() * vec2D.lengthSqr()));
    }

    public double angleTo(Vec2D vec2D) {
        double d = this.x * vec2D.x + this.y * vec2D.y;
        double d2 = this.x * vec2D.y - this.y * vec2D.x;
        return Math.atan2(d2, d);
    }

    public double arcAngleTo(Vec2D vec2D, boolean bl) {
        double d = this.angleTo(vec2D);
        if (bl && d > 0.0) {
            d -= Math.PI * 2;
        } else if (!bl && d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    public static double wrapToPI(double d) {
        return d < 0.0 ? (d + Math.PI) % (Math.PI * 2) - Math.PI : (d - Math.PI) % (Math.PI * 2) + Math.PI;
    }

    public static double wrapTo2PI(double d) {
        return Vec2D.wrapToPI(d) + Math.PI;
    }

    public static double mod2PI(double d) {
        double d2;
        return d2 < 0.0 ? d + Math.PI * 2 : (d %= Math.PI * 2);
    }

    public Vec2D projectedOn(Vec2D vec2D) {
        return vec2D.clone().scale(this.dot(vec2D) / vec2D.lengthSqr());
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + '(' + this.x + ", " + this.y + ')' + " L: " + (double)Math.round(this.length() * 1.0E7) / 1.0E7 + " \u03b8: " + (double)Math.round(this.getAngle() * 180.0 / Math.PI * 1.0E7) / 1.0E7 + ']';
    }

    public static Vec2D reflect(Point2D point2D, Vec2D vec2D, Point2D point2D2) {
        Vec2D vec2D2 = new Vec2D(point2D, point2D2);
        Vec2D vec2D3 = vec2D2.projectedOn(vec2D).scale(-2.0);
        vec2D2.scale(2.0).add(point2D);
        return vec2D2.add(vec2D3);
    }
}

