/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.Serializable;
import java.util.stream.IntStream;

public class StringBuilderEx
implements Serializable,
Appendable,
CharSequence {
    static final long serialVersionUID = 42L;
    private final StringBuilder _sb;

    public StringBuilderEx(StringBuilder stringBuilder) {
        this._sb = stringBuilder;
    }

    public StringBuilder getStringBuilder() {
        return this._sb;
    }

    public StringBuilderEx truncate(int n) {
        int n2 = this._sb.length() - n;
        this._sb.setLength(Math.max(n2, 0));
        return this;
    }

    public StringBuilderEx trimEnd(char c) {
        return this.trimEnd(c, -1);
    }

    public StringBuilderEx trimEnd(char c, int n) {
        int n2 = this._sb.length() - 1;
        if (n == 0) {
            return this;
        }
        if (n != -1) {
            n = n2 - n;
        }
        while (n2 != n && this._sb.charAt(n2) == c) {
            --n2;
        }
        if (++n2 != this._sb.length()) {
            this._sb.setLength(n2);
        }
        return this;
    }

    public StringBuilderEx trimEnd(char ... cArray) {
        return this.trimEnd(cArray, -1);
    }

    public StringBuilderEx trimEnd(char[] cArray, int n) {
        int n2 = this._sb.length();
        int n3 = cArray.length;
        if (n3 == 0 || n == 0) {
            return this;
        }
        if (n != -1) {
            n = n2 - n;
        }
        block0: while (--n2 != n) {
            char c = this._sb.charAt(n2);
            for (int i = n3; i >= 0; --i) {
                if (c == cArray[i]) continue block0;
            }
        }
        if (++n2 != this._sb.length()) {
            this._sb.setLength(n2);
        }
        return this;
    }

    public StringBuilderEx appendIfEmpty(String string) {
        if (this._sb.length() == 0) {
            this._sb.append(string);
        }
        return this;
    }

    public StringBuilderEx appendIfNotEmpty(String string) {
        if (this._sb.length() > 0) {
            this._sb.append(string);
        }
        return this;
    }

    public StringBuilderEx appendSeparator(String string) {
        if (this._sb.length() != 0 && !this.endsWith(string)) {
            this._sb.append(string);
        }
        return this;
    }

    public boolean startsWith(String string) {
        return this.endsWith(string, false);
    }

    public boolean startsWith(String string, boolean bl) {
        int n;
        int n2 = this._sb.length();
        return n2 > (n = string.length() - 1) && (bl ? this._sb.substring(0, n).equalsIgnoreCase(string) : this._sb.substring(0, n).equals(string));
    }

    public boolean endsWith(String string) {
        return this.endsWith(string, false);
    }

    public boolean endsWith(String string, boolean bl) {
        int n = this._sb.length();
        int n2 = n - string.length();
        return n2 >= 0 && (bl ? this._sb.substring(n2, n - 1).equalsIgnoreCase(string) : this._sb.substring(n2, n - 1).equals(string));
    }

    public StringBuilderEx() {
        this._sb = new StringBuilder();
    }

    public StringBuilderEx(int n) {
        this._sb = new StringBuilder(n);
    }

    public StringBuilderEx(String string) {
        this._sb = new StringBuilder(string);
    }

    public StringBuilderEx(CharSequence charSequence) {
        this._sb = new StringBuilder(charSequence);
    }

    public StringBuilderEx append(float f) {
        this._sb.append(f);
        return this;
    }

    public StringBuilderEx append(Object object) {
        this._sb.append(object);
        return this;
    }

    public StringBuilderEx append(String string) {
        this._sb.append(string);
        return this;
    }

    public StringBuilderEx append(StringBuffer stringBuffer) {
        this._sb.append(stringBuffer);
        return this;
    }

    @Override
    public StringBuilderEx append(CharSequence charSequence) {
        this._sb.append(charSequence);
        return this;
    }

    @Override
    public StringBuilderEx append(CharSequence charSequence, int n, int n2) {
        this._sb.append(charSequence, n, n2);
        return this;
    }

    public StringBuilderEx append(char[] cArray) {
        this._sb.append(cArray);
        return this;
    }

    public StringBuilderEx append(char[] cArray, int n, int n2) {
        this._sb.append(cArray, n, n2);
        return this;
    }

    public StringBuilderEx append(boolean bl) {
        this._sb.append(bl);
        return this;
    }

    @Override
    public StringBuilderEx append(char c) {
        this._sb.append(c);
        return this;
    }

    public StringBuilderEx append(int n) {
        this._sb.append(n);
        return this;
    }

    public StringBuilderEx append(long l) {
        this._sb.append(l);
        return this;
    }

    public StringBuilderEx append(double d) {
        this._sb.append(d);
        return this;
    }

    public StringBuilderEx appendCodePoint(int n) {
        this._sb.appendCodePoint(n);
        return this;
    }

    public StringBuilderEx delete(int n, int n2) {
        this._sb.delete(n, n2);
        return this;
    }

    public StringBuilderEx deleteCharAt(int n) {
        this._sb.deleteCharAt(n);
        return this;
    }

    public StringBuilderEx replace(int n, int n2, String string) {
        this._sb.replace(n, n2, string);
        return this;
    }

    public StringBuilderEx insert(int n, char[] cArray, int n2, int n3) {
        this._sb.insert(n, cArray, n2, n3);
        return this;
    }

    public StringBuilderEx insert(int n, Object object) {
        this._sb.insert(n, object);
        return this;
    }

    public StringBuilderEx insert(int n, String string) {
        this._sb.insert(n, string);
        return this;
    }

    public StringBuilderEx insert(int n, char[] cArray) {
        this._sb.insert(n, cArray);
        return this;
    }

    public StringBuilderEx insert(int n, CharSequence charSequence) {
        this._sb.insert(n, charSequence);
        return this;
    }

    public StringBuilderEx insert(int n, CharSequence charSequence, int n2, int n3) {
        this._sb.insert(n, charSequence, n2, n3);
        return this;
    }

    public StringBuilderEx insert(int n, boolean bl) {
        this._sb.insert(n, bl);
        return this;
    }

    public StringBuilderEx insert(int n, char c) {
        this._sb.insert(n, c);
        return this;
    }

    public StringBuilderEx insert(int n, int n2) {
        this._sb.insert(n, n2);
        return this;
    }

    public StringBuilderEx insert(int n, long l) {
        this._sb.insert(n, l);
        return this;
    }

    public StringBuilderEx insert(int n, float f) {
        this._sb.insert(n, f);
        return this;
    }

    public StringBuilderEx insert(int n, double d) {
        this._sb.insert(n, d);
        return this;
    }

    public int indexOf(String string) {
        return this._sb.indexOf(string);
    }

    public int indexOf(String string, int n) {
        return this._sb.indexOf(string, n);
    }

    public int lastIndexOf(String string) {
        return this._sb.lastIndexOf(string);
    }

    public int lastIndexOf(String string, int n) {
        return this._sb.lastIndexOf(string, n);
    }

    public StringBuilderEx reverse() {
        this._sb.reverse();
        return this;
    }

    @Override
    public String toString() {
        return this._sb.toString();
    }

    @Override
    public int length() {
        return this._sb.length();
    }

    public int capacity() {
        return this._sb.capacity();
    }

    public void ensureCapacity(int n) {
        this._sb.ensureCapacity(n);
    }

    public void trimToSize() {
        this._sb.trimToSize();
    }

    public void setLength(int n) {
        this._sb.setLength(n);
    }

    @Override
    public char charAt(int n) {
        return this._sb.charAt(n);
    }

    public int codePointAt(int n) {
        return this._sb.codePointAt(n);
    }

    public int codePointBefore(int n) {
        return this._sb.codePointBefore(n);
    }

    public int codePointCount(int n, int n2) {
        return this._sb.codePointCount(n, n2);
    }

    public int offsetByCodePoints(int n, int n2) {
        return this._sb.offsetByCodePoints(n, n2);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        this._sb.getChars(n, n2, cArray, n3);
    }

    public void setCharAt(int n, char c) {
        this._sb.setCharAt(n, c);
    }

    public String substring(int n) {
        return this._sb.substring(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this._sb.subSequence(n, n2);
    }

    public String substring(int n, int n2) {
        return this._sb.substring(n, n2);
    }

    @Override
    public IntStream chars() {
        return this._sb.chars();
    }

    @Override
    public IntStream codePoints() {
        return this._sb.codePoints();
    }
}

