/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.awt.Component;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.Displayable;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.annotation.ToFriendlyString;

public abstract class ObjTools {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = EMPTY_STRING_ARRAY;
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final boolean[] EMPTY_BOOL_ARRAY = new boolean[0];
    public static Object MISSING = new Object();
    private static Method cloneMethod = ObjTools.getCloneMethod();

    private ObjTools() {
    }

    public static String toDisplayString(Object object) {
        String string;
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        if (object instanceof Double || object instanceof Integer) {
            return object.toString();
        }
        Class<?> clazz = object.getClass();
        String string2 = clazz.getSimpleName();
        if (object instanceof Number) {
            return object.toString() + string2.substring(0, 1).toLowerCase();
        }
        if (object instanceof Component) {
            Component component = (Component)object;
            Rectangle rectangle = component.getBounds();
            return "[GUI " + string2 + " \"" + component.getName() + "\" Bounds: (x:" + rectangle.x + ", y:" + rectangle.y + ", w:" + rectangle.width + ", h:" + rectangle.height + ") ]";
        }
        if (object instanceof Throwable) {
            return "[ERROR: " + ((Throwable)object).getMessage() + "]";
        }
        if (object == MISSING) {
            return "[MISSING]";
        }
        if (object instanceof Displayable) {
            return ((Displayable)object).toDisplayString();
        }
        Class[] classArray = new Class[]{Boolean.class};
        for (Class genericDeclaration : classArray) {
            if (!genericDeclaration.isInstance(object)) continue;
            return object.toString();
        }
        Object[] objectArray = clazz.getAnnotationsByType(ToFriendlyString.class);
        if (objectArray.length != 0) {
            ToFriendlyString toFriendlyString = (ToFriendlyString)objectArray[0];
            String string3 = toFriendlyString.method();
            if ("toString".equals(string3)) {
                return object.toString();
            }
            if (!string3.isEmpty()) {
                try {
                    Method exception = clazz.getMethod(string3, new Class[0]);
                    if (exception != null) {
                        return exception.invoke(object, new Object[0]).toString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((string = object.toString()).startsWith("[") && string.endsWith("]") || string.startsWith("{") && string.endsWith("}")) {
            return string;
        }
        return "[" + string2 + ": " + string + "]";
    }

    public static String toStr(Object object) {
        return ObjTools.toStr(object, "");
    }

    public static String toStr(Object object, String string) {
        if (object == null) {
            return string;
        }
        return object.toString();
    }

    public static boolean isSet(int n, int n2) {
        return (n2 & n) == n;
    }

    public static boolean isAnySet(int n, int n2) {
        return (n2 & n) != 0;
    }

    public static boolean asBool(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            return Strings.asBool((String)object, false);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Byte) {
            return 0 != (Byte)object;
        }
        if (object instanceof Integer) {
            return 0 != (Integer)object;
        }
        if (object instanceof Float) {
            return 0.0f != ((Float)object).floatValue();
        }
        if (object instanceof Long) {
            return 0L != (Long)object;
        }
        if (object instanceof Character) {
            return '\u0000' == ((Character)object).charValue();
        }
        if (object instanceof Array) {
            return 0 != Array.getLength(object);
        }
        return Strings.asBool(object.toString(), false);
    }

    public static <T> void copyTo(List<? extends T> list, T[] TArray) {
        ObjTools.copyTo(list, TArray, 0, list.size());
    }

    public static <T> void copyTo(List<? extends T> list, T[] TArray, int n) {
        ObjTools.copyTo(list, TArray, n, list.size());
    }

    public static <T> void copyTo(List<? extends T> list, T[] TArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            TArray[n + i] = list.get(i);
        }
    }

    public static <T> void copyTo(Collection<? extends T> collection, T[] TArray) {
        ObjTools.copyTo(collection, TArray, 0, collection.size());
    }

    public static <T> void copyTo(Collection<? extends T> collection, T[] TArray, int n) {
        ObjTools.copyTo(collection, TArray, n, collection.size());
    }

    public static <T> void copyTo(Collection<? extends T> collection, T[] TArray, int n, int n2) {
        int n3 = 0;
        for (T t : collection) {
            TArray[n + n3++] = t;
            if (n3 != n2) continue;
            break;
        }
    }

    public static <K, V, K2, V2> Map<K2, V2> mapMap(Map<K, V> map, Function<? super K, ? extends K2> function, Function<? super V, ? extends V2> function2) {
        return ObjTools.mapMapEntries(map, entry -> function.apply((Object)entry.getKey()), entry -> function2.apply((Object)entry.getValue()));
    }

    public static <K, V, K2, V2> Map<K2, V2> mapMapEntries(Map<K, V> map, Function<? super Map.Entry<K, V>, ? extends K2> function, Function<? super Map.Entry<K, V>, ? extends V2> function2) {
        AbstractMap abstractMap = map instanceof TreeMap ? new TreeMap() : (map instanceof LinkedHashMap ? new LinkedHashMap(map.size()) : new HashMap(map.size()));
        return ObjTools.mapMapEntries(map, abstractMap, function, function2);
    }

    public static <K, V, K2, V2> Map<K2, V2> mapMapEntries(Map<K, V> map, Map<K2, V2> map2, Function<? super Map.Entry<K, V>, ? extends K2> function, Function<? super Map.Entry<K, V>, ? extends V2> function2) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            map2.put(function.apply(entry), function2.apply(entry));
        }
        return map2;
    }

    public static <K, V, K2, V2> Map<K2, V2> mapMap(Map<K, V> map, Map<K2, V2> map2, Function<? super K, ? extends K2> function, Function<? super V, ? extends V2> function2) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            map2.put(function.apply(entry.getKey()), function2.apply(entry.getValue()));
        }
        return map2;
    }

    public static <T, T2> List<T2> mapList(Collection<T> collection, Function<T, T2> function) {
        AbstractList abstractList = collection instanceof LinkedList ? new LinkedList() : new ArrayList(collection.size());
        return ObjTools.mapList(collection, abstractList, function);
    }

    public static <T, T2> List<T2> mapList(Collection<T> collection, List<T2> list, Function<? super T, ? extends T2> function) {
        for (T t : collection) {
            list.add(function.apply(t));
        }
        return list;
    }

    public static <T> ArrayList<T> safeClone(ArrayList<T> arrayList) {
        return (ArrayList)arrayList.clone();
    }

    private static Method getCloneMethod() {
        try {
            return Object.class.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (Method method : Object.class.getDeclaredMethods()) {
                AppLog.getDefault().warn("Found Method: " + method.getName());
            }
            throw new InternalError(noSuchMethodException);
        }
    }

    public static <T> T safeClone(T t) {
        try {
            return (T)cloneMethod.invoke(t, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public static <T> T firstOfType(Object[] objectArray, Class<T> clazz) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(objectArray);
        for (Object object : objectArray) {
            if (object == null || !clazz.isInstance(object)) continue;
            return (T)object;
        }
        return null;
    }

    public static <T> boolean contains(T[] TArray, T t) {
        return ObjTools.indexOf(TArray, t) != -1;
    }

    public static <T> boolean contains(T[] TArray, Predicate<T> predicate) {
        return ObjTools.indexOf(TArray, predicate) != -1;
    }

    public static <T> int indexOf(T[] TArray, Predicate<T> predicate) {
        for (int i = 0; i < TArray.length; ++i) {
            if (!predicate.test(TArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] TArray, T t) {
        if (t == null) {
            for (int i = 0; i < TArray.length; ++i) {
                if (TArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < TArray.length; ++i) {
                if (!t.equals(TArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(String[] stringArray, String string) {
        return ObjTools.indexOf(stringArray, string, false);
    }

    public static int indexOf(String[] stringArray, String string, boolean bl) {
        if (string == null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                return i;
            }
        } else if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                return i;
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <K, V> Map<K, V> toMap(K[] KArray, V[] VArray) {
        LinkedHashMap<K, V> linkedHashMap = new LinkedHashMap<K, V>(KArray.length);
        for (int i = 0; i < KArray.length; ++i) {
            linkedHashMap.put(KArray[i], VArray[i]);
        }
        return linkedHashMap;
    }

    public static <T> boolean any(Iterable<T> iterable, Predicate<T> predicate) {
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean all(Iterable<T> iterable, Predicate<T> predicate) {
        for (T t : iterable) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> T first(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            return t;
        }
        throw new IndexOutOfBoundsException("The list has no first element.");
    }

    public static <T> T first(Iterable<T> iterable, T t) {
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T t2 = iterator.next();
            return t2;
        }
        return t;
    }

    public static <T> T maxOf(T[] TArray, ToIntFunction<T> toIntFunction) {
        if (TArray.length == 0) {
            throw new IllegalArgumentException("The list of values passed to max() must not be empty.");
        }
        T t = TArray[0];
        int n = toIntFunction.applyAsInt(t);
        for (int i = 1; i < TArray.length; ++i) {
            int n2 = toIntFunction.applyAsInt(TArray[i]);
            if (n2 <= n) continue;
            n = n2;
            t = TArray[i];
        }
        return t;
    }

    public static <T> int max(T[] TArray, ToIntFunction<T> toIntFunction) {
        if (TArray.length == 0) {
            throw new IllegalArgumentException("The list of values passed to max() must not be empty.");
        }
        int n = toIntFunction.applyAsInt(TArray[0]);
        for (int i = 1; i < TArray.length; ++i) {
            int n2 = toIntFunction.applyAsInt(TArray[i]);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static <T> T minOf(T[] TArray, ToIntFunction<T> toIntFunction) {
        if (TArray.length == 0) {
            throw new IllegalArgumentException("The list of values passed to min() must not be empty.");
        }
        T t = TArray[0];
        int n = toIntFunction.applyAsInt(t);
        for (int i = 1; i < TArray.length; ++i) {
            int n2 = toIntFunction.applyAsInt(TArray[i]);
            if (n2 >= n) continue;
            n = n2;
            t = TArray[i];
        }
        return t;
    }

    public static <T> int min(T[] TArray, ToIntFunction<T> toIntFunction) {
        if (TArray.length == 0) {
            throw new IllegalArgumentException("The list of values passed to min() must not be empty.");
        }
        int n = toIntFunction.applyAsInt(TArray[0]);
        for (int i = 1; i < TArray.length; ++i) {
            int n2 = toIntFunction.applyAsInt(TArray[i]);
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public static List<Double> toList(double[] dArray) {
        return Arrays.asList(ObjTools.toObjArr(dArray));
    }

    public static List<Float> toList(float[] fArray) {
        return Arrays.asList(ObjTools.toObjArr(fArray));
    }

    public static List<Integer> toList(int[] nArray) {
        return Arrays.asList(ObjTools.toObjArr(nArray));
    }

    public static Double[] toObjArr(double[] dArray) {
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = dArray[i];
        }
        return doubleArray;
    }

    public static Float[] toObjArr(float[] fArray) {
        Float[] floatArray = new Float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            floatArray[i] = Float.valueOf(fArray[i]);
        }
        return floatArray;
    }

    public static Integer[] toObjArr(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public static class RefStr {
        public String value;

        public RefStr() {
        }

        public RefStr(String string) {
            this.value = string;
        }
    }

    public static class RefBool {
        public boolean value;

        public RefBool() {
        }

        public RefBool(boolean bl) {
            this.value = bl;
        }
    }

    public static class RefInt {
        public int value;

        public RefInt() {
        }

        public RefInt(int n) {
            this.value = n;
        }
    }
}

