/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Dimension;
import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.RadioButtonPanel;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class PseudoknotWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public PseudoknotWindow(String string) {
        super(string, "Break " + string + " Pseudoknots");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        if (commandInfo.command.equals("Input CT File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.CT);
            if (string == null) {
                return;
            }
            String string2 = this.backend.buildRemovePseudoknotsDataStructure(string, this.isRNA);
            if (!this.verifyBackendResult(string2, "File: %s\nRNA: %s", string, this.isRNA)) {
                return;
            }
            String string3 = string.substring(0, string.lastIndexOf("."));
            String string4 = string3 + "_no_pseudo.ct";
            filePanel.setFile(1, string);
            filePanel.setFile(2, string4);
            this.getCustomMenus().enableMenus();
        } else if (commandInfo.command.equals("Output CT File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.CT, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Input CT File").inputFile(FileFilters.CT);
        FileField fileField2 = FileField.createEnabled("Output CT File").outputFile(FileFilters.CT);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        String[] stringArray = new String[]{"Minimize Folding Free Energy", "Maximize Number of Pairs"};
        RadioButtonPanel radioButtonPanel = RadioButtonPanel.makeVertical("Pseudoknot Breakage Options", stringArray);
        int n = radioButtonPanel.getPreferredSize().height;
        radioButtonPanel.setPreferredSize(new Dimension(250, n));
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setGrid(1, 1);
        this.placeComponent(0, 1, radioButtonPanel);
        this.makeStartButton(1, 1);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        RadioButtonPanel radioButtonPanel = (RadioButtonPanel)this.getInputControl(2);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        boolean bl = radioButtonPanel.getSelectedIndex() == 1;
        this.showProgress(false);
        String string2 = this.backend.runPseudoknotRemoval(string, bl);
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        return this.drawStructures(string);
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        return new ConstraintsMenu[]{constraintsMenu};
    }
}

