/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.menus.MainMenu;
import ur_rna.RNAstructureUI.ui.BorderBuilder;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.HTMLCheckBox;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.RadioButtonPanel;
import ur_rna.RNAstructureUI.ui.ScrollerPane;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.ui.ValueSelectionDialog;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class OligoWalkWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;
    private boolean isInputWindow = true;
    private JPanel panelInput;
    private JPanel panelResults;

    public OligoWalkWindow() {
        super("RNA", "RNA OligoWalk");
    }

    private void buildResultsWindow(String string, int n, int n2, int n3) {
        Object object;
        this.isInputWindow = false;
        this.setCaption("OligoWalk Results: " + string);
        this.getCustomMenus().clear();
        this.getCustomMenus().add((MergeMenu)new OligoWalkResultsMenu());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                Integer n2 = 0;
                if (n == 39) {
                    n2 = 1;
                } else if (n == 37) {
                    n2 = -1;
                }
                OligoWalkWindow.this.invokeCommand("Move Oligo " + Integer.toString(n2), this);
            }
        });
        JPanel jPanel = (JPanel)this.panelResults.getComponent(2);
        ScrollerPane scrollerPane = (ScrollerPane)jPanel.getComponent(1);
        JPanel jPanel2 = (JPanel)scrollerPane.getViewport().getView();
        JLabel jLabel = (JLabel)jPanel2.getComponent(0);
        Box box = (Box)jPanel2.getComponent(2);
        Box box2 = (Box)box.getComponent(0);
        Box box3 = (Box)box.getComponent(1);
        int n4 = 3;
        Dimension dimension = new Dimension(10, 10);
        for (int i = 0; i <= n + 1; ++i) {
            object = new JComponent[n4];
            for (int j = 1; j <= n4; ++j) {
                if (i >= n2 && i <= n3) {
                    BarButton barButton = new BarButton();
                    barButton.setActionCommand("Set Oligo " + Integer.toString(i));
                    barButton.addActionListener(this);
                    barButton.setBorder(new LineBorder(Color.BLACK, 1));
                    object[j - 1] = barButton;
                    continue;
                }
                object[j - 1] = new JLabel();
            }
            for (JComponent jComponent : object) {
                ((Component)jComponent).setPreferredSize(dimension);
                ((Component)jComponent).setMinimumSize(dimension);
                ((Component)jComponent).setMaximumSize(dimension);
            }
            object[0].setAlignmentY(1.0f);
            object[1].setAlignmentY(0.0f);
            object[2].setAlignmentY(0.0f);
            Box box4 = Box.createVerticalBox();
            box4.setAlignmentY(0.0f);
            box4.add(object[1]);
            box4.add(object[2]);
            box2.add(object[0]);
            box3.add(box4);
        }
        box.setPreferredSize(new Dimension(box.getWidth(), 400));
        jLabel.setText(this.backend.getOligoTargetSequence());
        this.panelInput.setVisible(false);
        this.panelResults.setVisible(true);
        this.pack();
        String string2 = this.getCustomMenus().findByTreePath("Oligo Graph->[0]").getText();
        object = Integer.toString(n3);
        this.panelResults.setName(string2 + ";0/" + (String)object);
        this.invokeCommand("Menu " + string2, this);
        this.setOligoData(this.backend.getGraphRegionBegin());
        this.notifyUpdated();
    }

    private void createInputPanel() {
        FileField fileField = FileField.createDisabled("CT File").inputFile(FileFilters.CT);
        FileField fileField2 = FileField.createEnabled("Report File").outputFile(FileFilters.Report);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        String[] stringArray = new String[]{"Break Local Structure", "Refold Whole RNA for Each Oligomer (Slowest)", "Do Not Consider Target Structure (Fastest)"};
        RadioButtonPanel radioButtonPanel = RadioButtonPanel.makeVertical("Mode", stringArray);
        String[] stringArray2 = new String[]{"DNA", "RNA"};
        RadioButtonPanel radioButtonPanel2 = RadioButtonPanel.makeHorizontal("Oligomer Chemistry", stringArray2);
        int n = radioButtonPanel2.getPreferredSize().height;
        radioButtonPanel2.setPreferredSize(new Dimension(200, n));
        HTMLCheckBox hTMLCheckBox = HTMLCheckBox.createEmptyBox("Include Target Suboptimal Structures in Free Energy Calculation");
        SpinnerPanel spinnerPanel = new SpinnerPanel("Oligo Length:", 18, 1, Integer.MAX_VALUE);
        spinnerPanel.getSpinner().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OligoWalkWindow.this.invokeCommand("Update Target Region Range", this);
            }
        });
        NumberField.IntegerField integerField = new NumberField.IntegerField("Oligo Concentration", 1, (Integer)1);
        FieldPanel fieldPanel = new FieldPanel(integerField);
        fieldPanel.setPanelWidth(200);
        fieldPanel.makePanel();
        StringComboBox stringComboBox = new StringComboBox("M", "mM", "uM", "nM", "pM");
        stringComboBox.setSelectedItem("uM");
        JPanel jPanel = new JPanel();
        jPanel.add(fieldPanel);
        jPanel.add(stringComboBox);
        BorderBuilder borderBuilder = new BorderBuilder();
        SpinnerPanel spinnerPanel2 = new SpinnerPanel("Start:", 0, 0, 0);
        borderBuilder.makeRightBorder(5, spinnerPanel2);
        SpinnerPanel spinnerPanel3 = new SpinnerPanel("Stop:", 0, 0, 0);
        JPanel jPanel2 = new JPanel();
        borderBuilder.makeTitledBorder("Target Structure Limits for Walk", jPanel2);
        jPanel2.add(spinnerPanel2);
        jPanel2.add(spinnerPanel3);
        JButton jButton = new JButton("START");
        jButton.addActionListener(this);
        this.panelInput = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panelInput.add((Component)filePanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.panelInput.add((Component)radioButtonPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.gridy = 2;
        this.panelInput.add((Component)radioButtonPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 3;
        this.panelInput.add((Component)hTMLCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.panelInput.add((Component)spinnerPanel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.panelInput.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.gridy = 6;
        this.panelInput.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        this.panelInput.add((Component)jButton, gridBagConstraints);
        this.panelInput.setVisible(true);
    }

    private void createResultsPanel() {
        Component component2;
        Component[] componentArray;
        JComponent jComponent;
        Object object;
        Object object2;
        String[] stringArray;
        JPanel jPanel = new JPanel(new GridLayout(3, 3));
        for (int i = 1; i <= 9; ++i) {
            stringArray = new JLabel();
            stringArray.setFont(new Font("Monospaced", 1, 12));
            stringArray.setHorizontalAlignment(0);
            jPanel.add((Component)stringArray);
        }
        JPanel jPanel2 = new JPanel(new GridLayout(1, 5));
        stringArray = new String[]{"<<", "<", "Go...", ">", ">>"};
        Integer[] integerArray = new Integer[]{-10, -1, 0, 1, 10};
        for (int i = 1; i <= stringArray.length; ++i) {
            object2 = stringArray[i - 1];
            object = Integer.toString(integerArray[i - 1]);
            jComponent = new JButton((String)object2);
            ((AbstractButton)jComponent).setActionCommand("Move Oligo " + (String)object);
            ((AbstractButton)jComponent).addActionListener(this);
            componentArray = new JPanel();
            new BorderBuilder().makeEqualBorder(5, (JComponent)componentArray);
            componentArray.add(jComponent);
            jPanel2.add((Component)componentArray);
        }
        jPanel2.setPreferredSize(new Dimension(jPanel2.getPreferredSize().width, 100));
        Box box = Box.createVerticalBox();
        object2 = Box.createHorizontalBox();
        ((JComponent)object2).setAlignmentX(0.0f);
        object = Box.createHorizontalBox();
        ((JComponent)object).setAlignmentX(0.0f);
        box.add((Component)object2);
        box.add((Component)object);
        jComponent = new JPanel(new BorderLayout());
        jComponent.add((Component)new JLabel("MAX"), "North");
        jComponent.add((Component)new JLabel("MIN"), "South");
        componentArray = jComponent.getComponents();
        for (Component component2 : componentArray) {
            ((JLabel)component2).setFont(new Font("Monospaced", 1, 12));
            ((JLabel)component2).setHorizontalAlignment(4);
            new BorderBuilder().makeRightBorder(5, (JLabel)component2);
        }
        JLabel jLabel = new JLabel("SEQUENCE");
        jLabel.setFont(new Font("Monospaced", 1, 16));
        jLabel.setHorizontalAlignment(2);
        final JLabel jLabel2 = new JLabel("3OLIGO5");
        jLabel2.setFont(new Font("Monospaced", 1, 16));
        jLabel2.setHorizontalAlignment(2);
        jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                String string = jLabel2.getText().trim().replace("3", "").replace("5", "");
                Integer n = Integer.parseInt(jLabel2.getName().split(" ")[1]);
                boolean bl = OligoWalkWindow.this.backend.getOligoLabelData(n).contains("RNA");
                boolean bl2 = OligoWalkWindow.this.backend.canFoldOligoOligo(n);
                boolean bl3 = OligoWalkWindow.this.backend.canFoldOligoSelf(n);
                if (!bl2 && !bl3) {
                    return;
                }
                String string2 = System.getProperty("user.home") + System.getProperty("file.separator") + "Oligo" + Integer.toString(n) + ".ct";
                if (!bl2) {
                    OligoWalkWindow.this.backend.foldOligo(string, n, false, bl, string2);
                } else if (!bl3) {
                    OligoWalkWindow.this.backend.foldOligo(string, n, true, bl, string2);
                } else {
                    int n2 = JOptionPane.showOptionDialog(null, "Would you like to draw structures?", "RNAstructure", 1, 3, null, new String[]{"Unimolecular", "Bimolecular", "Cancel"}, "Cancel");
                    if (n2 == 2) {
                        return;
                    }
                    boolean bl4 = n2 == 1;
                    OligoWalkWindow.this.backend.foldOligo(string, n, bl4, bl, string2);
                }
                OligoWalkWindow.this.showDrawProgress();
                DrawingWindow drawingWindow = new DrawingWindow(string2);
                if (!drawingWindow.isError()) {
                    drawingWindow.showWindow();
                }
                new File(string2).delete();
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jLabel, "North");
        jPanel3.add((Component)jLabel2, "Center");
        jPanel3.add((Component)box, "South");
        component2 = new ScrollerPane(jPanel3, 875, 460);
        ((ScrollerPane)component2).setBarPolicies(1, 2);
        ((JComponent)component2).setAutoscrolls(true);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jComponent, "West");
        jPanel4.add(component2);
        new BorderBuilder().makeEqualBorder(10, jPanel4);
        this.panelResults = new JPanel(new BorderLayout());
        this.panelResults.add((Component)jPanel, "North");
        this.panelResults.add((Component)jPanel2, "Center");
        this.panelResults.add((Component)jPanel4, "South");
        this.panelResults.setVisible(false);
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        if (this.isInputWindow) {
            FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(this.panelInput, 1);
            Integer n = ((SpinnerPanel)this.getInputControl(this.panelInput, 5)).getValue();
            JPanel jPanel = (JPanel)this.getInputControl(this.panelInput, 7);
            SpinnerPanel spinnerPanel = (SpinnerPanel)this.getInputControl(jPanel, 1);
            SpinnerPanel spinnerPanel2 = (SpinnerPanel)this.getInputControl(jPanel, 2);
            if (commandInfo.command.equals("CT File")) {
                String string = StandardFileChooser.getOpenName(FileFilters.CT);
                if (string == null) {
                    return;
                }
                String string2 = this.backend.buildOligoWalkDataStructure(string, this.isRNA);
                if (!this.verifyBackendResult(string2, "File: %s\nRNA: %s", string, this.isRNA)) {
                    return;
                }
                this.invokeCommand("Update Target Region Range", commandInfo.event);
                String string3 = OligoWalkWindow.getOutputFile(string, "rep");
                filePanel.setFile(1, string);
                filePanel.setFile(2, string3);
                this.getCustomMenus().enableMenus();
            } else if (commandInfo.command.equals("Report File")) {
                int n2 = 2;
                String string = StandardFileChooser.getSaveName(FileFilters.Report, filePanel.getFile(n2));
                if (string != null) {
                    filePanel.setFile(n2, string);
                }
            } else if (commandInfo.command.equals("Update Target Region Range")) {
                int n3 = this.backend.determineOligoMaximum(n);
                spinnerPanel.resetModel(1, 1, n3);
                spinnerPanel2.resetModel(n3, 1, n3);
            } else {
                super.processCommand(commandInfo);
            }
        } else {
            JPanel jPanel = (JPanel)this.panelResults.getComponent(2);
            JPanel jPanel2 = (JPanel)jPanel.getComponent(0);
            ScrollerPane scrollerPane = (ScrollerPane)jPanel.getComponent(1);
            JPanel jPanel3 = (JPanel)scrollerPane.getViewport().getView();
            Box box = (Box)jPanel3.getComponent(2);
            Box box2 = (Box)box.getComponent(0);
            Box box3 = (Box)box.getComponent(1);
            if (commandInfo.command.startsWith("Menu")) {
                Color color = null;
                Color color2 = null;
                JPanel jPanel4 = (JPanel)this.panelResults.getComponent(0);
                int n = jPanel4.getComponents().length;
                for (int i = 1; i <= n; ++i) {
                    jPanel4.getComponent(i - 1).setForeground(Color.BLACK);
                }
                String string = this.panelResults.getName();
                String string4 = string.substring(string.indexOf(";") + 1);
                String string5 = commandInfo.command.substring(5);
                this.panelResults.setName(string5 + ";" + string4);
                int n4 = ((JPanel)scrollerPane.getViewport().getView()).getComponent((int)2).getPreferredSize().height;
                String[] stringArray = this.backend.getAllOligoData(n4).split(";");
                String string6 = null;
                if (commandInfo.command.endsWith("Overall and Duplex")) {
                    color = Color.BLUE;
                    color2 = new Color(17, 167, 77);
                    string6 = stringArray[0];
                    jPanel4.getComponent(1).setForeground(color);
                    jPanel4.getComponent(4).setForeground(color2);
                } else if (commandInfo.command.endsWith("Overall")) {
                    color = Color.BLUE;
                    string6 = stringArray[1];
                    jPanel4.getComponent(1).setForeground(color);
                } else if (commandInfo.command.endsWith("Duplex")) {
                    color = new Color(17, 167, 77);
                    string6 = stringArray[2];
                    jPanel4.getComponent(4).setForeground(color);
                } else if (commandInfo.command.contains("Target")) {
                    color = new Color(114, 67, 212);
                    string6 = stringArray[3];
                    jPanel4.getComponent(2).setForeground(color);
                } else if (commandInfo.command.endsWith("Unimolecular")) {
                    color = Color.MAGENTA;
                    string6 = stringArray[4];
                    jPanel4.getComponent(5).setForeground(color);
                } else if (commandInfo.command.endsWith("Bimolecular")) {
                    color = new Color(139, 25, 14);
                    string6 = stringArray[5];
                    jPanel4.getComponent(8).setForeground(color);
                } else {
                    super.processCommand(commandInfo);
                }
                String[] stringArray2 = string6.trim().split(" ");
                ((JLabel)jPanel2.getComponent(0)).setText(stringArray2[1]);
                ((JLabel)jPanel2.getComponent(1)).setText(stringArray2[0]);
                Double d = 0.0;
                int n5 = this.backend.getGraphRegionBegin();
                int n6 = this.backend.getGraphRegionEnd();
                for (int i = n5; i <= n6; ++i) {
                    int n7 = i - n5 + 2;
                    String[] stringArray3 = stringArray2[n7].split(",");
                    Double d2 = Double.parseDouble(stringArray3[0]);
                    Double d3 = Double.parseDouble(stringArray3[1]);
                    Double d4 = Double.parseDouble(stringArray3[2]);
                    d = Math.max(d, d2);
                    BarButton barButton = (BarButton)box2.getComponent(i);
                    Box box4 = (Box)box3.getComponent(i);
                    BarButton barButton2 = (BarButton)box4.getComponent(0);
                    BarButton barButton3 = (BarButton)box4.getComponent(1);
                    Dimension dimension = new Dimension(10, d2.intValue());
                    barButton.setPreferredSize(dimension);
                    barButton.setMinimumSize(barButton.getPreferredSize());
                    barButton.setMaximumSize(barButton.getPreferredSize());
                    barButton.setSize(barButton.getPreferredSize());
                    Dimension dimension2 = new Dimension(10, d3.intValue());
                    barButton2.setPreferredSize(dimension2);
                    barButton2.setMinimumSize(barButton2.getPreferredSize());
                    barButton2.setMaximumSize(barButton2.getPreferredSize());
                    barButton2.setSize(barButton2.getPreferredSize());
                    Dimension dimension3 = new Dimension(10, d4.intValue());
                    barButton3.setPreferredSize(dimension3);
                    barButton3.setMinimumSize(barButton3.getPreferredSize());
                    barButton3.setMaximumSize(barButton3.getPreferredSize());
                    barButton3.setSize(barButton3.getPreferredSize());
                    barButton.setBarColor(color);
                    barButton2.setBarColor(color);
                    barButton3.setBarColor(color);
                    if (color2 == null) continue;
                    if (d4 != 0.0) {
                        barButton3.setBarColor(color2);
                        continue;
                    }
                    barButton2.setBarColor(color2);
                }
                Dimension dimension = new Dimension(box2.getPreferredSize().width, d.intValue());
                box2.setPreferredSize(dimension);
                box2.setMinimumSize(dimension);
                box2.setMaximumSize(dimension);
                box2.setSize(dimension);
                String string7 = string.substring(string.indexOf(";") + 1, string.indexOf("/"));
                int n8 = Integer.parseInt(string7);
                this.setOligoData(n8);
                this.panelResults.revalidate();
                this.panelResults.repaint();
            } else if (commandInfo.command.startsWith("Move Oligo")) {
                String string = this.panelResults.getName();
                String string8 = string.substring(string.indexOf(";") + 1, string.indexOf("/"));
                int n = Integer.parseInt(string8);
                int n9 = Integer.parseInt(commandInfo.command.split(" ")[2]);
                if (n9 == 0) {
                    new OligoSelectionDialog();
                } else {
                    this.setOligoData(n + n9);
                }
            } else if (commandInfo.command.startsWith("Set Oligo")) {
                int n = Integer.parseInt(commandInfo.command.split(" ")[2]);
                this.setOligoData(n);
            } else {
                super.processCommand(commandInfo);
            }
        }
    }

    @Override
    protected void makeInputControls() {
        this.createInputPanel();
        this.createResultsPanel();
        this.add(this.panelInput);
        this.add(this.panelResults);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(this.panelInput, 1);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        RadioButtonPanel radioButtonPanel = (RadioButtonPanel)this.getInputControl(this.panelInput, 2);
        int n = radioButtonPanel.getSelectedIndex();
        String string2 = ((RadioButtonPanel)this.getInputControl(this.panelInput, 3)).getSelectedName();
        boolean bl = ((HTMLCheckBox)this.getInputControl(this.panelInput, 4)).isSelected();
        Integer n2 = ((SpinnerPanel)this.getInputControl(this.panelInput, 5)).getValue();
        JPanel jPanel = (JPanel)this.getInputControl(this.panelInput, 6);
        Integer n3 = ((NumberField.IntegerField)((FieldPanel)this.getInputControl(jPanel, 1)).getField(1)).getValue();
        String string3 = ((StringComboBox)this.getInputControl(jPanel, 2)).getSelectedItem();
        JPanel jPanel2 = (JPanel)this.getInputControl(this.panelInput, 7);
        Integer n4 = ((SpinnerPanel)this.getInputControl(jPanel2, 1)).getValue();
        Integer n5 = ((SpinnerPanel)this.getInputControl(jPanel2, 2)).getValue();
        this.showProgress();
        String string4 = this.backend.runOligoWalk(string, n, string2, bl, n2, n3, string3, n4, n5);
        if (!this.displayCalcError(string4)) {
            return false;
        }
        this.buildResultsWindow(string, this.backend.getOligoTargetLength(), n4, n5);
        return false;
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        if (this.isInputWindow) {
            ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
            constraintsMenu.buildTemperatureMenu();
            return new ConstraintsMenu[]{constraintsMenu};
        }
        OligoWalkResultsMenu oligoWalkResultsMenu = new OligoWalkResultsMenu();
        return new MergeMenu[]{oligoWalkResultsMenu};
    }

    private void setOligoData(int n) {
        String string = this.panelResults.getName();
        int n2 = Integer.parseInt(string.substring(string.indexOf("/") + 1));
        if (n < 1) {
            n = 1;
        } else if (n > n2) {
            n = n2;
        }
        String string2 = Integer.toString(n);
        String[] stringArray = this.backend.getOligoLabelData(n).split(";");
        int n3 = stringArray.length;
        JPanel jPanel = (JPanel)this.panelResults.getComponent(0);
        for (int i = 1; i <= n3; ++i) {
            ((JLabel)jPanel.getComponent(i - 1)).setText(stringArray[i - 1]);
        }
        JPanel jPanel2 = (JPanel)this.panelResults.getComponent(2);
        ScrollerPane scrollerPane = (ScrollerPane)jPanel2.getComponent(1);
        JPanel jPanel3 = (JPanel)scrollerPane.getViewport().getView();
        JLabel jLabel = (JLabel)jPanel3.getComponent(1);
        jLabel.setText(this.backend.getDisplayedOligo(n));
        jLabel.setName("Oligo " + Integer.toString(n));
        Box box = (Box)jPanel3.getComponent(2);
        Box box2 = (Box)box.getComponent(0);
        Box box3 = (Box)box.getComponent(1);
        int n4 = this.backend.getGraphRegionBegin();
        int n5 = this.backend.getGraphRegionEnd();
        for (int i = n4; i <= n5; ++i) {
            BarButton barButton = (BarButton)box2.getComponent(i);
            Box box4 = (Box)box3.getComponent(i);
            BarButton barButton2 = (BarButton)box4.getComponent(0);
            if (i != n) {
                if ((double)barButton.getHeight() > 0.0) {
                    barButton.deselect();
                    continue;
                }
                barButton2.deselect();
                continue;
            }
            if ((double)barButton.getHeight() > 0.0) {
                barButton.select();
                continue;
            }
            barButton2.select();
        }
        String string3 = string.substring(string.indexOf(";") + 1, string.indexOf("/"));
        this.panelResults.setName(string.replaceFirst(string3, string2));
    }

    public class StringComboBox
    extends JComboBox {
        private static final long serialVersionUID = 20120802L;

        public StringComboBox(String ... stringArray) {
            for (String string : stringArray) {
                this.addItem(string);
            }
        }

        @Override
        public String getSelectedItem() {
            return super.getSelectedItem().toString();
        }
    }

    public class SpinnerPanel
    extends JPanel {
        private static final long serialVersionUID = 20120802L;
        private JSpinner spinner;

        public SpinnerPanel(String string, int n, int n2, int n3) {
            this.setLayout(new BorderLayout());
            BorderBuilder borderBuilder = new BorderBuilder();
            JLabel jLabel = new JLabel(string);
            borderBuilder.makeTopBorder(5, jLabel);
            jLabel.setHorizontalAlignment(4);
            jLabel.setVerticalAlignment(1);
            this.add((Component)jLabel, "West");
            JPanel jPanel = new JPanel();
            borderBuilder.makeTopBorder(-5, jPanel);
            this.spinner = new JSpinner();
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setHorizontalAlignment(2);
            this.resetModel(n, n2, n3);
            this.spinner.setName(string);
            jPanel.add(this.spinner);
            this.add(jPanel);
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (!Character.isDigit(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    if (!Character.isDigit(keyEvent.getKeyChar())) {
                        keyEvent.consume();
                    }
                }
            });
        }

        public JSpinner getSpinner() {
            return this.spinner;
        }

        public Integer getValue() {
            return (Integer)this.spinner.getValue();
        }

        public void resetModel(int n, int n2, int n3) {
            this.spinner.setModel(new SpinnerNumberModel(n, n2, n3, 1));
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setColumns(5);
        }
    }

    public class OligoSelectionDialog
    extends ValueSelectionDialog {
        private static final long serialVersionUID = 20120802L;

        public OligoSelectionDialog() {
            super("Select Oligo");
            String string = OligoWalkWindow.this.panelResults.getName();
            int n = Integer.parseInt(string.substring(string.indexOf(";") + 1, string.indexOf("/")));
            int n2 = Integer.parseInt(string.substring(string.indexOf("/") + 1));
            NumberField.IntegerField integerField = new NumberField.IntegerField("Oligo Number", n, 1, n2);
            this.buildDialog("OK", integerField);
        }

        @Override
        public JPanel createAdditionalControls() {
            JButton jButton = new JButton("Most Stable");
            jButton.setPreferredSize(new Dimension(125, 30));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = OligoWalkWindow.this.backend.getMostStableOligo();
                    OligoSelectionDialog.this.fields[0].setText(Integer.toString(n));
                }
            });
            JPanel jPanel = new JPanel();
            new BorderBuilder().makeBottomBorder(5, jPanel);
            jPanel.add(jButton);
            return jPanel;
        }

        @Override
        public ActionListener createSelectionAction() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OligoWalkWindow.this.setOligoData(Integer.parseInt(OligoSelectionDialog.this.fields[0].getText()));
                    OligoSelectionDialog.this.dispose();
                }
            };
        }
    }

    class OligoWalkResultsMenu
    extends MainMenu {
        private static final long serialVersionUID = 20120802L;

        public OligoWalkResultsMenu() {
            super("Oligo Graph");
            this.addItem("Overall and Duplex", "Show overall and duplex oligo results.");
            this.addSeparator();
            this.addItem("Overall", "Show overall oligo results.");
            this.addItem("Duplex", "Show duplex oligo results.");
            this.addItem("Broken Target Structure", "Show broken target structure oligo results.");
            this.addItem("Oligomer Unimolecular", "Show unimolecular oligo results.");
            this.addItem("Oligomer Bimolecular", "Show bimolecular oligo results.");
            for (JMenuItem jMenuItem : this.getMenuItems()) {
                jMenuItem.setActionCommand("Menu " + jMenuItem.getName());
            }
        }

        @Override
        protected void onMenuAction(String string, ActionEvent actionEvent) {
            OligoWalkWindow.this.invokeCommand(string, this);
        }
    }

    class BarButton
    extends JButton {
        private static final long serialVersionUID = 20120802L;
        private Color currentColor = Color.white;
        private Color defaultColor = Color.white;
        private Color selectionColor = Color.red;

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(this.currentColor);
            ((Graphics2D)graphics).fill(this.getVisibleRect());
        }

        public void deselect() {
            this.currentColor = this.defaultColor;
            this.repaint();
        }

        public void select() {
            this.currentColor = this.selectionColor;
            this.repaint();
        }

        public void setBarColor(Color color) {
            this.currentColor = color;
            this.defaultColor = color;
        }
    }
}

