/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.HTMLCheckBox;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class FoldSingleWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public FoldSingleWindow(String string) {
        super(string, string + " Single Strand Fold");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(3);
        if (commandInfo.command.equals("CT File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.CT, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Sequence File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.Sequence);
            if (string == null) {
                return;
            }
            this.setSequenceFile(string);
        } else if (commandInfo.command.startsWith("Sequence File Auto")) {
            this.setSequenceFile(commandInfo.command.split(";")[1]);
        } else {
            super.processCommand(commandInfo);
        }
    }

    public void setSequenceFile(String string) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(3);
        String string2 = this.backend.buildFoldDataStructure(string, this.isRNA);
        if (!this.verifyBackendResult(string2, "File: " + string + "\nRNA: " + this.isRNA, new Object[0])) {
            return;
        }
        int n = this.backend.getFoldWindowSize();
        ((NumberField.IntegerField)fieldPanel.getField(3)).resetField(n, 0, Integer.MAX_VALUE);
        String string3 = FoldSingleWindow.getOutputFile(string, "ct");
        filePanel.setFile(1, string);
        filePanel.setFile(2, string3);
        this.getCustomMenus().enableMenus();
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Sequence File").inputFile(FileFilters.Sequence);
        FileField fileField2 = FileField.createEnabled("CT File").outputFile(FileFilters.CT);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        HTMLCheckBox hTMLCheckBox = HTMLCheckBox.createEmptyBox("Generate Save File");
        NumberField.IntegerField integerField = new NumberField.IntegerField("Max % Energy Difference", 10, (Integer)0);
        NumberField.IntegerField integerField2 = new NumberField.IntegerField("Max Number of Structures", 20, (Integer)1);
        NumberField.IntegerField integerField3 = new NumberField.IntegerField("Window Size", 0, (Integer)0);
        FieldPanel fieldPanel = new FieldPanel(integerField, integerField2, integerField3);
        fieldPanel.setPanelWidth(300);
        fieldPanel.makePanel();
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setFillCenter();
        this.placeComponent(0, 1, hTMLCheckBox);
        this.setFillHorizontal();
        this.setGrid(1, 1);
        this.placeComponent(0, 2, fieldPanel);
        this.makeStartButton(1, 2);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        HTMLCheckBox hTMLCheckBox = (HTMLCheckBox)this.getInputControl(2);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(3);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        Integer n = ((NumberField.IntegerField)fieldPanel.getField(1)).getValue();
        Integer n2 = ((NumberField.IntegerField)fieldPanel.getField(2)).getValue();
        Integer n3 = ((NumberField.IntegerField)fieldPanel.getField(3)).getValue();
        this.showProgress(true, true);
        String string2 = this.backend.runFold(string, n, n2, n3, hTMLCheckBox.isSelected());
        if (!this.displayCalcError(string2)) {
            return false;
        }
        return this.drawStructures(string);
    }

    public void setDataAutomatically(String string) {
        this.invokeCommand("Sequence File Auto;" + string, this);
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        ConstraintsMenu constraintsMenu2 = new ConstraintsMenu(this.backend);
        constraintsMenu2.addGeneralSection();
        constraintsMenu2.addMaxPairingDistanceSection();
        constraintsMenu2.addSHAPESection();
        constraintsMenu2.addShowResetSection();
        constraintsMenu2.addSaveRestoreSection();
        ConstraintsMenu constraintsMenu3 = new ConstraintsMenu(this.backend);
        constraintsMenu3.buildMaxLoopMenu();
        return new ConstraintsMenu[]{constraintsMenu, constraintsMenu2, constraintsMenu3};
    }
}

