/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.HTMLCheckBox;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class FoldDoubleWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public FoldDoubleWindow(String string) {
        super(string, string + " Bimolecular Fold");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        if (commandInfo.command.equals("CT File")) {
            int n = 3;
            String string = StandardFileChooser.getSaveName(FileFilters.CT, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Sequence File 1")) {
            String string = StandardFileChooser.getOpenName(FileFilters.Sequence);
            if (string != null) {
                filePanel.setFile(1, string);
            }
        } else if (commandInfo.command.equals("Sequence File 2")) {
            if (filePanel.getFile(1).equals("")) {
                String string = "Sequence File 1 hasn't been selected yet.";
                Dialogs.showError(string);
                return;
            }
            String string = StandardFileChooser.getOpenName(FileFilters.Sequence);
            if (string == null) {
                return;
            }
            filePanel.setFile(2, string);
            String string2 = filePanel.getFile(1);
            String string3 = filePanel.getFile(2);
            String string4 = this.backend.buildBifoldDataStructure(string2, string3, this.isRNA);
            if (!this.verifyBackendResult(string4, "Seq1: %s\nSeq2: %s\nRNA: %s", string2, string3, this.isRNA)) {
                return;
            }
            String string5 = this.combineFileNames(string2, string3, "ct");
            filePanel.setFile(3, string5);
            this.getCustomMenus().enableMenus();
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Sequence File 1").inputFile(FileFilters.Sequence);
        FileField fileField2 = FileField.createDisabled("Sequence File 2").inputFile(FileFilters.Sequence);
        FileField fileField3 = FileField.createEnabled("CT File").outputFile(FileFilters.CT);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2, fileField3);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        HTMLCheckBox hTMLCheckBox = HTMLCheckBox.createEmptyBox("Generate Save File");
        NumberField.FloatField floatField = new NumberField.FloatField("Max % Energy Difference", 50, (Number)0);
        NumberField.IntegerField integerField = new NumberField.IntegerField("Max Number of Structures", 20, (Integer)1);
        NumberField.IntegerField integerField2 = new NumberField.IntegerField("Window Size", 0, (Integer)0);
        FieldPanel fieldPanel = new FieldPanel(floatField, integerField, integerField2);
        fieldPanel.setPanelWidth(300);
        fieldPanel.makePanel();
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setFillCenter();
        this.placeComponent(0, 1, hTMLCheckBox);
        this.setGrid(1, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 2, fieldPanel);
        this.makeStartButton(1, 2);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        HTMLCheckBox hTMLCheckBox = (HTMLCheckBox)this.getInputControl(2);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(3);
        filePanel.saveRecent();
        filePanel.getFile(1);
        filePanel.getFile(2);
        String string = filePanel.getFile(3);
        if (filePanel.isError()) {
            return false;
        }
        Float f = ((NumberField.FloatField)fieldPanel.getField(1)).getValue();
        Integer n = ((NumberField.IntegerField)fieldPanel.getField(2)).getValue();
        Integer n2 = ((NumberField.IntegerField)fieldPanel.getField(3)).getValue();
        boolean bl = hTMLCheckBox.isSelected();
        boolean bl2 = this.getCustomMenus().findByName("Force->Forbid Unimolecular Pairs").isSelected();
        this.showProgress();
        String string2 = this.backend.runBifold(string, f.floatValue(), n, n2, bl, bl2);
        this.displayCalcError(string2);
        if (!string2.equals("")) {
            return false;
        }
        return this.drawStructures(string);
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        ConstraintsMenu constraintsMenu2 = new ConstraintsMenu(this.backend);
        constraintsMenu2.buildUnimolecularMenu();
        ConstraintsMenu constraintsMenu3 = new ConstraintsMenu(this.backend);
        constraintsMenu3.buildMaxLoopMenu();
        return new ConstraintsMenu[]{constraintsMenu, constraintsMenu2, constraintsMenu3};
    }
}

