/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.HTMLCheckBox;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.DrawingWindow;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class DynalignFoldWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20120802L;

    public DynalignFoldWindow(String string) {
        super(string, string + " Dynalign");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        String string = commandInfo.command;
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(2);
        if (string.startsWith("Alignment File")) {
            int n = 5;
            String string2 = StandardFileChooser.getSaveName(FileFilters.Alignment, filePanel.getFile(n));
            if (string2 != null) {
                filePanel.setFile(n, string2);
            }
        } else if (string.startsWith("CT File")) {
            int n = string.endsWith("1") ? 2 : 4;
            String string3 = StandardFileChooser.getSaveName(FileFilters.CT, filePanel.getFile(n));
            if (string3 != null) {
                filePanel.setFile(n, string3);
            }
        } else if (string.startsWith("Sequence File")) {
            String string4 = StandardFileChooser.getOpenName(FileFilters.Sequence);
            if (string4 == null) {
                return;
            }
            int n = string.endsWith("1") ? 1 : 3;
            String string5 = DynalignFoldWindow.getOutputFile(string4, "ct");
            filePanel.setFile(n, string4);
            filePanel.setFile(n + 1, string5);
            if (string.equals("Sequence File 2")) {
                String string6 = filePanel.getFile(1);
                String string7 = filePanel.getFile(3);
                String string8 = DynalignFoldWindow.getOutputFile(this.combineFileNames(string6, string7, "ali"));
                filePanel.setFile(5, string8);
                String string9 = this.backend.buildDynalignDataStructure(string6, string7, this.isRNA);
                if (!this.verifyBackendResult(string9, "Seq1: %s\nSeq2: %s\nRNA: %s", string6, string7, this.isRNA)) {
                    return;
                }
                int n2 = this.backend.getDynalignStructureWindowSize();
                ((NumberField.IntegerField)fieldPanel.getField(3)).resetField(n2, 0, Integer.MAX_VALUE);
                int n3 = this.backend.getDynalignAlignmentWindowSize();
                ((NumberField.IntegerField)fieldPanel.getField(4)).resetField(n3, 0, Integer.MAX_VALUE);
                this.getCustomMenus().enableMenus();
            }
        } else {
            super.processCommand(commandInfo);
        }
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("Sequence File 1").inputFile(FileFilters.Sequence);
        FileField fileField2 = FileField.createEnabled("CT File 1").outputFile(FileFilters.CT);
        FileField fileField3 = FileField.createDisabled("Sequence File 2").inputFile(FileFilters.Sequence);
        FileField fileField4 = FileField.createEnabled("CT File 2").outputFile(FileFilters.CT);
        FileField fileField5 = FileField.createEnabled("Alignment File").outputFile(FileFilters.Alignment);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2, fileField3, fileField4, fileField5);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        NumberField.DoubleField doubleField = new NumberField.DoubleField("Max % Energy Difference", 20, (Number)0);
        NumberField.IntegerField integerField = new NumberField.IntegerField("Max Number of Structures", 20, (Integer)1);
        NumberField.IntegerField integerField2 = new NumberField.IntegerField("Structure Window Size", 0, (Integer)0);
        NumberField.IntegerField integerField3 = new NumberField.IntegerField("Alignment Window Size", 0, (Integer)0);
        FieldPanel fieldPanel = new FieldPanel(doubleField, integerField, integerField2, integerField3);
        fieldPanel.setPanelWidth(250);
        fieldPanel.makePanel();
        NumberField.FloatField floatField = new NumberField.FloatField("Gap Penalty", 0.4);
        FieldPanel fieldPanel2 = new FieldPanel(floatField);
        fieldPanel2.setPanelWidth(100);
        fieldPanel2.makePanel();
        HTMLCheckBox hTMLCheckBox = HTMLCheckBox.createSelectedBox("Single BP Inserts\nAllowed");
        HTMLCheckBox hTMLCheckBox2 = HTMLCheckBox.createEmptyBox("Generate Save File");
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setGrid(1, 3);
        this.placeComponent(0, 1, fieldPanel);
        this.setGrid(1, 1);
        this.placeComponent(1, 1, fieldPanel2);
        this.setInsets(-10, 0, -10, 0);
        this.placeComponent(1, 2, hTMLCheckBox);
        this.setInsets(0, 0, 0, 0);
        this.placeComponent(1, 3, hTMLCheckBox2);
        this.setGrid(2, 1);
        this.makeStartButton(0, 4);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(2);
        FieldPanel fieldPanel2 = (FieldPanel)this.getInputControl(3);
        HTMLCheckBox hTMLCheckBox = (HTMLCheckBox)this.getInputControl(4);
        HTMLCheckBox hTMLCheckBox2 = (HTMLCheckBox)this.getInputControl(5);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        filePanel.getFile(3);
        String string2 = filePanel.getFile(4);
        String string3 = filePanel.getFile(5);
        if (filePanel.isError()) {
            return false;
        }
        Double d = ((NumberField.DoubleField)fieldPanel.getField(1)).getValue();
        Integer n = ((NumberField.IntegerField)fieldPanel.getField(2)).getValue();
        Integer n2 = ((NumberField.IntegerField)fieldPanel.getField(3)).getValue();
        Integer n3 = ((NumberField.IntegerField)fieldPanel.getField(4)).getValue();
        Float f = ((NumberField.FloatField)fieldPanel2.getField(1)).getValue();
        boolean bl = hTMLCheckBox.isSelected();
        String string4 = hTMLCheckBox2.isSelected() ? DynalignFoldWindow.getOutputFile(string3, "dsv") : "";
        this.showProgress(true, true);
        String string5 = this.backend.runDynalign(string, string2, string4, string3, d, n, n2, n3, f.floatValue(), bl);
        this.displayCalcError(string5);
        if (!string5.equals("")) {
            return false;
        }
        if (DynalignFoldWindow.promptDraw()) {
            this.showDrawProgress();
            DrawingWindow drawingWindow = new DrawingWindow(string);
            DrawingWindow drawingWindow2 = new DrawingWindow(string2);
            if (drawingWindow.isError() || drawingWindow2.isError()) {
                return false;
            }
            drawingWindow.showWindow();
            drawingWindow2.showWindow();
        }
        return true;
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        ConstraintsMenu constraintsMenu2 = new ConstraintsMenu(this.backend);
        constraintsMenu2.setText("Constraints for Sequence 1");
        constraintsMenu2.addGeneralSection();
        constraintsMenu2.addShowResetSection();
        constraintsMenu2.addSaveRestoreSection();
        ConstraintsMenu constraintsMenu3 = new ConstraintsMenu(this.backend);
        constraintsMenu3.setText("Constraints for Sequence 2");
        constraintsMenu3.addGeneralSection();
        constraintsMenu3.addShowResetSection();
        constraintsMenu3.addSaveRestoreSection();
        ConstraintsMenu constraintsMenu4 = new ConstraintsMenu(this.backend);
        constraintsMenu4.buildDynalignAlignmentMenu();
        return new ConstraintsMenu[]{constraintsMenu, constraintsMenu2, constraintsMenu3, constraintsMenu4};
    }
}

