/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JMenuItem;
import ur_rna.RNAstructureUI.drawing.dialogs.ImageDialog;
import ur_rna.RNAstructureUI.drawing.dialogs.PlotDialog;
import ur_rna.RNAstructureUI.drawing.dialogs.StructureDialog;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.ScrollerPane;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.utilities.FileType;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.OSInfo;

public class DrawingWindow
extends InternalWindow {
    private static final long serialVersionUID = 20120802L;
    private ImageDialog dialog;
    private boolean error;
    private int strand;

    public DrawingWindow(String string) {
        this(string, 1);
    }

    public DrawingWindow(String string, int n) {
        this(string, n, null);
    }

    public DrawingWindow(String string, int n, FileType fileType) {
        this.setCaption(string);
        this.setResizable(true);
        this.strand = n;
        if (fileType == null) {
            fileType = FileType.guessTypeFromFilePath(string);
        }
        switch (fileType) {
            case CT: 
            case DBN: {
                this.dialog = new StructureDialog(string);
                break;
            }
            case PFS: 
            case SAV: {
                this.dialog = new PlotDialog(string, n);
                break;
            }
            default: {
                Dialogs.showWarning("Cannot draw file (due to Unknown file type): " + string);
                return;
            }
        }
        if (this.dialog.isError()) {
            return;
        }
        this.getDialogContent();
        ComponentListener componentListener = new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                DrawingWindow.this.doRevalidate();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                DrawingWindow.this.doRevalidate();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DrawingWindow.this.doRevalidate();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                DrawingWindow.this.doRevalidate();
            }
        };
        this.getContentPane().getComponent(2).addComponentListener(componentListener);
        if (!this.error && fileType == FileType.CT) {
            int n2 = this.dialog.getKeyListeners().length - 1;
            this.addKeyListener(this.dialog.getKeyListeners()[n2]);
        }
        if (!this.error && fileType == FileType.PFS) {
            JMenuItem jMenuItem = this.getCustomMenus().findByTreePath("Output Plot->Write Probable Structures File");
            if (jMenuItem == null) {
                Dialogs.showError("Failed to find the menu item \"Output Plot->Write Probable Structures File\".");
            } else {
                ActionListener actionListener = jMenuItem.getActionListeners()[0];
                jMenuItem.removeActionListener(actionListener);
                jMenuItem.addActionListener(this);
            }
        }
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        if (commandInfo.command.equals("Write Probable Structures File")) {
            DrawingWindow drawingWindow;
            String string = StandardFileChooser.getSaveName(FileFilters.CT);
            boolean bl = false;
            if (string != null) {
                bl = ((PlotDialog)this.dialog).writeStructuresFile(string, false);
            }
            if (bl && ModuleWindow.promptDraw() && !(drawingWindow = new DrawingWindow(string)).isError()) {
                drawingWindow.showWindow();
            }
        } else {
            super.processCommand(commandInfo);
        }
    }

    private void doRevalidate() {
        Container container = this.getContentPane();
        Container container2 = (Container)container.getComponent(0);
        ScrollerPane scrollerPane = (ScrollerPane)container.getComponent(1);
        ScrollerPane scrollerPane2 = (ScrollerPane)container.getComponent(2);
        Container container3 = (Container)scrollerPane2.getViewport().getView();
        Dimension dimension = scrollerPane.getSize();
        dimension.height += container2.getPreferredSize().height;
        if (container3.getComponents().length != 0) {
            dimension.height += scrollerPane2.getPreferredSize().height;
        }
        this.getContentPane().setPreferredSize(dimension);
        this.repaint();
    }

    private void getDialogContent() {
        if (this.dialog.isError()) {
            this.error = true;
            return;
        }
        this.setContentPane(this.dialog.getContentPane());
        this.setCustomMenus(this.dialog.getCustomMenus());
        this.getCustomMenus().enableMenus();
        this.addKeyListener(this.dialog.getKeyListeners()[0]);
        if (OSInfo.isMac()) {
            this.addKeyListener(this.dialog.getKeyListeners()[1]);
        }
    }

    public boolean isError() {
        return this.error;
    }

    public PlotDialog getPlot() {
        return this.dialog instanceof PlotDialog ? (PlotDialog)this.dialog : null;
    }

    public StructureDialog getStructure() {
        return this.dialog instanceof StructureDialog ? (StructureDialog)this.dialog : null;
    }
}

