/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.windows;

import ur_rna.RNAstructureUI.menus.ConstraintsMenu;
import ur_rna.RNAstructureUI.ui.FieldPanel;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.HTMLCheckBox;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.RNAstructureUI.windows.InternalWindow;
import ur_rna.RNAstructureUI.windows.ModuleWindow;
import ur_rna.Utilities.swing.MergeMenu;

public class DesignWindow
extends ModuleWindow {
    private static final long serialVersionUID = 20160524L;
    private NumberField.DoubleField maxdefect;
    private NumberField.IntegerField maxdepth;
    private NumberField.IntegerField maxmutate;
    private NumberField.IntegerField maxleaf;
    private NumberField.IntegerField maxredesign;

    public DesignWindow(String string) {
        super(string, string + " Design");
    }

    @Override
    protected void processCommand(InternalWindow.CommandInfo commandInfo) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(3);
        if (commandInfo.command.equals("CT File")) {
            int n = 2;
            String string = StandardFileChooser.getSaveName(FileFilters.CT, filePanel.getFile(n));
            if (string != null) {
                filePanel.setFile(n, string);
            }
        } else if (commandInfo.command.equals("Sequence File")) {
            String string = StandardFileChooser.getOpenName(FileFilters.Sequence);
            if (string == null) {
                return;
            }
            this.setSequenceFile(string);
        } else if (commandInfo.command.startsWith("Sequence File Auto")) {
            this.setSequenceFile(commandInfo.command.split(";")[1]);
        } else {
            super.processCommand(commandInfo);
        }
    }

    public void setSequenceFile(String string) {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(3);
        String string2 = this.backend.buildFoldDataStructure(string, this.isRNA);
        if (!this.verifyBackendResult(string2, "File: " + string + "\nRNA: " + this.isRNA, new Object[0])) {
            return;
        }
        int n = this.backend.getFoldWindowSize();
        ((NumberField.IntegerField)fieldPanel.getField(3)).resetField(n, 0, Integer.MAX_VALUE);
        String string3 = DesignWindow.getOutputFile(string, "ct");
        filePanel.setFile(1, string);
        filePanel.setFile(2, string3);
        this.getCustomMenus().enableMenus();
    }

    @Override
    protected void makeInputControls() {
        FileField fileField = FileField.createDisabled("CT File").inputFile(FileFilters.CT);
        FileField fileField2 = FileField.createEnabled("Sequence File (output)").outputFile(FileFilters.Sequence);
        FieldPanel.FilePanel filePanel = new FieldPanel.FilePanel(this, fileField, fileField2);
        filePanel.setPanelWidth(600);
        filePanel.makePanel();
        HTMLCheckBox hTMLCheckBox = HTMLCheckBox.createEmptyBox("Generate Save File");
        this.maxdefect = new NumberField.DoubleField("Max Ensemble Defect", 0.01, (Number)0);
        this.maxdepth = new NumberField.IntegerField("Max Depth", 5, (Integer)1);
        this.maxmutate = new NumberField.IntegerField("Max Mutate", 4, (Integer)1);
        this.maxleaf = new NumberField.IntegerField("Max Leaf", 3, (Integer)1);
        this.maxredesign = new NumberField.IntegerField("Max Redesign", 10, (Integer)1);
        FieldPanel fieldPanel = new FieldPanel(this.maxdefect, this.maxdepth, this.maxmutate, this.maxleaf, this.maxredesign);
        fieldPanel.setPanelWidth(300);
        fieldPanel.makePanel();
        this.setGrid(2, 1);
        this.setFillHorizontal();
        this.placeComponent(0, 0, filePanel);
        this.setFillCenter();
        this.placeComponent(0, 1, hTMLCheckBox);
        this.setFillHorizontal();
        this.setGrid(1, 1);
        this.placeComponent(0, 2, fieldPanel);
        this.makeStartButton(1, 2);
    }

    @Override
    protected boolean runMainCalculation() {
        FieldPanel.FilePanel filePanel = (FieldPanel.FilePanel)this.getInputControl(1);
        HTMLCheckBox hTMLCheckBox = (HTMLCheckBox)this.getInputControl(2);
        FieldPanel fieldPanel = (FieldPanel)this.getInputControl(3);
        filePanel.saveRecent();
        filePanel.getFile(1);
        String string = filePanel.getFile(2);
        if (filePanel.isError()) {
            return false;
        }
        this.showProgress(true, true);
        String string2 = "Not yet implemented.";
        if (!this.displayCalcError(string2)) {
            return false;
        }
        return this.drawStructures(string);
    }

    @Override
    protected MergeMenu[] createCustomMenus() {
        ConstraintsMenu constraintsMenu = new ConstraintsMenu(this.backend);
        constraintsMenu.buildTemperatureMenu();
        ConstraintsMenu constraintsMenu2 = new ConstraintsMenu(this.backend);
        constraintsMenu2.addGeneralSection();
        constraintsMenu2.addMaxPairingDistanceSection();
        constraintsMenu2.addSHAPESection();
        constraintsMenu2.addShowResetSection();
        constraintsMenu2.addSaveRestoreSection();
        ConstraintsMenu constraintsMenu3 = new ConstraintsMenu(this.backend);
        constraintsMenu3.buildMaxLoopMenu();
        return new ConstraintsMenu[]{constraintsMenu, constraintsMenu2, constraintsMenu3};
    }
}

