/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.ui;

import java.awt.Font;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ur_rna.RNAstructureUI.RNAstructure;
import ur_rna.RNAstructureUI.utilities.FileSelectedEvent;
import ur_rna.Utilities.ObjTools;

public class RecentFileButton
extends JButton {
    public String filters;
    public Consumer<File> onFileSelected;
    private static FileFilter filterAcceptAll = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file != null && file.exists() && !file.isDirectory();
        }
    };
    static ActionListener createExampleFilesClicked = actionEvent -> RNAstructure.ExtractExamples();

    public RecentFileButton() {
    }

    public RecentFileButton(String string, String string2, ActionListener actionListener, String string3) {
        this(string, string2, null);
        this.onFileSelected = file -> actionListener.actionPerformed(new FileSelectedEvent((Object)this, (File)file, string3));
    }

    public RecentFileButton(String string, String string2, Consumer<File> consumer) {
        super(string);
        this.filters = string2;
        this.onFileSelected = consumer;
        this.addActionListener(actionEvent -> this.showFileSelectMenu());
    }

    public void showFileSelectMenu() {
        RecentFileButton.showRecentFileMenu(this, this.filters, this.onFileSelected);
    }

    public static void showRecentFileMenu(JComponent jComponent, String string, Consumer<File> consumer) {
        FileFilter fileFilter = RecentFileButton.parseFilters(string);
        List<File> list = RecentFileButton.filterFiles(RecentFileButton.getExamples(), fileFilter);
        List<File> list2 = RecentFileButton.filterFiles(RecentFileButton.getRecent(), fileFilter);
        JPopupMenu jPopupMenu = new JPopupMenu("Select a File");
        Font font = jPopupMenu.getFont().deriveFont(1);
        jPopupMenu.add(RecentFileButton.createMenuItem("Recent Files:", null, font));
        jPopupMenu.addSeparator();
        if (list2 == null || list2.size() == 0) {
            jPopupMenu.add(RecentFileButton.createMenuItem("  (No recent files yet.)", null));
        } else {
            Object object = jPopupMenu;
            int n = 0;
            for (int i = list2.size() - 1; i >= 0; --i) {
                if (n++ == 8) {
                    JMenu jMenu = new JMenu("More Recent Files");
                    jPopupMenu.add(jMenu);
                    object = jMenu.getPopupMenu();
                }
                ((JPopupMenu)object).add(RecentFileButton.createFileItem(list2.get(i), consumer, true));
            }
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(RecentFileButton.createMenuItem("Example Files:", null, font));
        jPopupMenu.addSeparator();
        if (list == null) {
            jPopupMenu.add(RecentFileButton.createMenuItem("  (Example files Missing! Click to create.)", createExampleFilesClicked));
        } else if (list.size() == 0) {
            jPopupMenu.add(RecentFileButton.createMenuItem("  (There are no examples of this file type.)", null));
        } else {
            for (File file : list) {
                jPopupMenu.add(RecentFileButton.createFileItem(file, consumer, false));
            }
        }
        jPopupMenu.show(jComponent, 0, jComponent == null ? 0 : jComponent.getHeight());
    }

    public static JMenuItem createMenuItem(String string, ActionListener actionListener) {
        return RecentFileButton.createMenuItem(string, actionListener, null);
    }

    public static JMenuItem createMenuItem(String string, ActionListener actionListener, Font font) {
        JMenuItem jMenuItem = new JMenuItem(string);
        if (actionListener == null) {
            jMenuItem.setEnabled(false);
        } else {
            jMenuItem.addActionListener(actionListener);
        }
        if (font != null) {
            jMenuItem.setFont(font);
        }
        return jMenuItem;
    }

    public static JMenuItem createFileItem(File file, Consumer<File> consumer, boolean bl) {
        String string = "  " + file.getName();
        if (bl) {
            string = string + " in " + (RNAstructure.isExampleFile(file) ? "<Examples>" : file.getParent());
        }
        return RecentFileButton.createMenuItem(string, actionEvent -> consumer.accept(file));
    }

    private static FileFilter parseFilters(String string) {
        if (string == null || string.trim().length() == 0) {
            return filterAcceptAll;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split("\\|");
        for (int i = 1; i < stringArray.length; ++i) {
            String string2 = stringArray[i - 1].trim();
            if (string2.length() == 0) continue;
            if (string2.equals("*")) {
                return filterAcceptAll;
            }
            for (String string3 : stringArray[i].split(";")) {
                arrayList.add(string3.trim());
            }
            ++i;
        }
        return new ExtensionFileFilter(true, arrayList.toArray(new String[arrayList.size()]));
    }

    public static List<File> getExamples() {
        File file = RNAstructure.getExamplesDir();
        if (file == null) {
            return null;
        }
        File[] fileArray = file.listFiles();
        return fileArray == null ? null : Arrays.asList(fileArray);
    }

    public static List<File> getRecent() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : RNAstructure.MRUFiles.getList()) {
            arrayList.add(new File(string));
        }
        return arrayList;
    }

    public static List<File> filterFiles(List<File> list, FileFilter fileFilter) {
        if (list == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>(list.size());
        for (File file : list) {
            if (!fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public static class ExtensionFileFilter
    implements FileFilter {
        private String[] extensions;
        private String[] normalizedExt;
        private boolean acceptAll;
        private boolean mustExist;
        private boolean includeDirs;

        public ExtensionFileFilter(boolean bl, String ... stringArray) {
            this.acceptAll = ObjTools.indexOf(stringArray, "*") != -1;
            this.mustExist = bl;
            this.setExtensions(stringArray);
        }

        public ExtensionFileFilter(String ... stringArray) {
            this(false, stringArray);
        }

        public static ExtensionFileFilter AcceptAll(boolean bl) {
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter();
            extensionFileFilter.setAcceptAll(true);
            extensionFileFilter.setMustExist(bl);
            return extensionFileFilter;
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (this.mustExist && !file.exists()) {
                return false;
            }
            if (this.acceptAll) {
                return true;
            }
            if (file.isDirectory() && !this.includeDirs) {
                return false;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            int n2 = this.normalizedExt.length;
            if (n > 0 && n < string.length() - 1) {
                String string2 = string.substring(n + 1).toLowerCase(Locale.ENGLISH);
                for (int i = 0; i < n2; ++i) {
                    if (!string2.equals(this.normalizedExt[i])) continue;
                    return true;
                }
            }
            return false;
        }

        public void setExtensions(String[] stringArray) {
            this.extensions = new String[stringArray.length];
            this.normalizedExt = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() == 0) {
                    throw new IllegalArgumentException("Each extension must be non-null and not empty");
                }
                this.extensions[i] = stringArray[i];
                this.normalizedExt[i] = stringArray[i].toLowerCase(Locale.ENGLISH);
            }
        }

        public ExtensionFileFilter() {
        }

        public String[] getExtensions() {
            return this.extensions;
        }

        public String[] getNormalizedExtensions() {
            return this.normalizedExt;
        }

        public boolean acceptAll() {
            return this.acceptAll;
        }

        public void setAcceptAll(boolean bl) {
            this.acceptAll = bl;
        }

        public boolean mustExist() {
            return this.mustExist;
        }

        public void setMustExist(boolean bl) {
            this.mustExist = bl;
        }

        public boolean includeFolders() {
            return this.includeDirs;
        }

        public void setIncludeFolders(boolean bl) {
            this.includeDirs = bl;
        }
    }
}

