/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.ui;

import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import ur_rna.RNAstructureUI.ui.BorderBuilder;

public class RadioButtonPanel
extends JPanel {
    private static final long serialVersionUID = 20120802L;
    private ButtonGroup group;
    private ArrayList<JRadioButton> group2;
    private String[] names;

    private RadioButtonPanel(String string, String string2, ActionListener actionListener, String ... stringArray) {
        int n = string2.equals("Horizontal") ? 1 : stringArray.length;
        int n2 = string2.equals("Vertical") ? 1 : stringArray.length;
        this.setLayout(new GridLayout(n, n2));
        if (string != null) {
            new BorderBuilder().makeTitledBorder(string, this);
        }
        this.group = new ButtonGroup();
        int n3 = stringArray.length;
        this.group2 = new ArrayList(n3);
        this.names = stringArray;
        for (int i = 1; i <= n3; ++i) {
            JRadioButton jRadioButton = new JRadioButton(stringArray[i - 1]);
            jRadioButton.setActionCommand(stringArray[i - 1]);
            if (actionListener != null) {
                jRadioButton.addActionListener(actionListener);
            }
            if (i == 1) {
                jRadioButton.setSelected(true);
            }
            this.group.add(jRadioButton);
            this.group2.add(jRadioButton);
            this.add(jRadioButton);
        }
    }

    public int getSelectedIndex() {
        for (int i = 1; i <= this.names.length; ++i) {
            if (!this.names[i - 1].equals(this.getSelectedName())) continue;
            return i;
        }
        return 0;
    }

    public String getSelectedName() {
        return this.group.getSelection().getActionCommand();
    }

    public static RadioButtonPanel makeHorizontal(String[] stringArray) {
        return new RadioButtonPanel(null, "Horizontal", null, stringArray);
    }

    public static RadioButtonPanel makeVertical(String[] stringArray) {
        return new RadioButtonPanel(null, "Vertical", null, stringArray);
    }

    public static RadioButtonPanel makeHorizontal(String string, String ... stringArray) {
        return new RadioButtonPanel(string, "Horizontal", null, stringArray);
    }

    public static RadioButtonPanel makeVertical(String string, String ... stringArray) {
        return new RadioButtonPanel(string, "Vertical", null, stringArray);
    }

    public static RadioButtonPanel makeHorizontal(String string, ActionListener actionListener, String ... stringArray) {
        return new RadioButtonPanel(string, "Horizontal", actionListener, stringArray);
    }

    public static RadioButtonPanel makeVertical(String string, ActionListener actionListener, String ... stringArray) {
        return new RadioButtonPanel(string, "Vertical", actionListener, stringArray);
    }

    public void setSelectedButton(String string) {
        AbstractButton abstractButton = null;
        for (JRadioButton jRadioButton : this.group2) {
            if (!jRadioButton.getText().equals(string)) continue;
            abstractButton = jRadioButton;
            break;
        }
        this.group.setSelected(abstractButton.getModel(), true);
        for (JRadioButton jRadioButton : this.group2) {
            boolean bl = jRadioButton.getText().equals(string);
            jRadioButton.setSelected(bl);
        }
    }
}

