/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ur_rna.RNAstructureUI.RNAstructure;
import ur_rna.RNAstructureUI.ui.Dialogs;
import ur_rna.RNAstructureUI.ui.FileField;
import ur_rna.RNAstructureUI.ui.RecentFileButton;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.utilities.FileSelectedEvent;
import ur_rna.RNAstructureUI.utilities.MRUFileStorage;
import ur_rna.Utilities.Strings;

public class FieldPanel
extends JPanel {
    private static final long serialVersionUID = 20120802L;
    private int specifiedPanelWidth;
    protected ArrayList<JTextField> textFields = new ArrayList();

    protected FieldPanel() {
        this.setLayout(new GridBagLayout());
        int n = 10;
        this.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
    }

    public FieldPanel(JTextField ... jTextFieldArray) {
        this();
        for (JTextField jTextField : jTextFieldArray) {
            this.addField(jTextField);
        }
    }

    public void addField(JTextField jTextField) {
        this.addField(jTextField, null, null, null);
    }

    public void addField(JTextField jTextField, String string) {
        this.addField(jTextField, string, null, null);
    }

    public void addField(JTextField jTextField, String string, String string2) {
        this.addField(jTextField, string, string2, null);
    }

    public void addField(JTextField jTextField, String string, String string2, ActionListener actionListener) {
        if (string == null) {
            string = jTextField.getName();
        }
        if (string2 == null) {
            string2 = jTextField.getName();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.textFields.add(jTextField);
        this.addFieldCore(jTextField, string, string2, actionListener, gridBagConstraints);
    }

    protected void addFieldCore(JTextField jTextField, String string, String string2, ActionListener actionListener, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(11);
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.gridy = this.textFields.size();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.8;
        this.add((Component)jTextField, gridBagConstraints);
    }

    public JTextField getField(int n) {
        return this.textFields.get(n - 1);
    }

    public JTextField getField(String string) {
        for (JTextField jTextField : this.textFields) {
            if (!string.equals(jTextField.getName())) continue;
            return jTextField;
        }
        return null;
    }

    public void makePanel() {
        Dimension dimension = this.getPreferredSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)Math.max((double)this.specifiedPanelWidth, dimension.getWidth());
        Dimension dimension2 = new Dimension(n2, n);
        this.setPreferredSize(dimension2);
        this.setSize(dimension2);
    }

    public void setPanelWidth(int n) {
        this.specifiedPanelWidth = n;
    }

    public static class FilePanel
    extends FieldPanel {
        private static final long serialVersionUID = 20120802L;
        private final ActionListener buttonListener;
        private static MRUFileStorage recentFiles = new MRUFileStorage();

        public FilePanel(ActionListener actionListener, FileField ... fileFieldArray) {
            super(fileFieldArray);
            this.buttonListener = actionListener;
        }

        public void saveRecent() {
            MRUFileStorage mRUFileStorage = RNAstructure.MRUFiles;
            for (JTextField jTextField : this.textFields) {
                String string;
                if (!(jTextField instanceof FileField) || Strings.isEmpty(string = ((FileField)jTextField).getFile())) continue;
                mRUFileStorage.add(string);
            }
            mRUFileStorage.saveToStorage();
        }

        public String getFile(int n) {
            return this.getField(n).getText().trim();
        }

        public boolean isError() {
            for (JTextField jTextField : this.textFields) {
                if (!jTextField.getText().trim().equals("")) continue;
                String string = jTextField.getName() + " must not be empty.";
                Dialogs.showError(string);
                return true;
            }
            return false;
        }

        public void setFile(int n, String string) {
            this.getField(n).setText(string);
        }

        @Override
        protected void addFieldCore(JTextField jTextField, String string, String string2, ActionListener actionListener, GridBagConstraints gridBagConstraints) {
            FileField fileField;
            super.addFieldCore(jTextField, string, string2, actionListener, gridBagConstraints);
            int n = this.textFields.size();
            gridBagConstraints.gridx += 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            JButton jButton = new JButton("...");
            jButton.setName(jTextField.getName());
            jButton.setActionCommand(string2);
            jButton.setToolTipText("Browse to select file.");
            ButtonListener buttonListener = new ButtonListener(n);
            jButton.addActionListener(buttonListener);
            this.add((Component)jButton, gridBagConstraints);
            if (jTextField instanceof FileField && (fileField = (FileField)jTextField).isInputFile() && fileField.getFilters() != null) {
                RecentFileButton recentFileButton = new RecentFileButton("Recent", fileField.getFilters(), buttonListener, jButton.getActionCommand());
                ++gridBagConstraints.gridx;
                this.add((Component)recentFileButton, gridBagConstraints);
            }
        }

        private class ButtonListener
        implements ActionListener {
            final int index;

            public ButtonListener(int n) {
                this.index = n;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!FilePanel.this.getField(this.index).isEnabled()) {
                    for (int i = 1; i <= this.index - 1; ++i) {
                        if (!FilePanel.this.getFile(i).equals("")) continue;
                        String string = FilePanel.this.getField(this.index).getName() + " cannot be set until after all preceding files (e.g. " + FilePanel.this.getField(i).getName() + ").";
                        Dialogs.showError(string);
                        return;
                    }
                }
                if (actionEvent instanceof FileSelectedEvent) {
                    StandardFileChooser.preemptNextFileNameRequest(((FileSelectedEvent)actionEvent).getFile().toString(), ((FileField)FilePanel.this.getField(this.index)).getFilters());
                }
                FilePanel.this.buttonListener.actionPerformed(actionEvent);
            }
        }
    }
}

