/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.utilities.RequestFocusListener;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.Strings;

public abstract class Dialogs
implements Serializable {
    private static final long serialVersionUID = 20120802L;

    public static void showError(String string) {
        Dialogs.showError(string, "RNAstructure error");
    }

    public static void showError(String string, String string2) {
        JOptionPane.showMessageDialog(null, Dialogs.fmtMsg(string), string2, 0);
    }

    public static String getInput(String string, String string2, Object object) {
        Object object2 = JOptionPane.showInputDialog(null, string2, string, 3, null, null, object);
        return ObjTools.toStr(object2, null);
    }

    public static Double getInput(NumberField.DoubleField doubleField) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(doubleField.getName()), "North");
        jPanel.add(doubleField);
        doubleField.setName("input");
        doubleField.addAncestorListener(new RequestFocusListener());
        JOptionPane.showOptionDialog(null, jPanel, "RNAstructure Input", 2, 1, null, null, null);
        return doubleField.getValue();
    }

    public static Integer getInput(NumberField.IntegerField integerField) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(integerField.getName()), "North");
        jPanel.add(integerField);
        integerField.setName("input");
        integerField.addAncestorListener(new RequestFocusListener());
        JOptionPane.showOptionDialog(null, jPanel, "RNAstructure Input", 2, 1, null, null, null);
        return integerField.getValue();
    }

    public static void showMessage(String string) {
        JOptionPane.showMessageDialog(null, Dialogs.fmtMsg(string), "RNAstructure", 1);
    }

    public static void showMessage(String string, Object ... objectArray) {
        Dialogs.showMessage(String.format(string, objectArray));
    }

    public static String showYesNoCancel(Object object) {
        int n = JOptionPane.showConfirmDialog(null, object, "RNAstructure", 1);
        if (n == 0) {
            return "YES";
        }
        if (n == 1) {
            return "NO";
        }
        return "CANCEL";
    }

    public static String showYesNoCancel(String string) {
        StringBuilder stringBuilder = new StringBuilder(Dialogs.fmtMsg(string));
        return Dialogs.showYesNoCancel(stringBuilder);
    }

    public static boolean showConfirm(Object object) {
        return 0 == JOptionPane.showConfirmDialog(null, object, "RNAstructure", 2);
    }

    public static boolean showConfirm(String string) {
        return 0 == JOptionPane.showConfirmDialog(null, Dialogs.fmtMsg(string), "RNAstructure", 2);
    }

    public static void showWarning(Component component) {
        JOptionPane.showMessageDialog(null, component, "RNAstructure", 2);
    }

    public static void showWarning(String string) {
        JOptionPane.showMessageDialog(null, Dialogs.fmtMsg(string), "RNAstructure", 2);
    }

    public static void showWarning(String string, boolean bl) {
        if (bl) {
            JOptionPane.showMessageDialog(null, Dialogs.createTextPanel(string), "RNAstructure", 2);
        } else {
            JOptionPane.showMessageDialog(null, Dialogs.fmtMsg(string), "RNAstructure", 2);
        }
    }

    private static String fmtMsg(String string) {
        return string;
    }

    public static String htmlCenter(String string) {
        if (string.substring(0, 6).equals("<html>")) {
            return string;
        }
        if (string.substring(0, 9).equals("<no-html>")) {
            return string.substring(9);
        }
        return "<html><center>" + Dialogs.nl2br(Strings.escapeHTML(string)) + "</center></html>";
    }

    public static String nohtml(String string) {
        if (string.substring(0, 4).equals("<html>")) {
            return string;
        }
        return "<no-html>" + string;
    }

    public static String nl2br(String string) {
        return string.replace("\n", "<br>").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public static JPanel createTextPanel(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBackground(jPanel.getBackground());
        jTextArea.setForeground(jPanel.getForeground());
        jTextArea.setFont(jPanel.getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setPreferredSize(new Dimension(560, 300));
        jTextArea.setText(string);
        return jPanel;
    }
}

