/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.menus;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class MenuRolloverAdapter
implements MouseListener,
Serializable {
    private static final long serialVersionUID = 20120802L;
    private HashMap<Object, String> rollovers = new HashMap();
    private final Consumer<String> rolloverHandler;

    public MenuRolloverAdapter(Consumer<String> consumer) {
        this.rolloverHandler = consumer;
    }

    public void add(JMenuItem jMenuItem, String string) {
        this.rollovers.put(jMenuItem, string);
        jMenuItem.addMouseListener(this);
    }

    public static MenuRolloverAdapter fromToolTips(Consumer<String> consumer, JComponent jComponent) {
        MenuRolloverAdapter menuRolloverAdapter = new MenuRolloverAdapter(consumer);
        menuRolloverAdapter.addFromToolTips(jComponent);
        return menuRolloverAdapter;
    }

    public void addFromToolTips(JComponent jComponent) {
        for (Component component : jComponent.getComponents()) {
            if (!(component instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)component;
            String string = jMenuItem.getToolTipText();
            if (string != null && string.length() != 0) {
                this.add(jMenuItem, string);
            }
            if (jMenuItem.getComponentCount() == 0) continue;
            this.addFromToolTips(jMenuItem);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.reset();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.set(mouseEvent.getSource());
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.reset();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.reset();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.reset();
    }

    private void reset() {
        this.rolloverHandler.accept(null);
    }

    private void set(Object object) {
        this.rolloverHandler.accept(this.rollovers.get(object));
    }
}

