/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.RNAstructureUI.drawing.menus;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ur_rna.RNAstructureUI.drawing.dialogs.StructureDialog;
import ur_rna.RNAstructureUI.menus.MainMenu;
import ur_rna.RNAstructureUI.ui.NumberField;
import ur_rna.RNAstructureUI.ui.StandardFileChooser;
import ur_rna.RNAstructureUI.ui.ValueSelectionDialog;
import ur_rna.RNAstructureUI.utilities.FileFilters;
import ur_rna.Utilities.swing.CheckMergeItem;

public class StructureMenu
extends MainMenu {
    private static final long serialVersionUID = 20120802L;
    private StructureDialog dialog;
    private CheckMergeItem circular;
    private CheckMergeItem flat;
    private CheckMergeItem flipped;
    private CheckMergeItem circled;

    public StructureMenu(StructureDialog structureDialog) {
        super("Draw");
        this.dialog = structureDialog;
        this.addItem("Go to Structure...", "Switch to a selected structure.");
        this.addItem("Zoom", "Zoom this structure.");
        this.addSeparator();
        this.flipped = this.addCheckItem("Render Counterclockwise/Flipped", "Checked if a structure is rendered Counterclockwise (Flipped Horizontally).");
        this.circled = this.addCheckItem("Render Circles around Nucleotides", "Checked if nucleotides are surrounded by circles.");
        this.circular = this.addCheckItem("Render Circular Structure", "Draw the structure with its backbone stretched around a circle.");
        this.flat = this.addCheckItem("Render Linear (Flat) Structure", "Draw the structure with a linear backbone.");
        this.addSeparator();
        this.addItem("Write Dot Bracket File", "Write a dot bracket file of all structures in this window.");
        this.addItem("Write Helix (Text) File", "Write a text file of the helices in this structure.");
        this.addItem("Write Postscript File", "Write the current structure to a Postscript image file.");
        this.addItem("Write SVG File", "Write the current structure to an SVG image file.");
        this.updateMenuUI();
    }

    @Override
    protected void onMenuAction(String string, ActionEvent actionEvent) {
        if (string.contains("Circles")) {
            this.dialog.toggleOption(StructureDialog.DrawOptions.UNCIRCLED);
            this.updateMenuUI();
        } else if (string.contains("Circular")) {
            this.dialog.toggleOption(StructureDialog.DrawOptions.CIRCULAR);
            this.updateMenuUI();
        } else if (string.contains("Flat")) {
            this.dialog.toggleOption(StructureDialog.DrawOptions.FLAT);
            this.updateMenuUI();
        } else if (string.contains("Flipped")) {
            this.dialog.toggleOption(StructureDialog.DrawOptions.FLIPPED);
            this.updateMenuUI();
        } else if (string.contains("File")) {
            String string2;
            if (string.contains("Dot Bracket")) {
                String string3 = StandardFileChooser.getSaveName(FileFilters.Bracket);
                if (string3 != null) {
                    this.dialog.writeDotBracketFile(string3);
                }
            } else if (string.contains("Helix")) {
                String string4 = StandardFileChooser.getSaveName(FileFilters.Helix);
                if (string4 != null) {
                    this.dialog.writeHelixFile(string4);
                }
            } else if (string.contains("Postscript")) {
                String string5 = StandardFileChooser.getSaveName(FileFilters.Postscript);
                if (string5 != null) {
                    this.dialog.writePostscriptFile(string5);
                }
            } else if (string.contains("SVG") && (string2 = StandardFileChooser.getSaveName(FileFilters.SVG)) != null) {
                this.dialog.writeSVGFile(string2);
            }
        } else if (string.equals("Go to Structure...")) {
            new ChooseStructureDialog();
        } else if (string.equals("Zoom")) {
            this.dialog.viewZoomDialog();
        }
    }

    private void updateMenuUI() {
        this.circular.setSelected(this.dialog.getOption(StructureDialog.DrawOptions.CIRCULAR));
        this.flat.setSelected(this.dialog.getOption(StructureDialog.DrawOptions.FLAT));
        this.flipped.setSelected(this.dialog.getOption(StructureDialog.DrawOptions.FLIPPED));
        this.circled.setSelected(!this.dialog.getOption(StructureDialog.DrawOptions.UNCIRCLED));
    }

    private class ChooseStructureDialog
    extends ValueSelectionDialog {
        private static final long serialVersionUID = 20120802L;
        private final int max;
        private int prevValue;
        private JButton first;
        private JButton last;
        private JButton next;
        private JButton prev;
        private JLabel display;
        private NumberField.IntegerField valueField;

        public ChooseStructureDialog() {
            super("Go to Structure");
            this.prevValue = -1;
            this.first = new JButton("|<<");
            this.last = new JButton(">>|");
            this.next = new JButton(">");
            this.prev = new JButton("<");
            this.display = new JLabel("Structure 1000 of 1000");
            this.max = StructureMenu.this.dialog.getStructureCount();
            this.valueField = new NumberField.IntegerField("Structure Number", StructureMenu.this.dialog.getStructureNumber(), 1, this.max);
            this.valueField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    ChooseStructureDialog.this.valueChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    ChooseStructureDialog.this.valueChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    ChooseStructureDialog.this.valueChanged();
                }
            });
            this.buildDialog("OK", this.valueField);
            this.updateNavUI();
            this.updateDisplay();
        }

        private void valueChanged() {
            this.updateNavUI();
            int n = this.getCurrent(-1);
            if (n != -1) {
                this.updateStructure();
            }
        }

        private void updateNavUI() {
            Integer n = this.valueField.getValue();
            if (n == null) {
                this.first.setEnabled(true);
                this.last.setEnabled(true);
                this.next.setEnabled(false);
                this.prev.setEnabled(false);
            } else {
                int n2 = n;
                this.first.setEnabled(n2 > 1);
                this.last.setEnabled(n2 < this.max);
                this.next.setEnabled(n2 < this.max);
                this.prev.setEnabled(n2 > 1);
            }
        }

        private void setCurrent(int n) {
            if (n < 1) {
                n = 1;
            }
            if (n > this.max) {
                n = this.max;
            }
            this.valueField.setValue(n);
        }

        private int getCurrent(int n) {
            Integer n2 = this.valueField.getValue();
            if (n2 == null) {
                return n;
            }
            if (n2 < 1) {
                return 1;
            }
            if (n2 > this.max) {
                return this.max;
            }
            return n2;
        }

        private int getCurrent() {
            return this.getCurrent(1);
        }

        @Override
        public JPanel createAdditionalControls() {
            JPanel jPanel = new JPanel();
            jPanel.add((Component)this.first, "West");
            jPanel.add((Component)this.prev, "West");
            jPanel.add((Component)this.display, "Center");
            jPanel.add((Component)this.next, "East");
            jPanel.add((Component)this.last, "East");
            this.first.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChooseStructureDialog.this.setCurrent(1);
                }
            });
            this.last.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChooseStructureDialog.this.setCurrent(ChooseStructureDialog.this.max);
                }
            });
            this.next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChooseStructureDialog.this.setCurrent(ChooseStructureDialog.this.getCurrent(0) + 1);
                }
            });
            this.prev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChooseStructureDialog.this.setCurrent(ChooseStructureDialog.this.getCurrent() - 1);
                }
            });
            return jPanel;
        }

        @Override
        public ActionListener createSelectionAction() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChooseStructureDialog.this.updateStructure();
                    ChooseStructureDialog.this.dispose();
                }
            };
        }

        private void updateStructure() {
            if (StructureMenu.this.dialog.getStructureNumber() != this.getCurrent()) {
                StructureMenu.this.dialog.setStructureNumber(this.getCurrent());
            }
            StructureMenu.this.dialog.zoomImage();
            StructureMenu.this.dialog.repaint();
            this.updateDisplay();
        }

        private void updateDisplay() {
            this.display.setText(String.format("Structure %s of %s", StructureMenu.this.dialog.getStructureNumber(), this.max));
        }
    }
}

