# This script is not intended to be executed directly.  It is sourced by test-runner.sh and most functions you see here are defined in test-tools.sh
# The variables EXENAME, EXEBASE, OKDIR, and EXEDIR are defined externally.

source "$SCRIPT_DIR/test-tools-gui.sh"
beginTestBlock  # Begin a group of tests.
runMake -r gui-tester EnergyPlot

 # Define the function that will be called implicitly by `runFullTest` and explicitly by `runTest $EXE`
function bifold-gui() {
  local minArgs=3
  (($# >= minArgs)) || { warnmsg "$EXEBASE requires $minArgs arguments."; return  1; }
  local seqFile1="$1" seqFile2="$2" ctFile="$3" ACID=RNA
  BOOL_FLAGS=(d i)                             # Flags with NO parameters       (e.g. -d sets variable $arg_d to "1" in guiParseArgs)
  PARAM_FLAGS=(s t l c m w p md sh si sm)    # Flags with required parameters (e.g. -s "FILE" sets variable $arg_s to "FILE" in guiParseArgs)
  
  guiParseArgs ${@:minArgs+1} # Parse remaining arguments

  guiArg -d && ACID=DNA
  guiWrite "Menu '$ACID', 'Fold $ACID Bimolecular'
    Click { BUTTON 'Sequence File 1' }
    TypeText '$seqFile1'; TypeENTER
    Prohibit { DIALOG 'RNAstructure error' } 
    Click { BUTTON 'Sequence File 2' }
    TypeText '$seqFile2'; TypeENTER
    Prohibit { DIALOG 'RNAstructure error' } 
    SetText { FIELD  'CT File' }, '$ctFile'" 

# guiWriteIf writes lines to the gui script IF the argument specified by the first parameter is present.
  guiWriteIf -i "Menu 'Force', 'Forbid Unimolecular Pairs'" # intramolecular_option
  guiWriteIf -s "CLICK { CHECK 'Generate Save File' }"
  guiWriteIf -c "Menu 'Force', 'Restore Constraints';  TypeText '$arg_c';  TypeENTER"
  guiWriteIf -l "Menu 'Maximum Loop', 'Set Maximum Loop Size'
    Focus { FIELD 'input' }
    ClearText; TypeText '$arg_l';
    Click { BUTTON 'OK' }"
  guiWriteIf -md "Menu 'Force', 'Maximum Pairing Distance'
    Click { OPTION 'Yes' }
    Focus { FIELD 'Maximum Distance' }
    ClearText; TypeText '$arg_md'
    Click { BUTTON 'OK' }"
  guiWriteIf -m "Focus { Field 'Max Number of Structures' }; ClearText; TypeText '$arg_m'"
  guiWriteIf -p "Focus { Field 'Max % Energy Difference' };  ClearText; TypeText '$arg_p'"

  #----SHAPE----
  guiWriteIf -sh "Menu 'Force', 'Read SHAPE Reactivity -- Pseudo-Energy Constraints'
    Focus { FIELD 'SHAPE Data File' };    TypeText '$arg_sh';"
  guiWriteIf -si   "Focus { FIELD 'Intercept *'}; ClearText;  TypeText '$arg_si'"
  guiWriteIf -sm   "Focus { FIELD 'Slope *'};     ClearText;  TypeText '$arg_sm'"
  guiWriteIf -sh "Click { BUTTON 'OK' }" # Click OK on SHAPE dialog
  #----^ SHAPE ^ ----
  
  guiWriteIf -t "Menu 'Temperature', 'Set Temperature'
    Focus { FIELD 'input' };
    ClearText; TypeText '$arg_t'; 
    Click { BUTTON 'OK' };"
  guiWriteIf -w "Focus { FIELD 'Window Size' };  ClearText; TypeText '$arg_w'"

  guiWrite "CLICK { BUTTON 'START' }
    Prohibit { DIALOG 'RNAstructure error' } 
    WAIT  { BUTTON 'OK' }, ${CALC_TIMEOUT}000 
    CLICK { BUTTON 'Cancel' }"

  guiRun  # Run the script
  local code=$? # Store return value

  # After the script has run, move any sav files that were specified by -s (because the java GUI does not allow setting the save-file name.)
  if guiArg -s; then
    [[ -f $OUT.sav ]] && mv "$OUT.sav" "$arg_s" || 
    { errmsg "Failed to rename save-file $OUT.sav to $arg_s"; code=1; }
  fi
  
  guiUnsetArgs # Clean up temporary variables
  return $code
}


EXT=.ct  # set extension for @OKFILE and @OUTFILE placeholders (defaults for runDiff)

# Test bifold_without_options.
runFullTest 'without_options'  $DOUBLESEQ @OUT.ct

# Test bifold_dna_option.
runFullTest 'dna_option'  $DOUBLESEQ @OUT.ct -d

# Test bifold_intramolecular_option.
runFullTest 'intramolecular_option'  $DOUBLESEQ @OUT.ct -i

# Test bifold_loop_option.
runFullTest 'loop_option'  $DOUBLESEQ @OUT.ct -l 5

# Test bifold_max_structures_option.
runFullTest 'max_structures_option'  $DOUBLESEQ @OUT.ct -m 2

# Test bifold_percent_difference_option.
runFullTest 'percent_difference_option'  $DOUBLESEQ @OUT.ct -p 1

SAV_FILE=${EXEBASE}_sav_plot.fsv #named so that it will be auto-deleted by the 'sav_plot' test.

# Test bifold_save_file_option.
runFullTest 'save_file_option'  $DOUBLESEQ @OUT.ct -s $SAV_FILE

# Test bifold_sav_plot (The save plot generated by the save file option).
initTest 'sav_plot' && { # skip this block if the test is excluded.
  [[ -f $SAV_FILE ]] || runTest @EXE $DOUBLESEQ @OUT.ct -s $SAV_FILE # Create the save file (just in case the previous test was excluded etc)
  runTest EnergyPlot $SAV_FILE @OUT.ps
  addTestOuput $SAV_FILE # mark this file as test output (for proper cleanup)
  replaceInFiles "$SAV_FILE" "[FILENAME]" @OUT.ps # replaces bifold_sav_plot.fsv or bifold-smp_sav_plot.fsv with just "[FILENAME]" so that -smp and serial output is identical.
  runDiff @OUT.ps @OKDIR/bifold_sav_plot.ps
endTest; }

# Test bifold_temperature_option.
runFullTest 'temperature_option'  $DOUBLESEQ @OUT.ct -t 250

# Test bifold_window_size_option.
runFullTest 'window_size_option'  $DOUBLESEQ @OUT.ct -w 20

endTestBlock # End a group of tests. Also cleans up orphaned files etc.
