/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class WaitDialog
extends JDialog {
    private static final String DEFAULT_TITLE = "Please wait...";
    private static final String DEFAULT_MESSAGE = "Operation in progress. Please wait...";
    private String message;
    private boolean showProgress;
    private boolean showCancel;
    private float progressValue;
    private float progressTotal = 100.0f;
    private ActionListener cancelListener;
    private boolean canceled;
    private JLabel lblMessage;
    private JProgressBar prgProgress;
    private JButton btnCancel;
    private boolean closeOnCancel = true;

    public static WaitDialog show(Frame frame, String string) {
        WaitDialog waitDialog = new WaitDialog(frame, string);
        waitDialog.setVisible(true);
        return waitDialog;
    }

    public WaitDialog() {
        this((Frame)null, DEFAULT_TITLE);
    }

    public WaitDialog(Frame frame) {
        this(frame, DEFAULT_TITLE);
    }

    public WaitDialog(String string) {
        this(null, null, string);
    }

    public WaitDialog(Frame frame, String string) {
        this(frame, string, DEFAULT_MESSAGE);
    }

    public WaitDialog(Frame frame, String string, String string2) {
        this(frame, string, string2, false, false);
    }

    public WaitDialog(Frame frame, String string, String string2, boolean bl, ActionListener actionListener) {
        this(frame, string, string2, bl, actionListener != null);
        this.setCancelListener(actionListener);
    }

    public WaitDialog(Frame frame, String string, String string2, boolean bl, boolean bl2) {
        super(frame, string == null ? DEFAULT_TITLE : string);
        this.message = string2 == null ? DEFAULT_MESSAGE : string2;
        this.showProgress = bl;
        this.showCancel = bl2;
        this.buildUI();
        this.updateUI();
    }

    private void updateUI() {
        this.lblMessage.setText(this.message);
        this.prgProgress.setVisible(this.showProgress);
        if (this.showProgress) {
            this.prgProgress.setValue(Math.round(this.progressValue / this.progressTotal));
        }
        this.btnCancel.setVisible(this.showCancel);
    }

    private void buildUI() {
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setSize(200, 100);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this::canceled);
        this.prgProgress = new JProgressBar();
        this.lblMessage = new JLabel();
        this.add((Component)this.lblMessage, "North");
        this.add((Component)this.prgProgress, "Center");
        this.add((Component)this.btnCancel, "South");
    }

    private void canceled(ActionEvent actionEvent) {
        this.canceled = true;
        if (this.cancelListener != null) {
            this.cancelListener.actionPerformed(actionEvent);
        }
        if (this.closeOnCancel) {
            this.dispose();
        }
    }

    public void close() {
        this.dispose();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
        this.updateUI();
    }

    public boolean isProgressVisible() {
        return this.showProgress;
    }

    public WaitDialog setProgressVisible(boolean bl) {
        this.showProgress = bl;
        this.updateUI();
        return this;
    }

    public boolean isCancelVisible() {
        return this.showCancel;
    }

    public WaitDialog setCancelVisible(boolean bl) {
        this.showCancel = bl;
        this.updateUI();
        return this;
    }

    public float getProgressValue() {
        return this.progressValue;
    }

    public WaitDialog setProgressValue(float f) {
        this.progressValue = f;
        this.updateUI();
        return this;
    }

    public float getProgressTotal() {
        return this.progressTotal;
    }

    public WaitDialog setProgressTotal(float f) {
        this.progressTotal = f;
        this.updateUI();
        return this;
    }

    public ActionListener getCancelListener() {
        return this.cancelListener;
    }

    public WaitDialog setCancelListener(ActionListener actionListener) {
        this.cancelListener = actionListener;
        return this;
    }

    public boolean isCloseOnCancel() {
        return this.closeOnCancel;
    }

    public WaitDialog setCloseOnCancel(boolean bl) {
        this.closeOnCancel = bl;
        return this;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.btnCancel.doClick();
    }
}

