/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import ur_rna.Utilities.Convert;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.annotation.Nullable;
import ur_rna.Utilities.swing.AcceleratorKey;
import ur_rna.Utilities.swing.KeyMnemonic;

public class UiAction
extends AbstractAction {
    public static final String TEXT_KEY = "HandlerTextKey";
    private static ActionListener[] EMPTY_LISTENERS = new ActionListener[0];
    private ActionListener listener;
    private Set<ActionListener> listeners = null;

    public UiAction(@Nullable String string, @NotNull Runnable runnable) {
        this(string, runnable, null);
    }

    public UiAction(@Nullable String string, @NotNull Runnable runnable, @Nullable Icon icon) {
        this(string, (ActionEvent actionEvent) -> runnable.run(), icon);
    }

    public UiAction(@Nullable String string, @Nullable ActionListener actionListener) {
        this(string, actionListener, null);
    }

    public UiAction(@Nullable String string, @Nullable ActionListener actionListener, @Nullable Icon icon) {
        this.listener = actionListener;
        if (string != null) {
            this.setName(string);
            this.setDesc(KeyMnemonic.stripMnemonics(string));
        }
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    public String name() {
        return UiAction.getName(this);
    }

    public int mnemonic() {
        return UiAction.getMnemonic(this);
    }

    public Icon icon() {
        return UiAction.getIcon(this);
    }

    public String desc() {
        return UiAction.getDesc(this);
    }

    public KeyStroke keyStroke() {
        return UiAction.getKeyStroke(this);
    }

    public String command() {
        return UiAction.getCommand(this);
    }

    public UiAction setName(String string) {
        int n = KeyMnemonic.getMnemonic(string);
        if (n != 0) {
            this.setMnemonic(n);
            string = KeyMnemonic.stripMnemonics(string);
        }
        this.putValue("Name", string);
        return this;
    }

    public UiAction setMnemonic(int n) {
        this.putValue("MnemonicKey", n);
        return this;
    }

    public UiAction setCommand(String string) {
        this.putValue("ActionCommandKey", string);
        return this;
    }

    public UiAction setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
        return this;
    }

    public UiAction setIcon(Image image) {
        this.setIcon(new ImageIcon(image));
        return this;
    }

    public UiAction setDesc(String string) {
        this.putValue("ShortDescription", string);
        return this;
    }

    public UiAction setLongDesc(String string) {
        this.putValue("LongDescription", string);
        return this;
    }

    public UiAction setKeyStroke(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
        return this;
    }

    public UiAction setKeyStroke(String string) {
        this.putValue("AcceleratorKey", AcceleratorKey.getKey(string));
        return this;
    }

    public UiAction setKeyStroke(char c) {
        this.putValue("AcceleratorKey", AcceleratorKey.getKey(c));
        return this;
    }

    public ActionListener getListener() {
        return this.listener;
    }

    public ActionListener[] getListeners() {
        if (this.listeners == null || this.listeners.size() == 0) {
            ActionListener[] actionListenerArray;
            if (this.listener == null) {
                actionListenerArray = EMPTY_LISTENERS;
            } else {
                ActionListener[] actionListenerArray2 = new ActionListener[1];
                actionListenerArray = actionListenerArray2;
                actionListenerArray2[0] = this.listener;
            }
            return actionListenerArray;
        }
        if (this.listener == null) {
            return this.listeners.toArray(new ActionListener[this.listeners.size()]);
        }
        ActionListener[] actionListenerArray = new ActionListener[this.listeners.size() + 1];
        actionListenerArray[0] = this.listener;
        ObjTools.copyTo(this.listeners, actionListenerArray, 1);
        return actionListenerArray;
    }

    public void addListener(ActionListener actionListener) {
        if (this.listener == null) {
            this.listener = actionListener;
        } else {
            if (this.listeners == null) {
                this.listeners = new HashSet<ActionListener>();
            }
            this.listeners.add(actionListener);
        }
    }

    public void removeListener(ActionListener actionListener) {
        if (this.listener == actionListener) {
            this.listener = null;
        } else if (this.listeners != null) {
            this.listeners.remove(actionListener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.listener != null) {
            this.listener.actionPerformed(actionEvent);
        }
    }

    public void invoke(Object object) {
        ActionEvent actionEvent = new ActionEvent(object, 1001, this.name(), System.currentTimeMillis(), 0);
        this.actionPerformed(actionEvent);
    }

    public void invoke(Object object, String string) {
        ActionEvent actionEvent = new ActionEvent(object, 1001, string, System.currentTimeMillis(), 0);
        this.actionPerformed(actionEvent);
    }

    public static String getName(Action action) {
        return Convert.toString(action.getValue("Name"));
    }

    public static String getDesc(Action action) {
        return Convert.toString(action.getValue("ShortDescription"));
    }

    public static Icon getIcon(Action action) {
        Object object = action.getValue("SmallIcon");
        if (object instanceof Icon) {
            return (Icon)object;
        }
        return null;
    }

    public static int getMnemonic(Action action) {
        Object object = action.getValue("MnemonicKey");
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return 0;
    }

    public static KeyStroke getKeyStroke(Action action) {
        Object object = action.getValue("AcceleratorKey");
        if (object instanceof KeyStroke) {
            return (KeyStroke)object;
        }
        if (object instanceof String) {
            return AcceleratorKey.getKey((String)object);
        }
        if (object instanceof Character) {
            return AcceleratorKey.getKey(((Character)object).charValue());
        }
        return null;
    }

    public static String getCommand(Action action) {
        return Convert.toString(action.getValue("ActionCommandKey"));
    }

    public static boolean isSelected(Action action) {
        return Boolean.TRUE.equals(action.getValue("SwingSelectedKey"));
    }

    public static void setSelected(Action action, boolean bl) {
        action.putValue("SwingSelectedKey", bl);
    }
}

