/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.util.Arrays;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class TextDocListener
implements DocumentListener {
    Object[] listeners = new Object[1];
    int count = 0;
    boolean changed;
    int suspendCount;

    public TextDocListener() {
    }

    public TextDocListener(Runnable runnable) {
        this.addListener(runnable);
    }

    public TextDocListener(Consumer<DocumentEvent> consumer) {
        this.addListener(consumer);
    }

    public void listen(JTextComponent jTextComponent) {
        jTextComponent.getDocument().addDocumentListener(this);
    }

    public void addListener(Consumer<DocumentEvent> consumer) {
        this.add(consumer);
    }

    public void addListener(Runnable runnable) {
        this.add(runnable);
    }

    private void add(Object object) {
        if (this.count >= this.listeners.length) {
            this.listeners = Arrays.copyOf(this.listeners, Math.max(4, this.listeners.length * 2));
        }
        this.listeners[this.count++] = object;
    }

    private boolean removeListener(Object object) {
        if (object != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (!object.equals(this.listeners[i])) continue;
                this.listeners[i] = null;
                System.arraycopy(this.listeners, i + 1, this.listeners, i, this.listeners.length - (i + 1));
                --this.count;
                return true;
            }
        }
        return false;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markChanged() {
        TextDocListener textDocListener = this;
        synchronized (textDocListener) {
            this.changed = true;
        }
    }

    private void update(DocumentEvent documentEvent) {
        if (this.suspendCount != 0) {
            return;
        }
        this.markChanged();
        if (this.count == 0) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.notifyListeners(documentEvent);
        } else {
            SwingUtilities.invokeLater(() -> this.notifyListeners(documentEvent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetIfChanged() {
        boolean bl;
        TextDocListener textDocListener = this;
        synchronized (textDocListener) {
            bl = this.changed;
            this.changed = false;
        }
        return bl;
    }

    public void reset() {
        this.changed = false;
    }

    public void suspendUpdates() {
        ++this.suspendCount;
    }

    public void resumeUpdates() {
        if (this.suspendCount == 0) {
            throw new IllegalStateException(this.getClass().getSimpleName() + "function resumeUpdates() was called too many times.");
        }
        --this.suspendCount;
    }

    private void notifyListeners(DocumentEvent documentEvent) {
        Object[] objectArray;
        for (Object object : objectArray = Arrays.copyOf(this.listeners, this.count)) {
            if (object instanceof Runnable) {
                ((Runnable)object).run();
                continue;
            }
            ((Consumer)object).accept(documentEvent);
        }
    }
}

