/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.swing;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class ImageUtil {
    public static BufferedImage toBufferedImage(Image image, boolean bl) {
        if (image instanceof BufferedImage && !bl) {
            return (BufferedImage)image;
        }
        if (!(image instanceof BufferedImage)) {
            image = new ImageIcon(image).getImage();
        }
        BufferedImage bufferedImage = ImageUtil.createCompatibleImage(image.getWidth(null), image.getHeight(null), ImageUtil.hasAlpha(image));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        return ImageUtil.toBufferedImage(image, false);
    }

    public static BufferedImage toBufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(renderedImage.getWidth(), renderedImage.getHeight());
        boolean bl = colorModel.isAlphaPremultiplied();
        Hashtable<String, Object> hashtable = null;
        if (renderedImage.getPropertyNames() != null) {
            hashtable = new Hashtable<String, Object>();
            for (String string : renderedImage.getPropertyNames()) {
                hashtable.put(string, renderedImage.getProperty(string));
            }
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, bl, hashtable);
        renderedImage.copyData(writableRaster);
        return bufferedImage;
    }

    public static BufferedImage getAlphaImage(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int[] nArray = new int[]{8};
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, true, 1, 0);
        WritableRaster writableRaster2 = ((ColorModel)componentColorModel).createCompatibleWritableRaster(n, n2);
        BufferedImage bufferedImage2 = new BufferedImage(componentColorModel, writableRaster2, false, null);
        int[] nArray2 = new int[bufferedImage.getWidth() * writableRaster.getNumBands()];
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            writableRaster.getPixels(0, i, bufferedImage.getWidth(), 1, nArray2);
            if (bufferedImage.getTransparency() == 2) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray2[j] <= 0) continue;
                    nArray2[j] = 255;
                }
            }
            bufferedImage2.getRaster().setPixels(0, i, bufferedImage.getWidth(), 1, nArray2);
        }
        return bufferedImage2;
    }

    public static boolean hasAlpha(Image image) {
        ColorModel colorModel;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            colorModel = pixelGrabber.getColorModel();
        }
        return colorModel.hasAlpha();
    }

    public static boolean usesAlpha(Image image) {
        if (image == null) {
            return false;
        }
        BufferedImage bufferedImage = ImageUtil.toBufferedImage(image);
        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
        if (writableRaster == null) {
            return false;
        }
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        for (int i = 0; i < dataBuffer.getSize(); ++i) {
            int n = dataBuffer.getElem(i);
            if (n >= 255) continue;
            return true;
        }
        return false;
    }

    public static BufferedImage createCompatibleImage(int n, int n2, boolean bl) {
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            return graphicsConfiguration.createCompatibleImage(n, n2, bl ? 3 : 1);
        }
        catch (HeadlessException headlessException) {
            return new BufferedImage(n, n2, bl ? 2 : 1);
        }
    }
}

