/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import ur_rna.Utilities.AppInfo;
import ur_rna.Utilities.Strings;

public class FilePreferences
extends AbstractPreferences {
    private static final Logger log = Logger.getLogger(FilePreferences.class.getName());
    private static final String[] EMPTY_NAME_ARRAY = new String[0];
    private boolean modified;
    private Map<String, String> prefs;
    private Set<String> childNames;
    protected final RootNode root;

    protected FilePreferences(AbstractPreferences abstractPreferences, String string) {
        super(abstractPreferences, string);
        log.finest("Instantiating node " + string);
        this.prefs = new TreeMap<String, String>();
        this.childNames = new TreeSet<String>();
        this.root = abstractPreferences == null ? (RootNode)this : ((FilePreferences)abstractPreferences).rootNode();
    }

    public static FilePreferences createRoot() {
        return FilePreferences.createRoot(null);
    }

    public static FilePreferences createRoot(String string) {
        RootNode rootNode = new RootNode(string == null ? null : new File(string));
        try {
            rootNode.loadProps();
            rootNode.readProps();
        }
        catch (BackingStoreException backingStoreException) {
            log.severe("Exception initializing preferences from file. " + rootNode.getPreferencesFile() + " - " + backingStoreException.toString());
        }
        return rootNode;
    }

    public File getPreferencesFile() {
        return this.rootNode().getFile();
    }

    public void setPreferencesFile(File file) {
        this.rootNode().setFile(file);
    }

    public FilePreferences getRoot() {
        return this.root;
    }

    protected RootNode rootNode() {
        return this.root;
    }

    public boolean isModified() {
        return this.modified || this.isRemoved();
    }

    @Override
    protected void putSpi(String string, String string2) {
        this.modified = true;
        this.prefs.put(string, string2);
    }

    @Override
    protected String getSpi(String string) {
        return this.prefs.get(string);
    }

    @Override
    protected void removeSpi(String string) {
        this.modified = true;
        this.prefs.remove(string);
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        ((FilePreferences)this.parent()).childNames.remove(this.name());
        this.rootNode().removeProps(this.nodePrefix(), true);
        this.rootNode().storeProps();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        return this.prefs.keySet().toArray(new String[this.prefs.keySet().size()]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.childNames.size() == 0 ? EMPTY_NAME_ARRAY : this.childNames.toArray(new String[this.childNames.size()]);
    }

    @Override
    protected FilePreferences childSpi(String string) {
        FilePreferences filePreferences = new FilePreferences(this, string);
        if (this.childNames.contains(string)) {
            filePreferences.readProps();
        } else {
            filePreferences.newNode = true;
            filePreferences.modified = true;
        }
        return filePreferences;
    }

    @Override
    public void sync() throws BackingStoreException {
        this.rootNode().loadProps();
        super.sync();
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        this.readProps();
    }

    protected void readProps() {
        Properties properties = this.root.getProps();
        String string = this.nodePrefix();
        int n = string.length();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(n);
            int n2 = string3.indexOf(47);
            if (n2 == -1) {
                this.prefs.put(string3, properties.getProperty(string2));
                continue;
            }
            if (n2 == 0) {
                throw new IndexOutOfBoundsException("Property key name must not be empty: " + string2);
            }
            this.childNames.add(string3.substring(0, n2));
        }
        this.modified = false;
    }

    public String nodePrefix() {
        return this.absolutePath() + "/";
    }

    @Override
    public void flush() throws BackingStoreException {
        this.rootNode().removeProps(this.nodePrefix(), false);
        super.flush();
        this.rootNode().storeProps();
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        Properties properties = this.root.getProps();
        String string = this.nodePrefix();
        for (String string2 : this.prefs.keySet()) {
            properties.setProperty(string + string2, this.prefs.get(string2));
        }
    }

    public static class Factory
    implements PreferencesFactory {
        private static final Logger log = Logger.getLogger(Factory.class.getName());
        FilePreferences rootPreferences;
        private static File preferencesFile;

        public static void register() {
            System.setProperty("java.util.prefs.PreferencesFactory", Factory.class.getName());
        }

        public static void register(File file) {
            Factory.register();
            Factory.setPreferencesFile(file);
        }

        @Override
        public Preferences systemRoot() {
            return this.userRoot();
        }

        @Override
        public Preferences userRoot() {
            if (this.rootPreferences == null) {
                log.finer("Instantiating root preferences");
                this.rootPreferences = FilePreferences.createRoot();
            }
            return this.rootPreferences;
        }

        public static void setPreferencesFile(String string) {
            Factory.setPreferencesFile(new File(string));
        }

        public static void setPreferencesFile(File file) {
            preferencesFile = file;
        }

        public static File getPreferencesFile() {
            if (preferencesFile == null) {
                Class<?> clazz;
                String string = System.getProperty("program.title");
                if (Strings.isEmpty(string)) {
                    clazz = AppInfo.getMainClass();
                    string = clazz == null ? "java" : clazz.getName();
                }
                clazz = System.getProperty("user.home") + File.separator + string + ".prefs";
                preferencesFile = new File((String)((Object)clazz)).getAbsoluteFile();
                log.finer("Preferences file is " + preferencesFile);
            }
            return preferencesFile;
        }
    }

    protected static class RootNode
    extends FilePreferences {
        private File file;
        private Properties cachedProps;

        public File getFile() {
            return this.file == null ? Factory.getPreferencesFile() : this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public RootNode(File file) {
            super(null, "");
            this.file = file;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    this.autoFlush();
                }
            };
            thread.setPriority(10);
            Runtime.getRuntime().addShutdownHook(thread);
        }

        protected void autoFlush() {
            try {
                this.flush();
            }
            catch (BackingStoreException backingStoreException) {
                log.severe(String.format("Error while auto-flushing %s to file \"%s\" : %s", FilePreferences.class.getSimpleName(), this.getFile(), backingStoreException));
            }
        }

        public void loadProps() throws BackingStoreException {
            this.cachedProps = new Properties();
            File file = this.getFile();
            if (!file.exists()) {
                return;
            }
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                this.cachedProps.load(fileInputStream);
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }

        public Properties getProps() {
            return this.cachedProps;
        }

        public void storeProps() throws BackingStoreException {
            File file = this.getFile();
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                this.cachedProps.store(fileOutputStream, FilePreferences.class.getSimpleName());
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }

        public void removeProps(String string, boolean bl) {
            Enumeration<?> enumeration = this.cachedProps.propertyNames();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = string.length();
            if (bl && string.equals("/")) {
                this.cachedProps = new Properties();
                return;
            }
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(string) || !bl && string2.indexOf(47, n) != -1) continue;
                arrayList.add(string2);
            }
            for (String string3 : arrayList) {
                this.cachedProps.remove(string3);
            }
        }

        @Override
        public String nodePrefix() {
            return "/";
        }
    }
}

