/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities.geom;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class ShapeUtil {
    public static Shape intersection(Shape shape, Shape shape2) {
        if (shape instanceof Rectangle2D && shape2 instanceof Rectangle2D) {
            return ((Rectangle2D)shape).createIntersection((Rectangle2D)shape2);
        }
        Area area = new Area(shape);
        area.intersect(new Area(shape2));
        return area;
    }

    public static Shape transform(Shape shape, AffineTransform affineTransform) {
        boolean bl;
        if (shape == null) {
            return null;
        }
        if (affineTransform == null || affineTransform.isIdentity()) {
            return ShapeUtil.clone(shape);
        }
        boolean bl2 = bl = (affineTransform.getType() & 0x30) == 0;
        if (shape instanceof Rectangle2D && bl) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            double[] dArray = new double[]{rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()};
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            rectangle2D = new Rectangle2D.Double();
            rectangle2D.setFrameFromDiagonal(dArray[0], dArray[1], dArray[2], dArray[3]);
            return rectangle2D;
        }
        return affineTransform.createTransformedShape(shape);
    }

    public static Shape inverseTransform(Shape shape, AffineTransform affineTransform) {
        if (shape == null) {
            return null;
        }
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            return ShapeUtil.transform(shape, affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public static Shape clone(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Line2D) {
            return (Shape)((Line2D)shape).clone();
        }
        if (shape instanceof Rectangle2D) {
            return (Shape)((Rectangle2D)shape).clone();
        }
        if (shape instanceof RoundRectangle2D) {
            return (Shape)((RoundRectangle2D)shape).clone();
        }
        if (shape instanceof Ellipse2D) {
            return (Shape)((Ellipse2D)shape).clone();
        }
        if (shape instanceof Arc2D) {
            return (Shape)((Arc2D)shape).clone();
        }
        if (shape instanceof Polygon) {
            Polygon polygon = (Polygon)shape;
            return new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        }
        if (shape instanceof CubicCurve2D) {
            return (Shape)((CubicCurve2D)shape).clone();
        }
        if (shape instanceof QuadCurve2D) {
            return (Shape)((QuadCurve2D)shape).clone();
        }
        if (shape instanceof Path2D.Float) {
            return (Shape)((Path2D)shape).clone();
        }
        return new Path2D.Double(shape);
    }

    public static boolean equals(Shape shape, Shape shape2) {
        PathIterator pathIterator = shape.getPathIterator(null);
        PathIterator pathIterator2 = shape2.getPathIterator(null);
        if (pathIterator.getWindingRule() != pathIterator2.getWindingRule()) {
            return false;
        }
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        while (!pathIterator.isDone()) {
            int n;
            int n2 = pathIterator.currentSegment(dArray);
            if (n2 != (n = pathIterator2.currentSegment(dArray2))) {
                return false;
            }
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] == dArray2[i]) continue;
                return false;
            }
            pathIterator.next();
            pathIterator2.next();
        }
        return pathIterator2.isDone();
    }
}

