/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.function.Function;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.annotation.Nullable;

public abstract class Strings {
    public static final int DefaultBufferSize = 4096;

    public static String fmt(String string, Object ... objectArray) {
        return String.format(string, objectArray);
    }

    public static String escapeStringLiteral(String string) {
        return Strings.escapeStringLiteral(string, -1);
    }

    public static String escapeStringLiteral(String string, int n) {
        boolean bl = ObjTools.isSet(131072, n);
        boolean bl2 = ObjTools.isSet(65536, n);
        boolean bl3 = ObjTools.isSet(0x20000000, n);
        boolean bl4 = ObjTools.isSet(524288, n);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block12: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u0000': {
                    stringBuilder.append("\\0");
                    continue block12;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block12;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block12;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block12;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block12;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block12;
                }
                case '\'': {
                    stringBuilder.append(bl ? "\\\"" : Character.valueOf(c));
                    continue block12;
                }
                case '\"': {
                    stringBuilder.append(bl2 ? "\\'" : Character.valueOf(c));
                    continue block12;
                }
                case '\\': {
                    stringBuilder.append(bl4 ? "\\\\" : Character.valueOf(c));
                    continue block12;
                }
                case '\u007f': {
                    stringBuilder.append("\\u007f");
                }
                default: {
                    if (c < ' ' || bl3 && c >= '\u0080' || c > '\u00ff') {
                        String string2 = "000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u");
                        stringBuilder.append(string2, string2.length() - 4, string2.length());
                        continue block12;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static String unescapeStringLiteral(@NotNull String string) throws ParseException {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            if (string.codePointAt(i) > 65535) {
                ++i;
            }
            if (!bl) {
                if (n == 92) {
                    bl = true;
                    continue;
                }
                stringBuilder.append(Character.toChars(n));
                continue;
            }
            switch (n) {
                case 92: {
                    stringBuilder.append('\\');
                    break;
                }
                case 34: {
                    stringBuilder.append('\"');
                    break;
                }
                case 39: {
                    stringBuilder.append('\'');
                    break;
                }
                case 114: {
                    stringBuilder.append('\r');
                    break;
                }
                case 110: {
                    stringBuilder.append('\n');
                    break;
                }
                case 116: {
                    stringBuilder.append('\t');
                    break;
                }
                case 102: {
                    stringBuilder.append('\f');
                    break;
                }
                case 98: {
                    stringBuilder.append('\b');
                    break;
                }
                case 97: {
                    stringBuilder.append('\u0007');
                    break;
                }
                case 101: {
                    stringBuilder.append('\u001b');
                    break;
                }
                case 99: {
                    if (++i == string.length()) {
                        throw Strings.parseError("trailing \\c", i - 1);
                    }
                    n = string.codePointAt(i);
                    if (n > 127) {
                        throw Strings.parseError("expected ASCII character after \\c", i);
                    }
                    stringBuilder.append(Character.toChars(n ^ 0x40));
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    char c;
                    int n2;
                    for (n2 = 1; n2 < 3 && i + n2 != string.length() && (c = string.charAt(i + n2)) >= '0' && c <= '7'; ++n2) {
                    }
                    try {
                        stringBuilder.append(Character.toChars(Integer.parseInt(string.substring(i, i + n2), 8)));
                        i += n2 - 1;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Strings.parseError("invalid octal value for \\0 escape", i);
                    }
                }
                case 120: {
                    if (i + 2 >= string.length()) {
                        throw Strings.parseError("string too short for \\x escape", i);
                    }
                    try {
                        stringBuilder.append(Character.toChars(Integer.parseInt(string.substring(++i, i + 2), 16)));
                        ++i;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Strings.parseError("invalid hex value for \\x escape", i);
                    }
                }
                case 117: {
                    if (i + 4 >= string.length()) {
                        throw Strings.parseError("string too short for \\u escape", i);
                    }
                    try {
                        stringBuilder.append(Character.toChars(Integer.parseInt(string.substring(++i, i + 4), 16)));
                        i += 3;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Strings.parseError("invalid hex value for \\u escape", i);
                    }
                }
                case 85: {
                    if (i + 8 >= string.length()) {
                        throw Strings.parseError("string too short for \\U escape", i);
                    }
                    try {
                        stringBuilder.append(Character.toChars(Integer.parseInt(string.substring(++i, i + 8), 16)));
                        i += 7;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw Strings.parseError("invalid hex value for \\U escape", i);
                    }
                }
                default: {
                    stringBuilder.append('\\').append(Character.toChars(n));
                }
            }
            bl = false;
        }
        if (bl) {
            stringBuilder.append('\\');
        }
        return stringBuilder.toString();
    }

    private static ParseException parseError(String string, int n) {
        return new ParseException("Error parsing string: " + string + " at char " + n + ".", n);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isWhiteSpace(@Nullable String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean asBool(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        if ("".equals(string = string.trim().toLowerCase())) {
            return bl;
        }
        switch (string) {
            case "false": 
            case "0": 
            case "no": {
                return false;
            }
        }
        return true;
    }

    public static boolean asBool(String string) {
        return Strings.asBool(string, false);
    }

    @NotNull
    public static String firstNonEmpty(String ... stringArray) {
        for (String string : stringArray) {
            if (Strings.isEmpty(string)) continue;
            return string;
        }
        return "";
    }

    public static String escapeHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder(Math.max(16, string.length()));
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block5;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String toFriendlyName(String string) {
        int n;
        if (Strings.isEmpty(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (n = 0; n < cArray.length; ++n) {
            char c = cArray[n];
            if (c == '_' || c == ' ') {
                if (bl3) continue;
                bl3 = true;
                bl2 = false;
                bl = false;
                bl4 = false;
                stringBuilder.append(' ');
                continue;
            }
            boolean bl5 = Character.isDigit(c);
            boolean bl6 = Character.isUpperCase(c);
            if (bl3) {
                c = Character.toUpperCase(c);
                bl3 = false;
            } else if (bl6 && !bl || bl5 && !bl2) {
                stringBuilder.append(' ');
            } else if (bl2 && !bl5) {
                stringBuilder.append(' ');
                c = Character.toUpperCase(c);
            } else if (bl4 && !bl6) {
                int n2 = stringBuilder.length() - 1;
                stringBuilder.append(stringBuilder.charAt(n2));
                stringBuilder.setCharAt(n2, ' ');
            }
            stringBuilder.append(c);
            bl4 = bl && bl6;
            bl = bl6;
            bl2 = bl5;
        }
        n = stringBuilder.length() - 1;
        if (n != -1 && stringBuilder.charAt(n) == ' ') {
            stringBuilder.setLength(n);
        }
        return stringBuilder.toString();
    }

    public static String replaceNonPrintable(String string, char c, char c2) {
        char c3;
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            c3 = string.charAt(i);
            if (Character.isHighSurrogate(c3) && i < n - 1) {
                ++i;
                continue;
            }
            if (c3 >= '!' && c3 != '\u007f') continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        char[] cArray = string.toCharArray();
        block4: for (int i = 0; i < n; ++i) {
            c3 = cArray[i];
            if (Character.isHighSurrogate(c3) && i < n - 1) {
                ++i;
                continue;
            }
            switch (c3) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    cArray[i] = c2;
                    continue block4;
                }
                default: {
                    if (c3 >= ' ' && c3 != '\u007f') continue block4;
                    cArray[i] = c;
                }
            }
        }
        return new String(cArray);
    }

    public static String replaceNonPrintableU(String string, char c, char c2) {
        int n;
        int n2;
        int n3 = string.length();
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            n2 = string.charAt(i);
            n = Character.isHighSurrogate((char)n2) && i < n3 - 1 ? Character.toCodePoint((char)n2, string.charAt(i++)) : n2;
            if (!Character.isWhitespace(n) && !Character.isISOControl(n)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n3; ++i) {
            n2 = cArray[i];
            n = Character.isHighSurrogate((char)n2) && i < n3 - 1 ? Character.toCodePoint((char)n2, cArray[i++]) : n2;
            if (Character.isWhitespace(n)) {
                cArray[i] = c2;
                continue;
            }
            if (!Character.isISOControl(n)) continue;
            cArray[i] = c;
        }
        return new String(cArray);
    }

    public static String pad(int n, String string, char c, int n2) {
        boolean bl;
        int n3 = string.length();
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        if (n3 > n && n2 != 0) {
            return n2 > 0 ? string.substring(0, n) : string.substring(string.length() - n);
        }
        if (n3 < n) {
            String string2 = Strings.fromChar(c, n - n3);
            return bl ? string2 + string : string + string2;
        }
        return string;
    }

    public static String pad(int n, String string) {
        return Strings.pad(n, string, ' ', 0);
    }

    public static String pad0s(int n, String string) {
        return Strings.pad(n, string, '0', 0);
    }

    public static String padr(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("Length cannot be negative.");
        }
        return Strings.pad(n, string, ' ', 0);
    }

    public static String padl(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("Length cannot be negative.");
        }
        return Strings.pad(-n, string, ' ', 0);
    }

    public static String fromChar(char c, int n) {
        if (n == 0) {
            return "";
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = c;
        }
        return new String(cArray);
    }

    public static <T> String join(String string, Iterable<T> iterable, @Nullable Function<? super T, String> function) {
        StringBuilder stringBuilder = new StringBuilder();
        for (T t : iterable) {
            stringBuilder.append(function == null ? ObjTools.toStr(t) : function.apply(t)).append(string);
        }
        if (stringBuilder.length() >= string.length()) {
            stringBuilder.setLength(stringBuilder.length() - string.length());
        }
        return stringBuilder.toString();
    }

    public static <T> String join(String string, Iterable<T> iterable) {
        return Strings.join(string, iterable, null);
    }

    public static <T> String join(String string, T[] TArray) {
        return Strings.join(string, Arrays.asList(TArray), null);
    }

    public static String md5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
            StringBuilder stringBuilder = new StringBuilder(32);
            for (byte by : byArray) {
                stringBuilder.append(String.format("%02x", by));
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String readAll(InputStream inputStream, Charset charset) throws IOException {
        return Strings.readAll(inputStream, charset, 4096);
    }

    public static String readAll(InputStream inputStream, String string, int n) throws IOException {
        return Strings.readAll(inputStream, Charset.forName(string), n);
    }

    public static String readAll(InputStream inputStream, String string) throws IOException {
        return Strings.readAll(inputStream, string, 4096);
    }

    public static String readAll(InputStream inputStream) throws IOException {
        return Strings.readAll(inputStream, Charset.defaultCharset(), 4096);
    }

    public static String readAll(InputStream inputStream, Charset charset, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toString(charset.name());
    }

    public static void writeAll(String string, OutputStream outputStream, Charset charset) throws IOException {
        Strings.writeAll(string, outputStream, charset, 4096);
    }

    public static void writeAll(String string, OutputStream outputStream, String string2, int n) throws IOException {
        Strings.writeAll(string, outputStream, Charset.forName(string2), n);
    }

    public static void writeAll(String string, OutputStream outputStream, String string2) throws IOException {
        Strings.writeAll(string, outputStream, string2, 4096);
    }

    public static void writeAll(String string, OutputStream outputStream) throws IOException {
        Strings.writeAll(string, outputStream, Charset.defaultCharset(), 4096);
    }

    public static void writeAll(String string, OutputStream outputStream, Charset charset, int n) throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, n);){
            bufferedOutputStream.write(string.getBytes(charset));
            bufferedOutputStream.flush();
        }
    }
}

