/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.Utilities;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Vector;

public class ClassLoaderInfo {
    private static final Field reflectedClassLoaderField;

    public static String[] getLoadedLibraries(ClassLoader classLoader) {
        try {
            Vector vector = (Vector)reflectedClassLoaderField.get(classLoader);
            return vector.toArray(new String[vector.size()]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String[] getLoadedLibraries(ClassLoader[] classLoaderArray) {
        Vector<String> vector = new Vector<String>();
        for (ClassLoader classLoader : classLoaderArray) {
            String[] stringArray = ClassLoaderInfo.getLoadedLibraries(classLoader);
            if (stringArray == null) continue;
            vector.addAll(Arrays.asList(stringArray));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public static String[] getAppLoadedLibraries() {
        return ClassLoaderInfo.getLoadedLibraries(ClassLoader.getSystemClassLoader());
    }

    public static String[] getMyLoadedLibraries() {
        return ClassLoaderInfo.getLoadedLibraries(ClassLoaderInfo.class.getClassLoader());
    }

    public static String[] getAllLoadedLibraries() {
        ClassLoader[] classLoaderArray = new ClassLoader[]{ClassLoader.getSystemClassLoader(), ClassLoaderInfo.class.getClassLoader()};
        return ClassLoaderInfo.getLoadedLibraries(classLoaderArray);
    }

    static {
        Field field = null;
        try {
            field = ClassLoader.class.getDeclaredField("loadedLibraryNames");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        reflectedClassLoaderField = field;
    }
}

