/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import ur_rna.StructureEditor.AppActions;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.models.BondType;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.RnaSceneGroup;
import ur_rna.StructureEditor.windows.ChildFrame;
import ur_rna.StructureEditor.windows.DrawWindow;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.swing.AcceleratorKey;
import ur_rna.Utilities.swing.ActionHelper;
import ur_rna.Utilities.swing.Dialogs;
import ur_rna.Utilities.swing.TextDocListener;

public class NewFileWindow
extends ChildFrame {
    private JTextPane txtSequence;
    private JButton btnCancel;
    private JButton btnOK;
    private JTextPane txtStructure;
    private JTextField txtTitle;
    private JPanel pnlMain;
    private JCheckBox chkWrapSequence;
    private JCheckBox chkWrapStructure;
    private JButton btnStructureHelp;
    private JButton btnSequenceHelp;
    private JTextPane txtDebug;
    private JLabel lblLocation;
    private StyledDocument docSeq;
    private StyledDocument docStr;
    private Timer tmrUpdate = new Timer(100, this::updateTimerElapsed);
    private Font defaultFont = new Font("Monospaced", 0, 12);
    private int[] seqLookup = new int[1024];
    private int[] revSeqLookup = new int[1024];
    private int seqLen = 0;
    private ArrayList<StructItem> structure = new ArrayList();
    private StructItem selectedStructItem;
    private int selectedPair = -1;
    private int selectedBase = -1;
    private int selectedHelixLen = 0;
    private String seqText;
    private String strText;
    private UndoManager undoSeq;
    private UndoManager undoStr;
    private final TextDocListener docUpdateListener = new TextDocListener();
    private JTextPane _lastActivePane;
    private static int[] _textRegions = new int[4];
    private static final char[] bracketChars = "{}[]()<>\u00ab\u00bb".toCharArray();
    private static final Pattern helixH3 = Pattern.compile("(\\d+)[ \t]+(\\d+)[ \t]+(\\d+)\\b");
    private static final Pattern helixPair = Pattern.compile("(\\d+)(?:-(\\d+))?:(\\d+)(?:-(\\d+))?\\b");
    private static final Pattern helixSep = Pattern.compile("[,\\s]+");
    private static final Pattern helixInvalid = Pattern.compile("[^,\\s]+");
    private static final Pattern[] helixParsePatterns = new Pattern[]{helixH3, helixPair, helixSep, helixInvalid};
    private Style styleSeqDefault;
    private Style styleStrDefault;
    private Style styleStrInvalid;
    private Style styleSeqPaired;
    private Style styleStrSel;

    public NewFileWindow() {
        super("New Drawing from Sequence", true);
        this.$$$setupUI$$$();
        AbstractButton[] abstractButtonArray = new AbstractButton[]{this.btnOK, this.btnCancel, this.btnStructureHelp, this.btnSequenceHelp};
        AbstractButton[] abstractButtonArray2 = new AbstractButton[]{this.chkWrapSequence, this.chkWrapStructure};
        for (AbstractButton abstractButton : abstractButtonArray) {
            abstractButton.addActionListener(this::actionPerformed);
        }
        for (AbstractButton abstractButton : abstractButtonArray2) {
            abstractButton.addItemListener(this::itemSelected);
        }
        StyleContext styleContext = this.createStyleContext();
        this.docSeq = new DefaultStyledDocument(styleContext);
        this.txtSequence.setStyledDocument(this.docSeq);
        this.docStr = new DefaultStyledDocument(styleContext);
        this.txtStructure.setStyledDocument(this.docStr);
        this.docSeq.addDocumentListener(this.docUpdateListener);
        this.docStr.addDocumentListener(this.docUpdateListener);
        this.txtSequence.addCaretListener(this::textCaretEvent);
        this.txtStructure.addCaretListener(this::textCaretEvent);
        this.undoSeq = new IgnoreStylesUndoManager();
        this.docSeq.addUndoableEditListener(this.undoSeq);
        this.undoStr = new IgnoreStylesUndoManager();
        this.docStr.addUndoableEditListener(this.undoStr);
        ActionHelper.addKeyAction(this, AcceleratorKey.getKey('Z'), "undo", this::doUndo);
        ActionHelper.addKeyAction(this, AcceleratorKey.getKey('Y'), "redo", this::doRedo);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlMain, gridBagConstraints);
        this.pack();
        this.setSize(new Dimension(600, this.getHeight()));
        this.tmrUpdate.start();
        this.txtTitle.requestFocusInWindow();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.pnlMain = new JPanel();
        this.pnlMain.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVisible(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.fill = 1;
        this.pnlMain.add((Component)jScrollPane, gridBagConstraints);
        this.txtSequence.setFont(new Font("Monospaced", this.txtSequence.getFont().getStyle(), this.txtSequence.getFont().getSize()));
        this.txtSequence.setPreferredSize(new Dimension(6, 60));
        jScrollPane.setViewportView(this.txtSequence);
        JLabel jLabel = new JLabel();
        jLabel.setText("Sequence:");
        jLabel.setDisplayedMnemonic('E');
        jLabel.setDisplayedMnemonicIndex(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.pnlMain.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setForeground(new Color(-12294257));
        jLabel2.setText("Spaces, tabs, and line-breaks can be used for formatting.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 5, 0, 0);
        this.pnlMain.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(new Font(jLabel3.getFont().getName(), 1, 14));
        jLabel3.setText("New Drawing from Sequence");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.pnlMain.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(new Font(jLabel4.getFont().getName(), 1, 12));
        jLabel4.setText("Enter the sequence, and optionally, basepairing information for the new drawing.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.pnlMain.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Structure:");
        jLabel5.setDisplayedMnemonic('R');
        jLabel5.setDisplayedMnemonicIndex(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.pnlMain.add((Component)jLabel5, gridBagConstraints);
        JScrollPane jScrollPane2 = new JScrollPane();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.fill = 1;
        this.pnlMain.add((Component)jScrollPane2, gridBagConstraints);
        this.txtStructure.setFont(new Font("Monospaced", this.txtStructure.getFont().getStyle(), this.txtStructure.getFont().getSize()));
        this.txtStructure.setPreferredSize(new Dimension(6, 60));
        jScrollPane2.setViewportView(this.txtStructure);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.pnlMain.add((Component)jPanel, gridBagConstraints);
        this.btnCancel = new JButton();
        this.btnCancel.setActionCommand("cancel");
        this.btnCancel.setPreferredSize(new Dimension(200, 32));
        this.btnCancel.setText("Cancel");
        this.btnCancel.setMnemonic('C');
        this.btnCancel.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.btnCancel, gridBagConstraints);
        this.btnOK = new JButton();
        this.btnOK.setActionCommand("ok");
        this.btnOK.setPreferredSize(new Dimension(200, 32));
        this.btnOK.setText("OK - Create Drawing");
        this.btnOK.setMnemonic('O');
        this.btnOK.setDisplayedMnemonicIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.btnOK, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setForeground(new Color(-12294257));
        jLabel6.setText("(optional) Enter structure information in dot-bracket notation, or extended helix notation.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.pnlMain.add((Component)jLabel6, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Title:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.pnlMain.add((Component)jLabel7, gridBagConstraints);
        JLabel jLabel8 = new JLabel();
        jLabel8.setForeground(new Color(-12294257));
        jLabel8.setText("(optional) Title for this sequence/drawing");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 5, 0, 0);
        this.pnlMain.add((Component)jLabel8, gridBagConstraints);
        this.txtTitle = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.pnlMain.add((Component)this.txtTitle, gridBagConstraints);
        this.chkWrapStructure = new JCheckBox();
        this.chkWrapStructure.setActionCommand("wrap-str");
        this.chkWrapStructure.setSelected(true);
        this.chkWrapStructure.setText("wrap");
        this.chkWrapStructure.setMnemonic('W');
        this.chkWrapStructure.setDisplayedMnemonicIndex(0);
        this.chkWrapStructure.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.pnlMain.add((Component)this.chkWrapStructure, gridBagConstraints);
        this.chkWrapSequence = new JCheckBox();
        this.chkWrapSequence.setActionCommand("wrap-seq");
        this.chkWrapSequence.setSelected(true);
        this.chkWrapSequence.setText("wrap");
        this.chkWrapSequence.setMnemonic('W');
        this.chkWrapSequence.setDisplayedMnemonicIndex(0);
        this.chkWrapSequence.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.pnlMain.add((Component)this.chkWrapSequence, gridBagConstraints);
        this.btnStructureHelp = new JButton();
        this.btnStructureHelp.setActionCommand("help-str");
        this.btnStructureHelp.setPreferredSize(new Dimension(200, 32));
        this.btnStructureHelp.setText("?");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.pnlMain.add((Component)this.btnStructureHelp, gridBagConstraints);
        this.btnSequenceHelp = new JButton();
        this.btnSequenceHelp.setActionCommand("help-seq");
        this.btnSequenceHelp.setPreferredSize(new Dimension(200, 32));
        this.btnSequenceHelp.setText("?");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.pnlMain.add((Component)this.btnSequenceHelp, gridBagConstraints);
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.setPreferredSize(new Dimension(6, 200));
        jScrollPane3.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.pnlMain.add((Component)jScrollPane3, gridBagConstraints);
        this.txtDebug = new JTextPane();
        this.txtDebug.setPreferredSize(new Dimension(6, 23));
        this.txtDebug.setVisible(true);
        jScrollPane3.setViewportView(this.txtDebug);
        this.lblLocation = new JLabel();
        this.lblLocation.setText("(position)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.pnlMain.add((Component)this.lblLocation, gridBagConstraints);
        jLabel.setLabelFor(this.txtSequence);
        jLabel5.setLabelFor(this.txtStructure);
        jLabel7.setLabelFor(this.txtTitle);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.pnlMain;
    }

    private void doUndo(ActionEvent actionEvent) {
        System.out.println("Undo");
        UndoManager undoManager = this.getActiveUndoManager();
        if (undoManager != null && undoManager.canUndo()) {
            undoManager.undo();
        }
    }

    private void doRedo(ActionEvent actionEvent) {
        System.out.println("Redo");
        UndoManager undoManager = this.getActiveUndoManager();
        if (undoManager != null && undoManager.canRedo()) {
            undoManager.redo();
        }
    }

    public UndoManager getActiveUndoManager() {
        if (this.txtSequence.hasFocus()) {
            return this.undoSeq;
        }
        if (this.txtStructure.hasFocus()) {
            return this.undoStr;
        }
        return null;
    }

    private void textCaretEvent(CaretEvent caretEvent) {
        this.docUpdateListener.markChanged();
    }

    private void updateTimerElapsed(ActionEvent actionEvent) {
        if (this.docUpdateListener.resetIfChanged()) {
            this.updateTextUI();
        }
    }

    private void updateTextUI() {
        try {
            JTextPane jTextPane;
            this.strText = this.docStr.getText(0, this.docStr.getLength());
            this.seqText = this.docSeq.getText(0, this.docSeq.getLength());
            this.parseSequence(this.seqText);
            this.parseStructure(this.strText);
            this._lastActivePane = jTextPane = this.txtStructure.hasFocus() ? this.txtStructure : (this.txtSequence.hasFocus() ? this.txtSequence : this._lastActivePane);
            if (jTextPane != null) {
                this.handleTextSelection(jTextPane);
            }
            this.restyleStructure();
            this.restyleSequence();
            if (this.txtDebug.isVisible()) {
                this.showDebug();
            }
        }
        catch (Exception exception) {
            System.err.println("Error in ");
            exception.printStackTrace();
        }
    }

    private void handleTextSelection(JTextPane jTextPane) {
        int n = jTextPane.getSelectionStart();
        int n2 = jTextPane.getSelectionEnd();
        int n3 = n2 - n;
        StructItem structItem = null;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        if (jTextPane == this.txtSequence) {
            int n7;
            int n8 = -1;
            if (n3 == 1) {
                n8 = this.revSeqLookup[n];
            } else if (n3 == 0) {
                if (n < this.seqText.length()) {
                    n8 = this.revSeqLookup[n];
                } else if (n > 0) {
                    n8 = this.revSeqLookup[n - 1];
                }
            }
            if (n8 != -1) {
                for (StructItem structItem2 : this.structure) {
                    if (!structItem2.containsBase(n8)) continue;
                    structItem = structItem2;
                    n5 = structItem2.getPair(n8);
                    n4 = n8;
                    n6 = 1;
                    break;
                }
            }
            int n9 = -1;
            int n10 = -1;
            for (n7 = n; n7 < Math.max(n + 1, n2) && n7 != this.seqText.length(); ++n7) {
                if (this.revSeqLookup[n7] == -1) continue;
                if (n9 == -1) {
                    n9 = this.revSeqLookup[n7];
                    continue;
                }
                n10 = this.revSeqLookup[n7];
            }
            if (n9 == -1) {
                for (n7 = n; n7 < this.seqText.length() && (n9 = this.revSeqLookup[n7]) == -1; ++n7) {
                }
                this.lblLocation.setText("next base: " + (n9 == -1 ? this.seqLen + 1 : n9 + 1));
            } else if (n10 == -1) {
                this.lblLocation.setText("base: " + (n9 + 1));
            } else {
                this.lblLocation.setText(String.format("bases: %s to %s (%s selected)", n9 + 1, n10 + 1, n10 - n9 + 1));
            }
        } else if (jTextPane == this.txtStructure) {
            this.lblLocation.setText("");
            if (n > 0 && (n == this.strText.length() || this.strText.charAt(n) == '\n')) {
                --n;
                --n2;
            }
            for (StructItem structItem3 : this.structure) {
                if (!structItem3.isSelected(n, n2)) continue;
                structItem = structItem3;
                n4 = structItem3.seq1;
                n5 = structItem3.seq2;
                n6 = structItem3.len;
                break;
            }
        }
        this.selectedStructItem = structItem;
        this.selectedPair = n5;
        this.selectedBase = n4;
        this.selectedHelixLen = n6;
    }

    private void restyleSequence() {
        int n;
        int n2;
        int n3 = this.docSeq.getLength();
        this.setCharStyle(this.docSeq, 0, n3, this.styleSeqDefault);
        if (this.selectedBase != -1) {
            n2 = this.bounded(this.selectedBase + this.selectedHelixLen, 0, this.seqLookup.length);
            for (n = this.bounded(this.selectedBase, 0, this.seqLookup.length - 1); n < n2; ++n) {
                if (n > this.seqLookup.length || this.seqLookup[n] <= -1 || this.seqLookup[n] >= n3) continue;
                this.setCharStyle(this.docSeq, this.seqLookup[n], 1, this.styleSeqPaired);
            }
        }
        if (this.selectedPair != -1) {
            n2 = this.bounded(this.selectedPair - this.selectedHelixLen, -1, this.seqLookup.length - 1);
            for (n = this.bounded(this.selectedPair, 0, this.seqLookup.length - 1); n > n2; --n) {
                if (this.seqLookup[n] <= -1 || this.seqLookup[n] >= n3) continue;
                this.setCharStyle(this.docSeq, this.seqLookup[n], 1, this.styleSeqPaired);
            }
        }
    }

    private int bounded(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    private void restyleStructure() {
        this.setCharStyle(this.docStr, 0, this.docStr.getLength(), this.styleStrDefault);
        if (this.selectedStructItem != null) {
            this.applyStyleToStructure(this.selectedStructItem, this.styleStrSel);
        }
        for (StructItem structItem : this.structure) {
            if (!this.isStructureError(structItem)) continue;
            this.applyStyleToStructure(structItem, this.styleStrInvalid);
        }
    }

    private boolean isStructureError(StructItem structItem) {
        return structItem.type == 0 || structItem.seq1 < 0 || structItem.seq2 - structItem.len + 1 < 0 || structItem.seq1 + structItem.len - 1 > this.seqLen || structItem.seq2 >= this.seqLen;
    }

    private void applyStyleToStructure(StructItem structItem, Style style) {
        int n = structItem.getTextRegion(_textRegions);
        int n2 = _textRegions[0];
        int n3 = _textRegions[1];
        this.setCharStyle(this.docStr, n2, n3 - n2 + 1, style);
        if (n == 2) {
            n2 = _textRegions[2];
            n3 = _textRegions[3];
            this.setCharStyle(this.docStr, n2, n3 - n2 + 1, style);
        }
    }

    private void itemSelected(ItemEvent itemEvent) {
        AbstractButton abstractButton = (AbstractButton)itemEvent.getSource();
        switch (abstractButton.getActionCommand()) {
            case "wrap-seq": {
                ((JWrapTextPane)this.txtSequence).setWrap(abstractButton.isSelected());
                break;
            }
            case "wrap-str": {
                ((JWrapTextPane)this.txtStructure).setWrap(abstractButton.isSelected());
                break;
            }
            default: {
                new Exception("Unknown ActionCommand in itemSelected: " + abstractButton.getActionCommand()).printStackTrace();
            }
        }
    }

    private void parseStructure(String string) {
        char[] cArray = string.toCharArray();
        this.structure.clear();
        if (this.isDotBracket(string)) {
            int[] nArray = new int[3 * cArray.length];
            int n = 0;
            int n2 = 0;
            block7: for (int i = 0; i < cArray.length; ++i) {
                int n3 = cArray[i];
                switch (n3) {
                    case 13: {
                        throw new AssertionError((Object)"Document text should not contain CR.");
                    }
                    case 9: 
                    case 10: 
                    case 32: {
                        continue block7;
                    }
                    case 44: 
                    case 45: 
                    case 46: 
                    case 58: 
                    case 95: {
                        this.structure.add(StructItem.Dot(n2, i));
                        ++n2;
                        continue block7;
                    }
                    case 40: 
                    case 60: 
                    case 91: 
                    case 123: 
                    case 171: {
                        nArray[3 * n] = n3;
                        nArray[3 * n + 1] = n2++;
                        nArray[3 * n + 2] = i;
                        ++n;
                        continue block7;
                    }
                    case 41: 
                    case 62: 
                    case 93: 
                    case 125: 
                    case 187: {
                        int n4;
                        for (n4 = 1; n4 < bracketChars.length; n4 += 2) {
                            if (bracketChars[n4] != n3) continue;
                            n3 = bracketChars[n4 - 1];
                        }
                        n4 = -1;
                        for (int j = n - 1; j > -1; --j) {
                            if (nArray[3 * j] != n3) continue;
                            n4 = j;
                            break;
                        }
                        if (n4 == -1) {
                            this.structure.add(StructItem.Error(i));
                        } else {
                            this.structure.add(StructItem.Pair(nArray[3 * n4 + 1], n2, nArray[3 * n4 + 2], i));
                            if (n4 == n - 1) {
                                --n;
                                while (n > 0 && nArray[3 * n] == -1) {
                                    --n;
                                }
                            } else {
                                nArray[3 * n4] = -1;
                            }
                        }
                        ++n2;
                        continue block7;
                    }
                    default: {
                        if (Character.isWhitespace((char)n3)) continue block7;
                        this.structure.add(StructItem.Error(i));
                    }
                }
            }
            while (n > 0) {
                if (nArray[3 * (n - 1)] != -1) {
                    this.structure.add(StructItem.Error(nArray[3 * (n - 1) + 2]));
                }
                --n;
            }
        } else {
            int n = 0;
            block12: while (n < cArray.length) {
                for (int i = 0; i < helixParsePatterns.length; ++i) {
                    int n5;
                    int n6;
                    int n7;
                    Matcher matcher = helixParsePatterns[i].matcher(string).region(n, cArray.length);
                    if (!matcher.lookingAt()) continue;
                    if (i == 2) {
                        n = matcher.end();
                        continue block12;
                    }
                    if (i == 0) {
                        n7 = NewFileWindow.toInt(matcher.group(1));
                        n6 = NewFileWindow.toInt(matcher.group(2));
                        n5 = NewFileWindow.toInt(matcher.group(3));
                    } else if (i == 1) {
                        int n8 = NewFileWindow.toInt(matcher.group(1));
                        int n9 = NewFileWindow.toInt(matcher.group(2), -1);
                        int n10 = NewFileWindow.toInt(matcher.group(3));
                        int n11 = NewFileWindow.toInt(matcher.group(4), -1);
                        if (n9 != -1 && n11 != -1) {
                            n5 = Math.abs(n9 - n8) + 1;
                            n7 = Math.min(n8, n9);
                            n6 = Math.max(n10, n11);
                            if (Math.abs(n10 - n11) + 1 != n5) {
                                n7 = -1;
                            }
                        } else if (n9 != -1) {
                            n5 = Math.abs(n9 - n8) + 1;
                            n7 = Math.min(n8, n9);
                            n6 = n10;
                        } else if (n11 != -1) {
                            n5 = Math.abs(n11 - n10) + 1;
                            n7 = n8;
                            n6 = Math.max(n10, n11);
                        } else {
                            n7 = n8;
                            n6 = n10;
                            n5 = 1;
                        }
                    } else {
                        n5 = -1;
                        n6 = -1;
                        n7 = -1;
                    }
                    if (n7 == -1) {
                        this.structure.add(StructItem.Error(n, matcher.end()));
                    } else {
                        this.structure.add(StructItem.Helix(n7 - 1, n6 - 1, n5, n, matcher.end()));
                    }
                    n = matcher.end();
                    continue block12;
                }
            }
        }
    }

    private static int toInt(String string) {
        return Integer.parseInt(string);
    }

    private static int toInt(String string, int n) {
        return string == null || string.isEmpty() ? n : Integer.parseInt(string);
    }

    private boolean isDotBracket(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '.': 
                case '<': 
                case '>': 
                case '[': 
                case ']': 
                case '{': 
                case '}': 
                case '\u00ab': 
                case '\u00bb': {
                    return true;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return false;
                }
            }
        }
        return false;
    }

    private void parseSequence(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        if (this.revSeqLookup.length < cArray.length) {
            this.revSeqLookup = Arrays.copyOf(this.revSeqLookup, cArray.length * 3 / 2);
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) {
                this.revSeqLookup[i] = -1;
                continue;
            }
            if (n >= this.seqLookup.length) {
                this.seqLookup = Arrays.copyOf(this.seqLookup, 2 * n);
            }
            this.revSeqLookup[i] = n;
            this.seqLookup[n++] = i;
        }
        this.seqLen = n;
    }

    private void showDebug() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Sequence: ");
        for (int i = 0; i < this.seqLen; ++i) {
            stringBuilder.append(" ").append(this.seqLookup[i]);
        }
        stringBuilder.append('\n');
        stringBuilder.append("Structure:\n");
        for (StructItem structItem : this.structure) {
            stringBuilder.append("\t").append(structItem.seq1).append(':').append(structItem.seq2).append('@').append(structItem.len).append(" (").append(structItem.pos1).append(',').append(structItem.pos2).append(")\n");
        }
        this.txtDebug.setText(stringBuilder.toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (actionEvent.getActionCommand()) {
            case "ok": {
                if (!this.checkErrors() || !this.createDrawing()) break;
                this.close();
                break;
            }
            case "cancel": {
                this.close();
                break;
            }
            case "help-seq": {
                Dialogs.showMessage(Program.getResourceText("new-drawing-help", "sequence"), "Sequence Entry Help", Dialogs.INFO);
                break;
            }
            case "help-str": {
                Dialogs.showMessage(Program.getResourceText("new-drawing-help", "structure"), "Structure Entry Help", Dialogs.INFO, true);
                break;
            }
            default: {
                Dialogs.showWarning("Unknown action: " + actionEvent.getActionCommand());
            }
        }
    }

    private boolean createDrawing() {
        try {
            this.updateTextUI();
            RnaScene rnaScene = new RnaScene();
            rnaScene.title = this.txtTitle.getText().trim();
            StringBuilder stringBuilder = new StringBuilder(this.seqLen);
            for (int i = 0; i < this.seqLen; ++i) {
                stringBuilder.append(this.seqText.charAt(this.seqLookup[i]));
            }
            rnaScene.strands.first().addAll(stringBuilder);
            for (StructItem object2 : this.structure) {
                if (this.isStructureError(object2)) continue;
                for (int i = 0; i < object2.pairCount(); ++i) {
                    int n = object2.getBase(i);
                    int n2 = object2.getPair(n);
                    if (n == -1 || n2 == -1) continue;
                    rnaScene.breakBonds(n, n2);
                    rnaScene.addBond(n, n2, BondType.Default);
                }
            }
            Iterator<StructItem> iterator = rnaScene.strands.first().listIterator();
            while (iterator.hasNext()) {
                if (!"-".equals(((Nuc)iterator.next()).symbol)) continue;
                iterator.remove();
            }
            DrawWindow drawWindow = AppActions.createEditorWindow(RnaSceneGroup.from(rnaScene));
            drawWindow.redrawScene();
            return true;
        }
        catch (Exception exception) {
            Dialogs.showWarning("Failed to create the drawing due to the following error: " + exception.toString(), "Error Creating Drawing");
            return false;
        }
    }

    private boolean checkErrors() {
        if (!ObjTools.any(this.structure, this::isStructureError)) {
            return true;
        }
        Object[] objectArray = new String[]{"Cancel (Continue Editing)", "Create Drawing (Ignore Errors)"};
        int n = Dialogs.prompt("Errors exist in the structure notation. If you create the drawing now, only the valid structure elements will be used.\nYou can also click Cancel to continue editing the structure and attempt to correct the errors.\n\nPlease choose an action:", "Create Drawing, Despite Structure Errors?", objectArray, objectArray[0]);
        return n == 1;
    }

    private void createUIComponents() {
        this.txtSequence = new JWrapTextPane();
        this.txtStructure = new JWrapTextPane();
    }

    private StyleContext createStyleContext() {
        Color color = new Color(0xFFCCCC);
        Color color2 = new Color(0x990000);
        Color color3 = new Color(0xCCCCFF);
        Color color4 = new Color(255);
        Color color5 = new Color(102);
        StyleContext styleContext = new StyleContext();
        this.styleSeqDefault = styleContext.getStyle("default");
        this.styleSeqDefault.addAttribute(StyleConstants.FontFamily, this.defaultFont.getFamily());
        this.styleSeqDefault.addAttribute(StyleConstants.FontSize, this.defaultFont.getSize());
        this.styleStrDefault = styleContext.addStyle("strDefault", this.styleSeqDefault);
        this.styleStrDefault.addAttribute(StyleConstants.Foreground, color5);
        this.styleStrInvalid = styleContext.addStyle("strError", this.styleStrDefault);
        this.styleStrInvalid.addAttribute(StyleConstants.Background, color);
        this.styleStrInvalid.addAttribute(StyleConstants.Foreground, color2);
        this.styleSeqPaired = styleContext.addStyle("seqPaired", this.styleSeqDefault);
        this.styleSeqPaired.addAttribute(StyleConstants.Bold, true);
        this.styleSeqPaired.addAttribute(StyleConstants.Background, color3);
        this.styleStrSel = styleContext.addStyle("strSel", this.styleStrDefault);
        this.styleStrSel.addAttribute(StyleConstants.Bold, true);
        this.styleStrSel.addAttribute(StyleConstants.Background, color3);
        return styleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCharStyle(StyledDocument styledDocument, int n, int n2, Style style) {
        this.docUpdateListener.suspendUpdates();
        try {
            styledDocument.setCharacterAttributes(n, n2, style, true);
        }
        finally {
            this.docUpdateListener.resumeUpdates();
        }
    }

    private static class StructItem {
        public static final int ERROR = 0;
        public static final int HELIX = 1;
        public static final int BP = 2;
        public static final int DOT = 3;
        int seq1 = -1;
        int seq2 = -1;
        int len;
        final int pos1;
        final int pos2;
        final int type;

        private StructItem(int n, int n2, int n3) {
            this.type = n;
            this.pos1 = n2;
            this.pos2 = n3;
        }

        public static StructItem Helix(int n, int n2, int n3, int n4, int n5) {
            StructItem structItem = new StructItem(1, n4, n5);
            structItem.seq1 = n;
            structItem.seq2 = n2;
            structItem.len = n3;
            return structItem;
        }

        public static StructItem Error(int n, int n2) {
            return new StructItem(0, n, n2);
        }

        public static StructItem Error(int n) {
            return StructItem.Error(n, n);
        }

        public static StructItem Pair(int n, int n2, int n3, int n4) {
            StructItem structItem = new StructItem(2, n3, n4);
            structItem.seq1 = n;
            structItem.seq2 = n2;
            structItem.len = 1;
            return structItem;
        }

        public static StructItem Dot(int n, int n2) {
            StructItem structItem = new StructItem(3, n2, n2);
            structItem.seq1 = n;
            structItem.seq2 = n;
            structItem.len = 1;
            return structItem;
        }

        public boolean containsBase(int n) {
            return n >= this.seq1 && n < this.seq1 + this.len || n > this.seq2 - this.len && n <= this.seq2;
        }

        public int getPair(int n) {
            if (n >= this.seq1 && n < this.seq1 + this.len) {
                return this.seq2 + this.seq1 - n;
            }
            if (n > this.seq2 - this.len && n <= this.seq2) {
                return this.seq1 + this.seq2 - n;
            }
            return -1;
        }

        boolean isSelected(int n, int n2) {
            if (this.type == 2) {
                return n == this.pos1 && n2 <= this.pos1 + 1 || n == this.pos2 && n2 <= this.pos2 + 1;
            }
            return n >= this.pos1 && (n2 <= this.pos2 || n == this.pos1 | n < this.pos2 && n2 <= this.pos2 + 1);
        }

        public int pairCount() {
            switch (this.type) {
                case 2: {
                    return 1;
                }
                case 0: 
                case 3: {
                    return 0;
                }
            }
            return this.len;
        }

        public int getBase(int n) {
            switch (this.type) {
                case 2: {
                    return n == 0 ? this.seq1 : -1;
                }
                case 0: 
                case 3: {
                    return -1;
                }
            }
            return n < this.len ? this.seq1 + n : -1;
        }

        public int getTextRegion(int[] nArray) {
            if (this.type == 2) {
                nArray[0] = this.pos1;
                nArray[1] = this.pos1;
                nArray[2] = this.pos2;
                nArray[3] = this.pos2;
                return 2;
            }
            nArray[0] = this.pos1;
            nArray[1] = this.pos2;
            return 1;
        }
    }

    private static class JWrapTextPane
    extends JTextPane {
        private boolean nowrap;

        private JWrapTextPane() {
        }

        public void setWrap(boolean bl) {
            this.nowrap = !bl;
        }

        public boolean getWrap() {
            return !this.nowrap;
        }
    }

    private static class IgnoreStylesUndoManager
    extends UndoManager {
        private IgnoreStylesUndoManager() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEditEvent.getEdit();
            if (!defaultDocumentEvent.getType().equals(DocumentEvent.EventType.CHANGE)) {
                super.undoableEditHappened(undoableEditEvent);
            }
        }
    }
}

