/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import ur_rna.StructureEditor.AppActions;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.Settings;
import ur_rna.StructureEditor.services.RecentFileList;
import ur_rna.Utilities.swing.ActionHelper;
import ur_rna.Utilities.swing.JFlatButton;

public class DashboardFrame
extends JInternalFrame {
    public static final String EXAMPLE_INDICATOR = "example://";
    private JButton btnWebsite;
    private JButton btnHelp;
    private JList<Object> lstRecent;
    private JPanel pnlMain;
    private JList<Object> lstExamples;
    private JButton btnCleanupRecent;
    private JButton btnClearRecent;
    private JCheckBox chkDisableDashboard;
    private JButton btnOpenFile;
    private JButton btnFeedback;
    private boolean updatingSettings;
    private HierarchyBoundsAdapter ancestorResizeListener = new HierarchyBoundsAdapter(){

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            DashboardFrame.this.updateLayout();
            super.ancestorResized(hierarchyEvent);
        }
    };

    public DashboardFrame() {
        super("Home", false);
        this.$$$setupUI$$$();
        this.btnWebsite.addActionListener(AppActions.OPEN_WEBSITE);
        this.btnHelp.addActionListener(AppActions.SHOW_LOCAL_HELP);
        this.btnFeedback.addActionListener(AppActions.SEND_FEEDBACK);
        this.btnCleanupRecent.setAction(AppActions.CLEANUP_RECENT_FILES);
        this.btnClearRecent.setAction(AppActions.CLEAR_RECENT_FILES);
        this.btnOpenFile.setAction(AppActions.SHOW_OPEN_FILE);
        this.chkDisableDashboard.addActionListener(this::disableOptionClick);
        Program.getInstance().settings().addChangeHandler(this::settingsChanged);
        this.setPreferredSize(new Dimension(600, 400));
        this.setBackground(Color.WHITE);
        BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)this.getUI();
        basicInternalFrameUI.setNorthPane(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addHierarchyBoundsListener(this.ancestorResizeListener);
        this.add((Component)this.pnlMain, "North");
        Cursor cursor = Cursor.getPredefinedCursor(12);
        this.lstExamples.setCursor(cursor);
        this.lstRecent.setCursor(cursor);
        this.lstRecent.addListSelectionListener(this::listItemSelected);
        this.lstExamples.addListSelectionListener(this::listItemSelected);
        this.loadExamples();
        this.settingsChanged();
        ActionHelper.addKeyAction(this, KeyStroke.getKeyStroke(27, 0), "closeOnESC", actionEvent -> Program.getInstance().getMainFrame().hideDashboard());
    }

    private void settingsChanged() {
        Settings settings = Program.getInstance().settings();
        this.updatingSettings = true;
        this.chkDisableDashboard.setSelected(!settings.ShowDashboard);
        this.updatingSettings = false;
    }

    private void disableOptionClick(ActionEvent actionEvent) {
        if (this.updatingSettings) {
            return;
        }
        boolean bl = this.chkDisableDashboard.isSelected();
        Program.getInstance().settings().ShowDashboard = !bl;
        Program.getInstance().settings().notifyChanged();
        if (bl) {
            JOptionPane.showMessageDialog(this, "You can re-enable the dashboard screen later from the Settings menu.");
        }
    }

    private void listItemSelected(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList.getSelectedIndex() != -1) {
            ListItem listItem = (ListItem)jList.getSelectedValue();
            jList.clearSelection();
            AppActions.openFile(listItem.file.path, listItem.file.type);
        }
    }

    public void updateLayout() {
        Container container = this.getParent();
        if (container == null) {
            return;
        }
        Dimension dimension = container.getSize();
        Dimension dimension2 = this.getPreferredSize();
        int n = Math.round((float)dimension.width * 0.9f);
        int n2 = Math.round((float)dimension.height * 0.9f);
        n = Math.min(dimension.width, Math.max(dimension2.width, n));
        n2 = Math.min(dimension.height, Math.max(dimension2.height, n2));
        this.reshape((dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2);
    }

    private void createUIComponents() {
        this.btnHelp = new JFlatButton();
        this.btnWebsite = new JFlatButton();
        this.btnFeedback = new JFlatButton();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractExample(String string) {
        string = string.substring(EXAMPLE_INDICATOR.length());
        File file = Paths.get(System.getProperty("java.io.tmpdir"), "RNAeditor", "examples", string).toFile();
        if (file.exists()) {
            if (file.length() != 0L) return file.toString();
        }
        try {
            Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            try (InputStream inputStream = Program.getResourceStream("examples/" + string);){
                if (inputStream == null) {
                    System.err.println("Resource examples/" + string + " was not found.");
                    String string2 = null;
                    return string2;
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    int n;
                    byte[] byArray = new byte[1024];
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.flush();
                }
            }
            if (file.setReadOnly()) return file.toString();
            System.out.println("Failed to set example file as readonly.");
            return file.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file.toString();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.pnlMain = new JPanel();
        this.pnlMain.setLayout(new GridBagLayout());
        this.pnlMain.setBackground(new Color(-1));
        this.pnlMain.setForeground(new Color(-16777216));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(new Color(-14667710));
        jPanel.setForeground(new Color(-16777216));
        jPanel.setInheritsPopupMenu(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.pnlMain.add((Component)jPanel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("Segoe UI", 1, 14));
        jLabel.setForeground(new Color(-1));
        jLabel.setText("RNAstucture is developed by the David H. Mathews Lab at the University of Rochester.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font("Segoe UI", 1, 12));
        jLabel2.setForeground(new Color(-1));
        jLabel2.setText("The RNA Drawing Editor was written by Richard M. Watson");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 0, 5, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.btnHelp.setActionCommand("help");
        this.btnHelp.setAlignmentY(0.0f);
        this.btnHelp.setFont(new Font("Segoe UI", 1, 14));
        this.btnHelp.setForeground(new Color(-256));
        this.btnHelp.setIcon(new ImageIcon(this.getClass().getResource("/ur_rna/StructureEditor/resources/images/open-link_yellow.png")));
        this.btnHelp.setInheritsPopupMenu(true);
        this.btnHelp.setText("Help/Documentation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)this.btnHelp, gridBagConstraints);
        this.btnWebsite.setActionCommand("website");
        this.btnWebsite.setAlignmentY(0.0f);
        this.btnWebsite.setFont(new Font("Segoe UI", 1, 14));
        this.btnWebsite.setForeground(new Color(-256));
        this.btnWebsite.setIcon(new ImageIcon(this.getClass().getResource("/ur_rna/StructureEditor/resources/images/open-link_yellow.png")));
        this.btnWebsite.setText("Lab Website");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)this.btnWebsite, gridBagConstraints);
        this.btnFeedback.setActionCommand("feedback");
        this.btnFeedback.setAlignmentY(0.0f);
        this.btnFeedback.setFont(new Font("Segoe UI", 1, 14));
        this.btnFeedback.setForeground(new Color(-256));
        this.btnFeedback.setIcon(new ImageIcon(this.getClass().getResource("/ur_rna/StructureEditor/resources/images/open-link_yellow.png")));
        this.btnFeedback.setText("Send Feedback");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)this.btnFeedback, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(new Font("Segoe UI", 1, 14));
        jLabel3.setForeground(new Color(-16777216));
        jLabel3.setText("Recent Files:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.pnlMain.add((Component)jLabel3, gridBagConstraints);
        this.lstRecent = new JList();
        this.lstRecent.setForeground(new Color(-16776961));
        this.lstRecent.setMinimumSize(new Dimension(100, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlMain.add(this.lstRecent, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(new Font("Segoe UI", 1, 14));
        jLabel4.setForeground(new Color(-16777216));
        jLabel4.setText("Example Files:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.pnlMain.add((Component)jLabel4, gridBagConstraints);
        this.lstExamples = new JList();
        this.lstExamples.setForeground(new Color(-16776961));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlMain.add(this.lstExamples, gridBagConstraints);
        this.btnCleanupRecent = new JButton();
        this.btnCleanupRecent.setBackground(new Color(-1));
        this.btnCleanupRecent.setHideActionText(true);
        this.btnCleanupRecent.setIcon(new ImageIcon(this.getClass().getResource("/ur_rna/StructureEditor/resources/images/clear-recent.png")));
        this.btnCleanupRecent.setText("");
        this.btnCleanupRecent.setToolTipText("Cleanup missing files");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.pnlMain.add((Component)this.btnCleanupRecent, gridBagConstraints);
        this.chkDisableDashboard = new JCheckBox();
        this.chkDisableDashboard.setBackground(new Color(-1));
        this.chkDisableDashboard.setForeground(new Color(-16777216));
        this.chkDisableDashboard.setMargin(new Insets(2, 14, 2, 14));
        this.chkDisableDashboard.setText("Disable this Screen");
        this.chkDisableDashboard.setToolTipText("This dashboard screen is usually shown when no files are open, unless you check this box which will disable it.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.pnlMain.add((Component)this.chkDisableDashboard, gridBagConstraints);
        this.btnClearRecent = new JButton();
        this.btnClearRecent.setBackground(new Color(-1));
        this.btnClearRecent.setHideActionText(true);
        this.btnClearRecent.setIcon(new ImageIcon(this.getClass().getResource("/ur_rna/StructureEditor/resources/images/delete.png")));
        this.btnClearRecent.setText("");
        this.btnClearRecent.setToolTipText("Clear ALL recent files");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.pnlMain.add((Component)this.btnClearRecent, gridBagConstraints);
        this.btnOpenFile = new JButton();
        this.btnOpenFile.setBackground(new Color(-1));
        this.btnOpenFile.setHideActionText(true);
        this.btnOpenFile.setIcon(new ImageIcon(this.getClass().getResource("/ur_rna/StructureEditor/resources/images/file-open.png")));
        this.btnOpenFile.setText("");
        this.btnOpenFile.setToolTipText("Cleanup missing files");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.pnlMain.add((Component)this.btnOpenFile, gridBagConstraints);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.pnlMain;
    }

    public void setRecent(RecentFileList recentFileList) {
        int n = 0;
        ListItem[] listItemArray = new ListItem[recentFileList.size()];
        for (RecentFileList.RecentFile recentFile : recentFileList) {
            File file = new File(recentFile.path);
            ListItem listItem = new ListItem(recentFile, String.format("%s    in    %s", file.getName(), file.getParent()));
            listItemArray[n++] = listItem;
        }
        this.lstRecent.setListData((Object[])listItemArray);
    }

    public void loadExamples() {
        try (InputStream inputStream = Program.getResourceStream("examples/examples.dir");){
            if (inputStream == null) {
                return;
            }
            ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
            try (Scanner scanner = new Scanner(inputStream);){
                while (scanner.hasNextLine()) {
                    String string = scanner.nextLine().trim();
                    if (string.isEmpty()) continue;
                    RecentFileList.RecentFile recentFile = new RecentFileList.RecentFile(EXAMPLE_INDICATOR + string);
                    arrayList.add(new ListItem(recentFile, string));
                }
            }
            this.lstExamples.setListData((Object[])arrayList.toArray(new ListItem[arrayList.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static class ListItem {
        public final String desc;
        public final RecentFileList.RecentFile file;

        public ListItem(RecentFileList.RecentFile recentFile, String string) {
            this.desc = string;
            this.file = recentFile;
        }

        public String toString() {
            return this.desc;
        }
    }
}

