/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ur_rna.StructureEditor.ui.ToolWindow;
import ur_rna.Utilities.Convert;

public class SliderToolWindow
extends ToolWindow {
    private JSlider slider;
    private JLabel lblValue;
    private JButton btnCancel;
    private JButton btnAccept;
    private JTextField txtValue;
    private JLabel lblPrompt;

    public SliderToolWindow() {
        this.$$$setupUI$$$();
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SliderToolWindow.this.txtValue.setText("" + SliderToolWindow.this.slider.getValue());
            }
        });
        this.txtValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SliderToolWindow.this.docChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SliderToolWindow.this.docChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SliderToolWindow.this.docChanged();
            }
        });
        this.setPreferredSize(new Dimension(300, 200));
        this.pack();
        this.setVisible(true);
    }

    void docChanged() {
        int n = Convert.toInt(this.txtValue.getText(), -1);
        if (n != -1 && n != this.slider.getValue() && n >= this.slider.getMinimum() && n <= this.slider.getMaximum()) {
            this.slider.setValue(n);
        }
    }

    private void createUIComponents() {
    }

    private void $$$setupUI$$$() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.slider = new JSlider();
        this.slider.setMajorTickSpacing(5);
        this.slider.setMinorTickSpacing(1);
        this.slider.setPaintLabels(false);
        this.slider.setPaintTicks(true);
        this.slider.setPaintTrack(true);
        this.slider.setPreferredSize(new Dimension(300, 32));
        this.slider.putClientProperty("Slider.paintThumbArrowShape", Boolean.TRUE);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)this.slider, gridBagConstraints);
        this.btnAccept = new JButton();
        this.btnAccept.setActionCommand("accept");
        this.btnAccept.setText("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.btnAccept, gridBagConstraints);
        this.btnCancel = new JButton();
        this.btnCancel.setActionCommand("cancel");
        this.btnCancel.setText("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.btnCancel, gridBagConstraints);
        this.lblPrompt = new JLabel();
        this.lblPrompt.setPreferredSize(new Dimension(300, 32));
        this.lblPrompt.setText("<html>Enter a numeric value below or use the slider <br>\nto select one within the valid range.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        jPanel.add((Component)this.lblPrompt, gridBagConstraints);
        this.txtValue = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        jPanel.add((Component)this.txtValue, gridBagConstraints);
        this.lblValue = new JLabel();
        this.lblValue.setText("Value:");
        this.lblValue.setVerticalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.lblValue, gridBagConstraints);
        this.lblValue.setLabelFor(this.txtValue);
    }
}

