/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import ur_rna.StructureEditor.models.HistoryUpdateEvent;
import ur_rna.StructureEditor.models.IScreenObject;
import ur_rna.StructureEditor.services.RnaDrawController;
import ur_rna.StructureEditor.services.SceneRenderer;
import ur_rna.StructureEditor.services.SceneUpdateCategory;
import ur_rna.StructureEditor.services.drawing.ICanvas;
import ur_rna.StructureEditor.services.drawing.View2D;
import ur_rna.Utilities.EventSource;
import ur_rna.Utilities.annotation.Nullable;

public class DrawPanel
extends JPanel
implements ICanvas {
    private float scale = 1.0f;
    private Point2D.Float offset = new Point2D.Float();
    private AffineTransform tr = new AffineTransform();
    private final int MARGIN = 5;
    private View2D view = new View2D();
    private View2D drawnView = new View2D();
    private SceneRenderer renderer;
    private static final int ZOOM_MASK = 128;
    public final EventSource.NoArg viewChanged = new EventSource.NoArg();
    Point2D scrollTargetModel;
    Point scrollTargetView;
    private Rectangle prevBounds;
    final View2D IDENTITY_VIEW = new View2D();

    public DrawPanel() {
        this.setDoubleBuffered(true);
        this.addMouseWheelListener(mouseWheelEvent -> {
            int n = mouseWheelEvent.getModifiersEx();
            if ((n & 0x80) == 128) {
                float f = (float)((double)this.scale - 0.1 * (double)this.scale * mouseWheelEvent.getPreciseWheelRotation());
                this.setZoomScroll(mouseWheelEvent.getPoint());
                this.setScale(f);
                mouseWheelEvent.consume();
            } else {
                this.delegateToParent(mouseWheelEvent);
            }
        });
    }

    private void setZoomScroll(Point point) {
        Point2D.Float float_ = new Point2D.Float();
        this.drawnView.toModel(point, float_);
        point.x += this.getX();
        point.y += this.getY();
        this.scrollTargetModel = float_;
        this.scrollTargetView = point;
    }

    private static void log(String string, Object ... objectArray) {
        DrawPanel.log(false, string, objectArray);
    }

    private static void loge(String string, Object ... objectArray) {
        DrawPanel.log(true, string, objectArray);
    }

    private static void log(boolean bl, String string, Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Rectangle) {
                objectArray[i] = DrawPanel.fmt((Rectangle)objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof Point) {
                objectArray[i] = DrawPanel.fmt((Point)objectArray[i]);
                continue;
            }
            if (!(objectArray[i] instanceof Dimension)) continue;
            objectArray[i] = DrawPanel.fmt((Dimension)objectArray[i]);
        }
        (bl ? System.err : System.out).println(objectArray.length == 0 ? string : String.format(string, objectArray));
    }

    private Point getZoomScroll(Dimension dimension, Dimension dimension2) {
        if (this.scrollTargetModel == null) {
            return null;
        }
        Point point = new Point();
        this.drawnView.toScreen(this.scrollTargetModel, point);
        point.x -= this.scrollTargetView.x;
        point.y -= this.scrollTargetView.y;
        if (dimension2 == null) {
            dimension2 = this.getParent() instanceof JViewport ? ((JViewport)this.getParent()).getExtentSize() : this.getVisibleRect().getSize();
        }
        point.x = Math.max(0, Math.min(point.x, dimension.width - dimension2.width));
        point.y = Math.max(0, Math.min(point.y, dimension.height - dimension2.height));
        return point;
    }

    public void scrollToPoint(Point point) {
        if (point == null || !(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = jViewport.getViewRect();
        Dimension dimension = this.getSize();
        point.x = Math.max(0, Math.min(point.x, dimension.width - rectangle.width));
        point.y = Math.max(0, Math.min(point.y, dimension.height - rectangle.height));
        if (this.getX() != -point.x || this.getY() != -point.y) {
            this.setLocation(-point.x, -point.y);
        }
        jViewport.setViewPosition(point);
    }

    private void delegateToParent(MouseWheelEvent mouseWheelEvent) {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (jScrollPane != null) {
            MouseWheelEvent mouseWheelEvent2 = null;
            for (MouseWheelListener mouseWheelListener : jScrollPane.getMouseWheelListeners()) {
                mouseWheelListener.mouseWheelMoved(mouseWheelEvent2 != null ? mouseWheelEvent2 : (MouseWheelEvent)SwingUtilities.convertMouseEvent(this, mouseWheelEvent, jScrollPane));
            }
        }
    }

    private void updateTransform() {
        this.tr.setToScale(this.scale, this.scale);
        this.tr.translate(this.offset.x, this.offset.y);
        this.updateView();
        this.viewChanged.invoke();
        this.repaint();
    }

    public void updateView() {
        this.view.setView(this.tr, this.getVisibleRect());
        this.view.screenMargin.setSize(5, 5);
    }

    public void setRenderer(SceneRenderer sceneRenderer) {
        this.renderer = sceneRenderer;
        if (sceneRenderer instanceof RnaDrawController) {
            ((RnaDrawController)sceneRenderer).historyEvent.add(this::controllerHistoryUpdate);
        }
    }

    private void controllerHistoryUpdate(HistoryUpdateEvent historyUpdateEvent) {
        if (historyUpdateEvent.storing) {
            historyUpdateEvent.state.put("view-scale", Float.valueOf(this.scale));
            historyUpdateEvent.state.put("view-offset", new Point2D.Float(this.offset.x, this.offset.y));
        } else if (historyUpdateEvent.state.update.category == SceneUpdateCategory.Layout) {
            this.setView(historyUpdateEvent.state.get("view-scale", Float.valueOf(this.scale)).floatValue(), historyUpdateEvent.state.get("view-offset", this.offset));
        }
    }

    public SceneRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void repaintRequired() {
        this.repaint();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public View2D getView() {
        return this.view;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.renderer != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = this.view.trToScreen.getScaleX() / this.drawnView.trToScreen.getScaleX();
            this.drawnView.setView(this.view);
            if (!Double.isNaN(d) && (d > 1.000001 || d < 0.999999)) {
                if (this.prevBounds == null) {
                    this.prevBounds = this.getBounds();
                }
                this.prevBounds.width = (int)((double)(this.prevBounds.width - 5) * d + 5.0);
                this.prevBounds.height = (int)((double)(this.prevBounds.height - 5) * d + 5.0);
                if (this.getParent() instanceof JViewport) {
                    Dimension dimension = ((JViewport)this.getParent()).getExtentSize();
                    Point point = this.getZoomScroll(this.prevBounds.getSize(), dimension);
                    if (point != null) {
                        Point point2 = this.getLocation();
                        graphics2D.translate(-(point2.x + point.x), -(point2.y + point.y));
                        this.prevBounds.setLocation(-point.x, -point.y);
                    }
                    if (this.prevBounds.width < dimension.width) {
                        this.prevBounds.width = dimension.width;
                    }
                    if (this.prevBounds.height < dimension.height) {
                        this.prevBounds.height = dimension.height;
                    }
                }
                this.setBounds(this.prevBounds);
            }
            this.updateContentSize(this.getBounds(this.renderer.render(graphics2D, this.drawnView, true)));
        }
    }

    private void updateContentSize(Rectangle rectangle) {
        float f;
        boolean bl = true;
        if (rectangle == null) {
            return;
        }
        if (this.renderer instanceof RnaDrawController) {
            RnaDrawController rnaDrawController = (RnaDrawController)this.renderer;
            bl = !rnaDrawController.isUserActionInProgress();
        }
        rectangle.grow(5, 5);
        float f2 = rectangle.x < 0 ? (float)(-rectangle.x) : 0.0f;
        float f3 = f = rectangle.y < 0 ? (float)(-rectangle.y) : 0.0f;
        if (f2 != 0.0f || f != 0.0f) {
            if (bl) {
                this.setOffset(this.offset.x + f2 / this.scale, this.offset.y + f / this.scale);
                return;
            }
            rectangle.translate((int)Math.ceil(f2), (int)Math.ceil(f));
        }
        Dimension dimension = new Dimension(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        if (!this.getPreferredSize().equals(dimension)) {
            this.setPreferredSize(dimension);
            if (this.prevBounds == null) {
                this.prevBounds = this.getBounds();
            } else {
                this.prevBounds.setSize(dimension);
            }
            Dimension dimension2 = ((JViewport)this.getParent()).getExtentSize();
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
            this.setSize(dimension);
            this.scrollToPoint(this.getZoomScroll(dimension, dimension2));
            this.scrollTargetModel = null;
            this.revalidate();
        }
    }

    private static String fmt(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return "NULL";
        }
        return String.format("[%5.0fx,%5.0fy,%5.0fw,%5.0fh]", rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    private static String fmt(Point2D point2D) {
        if (point2D == null) {
            return "NULL";
        }
        return String.format("[%5.0fx,%5.0fy]", point2D.getX(), point2D.getY());
    }

    private static String fmt(Dimension2D dimension2D) {
        if (dimension2D == null) {
            return "NULL";
        }
        return String.format("[%5.0fw,%5.0fh]", dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void setView(float f, Point2D point2D) {
        this.setView(f, (float)point2D.getX(), (float)point2D.getY());
    }

    public void setView(float f, float f2, float f3) {
        this.offset.x = f2;
        this.offset.y = f3;
        this.scale = f;
        this.updateTransform();
    }

    public Point2D getOffset() {
        return new Point2D.Float(this.offset.x, this.offset.y);
    }

    public void setOffset(float f, float f2) {
        this.setView(this.scale, f, f2);
    }

    public void setOffset(Point2D point2D) {
        this.setView(this.scale, point2D);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f) {
        this.setView(f, this.offset.x, this.offset.y);
    }

    public void autoScale(Dimension dimension) {
        Rectangle rectangle = this.calcPureRender();
        if (rectangle == null) {
            return;
        }
        float f = (float)(dimension.width - 10) / (float)(rectangle.width + 10);
        float f2 = (float)(dimension.height - 10) / (float)(rectangle.height + 10);
        float f3 = Math.min(f, f2);
        this.setView(f3, (float)(-rectangle.x) + 5.0f / f3, (float)(-rectangle.y) + 5.0f / f3);
    }

    @Nullable
    private Rectangle getBounds(Iterable<IScreenObject> iterable) {
        Iterator<IScreenObject> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Rectangle rectangle = iterator.next().getBounds();
        while (iterator.hasNext()) {
            rectangle = rectangle.union(iterator.next().getBounds());
        }
        return rectangle;
    }

    public void zoom(int n) {
        float f = (float)((double)this.scale + 0.1 * (double)this.scale * (double)n);
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Dimension dimension = jViewport.getExtentSize();
            Point point = new Point(dimension.width / 2 - this.getX(), dimension.height / 2 - this.getY());
            this.setZoomScroll(point);
        }
        this.setScale(f);
    }

    private Rectangle calcPureRender() {
        if (this.renderer == null) {
            return null;
        }
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return null;
        }
        graphics2D.setClip(0, 0, 0, 0);
        Rectangle rectangle = this.renderer.calcBounds(graphics2D, this.IDENTITY_VIEW, true);
        graphics2D.dispose();
        return rectangle;
    }

    public void resetOffset() {
        Rectangle rectangle = this.calcPureRender();
        if (rectangle == null) {
            return;
        }
        rectangle.grow(5, 5);
        this.setOffset(-rectangle.x, -rectangle.y);
    }
}

