/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.fileIO;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import ur_rna.RNAstructure.Nucleobase;
import ur_rna.RNAstructure.RnaBackendException;
import ur_rna.RNAstructure.backend.ProgressHandler;
import ur_rna.RNAstructure.backend.RNA;
import ur_rna.RNAstructure.backend.RNABackend;
import ur_rna.RNAstructure.backend.SimpleProgressHandler;
import ur_rna.RNAstructure.backend.structure;
import ur_rna.StructureEditor.FileType;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.BondType;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.RnaSceneGroup;
import ur_rna.StructureEditor.models.Strand;
import ur_rna.Utilities.AppLog;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.StopWatch;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.geom.Vec2D;

public class RnaFileIO {
    public static final int MAX_SEQUENCE_LENGTH = 10000;
    private static final AppLog log = AppLog.getDefault();
    private static String DATA_PATH;
    public static final char InterMolecularBreakChar = 'I';
    public static final String InterMolecularBreakStr = "III";
    public static final int InterMolecularBreakLength;
    public static final String ALPHABET_RNA = "rna";
    public static final int SEQUENCE_FMT_TEXT = 0;
    public static final int SEQUENCE_FMT_SEQ = 1;
    public static final int SEQUENCE_FMT_FASTA = 2;
    static Pattern stripEnergyTitleRegex;

    private static void checkErrors(RNA rNA, String string) throws RnaBackendException {
        int n = rNA.GetErrorCode();
        if (n != 0) {
            throw new RnaBackendException("Error " + string + ": " + rNA.GetFullErrorMessage(), n);
        }
    }

    public static RNA createRNAfromScene(RnaScene rnaScene, boolean bl, boolean bl2, boolean bl3) throws RnaBackendException {
        RnaFileIO.verifyDataPath();
        RNA rNA = new RNA(RnaFileIO.getRNASequence(rnaScene), RNABackend.SEQUENCE_STRING, ALPHABET_RNA, bl2, bl3);
        RnaFileIO.checkErrors(rNA, "building RNA structure");
        rNA.EnsureStructureCapcacity(1);
        if (rnaScene.title != null) {
            rNA.GetStructure().SetSequenceLabel(rnaScene.title);
            RnaFileIO.setStructureTitle(rNA, 1, rnaScene.title);
        }
        if (bl) {
            RnaFileIO.updateBackendBonds(rnaScene, rNA, 1);
        }
        return rNA;
    }

    public static RNA writeRNAstructureGroup(RnaSceneGroup rnaSceneGroup, boolean bl, boolean bl2) throws RnaBackendException {
        RnaFileIO.verifyDataPath();
        String string = RnaFileIO.getRNASequence((RnaScene)rnaSceneGroup.get(0));
        RNA rNA = new RNA(string, RNABackend.SEQUENCE_STRING, ALPHABET_RNA, bl, bl2);
        if (!Strings.isEmpty(rnaSceneGroup.getTitle())) {
            rNA.GetStructure().SetSequenceLabel(rnaSceneGroup.getTitle());
        }
        rNA.EnsureStructureCapcacity(rnaSceneGroup.size());
        for (int i = 0; i < rnaSceneGroup.size(); ++i) {
            RnaScene rnaScene = (RnaScene)rnaSceneGroup.get(i);
            if (!string.equals(RnaFileIO.getRNASequence(rnaScene))) {
                throw new RnaBackendException("RNA sequences differ between structures.");
            }
            int n = i + 1;
            if (rnaScene.title != null) {
                RnaFileIO.setStructureTitle(rNA, n, rnaScene.title);
            }
            RnaFileIO.updateBackendBonds(rnaScene, rNA, n);
        }
        return rNA;
    }

    private static int backendPairIndex(Nuc nuc) {
        return nuc.indexInScene() + nuc.getStrand().getIndex() * InterMolecularBreakLength + 1;
    }

    public static String getRNASequence(RnaScene rnaScene) {
        StringBuilder stringBuilder = new StringBuilder(rnaScene.getNucCount() + (rnaScene.strands.size() - 1) * RnaFileIO.getInterStrandLinker().length());
        for (int i = 0; i < rnaScene.strands.size(); ++i) {
            Strand strand = rnaScene.strands.get(i);
            if (i != 0) {
                stringBuilder.append(RnaFileIO.getInterStrandLinker());
            }
            for (Nuc nuc : strand) {
                stringBuilder.append(Nucleobase.getVerifiedSymbol(nuc.symbol));
            }
        }
        return stringBuilder.toString();
    }

    protected static void updateBackendBonds(RnaScene rnaScene, RNA rNA, int n) {
        List<Bond> list = rnaScene.getBonds();
        rNA.RemovePairs(n, false);
        rNA.RemoveConstraints();
        block5: for (Bond bond : list) {
            int n2 = RnaFileIO.backendPairIndex(bond.getNuc5());
            int n3 = RnaFileIO.backendPairIndex(bond.getNuc3());
            switch (bond.type) {
                case Pseudo: {
                    continue block5;
                }
                case Prohibited: {
                    rNA.ForceProhibitPair(n2, n3);
                    continue block5;
                }
                case Forced: {
                    rNA.ForcePair(n2, n3);
                }
            }
            rNA.SpecifyPair(n2, n3, n);
        }
    }

    public static void checkForErrors(RNA rNA) throws RnaBackendException {
        if (rNA.GetErrorCode() != 0) {
            throw new RnaBackendException(rNA.GetFullErrorMessage(), rNA.GetErrorCode());
        }
    }

    public static RnaScene createSceneFromRNA(RNA rNA, int n, boolean bl) throws RnaBackendException {
        RnaFileIO.checkForErrors(rNA);
        RnaScene rnaScene = new RnaScene();
        rnaScene.title = RnaFileIO.getStructureTitle(rNA, n);
        Strand strand = rnaScene.strands.first();
        strand.addAll(rNA.GetSequence());
        RnaFileIO.splitStrandsAtLinkers(rnaScene);
        if (bl) {
            RnaFileIO.updateSceneBonds(rnaScene, rNA, n);
        }
        return rnaScene;
    }

    public static void splitStrandsAtLinkers(RnaScene rnaScene) {
        boolean bl = false;
        ArrayList arrayList = null;
        ArrayList<Nuc> arrayList2 = null;
        for (Strand iNucGroup : rnaScene.strands) {
            for (Nuc nuc : iNucGroup) {
                if (!Strings.isEmpty(nuc.symbol) && nuc.symbol.charAt(0) == 'I') {
                    bl = true;
                    if (arrayList != null) continue;
                    arrayList = new ArrayList(6);
                    arrayList2 = new ArrayList<Nuc>(3);
                    continue;
                }
                if (!bl) continue;
                arrayList2.add(nuc);
                bl = false;
            }
            bl = false;
            if (arrayList == null || arrayList.size() == 0) continue;
            iNucGroup.removeAll(arrayList);
        }
        if (arrayList2 != null && arrayList2.size() != 0) {
            for (Nuc nuc : arrayList2) {
                rnaScene.strands.divideStrand(nuc.getStrand(), nuc.indexInStrand());
            }
        }
    }

    protected static void updateSceneBonds(RnaScene rnaScene, RNA rNA, int n) {
        int n2 = rNA.GetSequenceLength();
        NucIndexConverter nucIndexConverter = NucIndexConverter.create(rNA.GetSequence());
        List<Bond> list = rnaScene.getBonds();
        rnaScene.clearBonds();
        for (int i = 1; i <= n2; ++i) {
            int n3 = rNA.GetPair(i, n);
            if (n3 <= i) continue;
            rnaScene.addBond(nucIndexConverter.getSceneNuc(rnaScene, i), nucIndexConverter.getSceneNuc(rnaScene, n3));
        }
        for (Bond bond : list) {
            if (bond.n3.isPaired()) {
                bond.n3.getPairBond().type = bond.type;
            }
            if (!bond.n5.isPaired()) continue;
            bond.n5.getPairBond().type = bond.type;
        }
    }

    public static boolean isInterStrandLinker(char c) {
        return c == 'I';
    }

    public static String getInterStrandLinker() {
        return InterMolecularBreakStr;
    }

    public static double calculateEnergy(RnaScene rnaScene) throws RnaBackendException {
        RNA rNA = RnaFileIO.createRNAfromScene(rnaScene, true, false, false);
        RnaFileIO.breakBackendPseudoknots(rnaScene, rNA, 1);
        double d = rNA.CalculateFreeEnergy(1, true);
        if (rNA.GetErrorCode() != 0) {
            throw new RnaBackendException(rNA.GetFullErrorMessage(), rNA.GetErrorCode());
        }
        return d;
    }

    public static void breakBackendPseudoknots(RnaScene rnaScene, RNA rNA, int n) {
        Set<Bond> set = Motif.findPseudoKnots(rnaScene);
        for (Bond bond : set) {
            rNA.RemoveBasePair(RnaFileIO.backendPairIndex(bond.n5), n);
        }
    }

    public static boolean getBestOrientation(double[] dArray, double[] dArray2, double[] dArray3, double d) {
        d *= d;
        Vec2D vec2D = new Vec2D();
        Vec2D vec2D2 = new Vec2D();
        for (int i = 0; i < dArray.length; i += 2) {
            for (int j = 0; j < dArray.length; j += 2) {
                vec2D.setTo(dArray[j] - dArray[i], dArray[j + 1] - dArray[i + 1]);
                vec2D2.setTo(dArray2[j] - dArray2[i], dArray2[j + 1] - dArray2[i + 1]);
                if (vec2D.lengthSqr() != vec2D2.lengthSqr()) continue;
                double d2 = vec2D.angleTo(vec2D2);
            }
        }
        return true;
    }

    public static BackendCalc<RnaSceneGroup> foldSeq(final String string, final int n) {
        return new BackendCalc<RnaSceneGroup>(){

            @Override
            protected RnaSceneGroup calcResult() throws Exception {
                this.nextStep(5, "Loading Sequence...", true);
                if (this.isCanceled()) {
                    return null;
                }
                RNA rNA = new RNA(string, true);
                if (rNA.GetErrorCode() != 0) {
                    throw new RnaBackendException("Failed to Fold RNA Sequence:  " + rNA.GetFullErrorMessage());
                }
                rNA.SetProgress(this.backendProgress);
                this.nextStep(95, "Folding Sequence...", true);
                if (this.isCanceled()) {
                    return null;
                }
                int n2 = rNA.FoldSingleStrand(20.0f, n, RnaFileIO.defaultWindowSize(rNA), null, 30, false, true, false);
                if (n2 != 0) {
                    throw new RnaBackendException("Failed to Fold RNA Sequence:  " + RNA.GetErrorMessage(n2), n2);
                }
                return RnaFileIO.getRNAstructureGroup(rNA);
            }
        };
    }

    private static int defaultWindowSize(RNA rNA) {
        int n = rNA.GetSequenceLength();
        if (n > 1200) {
            return 20;
        }
        if (n > 800) {
            return 15;
        }
        if (n > 500) {
            return 11;
        }
        if (n > 300) {
            return 7;
        }
        if (n > 120) {
            return 5;
        }
        if (n > 50) {
            return 3;
        }
        return 2;
    }

    private static void verifyDataPath() throws RnaBackendException {
        String string = RnaFileIO.getDataPath();
        if (string == null) {
            throw new RnaBackendException("The thermodynamic data tables could not be found.\nPlease set the DATAPATH environment variable to the directory where they are stored.\n\t(e.g. <PATH-TO-RNAstructure>/data_tables).");
        }
        RNABackend.setDataPath(string);
    }

    private static String getDataPath() {
        if (DATA_PATH != null) {
            return DATA_PATH;
        }
        if (RnaFileIO.verifyDataFiles(RNABackend.getDataPath())) {
            return DATA_PATH;
        }
        String[] stringArray = new String[]{".", "..", "./resources", "../Resources"};
        String[] stringArray2 = new String[]{"{path}/", "{path}/data_tables", "{app}/{path}/", "{app}/{path}/data_tables"};
        String string = PathTools.getAppPath(RnaFileIO.class);
        if (string == null) {
            string = ".";
        }
        for (String string2 : stringArray) {
            for (String string3 : stringArray2) {
                String string4 = string3.replace("{app}", string).replace("{path}", string2);
                if (!RnaFileIO.verifyDataFiles(string4)) continue;
                return DATA_PATH;
            }
        }
        return null;
    }

    private static boolean verifyDataFiles(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (file.exists()) {
            try {
                String string2 = file.getCanonicalPath();
                if (PathTools.listFiles(string2, "*.dat").size() != 0) {
                    DATA_PATH = string2;
                    log.debug("The thermodynamic data tables were located at \"" + string2 + "\".");
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static int getRNAType(FileType fileType) {
        switch (fileType) {
            case Structure: 
            case CT: {
                return RNABackend.FILE_CT;
            }
            case DotBracket: {
                return RNABackend.FILE_DBN;
            }
            case FoldingSav: {
                return RNABackend.FILE_SAV;
            }
            case PartitionSav: {
                return RNABackend.FILE_PFS;
            }
            case Sequence: 
            case Seq: 
            case Fasta: 
            case SeqText: {
                return RNABackend.FILE_SEQ;
            }
        }
        return -1;
    }

    public static RnaSceneGroup readFileAsScene(String string, FileType fileType) throws RnaBackendException {
        RnaFileIO.verifyDataPath();
        int n = RnaFileIO.getRNAType(fileType);
        RNA rNA = new RNA(string, n, ALPHABET_RNA, true, true);
        rNA.EnsureStructureCapcacity(1);
        if (rNA.GetErrorCode() != 0) {
            throw new RnaBackendException(rNA.GetFullErrorMessage(), rNA.GetErrorCode(), string);
        }
        System.out.println("Done readRNAFile @" + System.currentTimeMillis());
        return RnaFileIO.getRNAstructureGroup(rNA);
    }

    public static RnaSceneGroup getRNAstructureGroup(RNA rNA) throws RnaBackendException {
        RnaSceneGroup rnaSceneGroup = new RnaSceneGroup();
        rnaSceneGroup.setTitle(rNA.GetStructure().GetSequenceLabel());
        int n = rNA.GetStructureNumber();
        for (int i = 1; i <= n; ++i) {
            rnaSceneGroup.add(RnaFileIO.createSceneFromRNA(rNA, i, true));
        }
        return rnaSceneGroup;
    }

    public static boolean writeSequenceFile(RnaScene rnaScene, String string, FileType fileType, boolean bl) throws RnaBackendException, IOException {
        int n;
        switch (fileType) {
            case Fasta: {
                n = 2;
                break;
            }
            case Seq: {
                n = 1;
                break;
            }
            case SeqText: {
                n = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Sequence file format: " + fileType);
            }
        }
        RNA rNA = RnaFileIO.createRNAfromScene(rnaScene, false, true, true);
        structure structure2 = rNA.GetStructure();
        if (structure2.writeseq(string, n, bl) == 0) {
            String string2 = structure2.GetErrorDetails();
            throw new IOException(Strings.isEmpty(string2) ? "Error writing file." : string2);
        }
        return true;
    }

    public static boolean writeStructureFile(RnaSceneGroup rnaSceneGroup, String string, FileType fileType, boolean bl) throws IOException, RnaBackendException {
        RNA rNA = RnaFileIO.writeRNAstructureGroup(rnaSceneGroup, true, true);
        switch (fileType) {
            case Structure: 
            case DotBracket: {
                rNA.WriteDotBracket(string);
                break;
            }
            case CT: {
                rNA.WriteCt(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown file type: " + fileType);
            }
        }
        int n = rNA.GetErrorCode();
        if (n != 0) {
            throw new RnaBackendException(rNA.GetFullErrorMessage(), n, string);
        }
        return true;
    }

    public static String getStructureTitle(RNA rNA, int n) {
        String string = rNA.GetCommentString(n);
        if (string.endsWith("\n")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void setStructureTitle(RNA rNA, int n, String object) {
        String string;
        if (object == null) {
            object = "";
        }
        if ((string = rNA.GetCommentString(n)).endsWith("\n") && !((String)object).endsWith("\n")) {
            object = (String)object + "\n";
        }
        rNA.GetStructure().SetCtLabel((String)object, n);
    }

    public static void identifyPseudoKnotsBackend(RnaScene rnaScene) throws RnaBackendException {
        StopWatch stopWatch = new StopWatch(true);
        RNA rNA = RnaFileIO.createRNAfromScene(rnaScene, true, true, false);
        stopWatch.println("createRNAfromScene").restart();
        rNA.BreakPseudoknot(false, 1);
        stopWatch.println("rna.BreakPseudoknot").restart();
        RnaScene rnaScene2 = RnaFileIO.createSceneFromRNA(rNA, 1, true);
        stopWatch.println("createSceneFromRNA").restart();
        List<Nuc> list = rnaScene2.allNucs();
        for (Nuc nuc : rnaScene.allNucs()) {
            if (!nuc.isPaired()) continue;
            boolean bl = list.get(nuc.indexInScene()).isPaired();
            if (nuc.getPairBond().type == BondType.Default && !bl) {
                nuc.getPairBond().type = BondType.Pseudo;
                continue;
            }
            if (nuc.getPairBond().type != BondType.Pseudo || !bl) continue;
            nuc.getPairBond().type = BondType.Default;
        }
        stopWatch.println("UpdatedNucs").restart();
    }

    public static String stripEnergyTitle(String string) {
        if (string == null) {
            return null;
        }
        return stripEnergyTitleRegex.matcher(string).replaceFirst("");
    }

    static {
        InterMolecularBreakLength = InterMolecularBreakStr.length();
        stripEnergyTitleRegex = Pattern.compile("^\\s*ENERGY\\s*=\\s*-?[\\d.]+\\s*", 2);
    }

    public static abstract class BackgroundWork<TResult>
    implements AsyncTask<TResult> {
        protected boolean _isDone;
        protected boolean _isCanceled;
        protected boolean _canCancel;
        protected int _progress = 0;
        protected Object _tag;
        String _status;
        protected TResult _result;
        Exception _err;
        protected Consumer<? super BackgroundWork<TResult>> _update;
        protected Consumer<? super BackgroundWork<TResult>> _complete;

        @Override
        public Object getTag() {
            return this._tag;
        }

        @Override
        public int getProgress() {
            return this._progress;
        }

        @Override
        public String getStatus() {
            return this._status;
        }

        @Override
        public boolean isDone() {
            return this._isDone;
        }

        @Override
        public boolean isCanceled() {
            return this._isCanceled;
        }

        @Override
        public boolean canCancel() {
            return this._canCancel;
        }

        @Override
        public void cancel() {
            if (!this._canCancel) {
                throw new UnsupportedOperationException("This Task cannot be canceled.");
            }
            this._isCanceled = true;
            this.notifyUpdate();
        }

        @Override
        public TResult getResult() {
            return this._result;
        }

        @Override
        public Exception getError() {
            return this._err;
        }

        protected void setError(String string) {
            this.setError(new Exception(string));
        }

        protected void setError(Exception exception) {
            this._err = exception;
            this.notifyUpdate();
        }

        protected void update(int n, String string) {
            this._status = string;
            this.update(n);
        }

        protected void update(int n) {
            this._progress = n;
            this.notifyUpdate();
        }

        protected abstract TResult calcResult() throws Exception;

        public void start() {
            SwingWorker swingWorker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    try {
                        _result = this.calcResult();
                    }
                    catch (Exception exception) {
                        _result = null;
                        this.setError(exception);
                    }
                    _isDone = true;
                    this.notifyUpdate();
                    return null;
                }

                @Override
                protected void done() {
                    _complete.accept(this);
                }
            };
            swingWorker.execute();
        }

        protected void notifyUpdate() {
            if (this._update == null) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this._update.accept(this);
            } else {
                SwingUtilities.invokeLater(() -> this._update.accept(this));
            }
        }

        public void whenDone(Consumer<? super BackgroundWork<TResult>> consumer) {
            this._complete = consumer;
        }

        public void onUpdate(Consumer<? super BackgroundWork<TResult>> consumer) {
            this._update = consumer;
        }
    }

    public static abstract class BackendCalc<TResult>
    extends BackgroundWork<TResult> {
        protected ProgressHandler backendProgress = new SimpleProgressHandler();
        protected int _stepWork = 100;
        protected int _workComplete;

        @Override
        public int getProgress() {
            return (int)((float)this._workComplete + (float)this.backendProgress.progress() / 100.0f * (float)this._stepWork);
        }

        @Override
        public boolean isCanceled() {
            return this.backendProgress.canceled();
        }

        @Override
        public void cancel() {
            this.backendProgress.cancel();
        }

        protected void nextStep(int n) {
            if (this._stepWork != 100) {
                this._workComplete += this._stepWork;
            }
            this._stepWork = n;
            this.backendProgress.update(0);
            this.notifyUpdate();
        }

        protected void nextStep(int n, String string, boolean bl) {
            this._canCancel = bl;
            this._status = string;
            this.nextStep(n);
        }
    }

    public static interface AsyncTask<TResult> {
        public Object getTag();

        public int getProgress();

        public String getStatus();

        public boolean isDone();

        default public boolean isCanceled() {
            return false;
        }

        default public boolean canCancel() {
            return false;
        }

        default public void cancel() {
            throw new UnsupportedOperationException("This Task cannot be canceled.");
        }

        public TResult getResult();

        public Exception getError();

        default public boolean hadError() {
            return this.getError() != null;
        }
    }

    static abstract class NucIndexConverter {
        public static final NucIndexConverter SingleStrand = new NucIndexConverter(){

            @Override
            public Nuc getSceneNuc(RnaScene rnaScene, int n) {
                return rnaScene.strands.get(0).get(n - 1);
            }

            @Override
            public int getBackendIndex(Nuc nuc) {
                return nuc.indexInScene() + 1;
            }
        };

        NucIndexConverter() {
        }

        public abstract Nuc getSceneNuc(RnaScene var1, int var2);

        public abstract int getBackendIndex(Nuc var1);

        public static NucIndexConverter create(String string) {
            char[] cArray = string.toCharArray();
            int n = NucIndexConverter.countLinkers(cArray);
            if (n == 0) {
                return SingleStrand;
            }
            int[] nArray = new int[n * 2];
            NucIndexConverter.readLinkers(cArray, nArray);
            if (n == 1) {
                return new DoubleStrand(nArray[0], nArray[1]);
            }
            return new MultiStrand(nArray);
        }

        private static int countLinkers(char[] cArray) {
            boolean bl = false;
            int n = 0;
            for (char c : cArray) {
                boolean bl2 = RnaFileIO.isInterStrandLinker(c);
                if (bl2 && !bl) {
                    ++n;
                }
                bl = bl2;
            }
            return n;
        }

        private static void readLinkers(char[] cArray, int[] nArray) {
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            for (char c : cArray) {
                boolean bl2 = RnaFileIO.isInterStrandLinker(c);
                if (bl != bl2) {
                    nArray[n++] = n2;
                }
                bl = bl2;
                ++n2;
            }
        }

        public static class MultiStrand
        extends NucIndexConverter {
            final int[] linkers;

            public MultiStrand(int[] nArray) {
                this.linkers = nArray;
            }

            @Override
            public Nuc getSceneNuc(RnaScene rnaScene, int n) {
                int n2 = n - 1;
                if (n2 < this.linkers[0]) {
                    return rnaScene.strands.get(0).get(n2);
                }
                int n3 = 0;
                int n4 = this.linkers.length / 2;
                while (++n3 < n4) {
                    if (n2 >= this.linkers[n3 * 2]) continue;
                    return rnaScene.strands.get(n3).get(n2 - this.linkers[n3 * 2 - 1]);
                }
                return rnaScene.strands.get(n4).get(n2 - this.linkers[n4 * 2 - 1]);
            }

            @Override
            public int getBackendIndex(Nuc nuc) {
                if (nuc.getStrand().getIndex() == 0) {
                    return nuc.indexInStrand() + 1;
                }
                return nuc.indexInStrand() + 1 + this.linkers[nuc.getStrand().getIndex() * 2 - 1];
            }
        }

        public static class DoubleStrand
        extends NucIndexConverter {
            final int linkerStart;
            final int linkerEnd;

            public DoubleStrand(int n, int n2) {
                this.linkerStart = n;
                this.linkerEnd = n2;
            }

            @Override
            public Nuc getSceneNuc(RnaScene rnaScene, int n) {
                int n2 = n - 1;
                if (n2 < this.linkerStart) {
                    return rnaScene.strands.get(0).get(n2);
                }
                return rnaScene.strands.get(1).get(n2 - this.linkerEnd);
            }

            @Override
            public int getBackendIndex(Nuc nuc) {
                if (nuc.getStrand().getIndex() == 0) {
                    return nuc.indexInStrand() + 1;
                }
                return nuc.indexInStrand() + 1 + this.linkerEnd;
            }
        }
    }
}

