/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.fileIO;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ur_rna.StructureEditor.FileType;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.BondType;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.NucStyle;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.RnaSceneGroup;
import ur_rna.StructureEditor.models.Strand;
import ur_rna.StructureEditor.services.SceneDrawMode;
import ur_rna.StructureEditor.services.fileIO.RnaFileIO;
import ur_rna.Utilities.Colors;
import ur_rna.Utilities.Convert;
import ur_rna.Utilities.FormatterException;
import ur_rna.Utilities.SimpleDataSerializer;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.SyntaxErrorException;
import ur_rna.Utilities.Version;

public class DrawingFileIO {
    private static final DecimalFormat _dblFormat = new DecimalFormat("#.##########");

    public static RnaSceneGroup readNsdDrawingFile(String string) throws SyntaxErrorException, IOException {
        String string2 = new String(Files.readAllBytes(Paths.get(string, new String[0])), StandardCharsets.UTF_8);
        Object object = new SimpleDataSerializer().parse(string2, null);
        return DrawingFileIO.readNsdDrawingFile(object);
    }

    public static RnaSceneGroup readNsdDrawingFile(Reader reader) throws SyntaxErrorException, IOException {
        int n = 0;
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read(cArray)) > 0) {
            stringBuilder.append(cArray, 0, n);
        }
        Object object = new SimpleDataSerializer().parse(stringBuilder, null);
        return DrawingFileIO.readNsdDrawingFile(object);
    }

    private static RnaSceneGroup readNsdDrawingFile(Object object) throws SyntaxErrorException {
        if (object == null) {
            throw new IllegalStateException("Document content must be parsed before applying it to an RNA structure.");
        }
        Object object2 = "start of data";
        try {
            SimpleDataSerializer.SSONList sSONList = DrawingFileIO.expectList(object, "Expected a list of RNA scenes.");
            SimpleDataSerializer.SSONMap sSONMap = DrawingFileIO.expectMap(sSONList.isEmpty() ? null : sSONList.get(0), "Expected a Drawing file descriptor, e.g. { Version: ... }");
            Version version = new Version(Convert.toString(sSONMap.get("Version"), ""));
            if (version.isEmpty()) {
                throw new IllegalArgumentException("The version descriptor was not found.");
            }
            RnaSceneGroup rnaSceneGroup = new RnaSceneGroup();
            rnaSceneGroup.setTitle(sSONMap.get("Title", "Untitled"));
            int n = 0;
            for (Object e : sSONList.subList(1, sSONList.size())) {
                Nuc nuc;
                Cloneable cloneable;
                Object object3;
                Object object4;
                Cloneable cloneable2;
                Strand strand;
                Object object5;
                ++n;
                RnaScene rnaScene = new RnaScene();
                HashMap<Object, Nuc> hashMap = new HashMap<Object, Nuc>();
                HashMap hashMap2 = new HashMap();
                rnaSceneGroup.add(rnaScene);
                object2 = "scene " + n;
                String string = object2;
                SimpleDataSerializer.SSONMap sSONMap2 = DrawingFileIO.expectMap(e, "Expected an RNA 'scene' descriptor, e.g. { Title: ... Strands: ... Bonds: ... }");
                rnaScene.title = sSONMap2.get("Title", "Structure" + n);
                rnaScene.drawMode = SceneDrawMode.valueOf(sSONMap2.get("Mode", SceneDrawMode.Standard.name()));
                rnaScene.drawFlipped = sSONMap2.get("Flip", false);
                SimpleDataSerializer.SSONList sSONList2 = DrawingFileIO.expectList(sSONMap2.get("Strands"), "Expected a list of Strands");
                int n2 = 1;
                for (Object e2 : sSONList2) {
                    object2 = string + ", strand #" + n2;
                    object5 = DrawingFileIO.expectMap(e2, "Expected an RNA strand descriptor, e.g. { Title: ... Bases: ... }");
                    strand = rnaScene.getStrand(n2 - 1, true);
                    cloneable2 = DrawingFileIO.expectList(((LinkedHashMap)object5).get("Strand"), "Expected a list of Nucleotides");
                    object4 = ((ArrayList)cloneable2).iterator();
                    while (object4.hasNext()) {
                        object3 = object4.next();
                        object2 = String.format("scene %s, strand #%s, position %s.", n, n2, strand.size() + 1);
                        cloneable = DrawingFileIO.expectMap(object3, "Expected a Nucleotide (e.g. { Base: G, X: 3, Y: 5 ...  })");
                        nuc = new Nuc(((SimpleDataSerializer.SSONMap)cloneable).get("Base", "?"), ((SimpleDataSerializer.SSONMap)cloneable).get("X", 0.0f), ((SimpleDataSerializer.SSONMap)cloneable).get("Y", 0.0f));
                        strand.add(nuc);
                        nuc.number = ((SimpleDataSerializer.SSONMap)cloneable).get("HNum", -1);
                        Object v = ((LinkedHashMap)cloneable).get("ID");
                        Object object6 = v == null ? "" + (nuc.indexInScene() + 1) : (v instanceof Number ? DrawingFileIO.fmtNumber(((Number)v).doubleValue()) : v.toString());
                        if (hashMap.containsKey(object6)) {
                            throw new SyntaxErrorException("The ID " + (String)object6 + " was used for more than one base.");
                        }
                        hashMap.put(object6, nuc);
                        if (!((SimpleDataSerializer.SSONMap)cloneable).containsAnyKey("Fill", "Color", "Line", "Font", "Bond", "NumOffset")) continue;
                        nuc.style = new NucStyle(DrawingFileIO.decodeColor(((LinkedHashMap)cloneable).get("Fill"), null), DrawingFileIO.decodeColor(((LinkedHashMap)cloneable).get("Color"), null), DrawingFileIO.decodeColor(((LinkedHashMap)cloneable).get("Line"), null), DrawingFileIO.decodeColor(((LinkedHashMap)cloneable).get("Bond"), null), DrawingFileIO.decodeFont(((LinkedHashMap)cloneable).get("Font"), null), ((SimpleDataSerializer.SSONMap)cloneable).get("NumOffset", 0.0f));
                    }
                    ++n2;
                }
                object2 = string;
                SimpleDataSerializer.SSONList sSONList3 = DrawingFileIO.expectList(sSONMap2.get("Pairs"), "Expected a list of Bonds" + n);
                int n3 = 0;
                object5 = sSONList3.iterator();
                while (object5.hasNext()) {
                    strand = object5.next();
                    object2 = string + ", bond #" + ++n3;
                    cloneable2 = DrawingFileIO.expectMap(strand, "Expected a Bond descriptor, e.g. { Pair: \"5:12\" Type: BP }");
                    object4 = BondType.fromAbbrev(((SimpleDataSerializer.SSONMap)cloneable2).get("Type", ""), BondType.Default);
                    object3 = ((SimpleDataSerializer.SSONMap)cloneable2).get("Pair", "").split(":");
                    cloneable = (Nuc)hashMap.get(((String)object3[0]).trim());
                    nuc = (Nuc)hashMap.get(((String)object3[1]).trim());
                    if (cloneable == null) {
                        throw new SyntaxErrorException("The ID \"" + object3[0] + "\" is not associated with any nucleotide.");
                    }
                    if (nuc == null) {
                        throw new SyntaxErrorException("The ID \"" + object3[1] + "\" is not associated with any nucleotide.");
                    }
                    rnaScene.addBond((Nuc)cloneable, nuc, (BondType)((Object)object4));
                }
            }
            return rnaSceneGroup;
        }
        catch (Exception exception) {
            throw new SyntaxErrorException("Error reading Drawing data: while parsing " + (String)object2 + ": " + exception.getMessage(), exception);
        }
    }

    private static String fmtNumber(double d) {
        long l = Math.round(d);
        if (d == (double)l) {
            return Long.toString(l);
        }
        if (Math.abs(d) > 1.0E-4 && Math.abs(d) < 100000.0) {
            return _dblFormat.format(d);
        }
        return Double.toString(d);
    }

    private static SimpleDataSerializer.SSONMap expectMap(Object object, String string) {
        if (object instanceof SimpleDataSerializer.SSONMap) {
            return (SimpleDataSerializer.SSONMap)object;
        }
        throw new IllegalArgumentException(string);
    }

    private static SimpleDataSerializer.SSONList expectList(Object object, String string) {
        if (object instanceof SimpleDataSerializer.SSONList) {
            return (SimpleDataSerializer.SSONList)object;
        }
        throw new IllegalArgumentException(string);
    }

    public static void writeNsdDrawingFile(RnaSceneGroup rnaSceneGroup, String string, boolean bl) throws IOException, FormatterException {
        DrawingFileIO.writeNsdDrawingFile(rnaSceneGroup, string, bl, 2, false);
    }

    public static void writeNsdDrawingFile(RnaSceneGroup rnaSceneGroup, String string, boolean bl, int n, boolean bl2) throws IOException, FormatterException {
        try (Writer writer = DrawingFileIO.newUTF8Writer(string, bl);){
            DrawingFileIO.writeNsdDrawingFile(rnaSceneGroup, writer, n, bl2);
        }
    }

    public static void writeNsdDrawingFile(RnaSceneGroup rnaSceneGroup, Writer writer, int n, boolean bl) throws IOException, FormatterException {
        Cloneable cloneable22;
        SimpleDataSerializer.SSONMap sSONMap = new SimpleDataSerializer.SSONMap();
        SimpleDataSerializer.SSONList sSONList = new SimpleDataSerializer.SSONList();
        sSONMap.put("Version", "1.0");
        sSONMap.put("Title", rnaSceneGroup.getTitle());
        sSONList.add(sSONMap);
        for (Cloneable cloneable22 : rnaSceneGroup) {
            SimpleDataSerializer.SSONMap sSONMap2;
            SimpleDataSerializer.SSONMap sSONMap3 = sSONList.addMap();
            sSONMap3.put("Title", ((RnaScene)cloneable22).title);
            sSONMap3.put("Mode", ((RnaScene)cloneable22).drawMode.name());
            sSONMap3.put("Flip", ((RnaScene)cloneable22).drawFlipped);
            SimpleDataSerializer.SSONList sSONList2 = sSONMap3.putList("Strands");
            SimpleDataSerializer.SSONList sSONList3 = sSONMap3.putList("Pairs");
            for (Strand strand : ((RnaScene)cloneable22).strands) {
                sSONMap2 = sSONList2.addMap();
                SimpleDataSerializer.SSONList sSONList4 = sSONMap2.putList("Strand");
                for (Nuc nuc : strand) {
                    SimpleDataSerializer.SSONMap sSONMap4 = sSONList4.addMap();
                    sSONMap4.put("ID", nuc.indexInScene() + 1);
                    sSONMap4.put("Base", nuc.symbol);
                    if (nuc.number != -1) {
                        sSONMap4.put("HNum", nuc.number);
                    }
                    sSONMap4.put("X", Float.valueOf(DrawingFileIO.roundLoc(nuc.location.x)));
                    sSONMap4.put("Y", Float.valueOf(DrawingFileIO.roundLoc(nuc.location.y)));
                    if (nuc.style == null) continue;
                    NucStyle nucStyle = nuc.style;
                    SimpleDataSerializer.SSONMap sSONMap5 = sSONMap4;
                    if (nucStyle.textColor != null) {
                        sSONMap5.put("Color", Colors.getName(nucStyle.textColor));
                    }
                    if (nucStyle.fillColor != null) {
                        sSONMap5.put("Fill", Colors.getName(nucStyle.fillColor));
                    }
                    if (nucStyle.outlineColor != null) {
                        sSONMap5.put("Line", Colors.getName(nucStyle.outlineColor));
                    }
                    if (nucStyle.bondColor != null) {
                        sSONMap5.put("Bond", Colors.getName(nucStyle.bondColor));
                    }
                    if (nucStyle.font != null) {
                        sSONMap5.put("Font", nucStyle.font.toString());
                    }
                    if (nucStyle.numberOffset == 0.0f) continue;
                    sSONMap5.put("NumOffset", Float.valueOf(nucStyle.numberOffset));
                }
            }
            for (Bond bond : ((RnaScene)cloneable22).getBonds()) {
                sSONMap2 = sSONList3.addMap();
                sSONMap2.put("Pair", bond.getNuc5().indexInScene() + 1 + ":" + (bond.getNuc3().indexInScene() + 1));
                sSONMap2.put("Type", bond.type.getAbbrev());
            }
        }
        SimpleDataSerializer simpleDataSerializer = new SimpleDataSerializer();
        cloneable22 = new SimpleDataSerializer.OutputFormatSettings(n, bl);
        simpleDataSerializer.write(sSONList, writer, (SimpleDataSerializer.OutputFormatSettings)cloneable22);
    }

    private static Font decodeFont(Object object, Font font) {
        if (object == null || object.equals("")) {
            return font;
        }
        if (object instanceof Font) {
            return (Font)object;
        }
        if (object instanceof String) {
            return Font.decode((String)object);
        }
        return font;
    }

    private static Color decodeColor(Object object, Color color) {
        if (object == null || object.equals("")) {
            return color;
        }
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof String) {
            return Colors.getColor((String)object, color);
        }
        if (object instanceof Number) {
            return new Color(((Number)object).intValue());
        }
        return color;
    }

    private static float roundLoc(float f) {
        return (float)Math.round(10.0f * f) / 10.0f;
    }

    private static Writer newUTF8Writer(String string, boolean bl) throws IOException {
        OpenOption[] openOptionArray;
        if (bl) {
            OpenOption[] openOptionArray2 = new OpenOption[1];
            openOptionArray = openOptionArray2;
            openOptionArray2[0] = StandardOpenOption.APPEND;
        } else {
            openOptionArray = new OpenOption[]{};
        }
        OpenOption[] openOptionArray3 = openOptionArray;
        return Files.newBufferedWriter(Paths.get(string, new String[0]), StandardCharsets.UTF_8, openOptionArray3);
    }

    public static void writeCteDrawingFile(RnaSceneGroup rnaSceneGroup, String string, boolean bl) throws IOException {
        try (Writer writer = DrawingFileIO.newUTF8Writer(string, bl);){
            DrawingFileIO.writeCteDrawingFile(rnaSceneGroup, writer, true);
        }
    }

    public static void writeCtFile(RnaSceneGroup rnaSceneGroup, String string, boolean bl) throws IOException {
        try (Writer writer = DrawingFileIO.newUTF8Writer(string, bl);){
            DrawingFileIO.writeCteDrawingFile(rnaSceneGroup, writer, false);
        }
    }

    public static void writeCteDrawingFile(RnaSceneGroup rnaSceneGroup, Writer writer, boolean bl) {
        CTEWriter cTEWriter = new CTEWriter(writer);
        for (RnaScene rnaScene : rnaSceneGroup) {
            int n = rnaScene.strands.size();
            int n2 = rnaScene.getNucCount() + 3 * (n - 1);
            cTEWriter.write(5, n2).space(2).write(rnaScene.title).writeln();
            int n3 = 1;
            int[] nArray = rnaScene.buildStrandIndex(1, RnaFileIO.InterMolecularBreakLength);
            for (Strand strand : rnaScene.strands) {
                if (n3 != 1) {
                    for (int i = 0; i < "III".length(); ++i) {
                        cTEWriter.write(5, n3).space().write(-4, 'I');
                        cTEWriter.space().write(4, n3 - 1).space().write(4, n3 + 1);
                        cTEWriter.space().write(4, 0).space().write(4, n3);
                        cTEWriter.writeln();
                        ++n3;
                    }
                }
                for (Nuc nuc : strand) {
                    cTEWriter.write(5, n3);
                    cTEWriter.space().write(-4, Strings.isEmpty(nuc.symbol) ? (char)'?' : nuc.symbol.charAt(0));
                    cTEWriter.space().write(4, n3 == 1 ? 0 : n3 - 1);
                    cTEWriter.space().write(4, n3 == n2 ? 0 : n3 + 1);
                    cTEWriter.space().write(4, nuc.isPaired() ? nuc.getPaired().indexInScene(nArray) : 0);
                    cTEWriter.space().write(4, nuc.number == -1 ? n3 : nuc.number);
                    if (bl) {
                        NucStyle nucStyle;
                        cTEWriter.space().write(";!");
                        cTEWriter.writep("X", 6, Math.round(nuc.location.x));
                        cTEWriter.writep("Y", 6, Math.round(nuc.location.y));
                        Bond bond = nuc.getPairBond();
                        if (bond != null && bond.type != BondType.Default) {
                            cTEWriter.writep("B", 1, bond.type.getAbbrev());
                        }
                        if ((nucStyle = nuc.style) != null && !nucStyle.isEmpty()) {
                            if (nucStyle.textColor != null) {
                                cTEWriter.writep("TC", 7, Colors.getName(nucStyle.textColor));
                            }
                            if (nucStyle.fillColor != null) {
                                cTEWriter.writep("FC", 7, Colors.getName(nucStyle.fillColor));
                            }
                            if (nucStyle.outlineColor != null) {
                                cTEWriter.writep("LC", 7, Colors.getName(nucStyle.outlineColor));
                            }
                            if (nucStyle.bondColor != null) {
                                cTEWriter.writep("BC", 7, Colors.getName(nucStyle.bondColor));
                            }
                            if (nucStyle.font != null) {
                                cTEWriter.writep("FS", 10, nucStyle.font.toString());
                            }
                            if (nucStyle.numberOffset != 0.0f) {
                                cTEWriter.writep("LO", 6, Float.toString(nucStyle.numberOffset));
                            }
                        }
                    }
                    cTEWriter.writeln();
                    ++n3;
                }
            }
        }
    }

    public static RnaSceneGroup readCteDrawingFile(String string) throws IOException, SyntaxErrorException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(string, new String[0]), StandardCharsets.UTF_8);){
            RnaSceneGroup rnaSceneGroup = DrawingFileIO.readCteDrawingFile(bufferedReader);
            return rnaSceneGroup;
        }
    }

    public static RnaSceneGroup readCteDrawingFile(Reader reader) throws SyntaxErrorException {
        RnaSceneGroup rnaSceneGroup = new RnaSceneGroup();
        rnaSceneGroup.setSource("<input>", FileType.CteDrawing);
        Pattern pattern = Pattern.compile("[;#]");
        Pattern pattern2 = Pattern.compile("(\\w+)[\\s\\t]*:");
        Pattern pattern3 = Pattern.compile(";!");
        SimpleScanner simpleScanner = new SimpleScanner(reader);
        int n = 0;
        RnaScene rnaScene = null;
        Strand strand = null;
        NucStyle nucStyle = null;
        int n2 = 0;
        while (!simpleScanner.atEOF()) {
            if (simpleScanner.at(pattern) || simpleScanner.atEndOfLine()) {
                simpleScanner.nextLine();
                continue;
            }
            if (rnaScene == null) {
                try {
                    n = simpleScanner.nextInt();
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw DrawingFileIO.parseError(simpleScanner, "Expected the number of nucleobases in the structure, but found '%s'.", simpleScanner.next());
                }
                if (n < 0 || n > 10000) {
                    throw DrawingFileIO.parseError(simpleScanner, "Invalid number of nucleobases: '%d' (expected from 1 to %d).", n, 10000);
                }
                rnaScene = new RnaScene();
                rnaSceneGroup.add(rnaScene);
                rnaScene.title = simpleScanner.nextLine().trim();
                if (rnaSceneGroup.size() == 0) {
                    rnaSceneGroup.setTitle(rnaScene.title);
                }
                strand = rnaScene.firstStrand();
                strand.addPlaceholders(n);
                n2 = 0;
                continue;
            }
            String string = null;
            try {
                Nuc nuc = strand.get(n2++);
                Bond bond = null;
                if (nucStyle == null) {
                    nucStyle = new NucStyle();
                }
                string = "index";
                int n3 = simpleScanner.nextInt();
                if (n3 != n2) {
                    throw DrawingFileIO.parseError(simpleScanner, "Invalid nucleobase index %d (expected %d)", n3, n2);
                }
                string = "symbol";
                nuc.symbol = simpleScanner.next();
                string = "prev-index";
                int n4 = simpleScanner.nextInt();
                if (n4 != 0 && n4 != n2 - 1) {
                    throw DrawingFileIO.parseError(simpleScanner, "Invalid nucleobase connection to previous base %d (expected 0 or %d)", n4, n2 - 1);
                }
                if (n4 < 0 || n4 > n) {
                    throw DrawingFileIO.parseError(simpleScanner, "Invalid nucleobase index %d (expected range: 1 to %d)", n4, n - 1);
                }
                string = "next-index";
                int n5 = simpleScanner.nextInt();
                if (n5 != 0 && n5 != n2 + 1) {
                    throw DrawingFileIO.parseError(simpleScanner, "Invalid nucleobase connection to next base %d (expected 0 or %d)", n5, n2 + 1);
                }
                string = "pair-index";
                int n6 = simpleScanner.nextInt();
                if (n6 < 0 || n6 > n) {
                    throw DrawingFileIO.parseError(simpleScanner, "Invalid nucleobase index %d (expected range: 1 to %d)", n6, n);
                }
                string = "historic-index";
                int n7 = nuc.number = simpleScanner.atNumber() ? simpleScanner.nextInt() : n3;
                if (n5 == 0 && n2 != n) {
                    strand = rnaScene.strands.add();
                }
                if (n6 != 0) {
                    if (n6 > n3) {
                        if (strand.get(n6 - 1).isPaired()) {
                            throw DrawingFileIO.parseError(simpleScanner.lineNumber(), -1, "Inconsistent base pairing: bases %d and %d are both paired to base %d: ", n3, strand.get(n6 - 1).getPaired().indexInScene() + 1, n6);
                        }
                        bond = rnaScene.addBond(n3 - 1, n6 - 1, BondType.Default);
                    } else {
                        bond = nuc.getPairBond();
                        if (bond == null || bond.getNuc3() != nuc) {
                            throw DrawingFileIO.parseError(simpleScanner.lineNumber(), -1, "Inconsistent base pairing information between bases %d and %d: ", n6, n3);
                        }
                    }
                } else if (nuc.isPaired()) {
                    throw DrawingFileIO.parseError(simpleScanner.lineNumber(), -1, "Inconsistent base pairing information between bases %d and %d: ", nuc.getPaired().indexInScene() + 1, n3);
                }
                if (simpleScanner.at(pattern3)) {
                    simpleScanner.next(pattern3);
                    block27: while (simpleScanner.at(pattern2)) {
                        String string2 = simpleScanner.nextMatch(pattern2).group(1);
                        switch (string2.toUpperCase()) {
                            case "X": {
                                string = "X-pos";
                                nuc.location.x = simpleScanner.nextFloat();
                                continue block27;
                            }
                            case "Y": {
                                string = "Y-pos";
                                nuc.location.y = simpleScanner.nextFloat();
                                continue block27;
                            }
                            case "TC": {
                                string = "Color";
                                nucStyle.textColor = Colors.getColor(simpleScanner.next());
                                continue block27;
                            }
                            case "FC": {
                                string = "Fill-Color";
                                nucStyle.fillColor = Colors.getColor(simpleScanner.next());
                                continue block27;
                            }
                            case "LC": {
                                string = "Line-Color";
                                nucStyle.outlineColor = Colors.getColor(simpleScanner.next());
                                continue block27;
                            }
                            case "BC": {
                                string = "Bond-Color";
                                nucStyle.bondColor = Colors.getColor(simpleScanner.next());
                                continue block27;
                            }
                            case "FS": {
                                string = "Font";
                                nucStyle.font = Font.decode(simpleScanner.next());
                                continue block27;
                            }
                            case "LO": {
                                string = "Label-Offset";
                                nucStyle.numberOffset = simpleScanner.nextFloat();
                                continue block27;
                            }
                            case "B": {
                                string = "Bond-Type";
                                if (bond == null) {
                                    throw DrawingFileIO.parseError(simpleScanner, "Basepair properties are specified for base number " + n3 + ", which is not paired.", new Object[0]);
                                }
                                bond.type = BondType.fromAbbrev(simpleScanner.next());
                                continue block27;
                            }
                        }
                        System.err.println("Warning: unknown nucleobase property in CTE file: " + string2);
                    }
                    if (!nucStyle.isEmpty()) {
                        nuc.style = nucStyle;
                        nucStyle = null;
                    }
                }
                if (!simpleScanner.atEndOfLine()) {
                    throw DrawingFileIO.parseError(simpleScanner, "Unexpected text after columns: \"%s\".", simpleScanner.next());
                }
                simpleScanner.nextLine();
            }
            catch (NumberFormatException | NoSuchElementException runtimeException) {
                throw DrawingFileIO.parseError(simpleScanner, "The nucleobase information is malformed. (Expected %s, but found '%s').", string, simpleScanner.atEndOfLine() ? "end-of-line" : simpleScanner.next());
            }
            if (n2 != n) continue;
            RnaFileIO.splitStrandsAtLinkers(rnaScene);
            rnaScene = null;
        }
        if (rnaScene != null && rnaScene.getNucCount() != n) {
            throw DrawingFileIO.parseError(simpleScanner, "The file ended before the expected number of nucleobases were listed. (Expected %i bases, but found '%i').", n, rnaScene.getNucCount());
        }
        return rnaSceneGroup;
    }

    private static SyntaxErrorException parseError(SimpleScanner simpleScanner, String string, Object ... objectArray) {
        return DrawingFileIO.parseError(simpleScanner.lineNumber(), simpleScanner.colNumber(), string, objectArray);
    }

    private static SyntaxErrorException parseError(int n, int n2, String string, Object ... objectArray) {
        String string2 = "CTE File parsing error: " + (objectArray.length == 0 ? string : String.format(string, objectArray));
        return new SyntaxErrorException(string2, null, n, n2);
    }

    private static class SimpleScanner {
        private static final String END_TOKEN = "(?=\\s|$)";
        private static final Pattern SPACE = Pattern.compile("[\\s\\t]+");
        private static final Pattern NUM = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?(?=\\s|$)");
        private static final Pattern BOOL = Pattern.compile("true|false", 2);
        private static final Pattern ANY = Pattern.compile("[^\\s]+(?=\\s|$)");
        protected final BufferedReader reader;
        private String line;
        protected int lineNum;
        protected int pos;
        protected Matcher matcher;
        protected boolean eof;

        public SimpleScanner(String string) {
            this(new BufferedReader(new StringReader(string)));
        }

        public SimpleScanner(Reader reader) {
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        }

        public int lineNumber() {
            return this.lineNum;
        }

        public int colNumber() {
            return this.pos;
        }

        public boolean atNumber() {
            return this.matchNext(NUM);
        }

        public boolean atBool() {
            return this.matchNext(BOOL);
        }

        public boolean atEndOfLine() {
            return !this.matchNext(ANY);
        }

        public boolean atEOF() {
            return this.eof;
        }

        public boolean at(Pattern pattern) {
            return this.matchNext(pattern);
        }

        public String peek() {
            return this.matchNext(ANY) ? this.matcher.group() : null;
        }

        public String next() {
            String string = this.peek();
            this.accept();
            return string;
        }

        public String next(Pattern pattern) {
            this.require(pattern);
            String string = this.matcher.group();
            this.accept();
            return string;
        }

        public boolean nextBool() {
            return Boolean.parseBoolean(this.next(BOOL));
        }

        public double nextDouble() {
            double d = Double.parseDouble(this.require(NUM));
            this.accept();
            return d;
        }

        public float nextFloat() {
            float f = Float.parseFloat(this.require(NUM));
            this.accept();
            return f;
        }

        public int nextInt() {
            int n = Integer.parseInt(this.require(NUM));
            this.accept();
            return n;
        }

        public MatchResult peekMatch(Pattern pattern) {
            return this.matchNext(pattern) ? this.matcher : null;
        }

        public MatchResult nextMatch(Pattern pattern) {
            MatchResult matchResult = this.peekMatch(pattern);
            this.accept();
            return matchResult;
        }

        public String nextLine() {
            if (this.line == null && !this.eof) {
                this.readLine();
            }
            String string = this.line == null || this.pos == 0 ? this.line : (this.pos == this.line.length() ? "" : this.line.substring(this.pos));
            this.line = null;
            return string;
        }

        protected boolean readLine() {
            if (!this.eof) {
                try {
                    this.line = this.reader.readLine();
                    if (null != this.line) {
                        this.pos = 0;
                        ++this.lineNum;
                        return true;
                    }
                    this.eof = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return false;
        }

        protected String require(Pattern pattern) {
            if (this.matchNext(pattern)) {
                return this.matcher.group();
            }
            throw new NoSuchElementException();
        }

        protected void accept() {
            if (this.matcher != null) {
                this.pos = this.matcher.end();
            }
            this.matcher = null;
        }

        protected boolean matchNext(Pattern pattern) {
            if (this.matcher != null && this.matcher.pattern() == pattern) {
                return true;
            }
            if (this.line == null && !this.readLine()) {
                return false;
            }
            this.matcher = SPACE.matcher(this.line).region(this.pos, this.line.length());
            if (this.matcher.lookingAt()) {
                this.pos = this.matcher.end();
            }
            this.matcher = pattern.matcher(this.line).region(this.pos, this.line.length());
            if (this.matcher.lookingAt()) {
                return true;
            }
            this.matcher = null;
            return false;
        }
    }

    private static class CTEWriter
    extends TextWriter {
        public CTEWriter(Writer writer) {
            super(writer);
        }

        @Override
        public CTEWriter space() {
            return (CTEWriter)super.space();
        }

        public CTEWriter writep(String string, int n, String string2) {
            return (CTEWriter)this.space().write(string).write(":").write(n, string2);
        }

        public CTEWriter writep(String string, int n, int n2) {
            return this.writep(string, n, Integer.toString(n2));
        }
    }

    public static class TextWriter {
        protected final Writer writer;

        public TextWriter(Writer writer) {
            this.writer = writer;
        }

        public TextWriter write(String string) {
            try {
                this.writer.write(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return this;
        }

        public TextWriter write(char c) {
            return this.write(Character.toString(c));
        }

        public TextWriter write(int n) {
            return this.write(Integer.toString(n));
        }

        public TextWriter write(Number number) {
            return this.write(number.toString());
        }

        public TextWriter write(int n, String string) {
            return this.write(Strings.pad(-n, string));
        }

        public TextWriter write(int n, char c) {
            return this.write(n, Character.toString(c));
        }

        public TextWriter write(int n, int n2) {
            return this.write(n, Integer.toString(n2));
        }

        public TextWriter write(int n, Number number) {
            return this.write(n, number.toString());
        }

        public TextWriter space() {
            return this.write(' ');
        }

        public TextWriter space(int n) {
            return this.write(Strings.fromChar(' ', n));
        }

        public void writeln() {
            this.write(System.lineSeparator());
        }
    }

    private static interface CTE {
        public static final String X = "X";
        public static final String Y = "Y";
        public static final String TEXT_COLOR = "TC";
        public static final String FILL_COLOR = "FC";
        public static final String LINE_COLOR = "LC";
        public static final String BOND_COLOR = "BC";
        public static final String FONT = "FS";
        public static final String BOND_TYPE = "B";
        public static final String LBL_OFFSET = "LO";
        public static final int PAD_TOTAL = 5;
        public static final int PAD_INDEX = 4;
        public static final int PAD_SYMBOL = -4;
        public static final int PAD_COLOR = 7;
        public static final int PAD_LOC = 6;
        public static final int PAD_FONT = 10;
        public static final String PROP_SEPARATOR = ";!";
    }

    private static interface NSD {
        public static final String VERSION = "Version";
        public static final String STRANDS = "Strands";
        public static final String BONDS = "Pairs";
        public static final String STYLES = "Styles";
        public static final String TITLE = "Title";
        public static final String DRAW_MODE = "Mode";
        public static final String DRAW_FLIP = "Flip";
        public static final String STYLE = "Style";
        public static final String STRAND_NUCS = "Strand";
        public static final String NUC_SYMBOL = "Base";
        public static final String NUC_NUMBER = "HNum";
        public static final String NUC_ID = "ID";
        public static final String BOND_NUCS = "Pair";
        public static final String BOND_TYPE = "Type";
        public static final String STYLE_TEXT = "Color";
        public static final String STYLE_LINE = "Line";
        public static final String STYLE_FILL = "Fill";
        public static final String STYLE_BOND = "Bond";
        public static final String STYLE_FONT = "Font";
        public static final String STYLE_NUMOFF = "NumOffset";
        public static final String X = "X";
        public static final String Y = "Y";
        public static final float LOC_ZERO = 0.0f;
        public static final int UNSTYLED = -1;
    }
}

