/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing.export;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import ur_rna.StructureEditor.services.drawing.export.GraphicsOp;
import ur_rna.StructureEditor.services.drawing.export.GraphicsStyle;
import ur_rna.StructureEditor.services.drawing.export.PageSize;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.Strings;
import ur_rna.Utilities.swing.FontUtil;
import ur_rna.Utilities.swing.ImageUtil;

public class SvgGraphicsExporter {
    private static final String SVG_DOCTYPE_NAME = "svg";
    private static final String SVG_DOCTYPE_PUBLIC_ID = "-//W3C//DTD SVG 1.1//EN";
    private static final String SVG_DOCTYPE_SYSTEM_ID = "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd";
    private static final String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    private static final String XLINK_NAMESPACE = "xlink";
    private static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    public static int ScreenDPI = 72;
    public static int PrintDPI = 300;
    public static int TrueScreenDPI = Toolkit.getDefaultToolkit().getScreenResolution();
    private final double DPI;
    private final double PX_PER_MM;
    private static final String CHARSET_UTF8 = "UTF-8";
    private final Map<Integer, Element> clippingPathElements = new HashMap<Integer, Element>();
    private final Stack<GraphicsStyle> graphicsStyles = new Stack();
    private final Map<Element, GraphicsStyle> groupStyles = new HashMap<Element, GraphicsStyle>();
    private final PageSize pageSize;
    private final Document doc;
    private Element root;
    private Element group;
    private Element defs;
    private GraphicsStyle currentStyle;
    private GraphicsStyle groupStyle;
    private static final Map<Integer, String> STROKE_ENDCAPS = ObjTools.toMap(new Integer[]{0, 1, 2}, new String[]{"butt", "round", "square"});
    private static final Map<Integer, String> STROKE_LINEJOIN = ObjTools.toMap(new Integer[]{0, 1, 2}, new String[]{"miter", "round", "bevel"});
    private static final DecimalFormat _fmtSimpleDouble = new DecimalFormat("#.######");

    public SvgGraphicsExporter(PageSize pageSize, double d) {
        DocumentBuilder documentBuilder;
        this.pageSize = pageSize;
        this.DPI = d;
        this.PX_PER_MM = this.DPI / 25.4;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException("Could not create an XML builder.");
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(SVG_DOCTYPE_NAME, SVG_DOCTYPE_PUBLIC_ID, SVG_DOCTYPE_SYSTEM_ID);
        this.doc = dOMImplementation.createDocument(SVG_NAMESPACE_URI, SVG_DOCTYPE_NAME, documentType);
        try {
            this.doc.setXmlStandalone(false);
        }
        catch (AbstractMethodError abstractMethodError) {
            System.err.println("Standalone XML documents not supported.");
        }
        this.root = this.doc.getDocumentElement();
        this.initDocRoot();
        this.group = this.root;
        this.currentStyle = new GraphicsStyle();
        this.graphicsStyles.push(this.currentStyle);
        this.groupStyle = this.currentStyle.clone();
        this.groupStyles.put(this.group, this.groupStyle);
    }

    private void initDocRoot() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.pageSize.width;
        double d4 = this.pageSize.height;
        this.root.setAttribute("xmlns:xlink", XLINK_NAMESPACE_URI);
        this.root.setAttribute("version", "1.1");
        this.root.setAttribute("x", SvgGraphicsExporter.fmtNumber(d / this.PX_PER_MM) + "mm");
        this.root.setAttribute("y", SvgGraphicsExporter.fmtNumber(d2 / this.PX_PER_MM) + "mm");
        this.root.setAttribute("width", SvgGraphicsExporter.fmtNumber(d3 / this.PX_PER_MM) + "mm");
        this.root.setAttribute("height", SvgGraphicsExporter.fmtNumber(d4 / this.PX_PER_MM) + "mm");
        this.root.setAttribute("viewBox", SvgGraphicsExporter.join(" ", d, d2, d3, d4));
    }

    public void write(List<GraphicsOp> list, String string) throws IOException {
        try (Writer writer = SvgGraphicsExporter.newUTF8Writer(string, false);){
            this.write(list, writer);
        }
    }

    public void write(List<GraphicsOp> list, Writer writer) throws IOException {
        for (GraphicsOp graphicsOp : list) {
            this.applyOperation(graphicsOp);
        }
        this.writeTo(new StreamResult(writer));
    }

    private static Writer newUTF8Writer(String string, boolean bl) throws IOException {
        OpenOption[] openOptionArray;
        if (bl) {
            OpenOption[] openOptionArray2 = new OpenOption[1];
            openOptionArray = openOptionArray2;
            openOptionArray2[0] = StandardOpenOption.APPEND;
        } else {
            openOptionArray = new OpenOption[]{};
        }
        OpenOption[] openOptionArray3 = openOptionArray;
        return Files.newBufferedWriter(Paths.get(string, new String[0]), StandardCharsets.UTF_8, openOptionArray3);
    }

    private static String fmtNumber(double d) {
        return _fmtSimpleDouble.format(d);
    }

    private static String fmtObj(Object object) {
        if (object instanceof Number) {
            return _fmtSimpleDouble.format(((Number)object).doubleValue());
        }
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public void writeTo(StreamResult streamResult) throws IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "no");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("encoding", CHARSET_UTF8);
            transformer.setOutputProperty("doctype-public", this.doc.getDoctype().getPublicId());
            transformer.setOutputProperty("doctype-system", this.doc.getDoctype().getSystemId());
            transformer.transform(new DOMSource(this.doc), streamResult);
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.getMessage());
        }
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeTo(new StreamResult(byteArrayOutputStream));
            return byteArrayOutputStream.toString(CHARSET_UTF8);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private Element getClipElement(Shape shape) {
        Element element = this.clippingPathElements.get(shape.hashCode());
        if (element != null) {
            return element;
        }
        if (this.defs == null) {
            this.defs = this.doc.createElement("defs");
            this.root.insertBefore(this.defs, this.root.getFirstChild());
        }
        element = this.doc.createElement("clipPath");
        element.setAttribute("id", "clip" + shape.hashCode());
        Element element2 = this.getElement(shape);
        element2.removeAttribute("style");
        element.appendChild(element2);
        this.defs.appendChild(element);
        this.clippingPathElements.put(shape.hashCode(), element);
        return element;
    }

    private void newGroup() {
        Element element = this.group;
        this.group = this.doc.createElement("g");
        element.appendChild(this.group);
        this.initGroup(this.group);
    }

    private void initGroup(Element element) {
        Object object;
        Object object2;
        GraphicsStyle graphicsStyle = this.groupStyles.get((Element)element.getParentNode());
        Shape shape = this.currentStyle.getClip();
        if (shape != null && !Objects.equals(graphicsStyle.getClip(), shape)) {
            object2 = this.getClipElement(shape);
            object = "url(#" + object2.getAttribute("id") + ")";
            this.group.setAttribute("clip-path", (String)object);
        }
        object2 = this.currentStyle.getTransform();
        if (!Objects.equals(graphicsStyle.getTransform(), object2)) {
            this.group.setAttribute("transform", SvgGraphicsExporter.fmtTransform((AffineTransform)object2));
        }
        object = this.currentStyle.getFont();
        if (!Objects.equals(graphicsStyle.getFont(), object)) {
            this.group.setAttribute("style", this.getFontStyle((Font)object));
        }
        this.groupStyle = this.currentStyle.clone();
        this.groupStyles.put(element, this.groupStyle);
    }

    private void addToGroup(Element element) {
        this.group.appendChild(element);
    }

    private void exitGroup() {
        if (this.group == this.root) {
            throw new IllegalStateException("Cannot exit root group.");
        }
        this.group = (Element)this.group.getParentNode();
        this.groupStyle = this.groupStyles.get(this.group);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyOperation(GraphicsOp graphicsOp) {
        if (graphicsOp instanceof GraphicsOp.InitOp || graphicsOp instanceof GraphicsOp.EndOp) return;
        if (graphicsOp instanceof GraphicsOp.GroupStartOp) {
            this.newGroup();
            return;
        } else if (graphicsOp instanceof GraphicsOp.GroupEndOp) {
            this.exitGroup();
            return;
        } else if (graphicsOp instanceof GraphicsOp.ActionOp) {
            if (this.group == this.root) {
                this.newGroup();
            }
            if (graphicsOp instanceof GraphicsOp.DrawImageOp) {
                GraphicsOp.DrawImageOp drawImageOp = (GraphicsOp.DrawImageOp)graphicsOp;
                Element element = this.getElement(drawImageOp.getImage(), drawImageOp.getX(), drawImageOp.getY(), drawImageOp.getWidth(), drawImageOp.getHeight());
                this.addToGroup(element);
                return;
            } else if (graphicsOp instanceof GraphicsOp.DrawShapeOp) {
                GraphicsOp.DrawShapeOp drawShapeOp = (GraphicsOp.DrawShapeOp)graphicsOp;
                Element element = this.getElement(drawShapeOp.getShape());
                element.setAttribute("style", this.getDrawStyle(drawShapeOp.isFill()));
                this.addToGroup(element);
                return;
            } else if (graphicsOp instanceof GraphicsOp.ClearOp) {
                GraphicsOp.ClearOp clearOp = (GraphicsOp.ClearOp)graphicsOp;
                Element element = this.getElement(clearOp.getRect());
                GraphicsStyle graphicsStyle = this.pushState();
                graphicsStyle.setStroke(null);
                graphicsStyle.setColor(graphicsStyle.getBackground());
                graphicsStyle.setComposite(AlphaComposite.Src);
                element.setAttribute("style", this.getDrawStyle(true));
                this.popState();
                this.addToGroup(element);
                return;
            } else {
                if (!(graphicsOp instanceof GraphicsOp.DrawStringOp)) throw new IllegalArgumentException("Unknown Graphics Operation: " + graphicsOp.getClass().getSimpleName());
                GraphicsOp.DrawStringOp drawStringOp = (GraphicsOp.DrawStringOp)graphicsOp;
                Element element = this.getElement(drawStringOp.getText(), drawStringOp.getX(), drawStringOp.getY());
                element.setAttribute("style", this.getDrawStyle(true) + this.getFontStyle(this.currentStyle.getFont()));
                this.addToGroup(element);
            }
            return;
        } else {
            if (!(graphicsOp instanceof GraphicsOp.StateOp)) throw new IllegalArgumentException("Unknown Graphics Operation: " + graphicsOp.getClass().getSimpleName());
            graphicsOp.apply(this.currentStyle);
        }
    }

    private GraphicsStyle pushState() {
        this.currentStyle = this.currentStyle.clone();
        return this.graphicsStyles.push(this.currentStyle);
    }

    private GraphicsStyle popState() {
        GraphicsStyle graphicsStyle = this.graphicsStyles.pop();
        this.currentStyle = this.graphicsStyles.peek();
        return graphicsStyle;
    }

    private String getDrawStyle(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Color color = this.currentStyle.getColor();
        String string = SvgGraphicsExporter.getOutput(color);
        double d = (double)color.getAlpha() / 255.0;
        if (bl) {
            SvgGraphicsExporter.appendStyle(stringBuilder, "fill", string);
            if (color.getAlpha() < 255) {
                SvgGraphicsExporter.appendStyle(stringBuilder, "fill-opacity", d);
            }
        } else {
            SvgGraphicsExporter.appendStyle(stringBuilder, "fill", "none");
        }
        if (!bl) {
            Stroke stroke;
            SvgGraphicsExporter.appendStyle(stringBuilder, "stroke", string);
            if (color.getAlpha() < 255) {
                SvgGraphicsExporter.appendStyle(stringBuilder, "stroke-opacity", d);
            }
            if ((stroke = this.currentStyle.getStroke()) instanceof BasicStroke) {
                BasicStroke basicStroke = (BasicStroke)stroke;
                if (basicStroke.getLineWidth() != 1.0f) {
                    SvgGraphicsExporter.appendStyle(stringBuilder, "stroke-width", Float.valueOf(basicStroke.getLineWidth()));
                }
                if (basicStroke.getMiterLimit() != 4.0f) {
                    SvgGraphicsExporter.appendStyle(stringBuilder, "stroke-miterlimit", Float.valueOf(basicStroke.getMiterLimit()));
                }
                if (basicStroke.getEndCap() != 0) {
                    SvgGraphicsExporter.appendStyle(stringBuilder, "stroke-linecap", STROKE_ENDCAPS.get(basicStroke.getEndCap()));
                }
                if (basicStroke.getLineJoin() != 0) {
                    SvgGraphicsExporter.appendStyle(stringBuilder, "stroke-linejoin", STROKE_LINEJOIN.get(basicStroke.getLineJoin()));
                }
                if (basicStroke.getDashArray() != null) {
                    SvgGraphicsExporter.appendStyle(stringBuilder, "stroke-dasharray", SvgGraphicsExporter.join(",", basicStroke.getDashArray()));
                    if (basicStroke.getDashPhase() != 0.0f) {
                        SvgGraphicsExporter.appendStyle(stringBuilder, "stroke-dashoffset", Float.valueOf(basicStroke.getDashPhase()));
                    }
                }
            }
        } else {
            SvgGraphicsExporter.appendStyle(stringBuilder, "stroke", "none");
        }
        return stringBuilder.toString();
    }

    private String getFontStyle(Font font) {
        if (Objects.equals(this.groupStyle.getFont(), font)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = FontUtil.getPhysicalFont(font).getFamily();
        stringBuilder.append("font-family:\"").append(string).append("\";");
        stringBuilder.append("font-size:").append(SvgGraphicsExporter.fmtNumber(font.getSize2D())).append("px;");
        if ((font.getStyle() & 2) != 0) {
            stringBuilder.append("font-style:italic;");
        }
        if ((font.getStyle() & 1) != 0) {
            stringBuilder.append("font-weight:bold;");
        }
        return stringBuilder.toString();
    }

    private static void appendStyle(StringBuilder stringBuilder, String string, Object object) {
        stringBuilder.append(string).append(":").append(SvgGraphicsExporter.fmtObj(object)).append(";");
    }

    private static String fmtTransform(AffineTransform affineTransform) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = affineTransform.getType();
        if (n == 0) {
            return "";
        }
        if (n == 32 || 0 != (n & 0x18)) {
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            stringBuilder.append("matrix(").append(SvgGraphicsExporter.join(" ", dArray)).append(")");
            return stringBuilder.toString();
        }
        if ((n & 1) != 0) {
            stringBuilder.append("translate(").append(SvgGraphicsExporter.fmtNumber(affineTransform.getTranslateX())).append(" ").append(SvgGraphicsExporter.fmtNumber(affineTransform.getTranslateY())).append(") ");
        }
        if ((n & 6) != 0) {
            stringBuilder.append("scale(").append(SvgGraphicsExporter.fmtNumber(affineTransform.getScaleX())).append(" ").append(SvgGraphicsExporter.fmtNumber(affineTransform.getScaleY())).append(") ");
        }
        return stringBuilder.toString();
    }

    private static String join(String string, double ... dArray) {
        return Strings.join(string, ObjTools.toList(dArray), SvgGraphicsExporter::fmtNumber);
    }

    private static String join(String string, float ... fArray) {
        return Strings.join(string, ObjTools.toList(fArray), SvgGraphicsExporter::fmtNumber);
    }

    private static String getOutput(Color color) {
        if (color.getColorSpace().getType() == 9) {
            float[] fArray = color.getComponents(null);
            return String.format((Locale)null, "rgb(%d,%d,%d) icc-color(Generic-CMYK-profile,%f,%f,%f,%f)", color.getRed(), color.getGreen(), color.getBlue(), Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]));
        }
        return String.format((Locale)null, "rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static String getOutput(Shape shape) {
        StringBuilder stringBuilder = new StringBuilder();
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        int n = 0;
        while (!pathIterator.isDone()) {
            if (n > 0) {
                stringBuilder.append(" ");
            }
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    stringBuilder.append("M").append(dArray[0]).append(",").append(dArray[1]);
                    break;
                }
                case 1: {
                    stringBuilder.append("L").append(dArray[0]).append(",").append(dArray[1]);
                    break;
                }
                case 3: {
                    stringBuilder.append("C").append(dArray[0]).append(",").append(dArray[1]).append(" ").append(dArray[2]).append(",").append(dArray[3]).append(" ").append(dArray[4]).append(",").append(dArray[5]);
                    break;
                }
                case 2: {
                    stringBuilder.append("Q").append(dArray[0]).append(",").append(dArray[1]).append(" ").append(dArray[2]).append(",").append(dArray[3]);
                    break;
                }
                case 4: {
                    stringBuilder.append("Z");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++n;
            pathIterator.next();
        }
        return stringBuilder.toString();
    }

    private static String getImageOutput(Image image, boolean bl) {
        String string;
        BufferedImage bufferedImage = ImageUtil.toBufferedImage(image);
        String string2 = SvgGraphicsExporter.encodeImage(bufferedImage, "png");
        if (!ImageUtil.usesAlpha(bufferedImage) && bl && (string = SvgGraphicsExporter.encodeImage(bufferedImage, "jpeg")).length() > 0 && string.length() < string2.length()) {
            string2 = string;
        }
        return string2;
    }

    private static String encodeImage(BufferedImage bufferedImage, String string) {
        throw new RuntimeException("Not implemented.");
    }

    private Element getElement(Shape shape) {
        Element element;
        if (shape instanceof Line2D) {
            Line2D line2D = (Line2D)shape;
            element = this.doc.createElement("line");
            element.setAttribute("x1", SvgGraphicsExporter.fmtNumber(line2D.getX1()));
            element.setAttribute("y1", SvgGraphicsExporter.fmtNumber(line2D.getY1()));
            element.setAttribute("x2", SvgGraphicsExporter.fmtNumber(line2D.getX2()));
            element.setAttribute("y2", SvgGraphicsExporter.fmtNumber(line2D.getY2()));
        } else if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            element = this.doc.createElement("rect");
            element.setAttribute("x", SvgGraphicsExporter.fmtNumber(rectangle2D.getX()));
            element.setAttribute("y", SvgGraphicsExporter.fmtNumber(rectangle2D.getY()));
            element.setAttribute("width", SvgGraphicsExporter.fmtNumber(rectangle2D.getWidth()));
            element.setAttribute("height", SvgGraphicsExporter.fmtNumber(rectangle2D.getHeight()));
        } else if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
            element = this.doc.createElement("rect");
            element.setAttribute("x", SvgGraphicsExporter.fmtNumber(roundRectangle2D.getX()));
            element.setAttribute("y", SvgGraphicsExporter.fmtNumber(roundRectangle2D.getY()));
            element.setAttribute("width", SvgGraphicsExporter.fmtNumber(roundRectangle2D.getWidth()));
            element.setAttribute("height", SvgGraphicsExporter.fmtNumber(roundRectangle2D.getHeight()));
            element.setAttribute("rx", SvgGraphicsExporter.fmtNumber(roundRectangle2D.getArcWidth() / 2.0));
            element.setAttribute("ry", SvgGraphicsExporter.fmtNumber(roundRectangle2D.getArcHeight() / 2.0));
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            element = this.doc.createElement("ellipse");
            element.setAttribute("cx", SvgGraphicsExporter.fmtNumber(ellipse2D.getCenterX()));
            element.setAttribute("cy", SvgGraphicsExporter.fmtNumber(ellipse2D.getCenterY()));
            element.setAttribute("rx", SvgGraphicsExporter.fmtNumber(ellipse2D.getWidth() / 2.0));
            element.setAttribute("ry", SvgGraphicsExporter.fmtNumber(ellipse2D.getHeight() / 2.0));
        } else {
            element = this.doc.createElement("path");
            element.setAttribute("d", SvgGraphicsExporter.getOutput(shape));
        }
        return element;
    }

    private Element getElement(String string, double d, double d2) {
        Element element = this.doc.createElement("text");
        element.appendChild(this.doc.createTextNode(string));
        element.setAttribute("x", SvgGraphicsExporter.fmtNumber(d));
        element.setAttribute("y", SvgGraphicsExporter.fmtNumber(d2));
        return element;
    }

    private Element getElement(Image image, double d, double d2, double d3, double d4) {
        Element element = this.doc.createElement("image");
        element.setAttribute("x", SvgGraphicsExporter.fmtNumber(d));
        element.setAttribute("y", SvgGraphicsExporter.fmtNumber(d2));
        element.setAttribute("width", SvgGraphicsExporter.fmtNumber(d3));
        element.setAttribute("height", SvgGraphicsExporter.fmtNumber(d4));
        element.setAttribute("preserveAspectRatio", "none");
        element.setAttribute("xlink:href", SvgGraphicsExporter.getImageOutput(image, true));
        return element;
    }
}

