/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing.export;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import ur_rna.StructureEditor.services.drawing.export.GraphicsStyle;
import ur_rna.Utilities.geom.ShapeUtil;

public interface GraphicsOp {
    public void replay(Graphics2D var1);

    public void apply(GraphicsStyle var1);

    public static class StrokeOp
    extends StateOp {
        Stroke stroke;

        public StrokeOp(Stroke stroke) {
            this.stroke = stroke;
        }

        public Stroke getStroke() {
            return this.stroke;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.setStroke(this.stroke);
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            graphicsStyle.setStroke(this.stroke);
        }
    }

    public static class ClipOp
    extends StateOp {
        private Shape clip;
        private boolean append;

        public ClipOp(Shape shape, boolean bl) {
            this.clip = shape;
            this.append = bl;
        }

        public Shape getClip() {
            return this.clip;
        }

        public boolean isAppend() {
            return this.append;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            if (this.append) {
                graphics2D.clip(this.clip);
            } else {
                graphics2D.setClip(this.clip);
            }
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            Shape shape = this.clip == null ? null : graphicsStyle.transformShape(this.clip);
            Shape shape2 = graphicsStyle.getClip();
            if (this.append && this.clip != null && shape2 != null) {
                shape = ShapeUtil.intersection(shape2, shape);
            }
            graphicsStyle.setClip(shape);
        }
    }

    public static class CompositeOp
    extends StateOp {
        private Composite composite;

        public CompositeOp(Composite composite) {
            this.composite = composite;
        }

        public Composite getComposite() {
            return this.composite;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.setComposite(this.composite);
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            graphicsStyle.setComposite(this.composite);
        }
    }

    public static class TransformOp
    extends StateOp {
        private AffineTransform tr;
        private boolean append;

        public TransformOp(AffineTransform affineTransform, boolean bl) {
            this.tr = affineTransform;
            this.append = bl;
        }

        public AffineTransform getTransform() {
            return this.tr;
        }

        public boolean isAppend() {
            return this.append;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            if (this.append) {
                graphics2D.transform(this.tr);
            } else {
                graphics2D.setTransform(this.tr);
            }
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            if (this.append) {
                graphicsStyle.getTransform().concatenate(this.tr);
            } else {
                graphicsStyle.setTransform(this.tr);
            }
        }
    }

    public static class PaintOp
    extends StateOp {
        private Paint paint;

        public PaintOp(Paint paint) {
            this.paint = paint;
        }

        public Paint getPaint() {
            return this.paint;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.setPaint(this.paint);
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            graphicsStyle.setPaint(this.paint);
        }
    }

    public static class ClearHintsOp
    extends StateOp {
        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.setRenderingHints(Collections.emptyMap());
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            graphicsStyle.getHints().clear();
        }
    }

    public static class HintOp
    extends StateOp {
        private RenderingHints.Key key;
        private Object value;

        public HintOp(RenderingHints.Key key, Object object) {
            this.key = key;
            this.value = object;
        }

        public RenderingHints.Key getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(this.key, this.value);
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            graphicsStyle.getHints().put(this.key, this.value);
        }
    }

    public static class XorModeOp
    extends StateOp {
        private Color color;

        public XorModeOp(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.setXORMode(this.color);
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            graphicsStyle.setXorMode(this.color);
        }
    }

    public static class ColorOp
    extends StateOp {
        private Color color;

        public ColorOp(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.setColor(this.color);
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            graphicsStyle.setColor(this.color);
        }
    }

    public static class FontOp
    extends StateOp {
        private Font font;

        public FontOp(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.setFont(this.font);
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            graphicsStyle.setFont(this.font);
        }
    }

    public static class BackgroundOp
    extends StateOp {
        private Color color;

        public BackgroundOp(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.setBackground(this.color);
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
            graphicsStyle.setBackground(this.color);
        }
    }

    public static class ClearOp
    extends ActionOp {
        private Rectangle rc;

        public ClearOp(Rectangle rectangle) {
            this.rc = rectangle;
        }

        public Rectangle getRect() {
            return this.rc;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.clearRect(this.rc.x, this.rc.y, this.rc.width, this.rc.height);
        }
    }

    public static class DrawImageOp
    extends ActionOp {
        private Image img;
        private int width;
        private int height;
        private int originalWidth;
        private int originalHeight;
        private int x;
        private int y;

        public Image getImage() {
            return this.img;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getOriginalWidth() {
            return this.originalWidth;
        }

        public int getOriginalHeight() {
            return this.originalHeight;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public DrawImageOp(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
            this.img = image;
            this.originalWidth = n;
            this.originalHeight = n2;
            this.x = n3;
            this.y = n4;
            this.width = n5;
            this.height = n6;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.drawImage(this.img, this.x, this.y, this.width, this.height, null);
        }
    }

    public static class DrawStringOp
    extends ActionOp {
        public String text;
        public float x;
        public float y;

        public String getText() {
            return this.text;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public DrawStringOp(String string, float f, float f2) {
            this.text = string;
            this.x = f;
            this.y = f2;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            graphics2D.drawString(this.text, this.x, this.y);
        }
    }

    public static class DrawShapeOp
    extends ActionOp {
        private Shape shape;
        private boolean fill;

        public Shape getShape() {
            return this.shape;
        }

        public boolean isFill() {
            return this.fill;
        }

        public DrawShapeOp(Shape shape, boolean bl) {
            this.shape = shape;
            this.fill = bl;
        }

        @Override
        public void replay(Graphics2D graphics2D) {
            if (this.fill) {
                graphics2D.fill(this.shape);
            } else {
                graphics2D.draw(this.shape);
            }
        }
    }

    public static class GroupEndOp
    extends ControlOp {
    }

    public static class GroupStartOp
    extends ControlOp {
    }

    public static class EndOp
    extends ControlOp {
    }

    public static class InitOp
    extends ControlOp {
    }

    public static abstract class ControlOp
    implements GraphicsOp {
        @Override
        public void replay(Graphics2D graphics2D) {
        }

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
        }
    }

    public static abstract class StateOp
    implements GraphicsOp {
    }

    public static abstract class ActionOp
    implements GraphicsOp {
        @Override
        public abstract void replay(Graphics2D var1);

        @Override
        public void apply(GraphicsStyle graphicsStyle) {
        }
    }
}

