/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing.export;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ur_rna.StructureEditor.services.drawing.export.GraphicsOp;
import ur_rna.StructureEditor.services.drawing.export.GraphicsStyle;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.geom.ShapeUtil;
import ur_rna.Utilities.swing.ImageUtil;

public class Graphics2DRecorder
extends Graphics2D
implements Cloneable {
    private final List<GraphicsOp> ops = new ArrayList<GraphicsOp>();
    private final GraphicsConfiguration deviceConfig;
    private final FontRenderContext fontRenderContext;
    private boolean disposed;
    private GraphicsStyle ctx;
    private int suspendRecordingCounter;

    public Graphics2DRecorder() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment.isHeadlessInstance()) {
            this.deviceConfig = null;
        } else {
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            this.deviceConfig = graphicsDevice.getDefaultConfiguration();
        }
        this.fontRenderContext = new FontRenderContext(null, true, true);
        this.ctx = new GraphicsStyle();
        this.add(new GraphicsOp.InitOp());
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Graphics2DRecorder graphics2DRecorder = (Graphics2DRecorder)super.clone();
            graphics2DRecorder.ctx = this.ctx.clone();
            return graphics2DRecorder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        if (this.isDisposed()) {
            return;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.setRenderingHint((RenderingHints.Key)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clip(Shape shape) {
        this.add(new GraphicsOp.ClipOp(shape, true));
    }

    @Override
    public void draw(Shape shape) {
        this.draw(shape, true);
    }

    public void draw(Shape shape, boolean bl) {
        if (this.isDisposed() || shape == null) {
            return;
        }
        if (bl) {
            shape = ShapeUtil.clone(shape);
        }
        this.add(new GraphicsOp.DrawShapeOp(shape, false));
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.draw(glyphVector.getOutline(f, f2), false);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        BufferedImage bufferedImage = this.getTransformedImage(image, affineTransform);
        return this.drawImage(bufferedImage, bufferedImage.getMinX(), bufferedImage.getMinY(), bufferedImage.getWidth(), bufferedImage.getHeight(), null, null);
    }

    private BufferedImage getTransformedImage(Image image, AffineTransform affineTransform) {
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, this.ctx.getHints());
        BufferedImage bufferedImage = ImageUtil.toBufferedImage(image);
        return affineTransformOp.filter(bufferedImage, null);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        this.drawImage(bufferedImage, n, n2, bufferedImage.getWidth(), bufferedImage.getHeight(), null, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.drawImage(ImageUtil.toBufferedImage(renderedImage), affineTransform, null);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        if (this.isDisposed() || string == null || string.trim().length() == 0) {
            return;
        }
        this.add(new GraphicsOp.DrawStringOp(string, f, f2));
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuilder.append(c);
            c = attributedCharacterIterator.next();
        }
        this.drawString(stringBuilder.toString(), f, f2);
    }

    @Override
    public void fill(Shape shape) {
        this.fill(shape, true);
    }

    public void fill(Shape shape, boolean bl) {
        if (this.isDisposed() || shape == null) {
            return;
        }
        if (bl) {
            shape = ShapeUtil.clone(shape);
        }
        this.add(new GraphicsOp.DrawShapeOp(shape, true));
    }

    @Override
    public Color getBackground() {
        return this.ctx.getBackground();
    }

    @Override
    public Composite getComposite() {
        return this.ctx.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.deviceConfig;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public Paint getPaint() {
        return this.ctx.getPaint();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.ctx.getHints().get(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.ctx.getHints();
    }

    @Override
    public Stroke getStroke() {
        return this.ctx.getStroke();
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        Shape shape2 = shape;
        if (bl) {
            shape2 = this.getStroke().createStrokedShape(shape2);
        }
        shape2 = this.ctx.transformShape(shape2);
        return shape2.intersects(rectangle);
    }

    @Override
    public void setBackground(Color color) {
        if (this.isDisposed() || color == null || this.getColor().equals(color)) {
            return;
        }
        this.add(new GraphicsOp.BackgroundOp(color));
    }

    @Override
    public void setComposite(Composite composite) {
        if (this.isDisposed()) {
            return;
        }
        if (composite == null) {
            throw new IllegalArgumentException("Cannot set a null composite.");
        }
        this.add(new GraphicsOp.CompositeOp(composite));
    }

    @Override
    public void setPaint(Paint paint) {
        if (this.isDisposed() || paint == null) {
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        if (this.getPaint().equals(paint)) {
            return;
        }
        this.add(new GraphicsOp.PaintOp(paint));
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.isDisposed()) {
            return;
        }
        this.add(new GraphicsOp.HintOp(key, object));
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        if (this.isDisposed()) {
            return;
        }
        this.add(new GraphicsOp.ClearHintsOp());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.setRenderingHint((RenderingHints.Key)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Cannot set a null stroke.");
        }
        if (this.isDisposed()) {
            return;
        }
        this.add(new GraphicsOp.StrokeOp(stroke));
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.ctx.getTransform());
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        if (this.isDisposed() || affineTransform == null || this.ctx.getTransform().equals(affineTransform)) {
            return;
        }
        this.add(new GraphicsOp.TransformOp(affineTransform, false));
    }

    @Override
    public void shear(double d, double d2) {
        if (d != 1.0 || d2 != 1.0) {
            this.transform(AffineTransform.getShearInstance(d, d2));
        }
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            this.add(new GraphicsOp.TransformOp(affineTransform, true));
        }
    }

    @Override
    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    @Override
    public void translate(double d, double d2) {
        if (d != 0.0 || d2 != 0.0) {
            this.transform(AffineTransform.getTranslateInstance(d, d2));
        }
    }

    @Override
    public void rotate(double d) {
        this.rotate(d, 0.0, 0.0);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        if (d != 0.0) {
            this.transform(AffineTransform.getRotateInstance(d, d2, d3));
        }
    }

    @Override
    public void scale(double d, double d2) {
        if (d != 1.0 || d2 != 1.0) {
            this.transform(AffineTransform.getScaleInstance(d, d2));
        }
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.add(new GraphicsOp.ClearOp(new Rectangle(n, n2, n3, n4)));
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        throw this.notImpl();
    }

    @Override
    public Graphics create() {
        if (this.isDisposed()) {
            return null;
        }
        try {
            return (Graphics2DRecorder)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.add(new GraphicsOp.EndOp());
        this.disposed = true;
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0), false);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (this.isDisposed() || image == null) {
            return true;
        }
        int n5 = image.getWidth(imageObserver);
        int n6 = image.getHeight(imageObserver);
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (color != null) {
            Color color2 = this.getColor();
            this.setColor(color);
            this.fill(rectangle, false);
            this.setColor(color2);
        }
        this.add(new GraphicsOp.DrawImageOp(image, n5, n6, n, n2, n3, n4));
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n9 = Math.min(n5, n7);
        int n10 = Math.min(n6, n8);
        int n11 = Math.min(n, n3);
        int n12 = Math.min(n2, n4);
        int n13 = Math.abs(n3 - n);
        int n14 = Math.abs(n4 - n2);
        BufferedImage bufferedImage = ImageUtil.toBufferedImage(image).getSubimage(n9, n10, Math.abs(n7 - n5), Math.abs(n8 - n6));
        return this.drawImage(bufferedImage, n11, n12, n13, n14, color, imageObserver);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.draw(new Line2D.Double(n, n2, n3, n4), false);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Ellipse2D.Double(n, n2, n3, n4), false);
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.draw(polygon, true);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n), false);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Path2D.Float float_ = new Path2D.Float();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                ((Path2D)float_).lineTo(nArray[i], nArray2[i]);
                continue;
            }
            ((Path2D)float_).moveTo(nArray[i], nArray2[i]);
        }
        this.draw(float_, false);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.draw(new Rectangle(n, n2, n3, n4), false);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6), false);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, n5, n6, 2), false);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Ellipse2D.Double(n, n2, n3, n4), false);
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.fill(polygon, true);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fill(new Polygon(nArray, nArray2, n), false);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle(n, n2, n3, n4), false);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6), false);
    }

    @Override
    public Shape getClip() {
        return this.ctx.untransformShape(this.ctx.getClip());
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.getClip() == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    @Override
    public Color getColor() {
        return this.ctx.getColor();
    }

    @Override
    public Font getFont() {
        return this.ctx.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 3);
        Graphics graphics = bufferedImage.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        graphics.dispose();
        return fontMetrics;
    }

    @Override
    public void setClip(Shape shape) {
        if (this.isDisposed()) {
            return;
        }
        this.add(new GraphicsOp.ClipOp(shape, false));
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void setColor(Color color) {
        if (this.isDisposed() || color == null || this.getColor().equals(color)) {
            return;
        }
        this.add(new GraphicsOp.ColorOp(color));
    }

    @Override
    public void setFont(Font font) {
        if (this.isDisposed() || font != null && this.getFont().equals(font)) {
            return;
        }
        this.add(new GraphicsOp.FontOp(font));
        this.ctx.setFont(font);
    }

    @Override
    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    @NotNull
    public Color getXORMode() {
        return this.ctx.getXorMode();
    }

    @Override
    public void setXORMode(Color color) {
        if (this.isDisposed() || color == null) {
            return;
        }
        this.add(new GraphicsOp.XorModeOp(color));
    }

    private void add(GraphicsOp graphicsOp) {
        graphicsOp.apply(this.ctx);
        if (this.suspendRecordingCounter == 0) {
            this.ops.add(graphicsOp);
        }
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    private RuntimeException notImpl() {
        return new UnsupportedOperationException("Graphics operation not yet implemented.");
    }

    public List<GraphicsOp> getGraphicsOps() {
        return this.ops;
    }

    public void replay(Graphics2D graphics2D) {
        for (GraphicsOp graphicsOp : this.ops) {
            graphicsOp.replay(graphics2D);
        }
    }

    public void suspendRecording() {
        ++this.suspendRecordingCounter;
    }

    public void resumeRecording() {
        if (this.suspendRecordingCounter == 0) {
            throw new IllegalStateException("Cannot resume. Already recording. This probably means you have unbalanced calls to suspendRecording and resumeRecording.");
        }
        --this.suspendRecordingCounter;
    }

    public GraphicsStyle getContext() {
        return this.ctx;
    }

    public void startGroup() {
        this.add(new GraphicsOp.GroupStartOp());
    }

    public void endGroup() {
        this.add(new GraphicsOp.GroupEndOp());
    }
}

