/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.SceneUpdateInfo;
import ur_rna.StructureEditor.services.SceneController;
import ur_rna.StructureEditor.services.drawing.DrawHandle;
import ur_rna.Utilities.geom.Rectangles;

public class SelectionRotater
extends DrawHandle {
    private CenterPoint center;

    public SelectionRotater(SceneController sceneController) {
        super(sceneController);
        this.center = new CenterPoint(sceneController, this);
        this.setIcon(Program.getImage("rotate-handle"));
    }

    @Override
    public void setSelection(Nuc nuc, Collection<Nuc> collection) {
        super.setSelection(nuc, collection);
        this.center.setSelection(nuc, collection);
    }

    @Override
    protected void nucPositionsChanged() {
    }

    @Override
    public void dragComplete(boolean bl) {
        super.dragComplete(bl);
        this.center.saveRelativeLocation();
    }

    @Override
    public boolean isValid() {
        return this.allNucs != null && this.allNucs.size() > 1;
    }

    @Override
    protected void prepareDraw(boolean bl) {
        if (!bl) {
            this.resetLocation();
        }
    }

    @Override
    protected void selectionChanged() {
        this.resetLocation();
    }

    void resetLocation() {
        if (!this.isValid()) {
            return;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float f = this.getBoxSize();
        if (this.view.screenBounds.isEmpty()) {
            float_.setFrame(0.0, 0.0, f, f);
        } else {
            boolean bl = false;
            for (Nuc nuc : this.allNucs) {
                if (bl) {
                    float_.add(nuc.location);
                    continue;
                }
                float_.setFrame(nuc.location.x, nuc.location.y, 0.0, 0.0);
                bl = true;
            }
            Rectangles.grow(float_, this.controller.getSettings().nucleotideRadius(null));
            this.view.toScreen(float_);
            Rectangles.grow(float_, f);
            Rectangle rectangle = new Rectangle(this.view.screenBounds);
            rectangle.grow(-this.view.screenMargin.width, -this.view.screenMargin.height);
            Rectangle2D.intersect(float_, rectangle, float_);
        }
        this.location.setLocation(float_.x + float_.width - f / 2.0f, float_.y + f / 2.0f);
    }

    @Override
    protected void performDrag(Point point, Point point2, Point point3, SceneController.DragOpts dragOpts) {
        this.moveLocation(point, point3);
        this.controller.rotateNucs(this.allNucs, this.center.modelLocation, point, point3, dragOpts);
    }

    @Override
    public SceneUpdateInfo getCompletionEvent() {
        return SceneUpdateInfo.Rotate;
    }

    public CenterPoint getCenterPoint() {
        return this.center;
    }

    public static enum RotationCenter {
        Default,
        CenterOfMass,
        CustomXY,
        CustomNuc,
        BaseOfHelix,
        CenterOfHelix;

    }

    public static class CenterPoint
    extends DrawHandle {
        private final SelectionRotater owner;
        private Point2D.Float modelLocation = new Point2D.Float();
        private Point2D.Float previousCenter = new Point2D.Float();
        private Nuc customNuc;
        private Motif.Helix customHelix;
        private RotationCenter center = RotationCenter.CenterOfMass;
        private int selectionHash;

        public CenterPoint(SceneController sceneController, SelectionRotater selectionRotater) {
            super(sceneController);
            this.owner = selectionRotater;
            this.setIcon(Program.getImage("rotate-center"));
            this.customCursor = Cursor.getPredefinedCursor(1);
        }

        @Override
        protected void performDrag(Point point, Point point2, Point point3, SceneController.DragOpts dragOpts) {
            this.getModelSpaceDeltaTransform(point2, point3).transform(this.modelLocation, this.modelLocation);
            this.controller.controlsUpdated();
        }

        @Override
        public SceneUpdateInfo getCompletionEvent() {
            return null;
        }

        @Override
        protected void prepareDraw(boolean bl) {
            this.view.toScreen(this.modelLocation, this.location);
        }

        @Override
        protected void nucPositionsChanged() {
            if (!this.owner.isUpdating()) {
                Point2D.Float float_ = new Point2D.Float();
                this.calcLocation(float_);
                this.modelLocation.setLocation(this.modelLocation.x + float_.x - this.previousCenter.x, this.modelLocation.y + float_.y - this.previousCenter.y);
                this.previousCenter.setLocation(float_);
            }
        }

        @Override
        protected void selectionChanged() {
            int n = this.selectionHash;
            this.selectionHash = 987;
            for (Nuc nuc : this.allNucs) {
                this.selectionHash = 31 * this.selectionHash + nuc.indexInScene();
            }
            if (n == this.selectionHash) {
                return;
            }
            this.reset();
            this.calcLocation(this.modelLocation);
            this.previousCenter.setLocation(this.modelLocation);
        }

        private void calcLocation(Point2D.Float float_) {
            this.calcLocation(float_, this.center);
        }

        private void calcLocation(Point2D.Float float_, RotationCenter rotationCenter) {
            float f = 0.0f;
            float f2 = 0.0f;
            switch (rotationCenter) {
                case Default: {
                    this.customHelix = this.controller.findBaseHelix(this.allNucs);
                    if (this.customHelix == null) {
                        this.calcLocation(float_, RotationCenter.CenterOfMass);
                    } else {
                        this.calcLocation(float_, RotationCenter.BaseOfHelix);
                    }
                    return;
                }
                case CenterOfMass: {
                    for (Nuc nuc : this.allNucs) {
                        f += nuc.location.x;
                        f2 += nuc.location.y;
                    }
                    f /= (float)this.allNucs.size();
                    f2 /= (float)this.allNucs.size();
                    break;
                }
                case CustomNuc: {
                    f = this.customNuc.location.x;
                    f2 = this.customNuc.location.y;
                    break;
                }
                case CenterOfHelix: {
                    Collection<Nuc> collection = this.customHelix.getBases();
                    for (Nuc nuc : collection) {
                        f += nuc.location.x;
                        f2 += nuc.location.y;
                    }
                    f /= (float)collection.size();
                    f2 /= (float)collection.size();
                    break;
                }
                case BaseOfHelix: {
                    Bond bond = this.customHelix.getPair(0);
                    f = (bond.getNuc5().location.x + bond.getNuc3().location.x) / 2.0f;
                    f2 = (bond.getNuc5().location.y + bond.getNuc3().location.y) / 2.0f;
                }
            }
            float_.setLocation(f, f2);
        }

        private void reset() {
            this.center = RotationCenter.Default;
            this.customNuc = null;
            this.customHelix = null;
        }

        @Override
        public boolean isValid() {
            return this.allNucs != null && this.allNucs.size() > 1;
        }

        public void saveRelativeLocation() {
            this.calcLocation(this.previousCenter);
        }
    }
}

