/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.List;
import ur_rna.StructureEditor.Program;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.DrawSettings;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.SceneUpdateInfo;
import ur_rna.StructureEditor.services.RnaDrawController;
import ur_rna.StructureEditor.services.SceneController;
import ur_rna.StructureEditor.services.drawing.DrawHandle;
import ur_rna.StructureEditor.services.drawing.DrawHint;
import ur_rna.StructureEditor.services.drawing.NucLayout;
import ur_rna.Utilities.annotation.Nullable;
import ur_rna.Utilities.geom.Ellipses;
import ur_rna.Utilities.geom.PointMath;
import ur_rna.Utilities.geom.Vec2D;
import ur_rna.Utilities.swing.ImageUtil;

public class LoopResizer
extends DrawHandle {
    private Motif.Loop loop;
    private Motif.Loop.LoopType type;
    private Vec2D handleOffsetDir = new Vec2D();
    private static double radToDeg = 57.29577951308232;
    private BufferedImage[] directionalIcons = new BufferedImage[8];
    private Motif.MultiLoop multiLoop;
    private BufferedImage resizeSegmentIcon;
    private BufferedImage resizeMultiLoopIcon;
    private Point2D.Float _ptModel = new Point2D.Float();
    private static final SceneUpdateInfo ResizeLoop = SceneUpdateInfo.Loop;

    private BufferedImage getDirectionalIcon(double d) {
        double d2 = Math.PI * 2 / (double)this.directionalIcons.length;
        int n = (int)Math.floor((d + 1.5707963267948966 + d2 / 2.0) / d2);
        if ((n %= 8) < 0) {
            n += 8;
        }
        return this.directionalIcons[n];
    }

    private void createDirectionalIcons(BufferedImage bufferedImage) {
        this.directionalIcons[0] = bufferedImage;
        double d = Math.PI * 2 / (double)this.directionalIcons.length;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        for (int i = 1; i < this.directionalIcons.length; ++i) {
            affineTransform.setToRotation((double)i * d, (double)n / 2.0, (double)n2 / 2.0);
            BufferedImage bufferedImage2 = ImageUtil.createCompatibleImage(n, n2, true);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, affineTransform, null);
            graphics2D.dispose();
            this.directionalIcons[i] = bufferedImage2;
        }
    }

    public LoopResizer(SceneController sceneController) {
        super(sceneController);
        this.resizeSegmentIcon = Program.getImage("loop-resize-handle");
        this.resizeMultiLoopIcon = Program.getImage("multiloop-resize-handle");
        this.createDirectionalIcons(this.resizeSegmentIcon);
        super.setIcon(this.directionalIcons[0]);
    }

    @Override
    public boolean isValid() {
        return this.loop != null;
    }

    @Override
    protected void nucPositionsChanged() {
        this.calculateOffset();
    }

    @Override
    protected void performDrag(Point point, Point point2, Point point3, SceneController.DragOpts dragOpts) {
        this.moveLocation(point, point3);
        this.getModelSpaceDeltaTransform(point, point3).transform(this.targetNuc.location, this._ptModel);
        this.positionNucs(this._ptModel, dragOpts);
    }

    private void positionNucs(Point2D.Float float_, SceneController.DragOpts dragOpts) {
        Nuc nuc = this.loop.getNuc5();
        Nuc nuc2 = this.loop.getNuc3();
        Nuc nuc3 = nuc.getPrev();
        Nuc nuc4 = nuc2.getNext();
        Nuc nuc5 = nuc3 == null ? nuc : nuc3;
        Nuc nuc6 = nuc4 == null ? nuc2 : nuc4;
        boolean bl = this.controller.programSettings().SnapGuides ^ dragOpts.special;
        Nuc nuc7 = this.targetNuc;
        switch (this.type) {
            case Terminal: {
                if (nuc7 == nuc5) {
                    this.positionTerminalEndPoint(float_, nuc5, nuc6, 1, bl);
                    break;
                }
                if (nuc7 == nuc6) {
                    this.positionTerminalEndPoint(float_, nuc6, nuc5, -1, bl);
                    break;
                }
                this.positionTerminalLoop(float_, nuc5, nuc6, bl);
                break;
            }
            default: {
                if (dragOpts.expandMotif ^ this.controller.programSettings().ExpandMotif && this.multiLoop != null) {
                    LoopResizer.expandMultiLoop(this.controller, this.multiLoop, this.targetNuc.location, float_, null, dragOpts);
                    break;
                }
                this.positionLoopBetweenHelices(float_, nuc5, nuc6, bl);
            }
        }
        this.controller.layoutUpdated(ResizeLoop, false);
    }

    public static void expandMultiLoop(SceneController sceneController, Motif.MultiLoop multiLoop, Point2D.Float float_, Point2D.Float float_2, @Nullable Ellipses.Circle circle, SceneController.DragOpts dragOpts) {
        int n;
        Object object;
        Object object2;
        float f = (float)sceneController.getCanvas().getView().trToScreen.getScaleX();
        float f2 = 20.0f / f;
        Bond bond = multiLoop.getTrunk();
        Point2D point2D = bond.midpoint(null);
        Vec2D vec2D = bond.normal(null);
        if (bond.getScene().drawFlipped) {
            vec2D.negate();
        }
        if (circle == null) {
            object2 = multiLoop.getBonds();
            object = new Point2D[object2.size() + 1];
            for (n = 0; n < ((Point2D[])object).length - 1; ++n) {
                object[n] = ((Bond)object2.get(n)).midpoint(null);
            }
            object[((Point2D[])object).length - 1] = float_;
            circle = Ellipses.Circle.calcLeastSquaresFit(object);
            if (circle == null) {
                sceneController.addHint("Circle calculation failed.", float_2.x, float_2.y + f2).color(Color.RED).fromModel();
                return;
            }
        }
        if ((object = ((Point2D)(object2 = Vec2D.reflect(float_2, vec2D, point2D))).distanceSq(float_2) < 1.0 || point2D.distanceSq(float_2) < 1.0 ? new Ellipses.Circle(Vec2D.getMidpoint(point2D, float_), point2D.distance(float_2) / 2.0) : Ellipses.Circle.calcFromPoints(point2D, float_2, (Point2D)object2)) == null) {
            sceneController.addHint(circle).fromModel().color(Color.RED);
            sceneController.addHint("Circle calculation failed.", float_2.x, float_2.y + f2).color(Color.RED).fromModel();
            return;
        }
        n = 0;
        float f3 = sceneController.getSettings().nucRadius;
        float f4 = sceneController.getSettings().nucRadius * 1000.0f;
        Vec2D vec2D2 = new Vec2D(point2D, float_2);
        if (object.radius() < f3) {
            object.setCircle(vec2D.getPointAlong(point2D, f3), f3);
        } else {
            float f5;
            if (vec2D.angleBetween(vec2D2) > 1.535889744758606) {
                object.setCircle(vec2D.getPointAlong(point2D, f4), f4);
                sceneController.addHint("Loop size out of bounds.", float_2.x, float_2.y + f2).color(Color.RED).fromModel();
                sceneController.addHint((Shape)object).fromModel().color(Color.RED).bold();
                return;
            }
            if (dragOpts.special ^ sceneController.programSettings().SnapGuides && Math.abs((f5 = new NucLayout(sceneController.getSettings()).calcOptimalMultiLoopRadius(multiLoop)) - object.radius()) < 5.0f / f) {
                object.setCircle(vec2D.getPointAlong(point2D, f5), f5);
                n = 1;
            }
        }
        Point2D.Float float_3 = new Point2D.Float();
        AffineTransform affineTransform = new AffineTransform();
        if (!dragOpts.disableHints) {
            sceneController.addHint(circle).fromModel().color(RnaDrawController.Colors.warm).dashed();
            if (n != 0) {
                sceneController.addHint((Shape)object).fromModel().bold();
            } else {
                sceneController.addHint((Shape)object).fromModel();
            }
            sceneController.addHint(new Ellipses.Circle(object.center(), 2.0)).fill(RnaDrawController.Colors.cold).fromModel();
        }
        double d = object.radius() - circle.radius();
        Vec2D vec2D3 = new Vec2D();
        Point2D.Float float_4 = circle.center();
        Point2D.Float float_5 = object.center();
        for (Motif.Loop object3 : multiLoop.getLoops()) {
            for (Nuc nuc : object3.getBases()) {
                LoopResizer.expandPointAboutCenter(vec2D3, nuc.location, float_4, float_5, d);
            }
        }
        for (Bond bond2 : multiLoop.getBonds()) {
            if (bond2 == bond) continue;
            bond2.midpoint(point2D);
            float_3.setLocation(point2D);
            LoopResizer.expandPointAboutCenter(vec2D3, float_3, float_4, float_5, d);
            float_3.x = (float)((double)float_3.x - point2D.getX());
            float_3.y = (float)((double)float_3.y - point2D.getY());
            affineTransform.setToTranslation(float_3.x, float_3.y);
            bond2.n5.getBranch().transformAll(affineTransform);
        }
    }

    private static void expandPointAboutCenter(Vec2D vec2D, Point2D point2D, Point2D point2D2, Point2D point2D3, double d) {
        vec2D.setTo(point2D).subtr(point2D2);
        double d2 = vec2D.length() + d;
        point2D.setLocation(vec2D.getPointAlong(point2D3, d2 < 0.0 ? 0.0 : d2));
    }

    private void positionLoopBetweenHelices(Point2D.Float float_, Nuc nuc, Nuc nuc2, boolean bl) {
        Cloneable cloneable;
        Vec2D vec2D;
        Nuc nuc3;
        Point2D.Float float_2 = nuc.location;
        Point2D.Float float_3 = nuc2.location;
        boolean bl2 = nuc.getPaired() == nuc2;
        Point2D point2D = PointMath.midpoint(float_2, nuc.getPaired().location);
        Point2D point2D2 = PointMath.midpoint(float_3, nuc2.getPaired().location);
        Point2D point2D3 = PointMath.midpoint(float_2, float_3);
        Vec2D vec2D2 = new Vec2D(float_2, float_3).rotate90().normalize();
        Vec2D vec2D3 = new Vec2D(point2D3, float_);
        Vec2D vec2D4 = vec2D3.projectedOn(vec2D2).normalize();
        if (bl2 && (nuc3 = nuc.getPrev()) != null && nuc3.isPaired() && nuc3.getPaired() == nuc2.getNext() && (vec2D = new Vec2D(point2D3, PointMath.midpoint(nuc3.location, nuc3.getPaired().location))).dot(vec2D4) > 0.0) {
            vec2D4.negate();
        }
        int n = this.loop.size();
        boolean bl3 = false;
        float f = (float)this.view.trToScreen.getScaleX();
        DrawSettings drawSettings = this.controller.getSettings();
        float f2 = drawSettings.nucRadius;
        Cloneable cloneable2 = Ellipses.Circle.calcFromPoints(float_2, float_3, float_);
        if (cloneable2 == null || !bl2 && bl && Math.abs(vec2D3.dot(vec2D2)) < (double)(6.0f / f)) {
            this.positionLinear(nuc, nuc2, true);
            return;
        }
        double d = PointMath.dist(float_2, float_3);
        if (bl) {
            Ellipses.Circle circle = null;
            switch (this.type) {
                case Hairpin: {
                    double d2 = f2 * 2.0f * (float)(n + 1) + drawSettings.loopSpacing * (float)(n + 1);
                    circle = new Ellipses.Circle(Ellipses.Circle.getRadiusFromArcAndChord(d2, d));
                    circle.center(vec2D4.getPointAlong(point2D3, this.getChordHeight(d2, d, circle.radius())));
                    break;
                }
                case Multibranch: {
                    Point2D.Float float_4 = new Point2D.Float();
                    int n2 = 0;
                    List<Bond> list = Motif.Loop.getMultiBranchBasePairs(this.loop.getNuc3(), false);
                    if (list != null) {
                        for (Bond bond : list) {
                            Point2D point2D4 = PointMath.midpoint(bond.getNuc5().location, bond.getNuc3().location);
                            if (bond == nuc.getPairBond() || bond == nuc2.getPairBond()) {
                                this.controller.addHint(Ellipses.fromCenter(point2D4, (double)(f2 / 2.0f))).color(null, RnaDrawController.Colors.cold).fromModel();
                                continue;
                            }
                            this.controller.addHint(Ellipses.fromCenter(point2D4, (double)(f2 / 2.0f))).color(null, RnaDrawController.Colors.cool).fromModel();
                            Ellipses.Circle circle2 = Ellipses.Circle.calcFromPoints(float_2, float_3, point2D4);
                            if (circle2 == null) continue;
                            float_4.x = (float)((double)float_4.x + circle2.getCenterX());
                            float_4.y = (float)((double)float_4.y + circle2.getCenterY());
                            ++n2;
                        }
                    }
                    if (n2 <= 0) break;
                    float_4.x /= (float)n2;
                    float_4.y /= (float)n2;
                    circle = new Ellipses.Circle(float_4, PointMath.dist(float_4, float_2));
                }
            }
            if (circle == null) {
                circle = new Ellipses.Circle(PointMath.midpoint(point2D, point2D2), PointMath.dist(point2D, point2D2) / 2.0);
            }
            boolean bl4 = bl3 = PointMath.dist(((Ellipses.Circle)cloneable2).center(), circle.center()) <= Math.max(2.0, 6.0 / Math.sqrt(f));
            if (bl3) {
                cloneable2 = circle;
            }
        }
        if (bl2) {
            double d3 = f2 * ((float)n + 0.5f);
            Cloneable cloneable3 = cloneable = d3 > d ? new Ellipses.Circle(Ellipses.Circle.getRadiusFromArcAndChord(d3, d)) : null;
            if (cloneable != null) {
                ((Ellipses.Circle)cloneable).center(vec2D4.getPointAlong(point2D3, this.getChordHeight(d3, d, ((Ellipses.Circle)cloneable).radius())));
                if (vec2D4.dot(((Ellipses.Circle)cloneable2).center(), point2D3) < vec2D4.dot(((Ellipses.Circle)cloneable).center(), point2D3) || vec2D4.dot(float_, point2D3) < (double)f2) {
                    cloneable2 = cloneable;
                }
            } else if (vec2D4.dot(float_, point2D3) < (double)f2 && bl) {
                this.positionLinear(nuc, nuc2, true);
                return;
            }
        }
        Point2D.Float float_5 = ((Ellipses.Circle)cloneable2).center();
        Vec2D vec2D5 = new Vec2D(float_5, float_2);
        cloneable = new Vec2D(float_5, float_3);
        boolean bl5 = vec2D2.dot(vec2D4) > 0.0;
        double d4 = vec2D5.arcAngleTo((Vec2D)cloneable, bl5);
        double d5 = vec2D5.getAngle();
        this.controller.addHint((Shape)((Object)cloneable2)).dashed().fromModel();
        if (bl3) {
            this.controller.addHint(((Ellipses.Circle)cloneable2).arc(d5, d4)).fromModel().bold();
        }
        for (int i = 1; i < n + 1; ++i) {
            double d6 = d5 + d4 * (double)i / (double)(n + 1);
            nuc.getNext((int)i).location.setLocation(((Ellipses.Circle)cloneable2).getCircleX(d6), ((Ellipses.Circle)cloneable2).getCircleY(d6));
        }
    }

    private double getChordHeight(double d, double d2, double d3) {
        double d4 = Math.sqrt(d3 * d3 - d2 * d2 / 4.0);
        return d < Math.PI * d3 ? -d4 : d4;
    }

    private void positionTerminalLoop(Point2D.Float float_, Nuc nuc, Nuc nuc2, boolean bl) {
        boolean bl2;
        float f = (float)this.view.trToScreen.getScaleX();
        Vec2D vec2D = new Vec2D(nuc.location, nuc2.location).rotate90().normalize();
        Point2D.Double double_ = (Point2D.Double)PointMath.midpoint(nuc.location, nuc2.location, new Point2D.Double());
        Vec2D vec2D2 = new Vec2D(double_, float_);
        Ellipses.Circle circle = Ellipses.Circle.calcFromPoints(nuc.location, nuc2.location, float_);
        if (circle == null || bl && Math.abs(vec2D2.dot(vec2D)) < 6.0 / Math.sqrt(f)) {
            this.positionLinear(nuc, nuc2, true);
            return;
        }
        Point2D.Float float_2 = circle.center();
        double d = circle.radius();
        boolean bl3 = bl2 = bl && Point2D.distance(float_2.x, float_2.y, double_.x, double_.y) <= (double)Math.max(2.0f, 12.0f / f);
        if (bl2) {
            float_2.setLocation(double_);
            d = PointMath.dist(float_2, nuc.location);
        }
        Vec2D vec2D3 = new Vec2D(float_2, nuc.location);
        Vec2D vec2D4 = new Vec2D(float_2, nuc2.location);
        boolean bl4 = vec2D2.dot(vec2D) > 0.0;
        double d2 = vec2D3.getAngle();
        double d3 = vec2D3.arcAngleTo(vec2D4, bl4);
        this.controller.addHint(Ellipses.fromCenter(float_2, 2.0)).fill(DrawHint.HintColorReference).noLine().fromModel();
        DrawHint drawHint = this.controller.addHint(new Arc2D.Double((double)float_2.x - d, (double)float_2.y - d, d * 2.0, d * 2.0, d2 * -57.29577951308232, d3 * -57.29577951308232, 0)).fromModel();
        if (bl2) {
            drawHint.color(DrawHint.HintColorReference).bold();
        }
        int n = nuc2.indexInStrand() - nuc.indexInStrand();
        for (int i = 1; i < n; ++i) {
            double d4 = d2 + d3 * (double)i / (double)n;
            nuc.getNext((int)i).location.setLocation((double)float_2.x + d * Math.cos(d4), (double)float_2.y + d * Math.sin(d4));
        }
    }

    private void positionTerminalEndPoint(Point2D.Float float_, Nuc nuc, Nuc nuc2, int n, boolean bl) {
        float f;
        Point2D.Float float_2 = nuc2.location;
        int n2 = Math.abs(nuc.indexInStrand() - nuc2.indexInStrand());
        if (bl) {
            Vec2D vec2D;
            DrawSettings drawSettings = this.controller.getSettings();
            f = drawSettings.nucleotideRadius(nuc) * 2.0f;
            float f2 = (float)(6.0 / this.view.trToScreen.getScaleX());
            Vec2D[] vec2DArray = new Vec2D[]{new Vec2D(0.0, 1.0), new Vec2D(1.0, 0.0), null, null};
            if (nuc2.isPaired()) {
                vec2D = new Vec2D(nuc2.location, nuc2.getPaired().location).normalize();
                if (Math.abs(vec2D.x) > 0.1 && Math.abs(vec2D.y) > 0.1) {
                    vec2DArray[2] = vec2D;
                    vec2DArray[3] = vec2D.getRotated90();
                }
            }
            vec2D = new Vec2D(float_2, float_);
            double d = vec2D.length();
            for (Vec2D vec2D2 : vec2DArray) {
                double d2;
                if (vec2D2 == null || !(Math.sqrt(d * d - (d2 = vec2D2.dot(vec2D)) * d2) <= (double)f2)) continue;
                float_.setLocation(vec2D2.x * d2 + (double)float_2.x, vec2D2.y * d2 + (double)float_2.y);
                this.controller.addHint(vec2D2.toLine(float_2, (double)(d2 < 0.0 ? -1 : 1) * (d + (double)f))).fromModel().bold();
            }
            float f3 = drawSettings.calcOptimalNuc2NucDistance(nuc2, nuc);
            vec2D = new Vec2D(float_2, float_);
            if (Math.abs(vec2D.length() - (double)f3) <= (double)f2) {
                float_.setLocation(vec2D.setLength(f3).add(float_2));
                this.controller.addHint(Ellipses.fromCenter(float_2, (double)f3)).fromModel().bold();
            }
        }
        float f4 = (float_2.x - float_.x) / (float)n2;
        f = (float_2.y - float_.y) / (float)n2;
        for (int i = 0; i < n2; ++i) {
            nuc.getNext((int)(n * i)).location.setLocation(float_.x + f4 * (float)i, float_.y + f * (float)i);
        }
    }

    void positionLinear(Nuc nuc, Nuc nuc2, boolean bl) {
        this.positionLinear(nuc, nuc2, nuc.location, nuc2.location, false, false, bl);
    }

    void positionLinear(Nuc nuc, Nuc nuc2, Point2D point2D, Point2D point2D2, boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2 = nuc2.indexInStrand() - nuc.indexInStrand();
        int n3 = n = n2 < 0 ? -1 : 1;
        if (n == -1) {
            n2 = -n2;
        }
        if (bl) {
            ++n2;
        }
        if (bl2) {
            ++n2;
        }
        double d = (point2D2.getX() - point2D.getX()) / (double)n2;
        double d2 = (point2D2.getY() - point2D.getY()) / (double)n2;
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        int n4 = bl ? 1 : 0;
        Nuc nuc3 = nuc;
        while (true) {
            nuc3.location.setLocation(d3 + (double)n4 * d, d4 + (double)n4 * d2);
            ++n4;
            if (nuc3 == nuc2) break;
            nuc3 = nuc3.getNext(n);
        }
        DrawHint drawHint = this.controller.addHint(new Vec2D(point2D, point2D2).toLine(point2D)).fromModel();
        if (bl3) {
            drawHint.bold();
        }
    }

    @Override
    protected void prepareDraw(boolean bl) {
        if (!this.isValid()) {
            return;
        }
        if (!bl) {
            this.handleOffsetDir.setLength((double)this.controller.getSettings().nucleotideRadius(null) * this.view.trToScreen.getScaleX() + (double)this.getBoxSize() * Math.sqrt(2.0) / 2.0);
            this.view.toScreen(this.targetNuc.location, this.location);
            this.location.translate((int)this.handleOffsetDir.x, (int)this.handleOffsetDir.y);
            if (this.multiLoop != null && this.controller.programSettings().ExpandMotif) {
                super.setIcon(this.resizeMultiLoopIcon);
            } else {
                super.setIcon(this.getDirectionalIcon(this.handleOffsetDir.getAngle()));
            }
        }
    }

    @Override
    protected void selectionChanged() {
        this.loop = this.targetNuc == null ? null : this.targetNuc.getLoop();
        Motif.MultiLoop multiLoop = this.multiLoop = this.loop == null ? null : this.targetNuc.getMultiLoop(2, false);
        if (this.loop == null) {
            return;
        }
        this.type = this.loop.getType();
        this.calculateOffset();
    }

    private void calculateOffset() {
        if (this.targetNuc != null) {
            this.view.rayToScreen(this.controller.calcNormalToNuc(this.targetNuc), this.handleOffsetDir);
        }
    }

    @Override
    public void dragComplete(boolean bl) {
        super.dragComplete(bl);
        this.calculateOffset();
    }

    @Override
    public SceneUpdateInfo getCompletionEvent() {
        return ResizeLoop;
    }
}

