/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import ur_rna.StructureEditor.models.DrawSettings;
import ur_rna.StructureEditor.services.drawing.View2D;
import ur_rna.Utilities.Colors;
import ur_rna.Utilities.geom.GraphicsUtil;

public abstract class DrawHint {
    public static BasicStroke HintLineDefault = new BasicStroke(1.0f);
    public static BasicStroke HintLineThick = new BasicStroke(3.0f, 1, 1);
    public static final Color HintColorDefault = new Color(0, true);
    public static final Color HintColorReference = new Color(0, true);
    public Color colorFill = null;
    public Color colorLine = HintColorDefault;
    public boolean isModelCoords = false;
    public Stroke lineStyle = HintLineDefault;

    public void draw(Graphics2D graphics2D, View2D view2D, DrawSettings drawSettings) {
        this.drawHint(graphics2D, view2D, drawSettings);
    }

    protected abstract void drawHint(Graphics2D var1, View2D var2, DrawSettings var3);

    protected Color getDrawColor(Color color, DrawSettings drawSettings) {
        if (this.colorLine == HintColorDefault) {
            return drawSettings.hint;
        }
        if (this.colorLine == HintColorReference) {
            return drawSettings.hintEmphasis;
        }
        return color;
    }

    public DrawHint fromModel() {
        this.isModelCoords = true;
        return this;
    }

    public DrawHint color(Color color) {
        this.colorLine = color;
        return this;
    }

    public DrawHint color(Color color, Color color2) {
        this.colorLine = color;
        this.colorFill = color2;
        return this;
    }

    public DrawHint color(Color color, int n) {
        this.colorLine = color;
        this.colorFill = Colors.setAlpha(color, n);
        return this;
    }

    public DrawHint fill(Color color) {
        this.colorFill = color;
        return this;
    }

    public DrawHint fillAlpha(int n) {
        this.colorFill = Colors.setAlpha(this.colorLine, n);
        return this;
    }

    public DrawHint noFill() {
        this.colorFill = null;
        return this;
    }

    public DrawHint noLine() {
        this.colorLine = null;
        return this;
    }

    public DrawHint line(float f, float ... fArray) {
        BasicStroke basicStroke = this.lineStyle instanceof BasicStroke ? (BasicStroke)this.lineStyle : HintLineDefault;
        this.lineStyle = new BasicStroke(f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), fArray == null ? basicStroke.getDashArray() : fArray, basicStroke.getDashPhase());
        return this;
    }

    public DrawHint line(float f) {
        return this.line(f, (float[])null);
    }

    public DrawHint line(Stroke stroke) {
        this.lineStyle = stroke;
        return this;
    }

    public abstract DrawHint bold();

    public DrawHint dashed() {
        return this.line(1.0f, 2.0f, 4.0f);
    }

    public static DrawHint shape(Shape shape) {
        return new DrawShape(shape);
    }

    public static DrawHint text(String string, Point2D point2D) {
        return new DrawText(string, point2D);
    }

    public static class DrawText
    extends DrawHint {
        public final String text;
        public final Point2D textPos;
        public final Point2D.Float screenPos = new Point2D.Float();
        private boolean isBold;

        public DrawText(String string, Point2D point2D) {
            this.text = string;
            this.textPos = point2D;
        }

        @Override
        protected void drawHint(Graphics2D graphics2D, View2D view2D, DrawSettings drawSettings) {
            if (this.colorLine != null && this.text != null) {
                graphics2D.setColor(this.getDrawColor(this.colorLine, drawSettings));
                if (this.isModelCoords) {
                    view2D.toScreen(this.textPos, this.screenPos);
                } else {
                    this.screenPos.setLocation(this.textPos);
                }
                Font font = null;
                if (this.isBold) {
                    font = graphics2D.getFont();
                    graphics2D.setFont(font.deriveFont(font.getStyle() | 1));
                }
                GraphicsUtil.drawTextCentered(graphics2D, this.text, this.screenPos);
                if (this.isBold) {
                    graphics2D.setFont(font);
                }
            }
        }

        @Override
        public DrawHint bold() {
            this.isBold = true;
            return this;
        }
    }

    public static class DrawShape
    extends DrawHint {
        public final Shape shape;

        public DrawShape(Shape shape) {
            this.shape = shape;
        }

        @Override
        protected void drawHint(Graphics2D graphics2D, View2D view2D, DrawSettings drawSettings) {
            Shape shape;
            Shape shape2 = shape = this.isModelCoords ? view2D.trToScreen.createTransformedShape(this.shape) : this.shape;
            if (this.colorFill != null) {
                graphics2D.setColor(this.getDrawColor(this.colorFill, drawSettings));
                graphics2D.fill(shape);
            }
            if (this.lineStyle != null && this.colorLine != null) {
                graphics2D.setStroke(this.lineStyle);
                graphics2D.setColor(this.getDrawColor(this.colorLine, drawSettings));
                graphics2D.draw(shape);
            }
        }

        @Override
        public DrawHint bold() {
            this.lineStyle = HintLineThick;
            return this;
        }
    }
}

