/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services.drawing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import ur_rna.StructureEditor.models.DrawSettings;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.SceneUpdateInfo;
import ur_rna.StructureEditor.services.SceneController;
import ur_rna.StructureEditor.services.drawing.View2D;
import ur_rna.Utilities.geom.PointMath;

public abstract class DrawHandle {
    public static final float SNAP_DISTANCE = 6.0f;
    private static int defaultBoxSize = 16;
    protected static final BasicStroke defaultOutline = new BasicStroke(1.0f);
    protected static final Color defaultLineColor = new Color(-872395367, true);
    protected static final Color defaultBgColor = new Color(-869033473, true);
    private static int DEFAULT_MARGIN = 4;
    private boolean isPerformingDrag = false;
    private boolean enabled = true;
    protected Point location = new Point();
    protected Point startLocation = new Point();
    protected Rectangle cachedBounds;
    protected Image icon;
    protected Cursor customCursor;
    protected Nuc targetNuc;
    protected Collection<Nuc> allNucs;
    protected SceneController controller;
    protected final AffineTransform _tmpTr = new AffineTransform();
    protected final Point2D.Double _tmpPt = new Point2D.Double();
    protected View2D view = View2D.IDENTITY;
    protected int boxSize = defaultBoxSize;

    protected DrawHandle(SceneController sceneController) {
        this.controller = sceneController;
    }

    public int getBoxSize() {
        return this.boxSize;
    }

    public void setBoxSize(int n) {
        this.boxSize = n;
    }

    public Rectangle getBounds() {
        if (this.cachedBounds == null) {
            this.cachedBounds = new Rectangle(0, 0, this.boxSize, this.boxSize);
        }
        this.cachedBounds.setLocation(this.location.x - this.boxSize / 2, this.location.y - this.boxSize / 2);
        return this.cachedBounds;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setIcon(BufferedImage bufferedImage) {
        this.icon = bufferedImage;
    }

    public void settingsChanged() {
    }

    public void dragComplete(boolean bl) {
        SceneUpdateInfo sceneUpdateInfo;
        if (bl && (sceneUpdateInfo = this.getCompletionEvent()) != null) {
            this.controller.addUndo(sceneUpdateInfo);
        }
    }

    public void dragStarted(Point point) {
        this.startLocation.setLocation(this.location);
    }

    public final Shape draw(Graphics2D graphics2D, View2D view2D, DrawSettings drawSettings, boolean bl) {
        this.view = view2D;
        this.prepareDraw(bl);
        return this.drawBox(graphics2D, view2D, drawSettings);
    }

    protected Shape drawBox(Graphics2D graphics2D, View2D view2D, DrawSettings drawSettings) {
        Rectangle rectangle = this.getBounds();
        if (this.icon != null) {
            graphics2D.drawImage(this.icon, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        } else {
            graphics2D.setColor(defaultBgColor);
            graphics2D.fill(rectangle);
            graphics2D.setStroke(defaultOutline);
            graphics2D.setColor(defaultLineColor);
            graphics2D.draw(rectangle);
        }
        return rectangle;
    }

    protected Point2D calcBoxPos(Point2D point2D, Point2D point2D2, double d, DrawSettings drawSettings, AffineTransform affineTransform) {
        Point2D point2D3 = affineTransform.transform(point2D, null);
        Point2D point2D4 = affineTransform.deltaTransform(point2D2, null);
        if (d != 0.0) {
            d *= affineTransform.getScaleX();
        }
        PointMath.translate(point2D3, PointMath.scale(PointMath.normalize(point2D4), d += (double)this.boxSize / Math.sqrt(2.0) + (double)defaultOutline.getLineWidth() + (double)DEFAULT_MARGIN));
        PointMath.translate(point2D3, -this.boxSize / 2, -this.boxSize / 2);
        return point2D3;
    }

    public void setSelection(Nuc nuc, Collection<Nuc> collection) {
        this.targetNuc = nuc;
        this.allNucs = collection;
        this.selectionChanged();
    }

    private static int getSelectionHashCode(Iterable<Nuc> iterable) {
        int n = 0;
        for (Nuc nuc : iterable) {
            n = (n ^ nuc.indexInScene()) * 16777619;
        }
        return n;
    }

    protected AffineTransform getModelSpaceDeltaTransform(Point point, Point point2) {
        this._tmpPt.setLocation(point2.x - point.x, point2.y - point.y);
        this.view.rayToModel(this._tmpPt);
        this._tmpTr.setToTranslation(this._tmpPt.x, this._tmpPt.y);
        return this._tmpTr;
    }

    protected void moveLocation(Point point, Point point2) {
        this.location.setLocation(this.startLocation.x + point2.x - point.x, this.startLocation.y + point2.y - point.y);
    }

    public boolean isUpdating() {
        return this.isPerformingDrag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drag(Point point, Point point2, Point point3, SceneController.DragOpts dragOpts) {
        this.isPerformingDrag = true;
        try {
            this.performDrag(point, point2, point3, dragOpts);
        }
        finally {
            this.isPerformingDrag = false;
        }
    }

    public final void layoutUpdated() {
        if (!this.isPerformingDrag) {
            this.nucPositionsChanged();
        }
    }

    protected abstract void performDrag(Point var1, Point var2, Point var3, SceneController.DragOpts var4);

    protected abstract void nucPositionsChanged();

    protected abstract void prepareDraw(boolean var1);

    protected abstract void selectionChanged();

    public abstract boolean isValid();

    protected abstract SceneUpdateInfo getCompletionEvent();
}

