/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services;

import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import ur_rna.Utilities.prefs.FilePreferences;

public class UserPrefs {
    public static final String DEFAULT_USER = "default";
    private final FilePreferences root;
    private Preferences appNode;
    private Preferences userNode;

    public static void register() {
        FilePreferences.Factory.register();
    }

    public UserPrefs(String string) {
        this(FilePreferences.Factory.getPreferencesFile().toPath().getParent().resolve(string + ".prefs").toFile());
    }

    public UserPrefs(File file) {
        this.root = FilePreferences.createRoot(file.toString());
        this.appNode = this.root;
        this.setUser(DEFAULT_USER);
    }

    public void setUser(String string) {
        this.userNode = this.appNode.node(string);
    }

    public String getUser() {
        return this.userNode.name();
    }

    public Preferences app() {
        return this.appNode;
    }

    public Preferences user() {
        return this.userNode;
    }

    protected void save() {
        try {
            this.root.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public String get(String string) {
        return this.get(string, null);
    }

    public String get(String string, String string2) {
        return this.userNode.get(string, string2);
    }

    public void put(String string, String string2) {
        this.userNode.put(string, string2);
    }
}

