/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import ur_rna.StructureEditor.Settings;
import ur_rna.StructureEditor.models.Bond;
import ur_rna.StructureEditor.models.BondType;
import ur_rna.StructureEditor.models.DrawSettings;
import ur_rna.StructureEditor.models.HistoryState;
import ur_rna.StructureEditor.models.HistoryUpdateEvent;
import ur_rna.StructureEditor.models.IMotif;
import ur_rna.StructureEditor.models.INucGroup;
import ur_rna.StructureEditor.models.IScreenObject;
import ur_rna.StructureEditor.models.Motif;
import ur_rna.StructureEditor.models.Nuc;
import ur_rna.StructureEditor.models.NucStyle;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.models.SceneUpdateInfo;
import ur_rna.StructureEditor.models.Strand;
import ur_rna.StructureEditor.services.SceneColorizer;
import ur_rna.StructureEditor.services.SceneController;
import ur_rna.StructureEditor.services.SceneDrawMode;
import ur_rna.StructureEditor.services.SceneRenderer;
import ur_rna.StructureEditor.services.SceneUpdateEvent;
import ur_rna.StructureEditor.services.drawing.BranchSlider;
import ur_rna.StructureEditor.services.drawing.DrawHandle;
import ur_rna.StructureEditor.services.drawing.DrawHint;
import ur_rna.StructureEditor.services.drawing.ICanvas;
import ur_rna.StructureEditor.services.drawing.LoopResizer;
import ur_rna.StructureEditor.services.drawing.NucLayout;
import ur_rna.StructureEditor.services.drawing.ScreenShape;
import ur_rna.StructureEditor.services.drawing.SelectionRotater;
import ur_rna.StructureEditor.services.drawing.View2D;
import ur_rna.StructureEditor.services.drawing.export.Graphics2DRecorder;
import ur_rna.Utilities.EventSource;
import ur_rna.Utilities.ObjTools;
import ur_rna.Utilities.annotation.NotNull;
import ur_rna.Utilities.geom.Ellipses;
import ur_rna.Utilities.geom.GraphicsUtil;
import ur_rna.Utilities.geom.PointMath;
import ur_rna.Utilities.geom.Rectangles;
import ur_rna.Utilities.geom.Vec2D;
import ur_rna.Utilities.swing.AcceleratorKey;
import ur_rna.Utilities.swing.InputAdapter;

public class RnaDrawController
implements SceneRenderer,
SceneController {
    private Component canvasComponent;
    private ICanvas canvas;
    private RnaScene scene;
    private Set<Nuc> selection = new HashSet<Nuc>();
    private Collection<DrawHint> drawHints = new HashSet<DrawHint>();
    private final DrawHandle handleRotate;
    private final DrawHandle handleBranchSlide;
    private final DrawHandle handleLoopResize;
    private final DrawHandle[] drawHandles;
    private Nuc focused;
    private DrawSettings settings = new DrawSettings();
    private MouseHandler mouseHandler = new MouseHandler();
    private List<IScreenObject> screenObjects = null;
    public EventSource.OneArg<SceneUpdateEvent> sceneUpdated = new EventSource.OneArg();
    public EventSource.OneArg<HistoryUpdateEvent> historyEvent = new EventSource.OneArg();
    public static int SELECTION_ADD_MASK = 1;
    public static int EDIT_CLICK_MASK = 2;
    public static int DRAG_SPECIAL_MASK = AcceleratorKey.SystemMenuKeyModifier;
    public static int DRAG_EXPANDED_MOTIF_MASK = 1;
    private final Rectangle selectionBand = new Rectangle();
    private final Line2D.Float editBond = new Line2D.Float();
    private SelectionType selType = SelectionType.Individual;
    private BehaviorMode behaviorMode = BehaviorMode.NUC;
    private int[] EMPTY_SELECTION = new int[0];
    Graphics2DRecorder _dummyGraphics = new Graphics2DRecorder();
    private boolean useRecorder = false;
    private final AffineTransform _tmpTr = new AffineTransform();
    private final Point2D _tmpPt = new Point2D.Double();
    private Point2D prevStart = new Point();
    double prevTheta;
    private boolean prevBias;
    private static final double minBiasRange = 2.0943951023931953;
    private static final double[] stickyRotationAngles = new double[]{0.0, Math.PI, -Math.PI, 1.5707963267948966, -1.5707963267948966, 0.7853981633974483, -0.7853981633974483, 2.356194490192345, -2.356194490192345, 1.0471975511965976, 2.0943951023931953, -1.0471975511965976, -2.0943951023931953};
    private static final double stickyRotationEpsilon = 0.08726646259971647;
    private float[] coords = new float[128];
    private static int SELECT_ONLY = 1;
    private static int DESELECT_ONLY = 2;
    private Vec2D _backboneDir = new Vec2D();
    private Vec2D _backboneStart = new Vec2D();
    private Vec2D _backboneEnd = new Vec2D();
    Line2D.Float _backboneLine = new Line2D.Float();
    private final int ZORDER_NUMBER = -1;
    Ellipse2D.Float tmpNucShape = new Ellipse2D.Float();
    private Shape[] nucShapes;
    private ScreenNuc[] nucScreenShapes;
    private int _suspendUpdatesCounter = 0;
    private int _suspendRedraw = 0;

    public void programSettingsChanged(Settings settings) {
        this.handleLoopResize.setEnabled(!settings.DisableLoopResize);
        this.handleBranchSlide.setEnabled(!settings.DisableBranchSlide);
        this.handleRotate.setEnabled(!settings.DisableRotation);
        ((SelectionRotater)this.handleRotate).getCenterPoint().setEnabled(!settings.DisableRotation);
    }

    @Override
    public DrawSettings getSettings() {
        return this.settings;
    }

    public void setSettings(DrawSettings drawSettings) {
        this.settings = drawSettings;
    }

    public RnaDrawController() {
        this.setScene(this.createDefaultScene());
        this.handleBranchSlide = new BranchSlider(this);
        this.handleRotate = new SelectionRotater(this);
        this.handleLoopResize = new LoopResizer(this);
        this.drawHandles = new DrawHandle[]{this.handleRotate, ((SelectionRotater)this.handleRotate).getCenterPoint(), this.handleLoopResize, this.handleBranchSlide};
        this.sceneUpdated.add(this::onSceneUpdate);
    }

    private int[] getSelectionState() {
        if (this.selection.size() == 0) {
            return this.EMPTY_SELECTION;
        }
        int n = 0;
        int[] nArray = new int[this.selection.size() + 1];
        nArray[0] = this.focused == null ? -1 : this.focused.indexInScene();
        for (Nuc nuc : this.selection) {
            nArray[++n] = nuc.indexInScene();
        }
        return nArray;
    }

    private void setSelectionState(int[] nArray) {
        this.selection.clear();
        this.focused = null;
        if (nArray != null && nArray.length != 0) {
            if (nArray[0] != -1) {
                this.focused = this.scene.nucAtSceneIndex(nArray[0]);
            }
            for (int i = 1; i < nArray.length; ++i) {
                this.selection.add(this.scene.nucAtSceneIndex(nArray[i]));
            }
        }
        this.selectionUpdated();
    }

    private RnaScene createDefaultScene() {
        RnaScene rnaScene = new RnaScene();
        Strand strand = rnaScene.strands.first();
        String string = "AGUCUCCGCAGAUCAG";
        float f = this.settings.nucleotideRadius(null);
        float f2 = f * 2.0f * 1.4f;
        float f3 = f * 1.5f;
        for (int i = 0; i < string.length(); ++i) {
            strand.add(new Nuc("" + string.charAt(i), f3 + f2 * (float)i, f3));
        }
        return rnaScene;
    }

    @Override
    public ICanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(ICanvas iCanvas) {
        this.canvas = iCanvas;
        this.setCanvasComponent(this.canvas.getComponent());
    }

    private void setCanvasComponent(Component component) {
        if (component != null) {
            this.mouseHandler.remove(component);
        }
        if (component == null) {
            throw new IllegalArgumentException("Canvas cannot be null.");
        }
        this.canvasComponent = component;
        this.mouseHandler.listen(component);
    }

    public RnaScene getScene() {
        return this.scene;
    }

    public void setScene(RnaScene rnaScene) {
        if (rnaScene == null) {
            throw new IllegalArgumentException("Scene cannot be null.");
        }
        this.scene = rnaScene;
        if (rnaScene.history.size() == 0) {
            this.addUndo(SceneUpdateInfo.Initial);
        }
        this.resetStructure();
    }

    public boolean isUserActionInProgress() {
        return this.mouseHandler.state == 2;
    }

    protected void onSceneUpdate(SceneUpdateEvent sceneUpdateEvent) {
        switch (sceneUpdateEvent.type) {
            case Selection: {
                this.handleSelectionChange();
                break;
            }
            case Layout: 
            case Style: {
                break;
            }
            case Structure: {
                this.resetStructure();
                break;
            }
            case Controls: 
            case View: {
                break;
            }
            case History: {
                return;
            }
        }
        this.redraw();
    }

    private void resetStructure() {
        this.clearSelection();
        this.nucShapes = new Shape[this.scene.getNucCount()];
        this.nucScreenShapes = new ScreenNuc[this.nucShapes.length];
        this.scene.identifyPseudoknots();
    }

    private void clearSelection() {
        this.selection.clear();
        this.drawHints.clear();
        this.focused = null;
        this.selectionUpdated();
    }

    private void redraw() {
        if (this._suspendRedraw == 0 && this.canvas != null) {
            this.canvas.repaintRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle calcBounds(Graphics2D graphics2D, View2D view2D, boolean bl) {
        this._dummyGraphics.suspendRecording();
        try {
            this._dummyGraphics.getContext().copyFrom(graphics2D);
            List<IScreenObject> list = this.draw(this._dummyGraphics, view2D, this.settings, bl);
            int n = list.size();
            if (n == 0) {
                Rectangle rectangle = null;
                return rectangle;
            }
            Rectangle rectangle = list.get(0).getBounds();
            for (IScreenObject iScreenObject : list) {
                rectangle = rectangle.union(iScreenObject.getBounds());
            }
            Rectangle rectangle2 = rectangle;
            return rectangle2;
        }
        finally {
            this._dummyGraphics.resumeRecording();
        }
    }

    @Override
    public Collection<IScreenObject> render(Graphics2D graphics2D, View2D view2D, boolean bl) {
        if (this.useRecorder) {
            Graphics2DRecorder graphics2DRecorder = new Graphics2DRecorder();
            graphics2DRecorder.getContext().copyFrom(graphics2D);
            this.screenObjects = this.draw(graphics2DRecorder, view2D, this.settings, bl);
            graphics2DRecorder.replay(graphics2D);
        } else {
            this.screenObjects = this.draw(graphics2D, view2D, this.settings, bl);
        }
        return this.screenObjects;
    }

    public void translateScreenNucs(Collection<Nuc> collection, Point point, Point point2) {
        this.translateScreenNucs(collection, PointMath.diff(point2, point));
    }

    public void translateScreenNucs(Collection<Nuc> collection, Point2D point2D) {
        this.canvas.getView().rayToModel(point2D, this._tmpPt);
        this._tmpTr.setToTranslation(this._tmpPt.getX(), this._tmpPt.getY());
        this.transformNucs(collection, this._tmpTr);
    }

    @Override
    public void rotateNucs(Collection<Nuc> collection, Point2D point2D, Point point, Point point2, SceneController.DragOpts dragOpts) {
        this.rotateNucs(collection, point2D, point, point2, dragOpts, null, true);
    }

    @Override
    public void rotateNucs(Collection<Nuc> collection, Point2D point2D, Point point, Point point2, SceneController.DragOpts dragOpts, Motif.Helix helix, boolean bl) {
        boolean bl2;
        double d;
        Vec2D vec2D;
        Cloneable cloneable;
        Cloneable cloneable2;
        if (collection.size() == 0) {
            return;
        }
        if (helix == null) {
            helix = this.findBaseHelix(collection);
        }
        Vec2D vec2D2 = null;
        Vec2D vec2D3 = null;
        if (helix != null) {
            cloneable2 = helix.getPair(0);
            vec2D2 = Vec2D.getMidpoint(((Bond)cloneable2).n5.location, ((Bond)cloneable2).n3.location);
            cloneable = helix.getPair(helix.size() - 1);
            vec2D = Vec2D.getMidpoint(((Bond)cloneable).n5.location, ((Bond)cloneable).n3.location);
            vec2D3 = new Vec2D(vec2D2, vec2D);
        }
        if (point2D == null) {
            point2D = vec2D2 == null ? this.calcNucGroupCenter(collection) : vec2D2;
        }
        cloneable2 = this.canvas.getView().toScreen(point2D, new Point2D.Float());
        cloneable = new Vec2D((Point2D)cloneable2, point);
        vec2D = new Vec2D((Point2D)cloneable2, point2);
        boolean bl3 = false;
        if (vec2D3 != null && (!bl || point2D.distanceSq(vec2D2) < 6.0)) {
            d = -vec2D3.angleTo((Vec2D)cloneable);
            ((Vec2D)cloneable).rotate(d);
            vec2D.rotate(d);
        }
        if (this.programSettings().SnapGuides ^ dragOpts.special) {
            d = vec2D.getAngle();
            for (double d2 : stickyRotationAngles) {
                if (!(Math.abs(d2 - d) < 0.08726646259971647)) continue;
                vec2D.rotate(d2 - d);
                bl3 = true;
            }
        }
        d = ((Vec2D)cloneable).getAngle();
        double d3 = vec2D.getAngle();
        double d4 = d3 - d;
        if (this.prevStart.equals(point)) {
            bl2 = Math.abs(this.prevTheta) < 2.0943951023931953 && Math.abs(d4) < 2.0943951023931953 && d4 < 0.0 != this.prevTheta < 0.0;
        } else {
            bl2 = true;
            this.prevStart = point;
        }
        this.prevTheta = d4;
        if (bl2) {
            boolean bl4 = this.prevBias = d4 > 0.0 && d4 <= Math.PI;
        }
        if (this.prevBias && d4 < 0.0) {
            d4 += Math.PI * 2;
        } else if (!this.prevBias && d4 > 0.0) {
            d4 -= Math.PI * 2;
        }
        int n = 5;
        int n2 = (int)(Math.max(((Vec2D)cloneable).length(), vec2D.length()) + 15.0) + 2 * n;
        if (!dragOpts.disableHints) {
            this.addHint(Ellipses.fromCenter((Point2D)cloneable2, (double)n)).fill(DrawHint.HintColorReference).noLine();
            if (bl) {
                this.addHint(new Arc2D.Double(((Point2D)cloneable2).getX() - (double)n2, ((Point2D)cloneable2).getY() - (double)n2, 2 * n2, 2 * n2, d * -180.0 / Math.PI, d4 * -180.0 / Math.PI, 2));
            } else {
                this.addHint(vec2D.toLine((Point2D)cloneable2, n2));
            }
            if (bl3) {
                this.addHint(vec2D.toLine((Point2D)cloneable2, n2)).bold();
            }
            Point point3 = vec2D.getPointAlong((Point2D)cloneable2, n2 + 20).toPoint();
            this.addHint(Math.round(d3 * -180.0 / Math.PI) + " \u00b0", point3.x, point3.y);
        }
        if (d4 != 0.0) {
            this.rotateNucs(collection, point2D, d4);
        }
    }

    @Override
    public DrawHint addHint(Shape shape) {
        DrawHint drawHint = DrawHint.shape(shape);
        this.drawHints.add(drawHint);
        return drawHint;
    }

    @Override
    public DrawHint addHint(String string, double d, double d2) {
        DrawHint drawHint = DrawHint.text(string, new Point2D.Double(d, d2));
        this.drawHints.add(drawHint);
        return drawHint;
    }

    @Override
    public void rotateNucs(Collection<Nuc> collection, Point2D point2D, double d) {
        this._tmpTr.setToRotation(d, point2D.getX(), point2D.getY());
        this.layoutUpdated(SceneUpdateInfo.Rotate, false);
        this.transformNucs(collection, this._tmpTr);
    }

    protected void transformNucs(Collection<Nuc> collection, AffineTransform affineTransform) {
        if (collection.size() == 0) {
            return;
        }
        for (Nuc nuc : collection) {
            affineTransform.transform(nuc.location, nuc.location);
        }
        this.layoutUpdated(SceneUpdateInfo.Layout, false);
    }

    @Override
    public Motif.Helix findBaseHelix(Collection<Nuc> collection) {
        for (Motif.Helix helix : Motif.Helix.findAll(this.scene)) {
            if (!collection.contains(helix.getPair((int)0).n5) || !collection.contains(helix.getPair((int)0).n5)) continue;
            return helix;
        }
        return null;
    }

    private Point2D.Float calcNucGroupCenter(Collection<Nuc> collection) {
        Iterator<Nuc> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Nuc nuc = iterator.next();
        int n = 1;
        Point2D.Float float_ = new Point2D.Float(nuc.location.x, nuc.location.y);
        while (iterator.hasNext()) {
            nuc = iterator.next();
            ++n;
            float_.x += nuc.location.x;
            float_.y += nuc.location.y;
        }
        float_.x /= (float)n;
        float_.y /= (float)n;
        return float_;
    }

    public void selectSpecial(SelectionType selectionType) {
        if (this.focused == null) {
            return;
        }
        this.selectMotif(this.focused, true, selectionType);
        this.selectionUpdated();
    }

    public void setSelectedBondType(BondType bondType) {
        for (Nuc nuc : this.selection) {
            if (!nuc.isPaired()) continue;
            nuc.getPairBond().type = bondType;
        }
        this.structureUpdated(SceneUpdateInfo.BondType.subType(String.format("Set Basepair Type (%s)", bondType.getDescription())));
    }

    public void splitStrandsAtSelection() {
        if (this.selection.isEmpty()) {
            return;
        }
        for (Nuc nuc : this.getSelected()) {
            Nuc nuc2 = nuc.getNext();
            if (nuc2 == null) continue;
            this.scene.divideStrand(nuc2);
        }
        this.structureUpdated(SceneUpdateInfo.StrandDivisions.subType("Divided Strands"));
    }

    public void joinSelectionStrands() {
        if (this.selection.isEmpty()) {
            return;
        }
        Nuc[] nucArray = this.getSelected();
        boolean bl = false;
        for (int i = 0; i < nucArray.length; ++i) {
            int n = nucArray[i].getStrand().getIndex();
            for (int j = i + 1; j < nucArray.length; ++j) {
                if (Math.abs(n - nucArray[j].getStrand().getIndex()) != 1) continue;
                this.scene.joinStrands(nucArray[i].getStrand(), nucArray[j].getStrand());
                bl = true;
            }
        }
        if (bl) {
            this.structureUpdated(SceneUpdateInfo.StrandDivisions.subType("Joined Strands"));
        }
    }

    public void breakSelectedBonds() {
        if (this.selection.isEmpty()) {
            return;
        }
        for (Nuc nuc : this.getSelected()) {
            if (!nuc.isPaired()) continue;
            this.scene.breakBond(nuc.getPairBond());
        }
        this.structureUpdated(SceneUpdateInfo.Bonds.subType("Removed Basepairs"));
    }

    public Nuc[] getSelected() {
        return this.selection.toArray(new Nuc[this.selection.size()]);
    }

    public void deleteSelectedBases() {
        if (this.selection.isEmpty()) {
            return;
        }
        this.scene.removeNucs(this.getSelected());
        this.structureUpdated(SceneUpdateInfo.SequenceSize.subType("Removed Bases from Sequence"));
    }

    public void rotateNumber() {
        if (this.selection.isEmpty()) {
            return;
        }
        for (Nuc nuc : this.getSelected()) {
            nuc.style().numberOffset = (float)Vec2D.mod2PI((double)nuc.style().numberOffset + 0.39269908169872414);
        }
        this.structureUpdated(SceneUpdateInfo.Layout.subType("Rotated Base Number"));
    }

    private void rotateNumber(Nuc nuc, Point2D point2D) {
        Vec2D vec2D = this.calcNormalToNuc(nuc);
        Vec2D vec2D2 = new Vec2D(nuc.location, point2D);
        nuc.style().numberOffset = (float)vec2D.angleTo(vec2D2);
    }

    public void insertBases(String string, Nuc nuc, boolean bl) {
        Vec2D vec2D;
        Cloneable cloneable;
        Cloneable cloneable2;
        if (nuc == null) {
            nuc = this.focused;
        }
        if (nuc == null) {
            nuc = ObjTools.first(this.selection, null);
        }
        if (nuc == null) {
            throw new UnsupportedOperationException("Insert position was unspecified and no bases were selected.");
        }
        Strand strand = nuc.getStrand();
        Nuc nuc2 = bl ? nuc.getNext() : nuc.getPrev();
        int n = nuc.indexInStrand();
        if (bl) {
            ++n;
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            if (Character.isWhitespace(string2.charAt(0))) continue;
            cloneable2 = new Nuc(string2);
            strand.add(n + n2++, (Nuc)cloneable2);
        }
        float f = this.settings.calcOptimalLoopDistance(n2, 1);
        float f2 = (float)((double)f / (Math.PI * 2));
        if (nuc2 == null) {
            nuc2 = bl ? nuc.getPrev() : nuc.getNext();
            cloneable = nuc2 == null ? new Vec2D(1.0, 0.0) : new Vec2D(nuc2.location, nuc.location);
            vec2D = ((Vec2D)cloneable).getPointAlong(nuc.location, 2.0f * this.settings.nucRadius + this.settings.loopSpacing);
            cloneable2 = ((Vec2D)cloneable).getPointAlong(vec2D, f2);
        } else {
            cloneable = bl ? nuc : nuc2;
            Nuc nuc3 = bl ? nuc2 : nuc;
            Vec2D vec2D2 = new Vec2D(((Nuc)cloneable).location, nuc3.location);
            vec2D2.rotate90();
            if (this.scene.drawFlipped) {
                vec2D2.negate();
            }
            Vec2D vec2D3 = Vec2D.getMidpoint(((Nuc)cloneable).location, nuc3.location);
            vec2D = vec2D2.getPointAlong(((Nuc)cloneable).location, 2.0f * this.settings.nucRadius + this.settings.loopSpacing);
            cloneable2 = vec2D2.getPointAlong(vec2D3, 2.0f * this.settings.nucRadius + this.settings.loopSpacing + f2);
        }
        cloneable = new Vec2D((Point2D)cloneable2, vec2D);
        int n3 = this.scene.drawFlipped ? 1 : -1;
        for (int i = 0; i < n2; ++i) {
            strand.get((int)(n + i)).location.setLocation(((Vec2D)cloneable).getPointAlong((Point2D)cloneable2, f2));
            ((Vec2D)cloneable).rotate((double)n3 * (Math.PI * 2) / (double)n2);
        }
        this.structureUpdated(SceneUpdateInfo.SequenceSize.subType("Inserted Bases into Sequence"));
    }

    public void setBehaviorMode(BehaviorMode behaviorMode) {
        this.behaviorMode = behaviorMode;
    }

    public BehaviorMode getBehaviorMode() {
        return this.behaviorMode;
    }

    public void removeColors(boolean bl) {
        Collection<Nuc> collection = bl ? this.scene.allNucs() : this.selection;
        for (Nuc nuc : collection) {
            if (nuc.style == null) continue;
            nuc.style.textColor = null;
            nuc.style.fillColor = null;
            nuc.style.outlineColor = null;
        }
        this.styleUpdated(SceneUpdateInfo.FormatBases.subType("Removed Color Annotations"));
    }

    public void flip(boolean bl, boolean bl2) {
        Collection<Nuc> collection = bl2 ? this.selection : this.scene.allNucs();
        Point2D.Float float_ = this.calcNucGroupCenter(collection);
        if (float_ == null) {
            return;
        }
        for (Nuc nuc : collection) {
            if (bl) {
                nuc.location.x = float_.x - (nuc.location.x - float_.x);
            } else {
                nuc.location.y = float_.y - (nuc.location.y - float_.y);
            }
            if (nuc.style == null || nuc.style.numberOffset == 0.0f) continue;
            nuc.style.numberOffset = -nuc.style.numberOffset;
        }
        this.scene.drawFlipped = !this.scene.drawFlipped;
        this.layoutUpdated(SceneUpdateInfo.Layout.subType(String.format("Flipped %s %s", bl2 ? "selection" : "scene", bl ? "vertically" : "horizontally")));
    }

    public void colorize(SceneColorizer sceneColorizer, boolean bl) {
        Collection<Nuc> collection;
        Collection<Nuc> collection2 = collection = bl ? this.scene.allNucs() : this.selection;
        if (sceneColorizer.color(collection)) {
            this.styleUpdated(SceneUpdateInfo.FormatBases.subType("Applied Color Annotations"));
        }
    }

    public void redrawSelection() {
        NucLayout nucLayout = new NucLayout(this.settings);
        int n = 0;
        block0: for (Motif.Helix iMotif : this.scene.getHelices()) {
            for (Nuc nuc : iMotif.getBases()) {
                if (!this.selection.contains(nuc)) continue;
                ++n;
                nucLayout.redrawHelix(iMotif);
                continue block0;
            }
        }
        block2: for (Motif.MultiLoop multiLoop : this.scene.getMultiLoops(1, false)) {
            for (Nuc nuc : multiLoop.getBases()) {
                if (!this.selection.contains(nuc)) continue;
                ++n;
                nucLayout.redrawMultiLoop(multiLoop, this);
                continue block2;
            }
        }
        if (n != 0) {
            this.layoutUpdated(SceneUpdateInfo.Layout.subType("Redraw Selected Helices and Loops"));
        }
    }

    public Nuc getFocused() {
        return this.focused;
    }

    private void dragNucs(Nuc nuc, Point point, Point point2, Point point3, SceneController.DragOpts dragOpts) {
        Motif.Branch branch;
        Collection<Nuc> collection = this.selection;
        if (dragOpts.expandMotif && (branch = nuc.getBranch()) != null) {
            collection = branch.getBases();
        }
        if (dragOpts.special && collection.size() > 1) {
            this.rotateNucs(collection, null, point, point3, new SceneController.DragOpts(false, false, dragOpts.disableHints));
        } else {
            this.translateScreenNucs(collection, point, point3);
        }
    }

    private void addBond(Nuc nuc, Nuc nuc2) {
        SceneUpdateInfo sceneUpdateInfo;
        if (nuc.getPaired() == nuc2) {
            nuc.getPairBond().unpair();
            sceneUpdateInfo = SceneUpdateInfo.RemBonds;
        } else {
            Bond bond = nuc.getPairBond();
            Bond bond2 = nuc2.getPairBond();
            SceneUpdateInfo sceneUpdateInfo2 = sceneUpdateInfo = bond == null && bond2 == null ? SceneUpdateInfo.AddBonds : SceneUpdateInfo.Bonds;
            if (bond != null) {
                bond.unpair();
            }
            if (bond2 != null) {
                bond2.unpair();
            }
            this.scene.addBond(nuc, nuc2);
        }
        this.structureUpdated(sceneUpdateInfo);
    }

    private void resetRnaCoords() {
        int n = 0;
        for (Strand strand : this.scene.strands) {
            for (Nuc nuc : strand) {
                nuc.location.x = this.coords[n++];
                nuc.location.y = this.coords[n++];
            }
        }
    }

    private void storeRnaCoords() {
        int n = 0;
        for (Object object : this.scene.strands) {
            n += 2 * ((Strand)object).size();
        }
        if (this.coords.length < n) {
            this.coords = new float[n + n >> 1];
        }
        int n2 = 0;
        for (Strand strand : this.scene.strands) {
            for (Nuc nuc : strand) {
                this.coords[n2++] = nuc.location.x;
                this.coords[n2++] = nuc.location.y;
            }
        }
    }

    private void handleSelectionChange() {
        this.drawHints.clear();
        this.handleLoopResize.setSelection(this.focused, this.selection);
        this.handleRotate.setSelection(this.focused, this.selection);
        this.handleBranchSlide.setSelection(this.focused, this.selection);
        this.redraw();
    }

    private void selectMotif(Nuc nuc, boolean bl, SelectionType selectionType) {
        INucGroup iNucGroup = this.getMotif(nuc, selectionType, false);
        this.selectNucs(iNucGroup, bl);
    }

    private void selectNucs(Iterable<Nuc> iterable, boolean bl) {
        if (iterable == null) {
            return;
        }
        for (Nuc nuc : iterable) {
            if (bl) {
                this.selection.add(nuc);
                continue;
            }
            this.selection.remove(nuc);
        }
    }

    private INucGroup getMotif(Nuc nuc, SelectionType selectionType, boolean bl) {
        INucGroup iNucGroup = null;
        switch (selectionType) {
            case Individual: {
                break;
            }
            case Helix: {
                iNucGroup = nuc.getHelix();
                break;
            }
            case Loop: {
                iNucGroup = nuc.getLoop();
                break;
            }
            case HelixOrLoop: {
                if (nuc.isPaired()) {
                    iNucGroup = nuc.getHelix();
                    break;
                }
                iNucGroup = nuc.getLoop();
                break;
            }
            case Domain: {
                iNucGroup = nuc.getDomain();
                break;
            }
            case Branch: {
                iNucGroup = nuc.getBranch();
                break;
            }
            case DomainOrBranch: {
                iNucGroup = nuc.isPaired() ? nuc.getDomain() : nuc.getBranch();
            }
        }
        if (!bl && iNucGroup == null) {
            iNucGroup = nuc;
        }
        return iNucGroup;
    }

    private Nuc updateSelection(boolean bl, @NotNull Nuc nuc, int n) {
        boolean bl2 = this.selection.contains(nuc);
        if (bl2 && bl) {
            if (n == SELECT_ONLY) {
                return nuc;
            }
            this.selectMotif(nuc, false, this.selType);
            this.selection.remove(nuc);
            if (this.focused == nuc) {
                this.focused = null;
            }
        } else if (!bl2) {
            if (n == DESELECT_ONLY) {
                return null;
            }
            if (!bl) {
                this.clearSelection();
            }
            this.selectMotif(nuc, true, this.selType);
            this.focused = nuc;
        } else {
            if (n == DESELECT_ONLY) {
                return null;
            }
            this.focused = nuc;
        }
        this.selectionUpdated();
        return null;
    }

    private void updateSelection(boolean bl, Rectangle rectangle) {
        List<IScreenObject> list = this.hitTest(this.screenObjects, rectangle, true);
        if (!(bl || list != null && list.size() != 0)) {
            this.clearSelection();
        } else {
            boolean bl2;
            ArrayList<Nuc> arrayList = new ArrayList<Nuc>(list.size());
            int n = 0;
            for (IScreenObject object : list) {
                if (!(object.getModel() instanceof Nuc)) continue;
                arrayList.add((Nuc)object.getModel());
            }
            if (!bl) {
                this.selection.clear();
                bl2 = true;
            } else {
                for (Nuc nuc : arrayList) {
                    if (!this.selection.contains(nuc)) continue;
                    ++n;
                }
                bl2 = n < arrayList.size() / 2;
            }
            this.selectNucs(arrayList, bl2);
            if (bl2 && arrayList.size() != 0 && (this.focused == null || !this.selection.contains(this.focused))) {
                this.focused = (Nuc)arrayList.get(0);
            }
        }
        this.selectionUpdated();
    }

    private IScreenObject hitTest(Iterable<IScreenObject> iterable, Point2D point2D, boolean bl) {
        IScreenObject iScreenObject = null;
        int n = Integer.MIN_VALUE;
        if (iterable == null) {
            return null;
        }
        for (IScreenObject iScreenObject2 : iterable) {
            if (bl && !(iScreenObject2.getModel() instanceof Nuc) || iScreenObject2.getZOrder() <= n || !iScreenObject2.hitTest(point2D)) continue;
            if (iScreenObject2.getZOrder() == Integer.MAX_VALUE) {
                return iScreenObject2;
            }
            iScreenObject = iScreenObject2;
            n = iScreenObject.getZOrder();
        }
        return iScreenObject;
    }

    private List<IScreenObject> hitTest(Iterable<IScreenObject> iterable, Rectangle rectangle, boolean bl) {
        ArrayList<IScreenObject> arrayList = new ArrayList<IScreenObject>();
        if (iterable == null) {
            return arrayList;
        }
        for (IScreenObject iScreenObject : iterable) {
            if (bl && !(iScreenObject.getModel() instanceof Nuc) || !iScreenObject.hitTest(rectangle)) continue;
            arrayList.add(iScreenObject);
        }
        return arrayList;
    }

    public List<IScreenObject> draw(Graphics2D graphics2D, View2D view2D, DrawSettings drawSettings, boolean bl) {
        Iterator<Object> iterator22;
        AffineTransform affineTransform = graphics2D.getTransform();
        int n = this.scene.getNucCount() * 2;
        ArrayList<IScreenObject> arrayList = new ArrayList<IScreenObject>(n);
        graphics2D.setBackground(drawSettings.sceneBgColor);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null && !rectangle.isEmpty()) {
            graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics2D.transform(view2D.trToScreen);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawBonds(graphics2D, view2D, arrayList);
        if (drawSettings.backboneColor != null && drawSettings.drawBackboneInHelix | drawSettings.drawBackboneInLoops) {
            graphics2D.setColor(drawSettings.backboneColor);
            graphics2D.setStroke(drawSettings.backboneStroke);
            float f = 2.0f * (drawSettings.nucRadius + drawSettings.nucOutlineWidth);
            iterator22 = (Iterator<Object>)new boolean[this.scene.getNucCount()];
            if (drawSettings.drawBackboneCurved && drawSettings.drawBackboneInLoops) {
                this.drawCurvedBackbones(graphics2D, (boolean[])iterator22, f);
            }
            this.drawSimpleBackbones(graphics2D, (boolean[])iterator22, f);
        }
        for (Iterator<Object> iterator22 : this.scene.strands) {
            int n2 = 0;
            NucStyle nucStyle = new NucStyle();
            Iterator<Nuc> iterator3 = ((Strand)((Object)iterator22)).iterator();
            while (iterator3.hasNext()) {
                Nuc nuc = iterator3.next();
                drawSettings.fillStyle(nuc, nucStyle);
                Shape shape = this.getNucShape(nuc);
                arrayList.add(this.getScreenObject(nuc, view2D, ++n2));
                if (nucStyle.fillColor != null) {
                    graphics2D.setColor(nucStyle.fillColor);
                    graphics2D.fill(shape);
                }
                if (nucStyle.textColor != null) {
                    graphics2D.setFont(nucStyle.font);
                    graphics2D.setColor(nucStyle.textColor);
                    GraphicsUtil.drawTextCentered(graphics2D, nuc.symbol, nuc.location);
                }
                if (nucStyle.outlineColor == null) continue;
                graphics2D.setColor(nucStyle.outlineColor);
                graphics2D.setStroke(drawSettings.nucOutlineStroke);
                graphics2D.draw(shape);
            }
        }
        if (bl) {
            Object object = null;
            if (this.mouseHandler.state == 3 && (iterator22 = this.hitTest(arrayList, this.editBond.getP2(), true)) != null) {
                object = (Nuc)iterator22.getModel();
            }
            if (this.mouseHandler.state == 1) {
                for (IScreenObject iScreenObject : this.hitTest(arrayList, this.selectionBand, true)) {
                    if (iScreenObject.getModel() == this.focused || iScreenObject.getModel() == object) continue;
                    this.drawNucOutline(graphics2D, (Nuc)iScreenObject.getModel(), drawSettings.nucSelColor);
                }
            }
            for (Nuc nuc : this.selection) {
                if (nuc == this.focused || nuc == object) continue;
                this.drawNucOutline(graphics2D, nuc, drawSettings.nucSelColor);
            }
            if (object != null && object != this.focused) {
                this.drawNucOutline(graphics2D, (Nuc)object, drawSettings.nucHitColor);
            }
            if (this.focused != null) {
                this.drawNucOutline(graphics2D, this.focused, drawSettings.nucFocusColor);
            }
            graphics2D.setTransform(affineTransform);
            for (DrawHint drawHint : this.drawHints) {
                drawHint.draw(graphics2D, view2D, drawSettings);
            }
            this.drawHints.clear();
            graphics2D.setTransform(affineTransform);
            for (Iterator<Object> iterator : this.drawHandles) {
                if (iterator == null || this.mouseHandler.dragObject != null && this.mouseHandler.dragObject != iterator || !((DrawHandle)((Object)iterator)).isEnabled() || !((DrawHandle)((Object)iterator)).isValid()) continue;
                arrayList.add(new ScreenShape(iterator, ((DrawHandle)((Object)iterator)).draw(graphics2D, view2D, drawSettings, this.mouseHandler.dragObject == iterator), Integer.MAX_VALUE));
            }
            if (this.mouseHandler.state == 1) {
                graphics2D.setStroke(drawSettings.selBandOutline);
                graphics2D.setColor(drawSettings.selBandLineColor);
                graphics2D.draw(this.selectionBand);
                graphics2D.setColor(drawSettings.selBandFillColor);
                graphics2D.fill(this.selectionBand);
            } else if (this.mouseHandler.state == 3) {
                graphics2D.setStroke(drawSettings.editBondStroke);
                graphics2D.setColor(drawSettings.bondColor);
                graphics2D.draw(this.editBond);
            }
        }
        graphics2D.setTransform(affineTransform);
        if (drawSettings.drawNumbers) {
            int n3;
            graphics2D.transform(view2D.trToScreen);
            graphics2D.setColor(drawSettings.numberLineColor);
            graphics2D.setStroke(drawSettings.numberLineStroke);
            graphics2D.setFont(drawSettings.numberFont);
            int n4 = drawSettings.drawNumbersInterval;
            for (n3 = 0; n3 < this.scene.getNucCount(); ++n3) {
                if (n3 != 0 && (n3 + 1) % n4 != 0 || !this.shouldDrawNumber(this.scene.getNuc(n3))) continue;
                arrayList.add(this.drawNucNumber(graphics2D, view2D, this.scene.getNuc(n3), n3 + 1));
            }
            n3 = this.scene.getNucCount() - 1;
            if ((n3 + 1) % n4 > (n4 - 1) / 2 && this.shouldDrawNumber(this.scene.getNuc(n3))) {
                arrayList.add(this.drawNucNumber(graphics2D, view2D, this.scene.getNuc(n3), n3 + 1));
            }
        }
        return arrayList;
    }

    private boolean shouldDrawNumber(Nuc nuc) {
        return nuc.style == null || !Float.isInfinite(nuc.style.numberOffset);
    }

    private void drawBonds(Graphics2D graphics2D, View2D view2D, List<IScreenObject> list) {
        List<Bond> list2 = this.scene.getBonds();
        Rectangle2D rectangle2D = null;
        Line2D.Float float_ = new Line2D.Float();
        for (Bond bond : list2) {
            Shape shape;
            switch (bond.getType()) {
                case Pseudo: {
                    graphics2D.setColor(this.settings.bondColorPseudo);
                    graphics2D.setStroke(this.settings.bondStrokePseudo);
                    break;
                }
                default: {
                    graphics2D.setColor(this.getBondColor(bond));
                    graphics2D.setStroke(this.settings.bondStroke);
                }
            }
            switch (this.scene.drawMode) {
                case Circular: {
                    shape = NucLayout.getCircularBond(bond);
                    break;
                }
                case Linear: {
                    shape = NucLayout.getLinearBond(bond);
                    break;
                }
                case Standard: {
                    float_.setLine(bond.n5.location, bond.n3.location);
                    shape = float_;
                    break;
                }
                default: {
                    shape = null;
                }
            }
            if (shape == null) continue;
            if (rectangle2D == null) {
                rectangle2D = shape.getBounds2D();
            } else {
                Rectangle2D.union(rectangle2D, shape.getBounds2D(), rectangle2D);
            }
            graphics2D.draw(shape);
        }
        if (rectangle2D != null) {
            list.add(new ScreenShape(list2, view2D.trToScreen.createTransformedShape(rectangle2D), Integer.MIN_VALUE));
        }
    }

    private void drawSimpleBackbones(Graphics2D graphics2D, boolean[] blArray, float f) {
        for (Strand strand : this.scene.strands) {
            if (strand.size() <= 1) continue;
            for (int i = 1; i < strand.size(); ++i) {
                Nuc nuc = strand.get(i - 1);
                Nuc nuc2 = strand.get(i);
                if (blArray[nuc2.indexInScene()] || (nuc2.isPaired(false) && nuc.isPaired(false) ? !this.settings.drawBackboneInHelix : !this.settings.drawBackboneInLoops)) continue;
                this._backboneDir.setTo(nuc2.location).subtr(nuc.location);
                float f2 = (float)this._backboneDir.length();
                if (f2 < f) continue;
                this._backboneDir.setLength(1.0);
                this._backboneStart.setTo(nuc.location).addScaled(this._backboneDir, this.settings.nucRadius + this.settings.nucOutlineWidth);
                this._backboneEnd.setTo(nuc.location).addScaled(this._backboneDir, f2 - (this.settings.nucRadius + this.settings.nucOutlineWidth));
                this._backboneLine.setLine(this._backboneStart, this._backboneEnd);
                graphics2D.draw(this._backboneLine);
            }
        }
    }

    private void drawCurvedBackbones(Graphics2D graphics2D, boolean[] blArray, float f) {
    }

    private boolean allNucsFitCircle(Nuc nuc, Nuc nuc2, Ellipses.Circle circle) {
        for (int i = nuc.indexInScene(); i <= nuc2.indexInScene(); ++i) {
            if (this.nucFitsCircle(i, circle)) continue;
            return false;
        }
        return true;
    }

    private boolean nucFitsCircle(int n, Ellipses.Circle circle) {
        return Math.abs(this.scene.getNuc((int)n).location.distance(circle.center()) - (double)circle.radius()) > (double)(this.settings.nucRadius / 2.0f);
    }

    private Color getBondColor(Bond bond) {
        if (bond.n5.style != null && bond.n5.style.bondColor != null) {
            return bond.n5.style.bondColor;
        }
        if (bond.n3.style != null && bond.n3.style.bondColor != null) {
            return bond.n3.style.bondColor;
        }
        return this.settings.bondColor;
    }

    @Override
    public Vec2D calcNormalToNuc(Nuc nuc) {
        Vec2D vec2D;
        if (nuc.isPaired() && this.scene.drawMode == SceneDrawMode.Standard) {
            vec2D = new Vec2D(nuc.getPaired().location, nuc.location);
        } else {
            Nuc nuc2 = nuc.getPrev();
            Nuc nuc3 = nuc.getNext();
            if (nuc3 == null && nuc2 == null) {
                vec2D = new Vec2D(1.0, 0.0);
            } else if (nuc3 == null || nuc2 == null) {
                boolean bl = nuc3 == null;
                nuc2 = bl ? nuc2 : nuc3;
                vec2D = new Vec2D(nuc2.location, nuc.location).rotate90();
                if (bl == this.scene.drawFlipped) {
                    vec2D.negate();
                }
            } else {
                Vec2D vec2D2;
                Vec2D vec2D3 = new Vec2D(nuc2.location, nuc.location).normalize(1.0, 0.0);
                vec2D = Vec2D.getMidpoint(vec2D3, vec2D2 = new Vec2D(nuc3.location, nuc.location).normalize(1.0, 0.0));
                if (vec2D.length() < 1.0E-7) {
                    vec2D = new Vec2D(nuc2.location, nuc.location).rotate90();
                }
            }
        }
        if (vec2D.length() == 0.0) {
            vec2D = new Vec2D(1.0, 0.0);
        }
        return vec2D.normalize();
    }

    private IScreenObject drawNucNumber(Graphics2D graphics2D, View2D view2D, Nuc nuc, int n) {
        float f;
        float f2 = this.settings.nucRadius;
        Vec2D vec2D = this.calcNormalToNuc(nuc);
        if (nuc.style != null && nuc.style.numberOffset != 0.0f) {
            vec2D.rotate(nuc.style.numberOffset);
        }
        float f3 = nuc.location.x;
        float f4 = nuc.location.y;
        float f5 = (float)vec2D.x;
        float f6 = (float)vec2D.y;
        float f7 = f3 + f5 * (f2 + this.settings.numberLineMargin);
        float f8 = f4 + f6 * (f2 + this.settings.numberLineMargin);
        Rectangle2D.Float float_ = GraphicsUtil.drawTextCentered(graphics2D, Integer.toString(n), f3 + f5 * (f2 + this.settings.numberDistance), f4 + f6 * (f2 + this.settings.numberDistance));
        float f9 = (float)Math.sqrt(f2 + this.settings.numberLineMargin);
        float f10 = f5 > 0.0f ? float_.x - f9 : float_.x + float_.width + f9;
        float f11 = f = f6 > 0.0f ? float_.y - f9 : float_.y + float_.height + f9;
        float f12 = (double)Math.abs(f5) < 1.0E-5 ? (f - f4) / f6 : ((double)Math.abs(f6) < 1.0E-5 ? (f10 - f3) / f5 : Math.max((f10 - f3) / f5, (f - f4) / f6));
        f10 = f3 + f5 * f12;
        f = f4 + f6 * f12;
        graphics2D.drawLine((int)f7, (int)f8, (int)f10, (int)f);
        return new ScreenShape(n, view2D.trToScreen.createTransformedShape(float_), -1);
    }

    private void drawNucOutline(Graphics2D graphics2D, Nuc nuc, Color color) {
        Ellipse2D.Float float_ = (Ellipse2D.Float)this.nucShapes[nuc.indexInScene()];
        if (float_ == null) {
            return;
        }
        float f = 0.0f;
        this.tmpNucShape.setFrame(float_.x - f, float_.y - f, float_.width + 2.0f * f, float_.height + 2.0f * f);
        graphics2D.setStroke(this.settings.nucOutlineSelStroke);
        graphics2D.setColor(color);
        graphics2D.draw(this.tmpNucShape);
    }

    private Shape getNucShape(Nuc nuc) {
        Ellipse2D.Float float_ = (Ellipse2D.Float)this.nucShapes[nuc.indexInScene()];
        float f = this.settings.nucleotideRadius(nuc);
        if (float_ == null) {
            float_ = new Ellipse2D.Float();
            this.nucShapes[nuc.indexInScene()] = float_;
        }
        float_.x = nuc.location.x - f;
        float_.y = nuc.location.y - f;
        float_.width = float_.height = f * 2.0f;
        return float_;
    }

    private IScreenObject getScreenObject(Nuc nuc, View2D view2D, int n) {
        ScreenNuc screenNuc = this.nucScreenShapes[nuc.indexInScene()];
        if (screenNuc == null) {
            ScreenNuc screenNuc2 = new ScreenNuc(nuc, this.settings);
            this.nucScreenShapes[nuc.indexInScene()] = screenNuc2;
            screenNuc = screenNuc2;
        }
        screenNuc.updateView(view2D);
        screenNuc.setZorder(n);
        return screenNuc;
    }

    @Override
    public boolean addSceneUpdateListener(Consumer<SceneUpdateEvent> consumer) {
        return this.sceneUpdated.add(consumer);
    }

    @Override
    public boolean removeSceneUpdateListener(Consumer<SceneUpdateEvent> consumer) {
        return this.sceneUpdated.remove(consumer);
    }

    @Override
    public boolean addHistoryListener(Consumer<HistoryUpdateEvent> consumer) {
        return this.historyEvent.add(consumer);
    }

    @Override
    public boolean removeHistoryListener(Consumer<HistoryUpdateEvent> consumer) {
        return this.historyEvent.remove(consumer);
    }

    public void suspendUpdates() {
        ++this._suspendUpdatesCounter;
    }

    public void resumeUpdates() {
        if (this._suspendUpdatesCounter == 0) {
            throw new IllegalStateException("resumeUpdates called too many times");
        }
        --this._suspendUpdatesCounter;
    }

    public void suspendRedraw() {
        ++this._suspendRedraw;
    }

    public void resumeRedraw(boolean bl) {
        if (this._suspendRedraw == 0) {
            throw new IllegalStateException("resumeRedraw called too many times");
        }
        --this._suspendRedraw;
        if (bl && this._suspendRedraw == 0) {
            this.redraw();
        }
    }

    @Override
    public void selectionUpdated() {
        this.notifyUpdate(SceneUpdateInfo.Selection, false);
    }

    @Override
    public void viewUpdated() {
        this.notifyUpdate(SceneUpdateInfo.View, false);
    }

    @Override
    public void controlsUpdated() {
        this.notifyUpdate(SceneUpdateInfo.Controls, false);
    }

    @Override
    public void historyUpdated() {
        this.notifyUpdate(SceneUpdateInfo.EditHistory, false);
    }

    @Override
    public void structureUpdated(SceneUpdateInfo sceneUpdateInfo) {
        this.notifyUpdate(sceneUpdateInfo);
    }

    @Override
    public void styleUpdated(SceneUpdateInfo sceneUpdateInfo) {
        this.notifyUpdate(sceneUpdateInfo);
    }

    @Override
    public void layoutUpdated(SceneUpdateInfo sceneUpdateInfo) {
        this.layoutUpdated(sceneUpdateInfo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutUpdated(SceneUpdateInfo sceneUpdateInfo, boolean bl) {
        this.suspendUpdates();
        try {
            for (DrawHandle drawHandle : this.drawHandles) {
                if (drawHandle == null || !drawHandle.isEnabled() || !drawHandle.isValid()) continue;
                drawHandle.layoutUpdated();
            }
        }
        finally {
            this.resumeUpdates();
        }
        this.notifyUpdate(sceneUpdateInfo, bl);
    }

    @Override
    public void notifyUpdate(SceneUpdateInfo sceneUpdateInfo, boolean bl) {
        if (this._suspendUpdatesCounter == 0) {
            if (bl) {
                this.addUndo(sceneUpdateInfo);
            }
            SceneUpdateEvent sceneUpdateEvent = new SceneUpdateEvent(this, sceneUpdateInfo, this.scene);
            this.sceneUpdated.invoke(sceneUpdateEvent);
        }
    }

    @Override
    public void notifyUpdate(SceneUpdateInfo sceneUpdateInfo) {
        this.notifyUpdate(sceneUpdateInfo, true);
    }

    @Override
    public void clearUndo() {
        this.scene.history.clear();
        this.addUndo(SceneUpdateInfo.Initial);
    }

    @Override
    public void addUndo(SceneUpdateInfo sceneUpdateInfo) {
        HistoryState historyState = new HistoryState(this.scene.getState(), sceneUpdateInfo);
        historyState.put("selection", this.getSelectionState());
        this.scene.history.store(historyState);
        this.historyEvent.invoke(new HistoryUpdateEvent(this, true, historyState));
        this.historyUpdated();
    }

    @Override
    public boolean canUndo() {
        return this.scene.history.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.scene.history.canRedo();
    }

    @Override
    public void undo() {
        if (this.scene.history.canUndo()) {
            this.applyHistoryState(this.scene.history.undo());
        }
    }

    @Override
    public void redo() {
        if (this.scene.history.canRedo()) {
            this.applyHistoryState(this.scene.history.redo());
        }
    }

    private void applyHistoryState(HistoryState historyState) {
        this.suspendRedraw();
        try {
            this.scene.loadState(historyState.state);
            this.historyEvent.invoke(new HistoryUpdateEvent(this, false, historyState));
            this.notifyUpdate(SceneUpdateInfo.GotoHistory, false);
            this.historyUpdated();
            this.setSelectionState(historyState.get("selection", this.EMPTY_SELECTION));
        }
        finally {
            this.resumeRedraw(true);
        }
    }

    public void setSelType(SelectionType selectionType) {
        this.selType = selectionType;
    }

    public void expandSelection() {
        boolean[] blArray = new boolean[this.scene.getNucCount()];
        boolean bl = this.isFullMotifSelected();
        for (Nuc nuc : this.selection.toArray(new Nuc[this.selection.size()])) {
            Motif.Branch branch;
            if (blArray[nuc.indexInScene()]) continue;
            IMotif iMotif = bl ? nuc.getBranch() : (branch = nuc.isPaired() ? nuc.getHelix() : nuc.getLoop());
            if (branch == null) continue;
            Collection<Nuc> collection = branch.getBases();
            for (Nuc nuc2 : collection) {
                blArray[nuc2.indexInScene()] = true;
            }
            this.selection.addAll(collection);
        }
        this.selectionUpdated();
    }

    private boolean isFullMotifSelected() {
        boolean[] blArray = new boolean[this.scene.getNucCount()];
        for (Nuc nuc : this.selection) {
            IMotif iMotif;
            if (blArray[nuc.indexInScene()] || (iMotif = nuc.isPaired() ? nuc.getHelix() : nuc.getLoop()) == null) continue;
            for (Nuc nuc2 : iMotif.getBases()) {
                if (this.selection.contains(nuc2)) {
                    blArray[nuc2.indexInScene()] = true;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public void selectAll() {
        this.selection.clear();
        for (Strand strand : this.scene.strands) {
            this.selection.addAll(strand);
        }
        this.selectionUpdated();
    }

    public static enum SelectionType {
        Individual,
        Helix,
        Loop,
        HelixOrLoop,
        Domain,
        Branch,
        DomainOrBranch;

    }

    private static class ScreenNuc
    implements IScreenObject {
        public final int selectionBorder = 3;
        final float OUTLINE_WIDTH = 0.5f;
        public final Nuc nuc;
        public int zorder;
        public DrawSettings settings;
        public final Point p = new Point();
        float screenRadius;
        int hitDistance;
        int hitDistanceSq;
        Rectangle bounds = new Rectangle();

        public ScreenNuc(Nuc nuc, DrawSettings drawSettings) {
            this.nuc = nuc;
            this.settings = drawSettings;
        }

        public void setZorder(int n) {
            this.zorder = n;
        }

        @Override
        public void updateView(View2D view2D) {
            view2D.trToScreen.transform(this.nuc.location, this.p);
            this.screenRadius = (float)((double)(this.settings.nucRadius + ((BasicStroke)this.settings.nucOutlineSelStroke).getLineWidth() / 2.0f) * view2D.trToScreen.getScaleX());
            this.hitDistanceSq = (int)Math.ceil((this.screenRadius + 3.0f) * (this.screenRadius + 3.0f));
            this.hitDistance = (int)Math.ceil(this.screenRadius + 3.0f);
            this.bounds.setBounds(Math.round((float)this.p.x - this.screenRadius), Math.round((float)this.p.y - this.screenRadius), Math.round(2.0f * this.screenRadius), Math.round(2.0f * this.screenRadius));
        }

        @Override
        public boolean hitTest(Point2D point2D) {
            return Vec2D.distanceSq(this.p.x, this.p.y, point2D.getX(), point2D.getY()) < (double)this.hitDistanceSq;
        }

        @Override
        public boolean hitTest(Rectangle rectangle) {
            int n = Math.abs(this.p.x - (rectangle.x + rectangle.width / 2));
            int n2 = Math.abs(this.p.y - (rectangle.y + rectangle.height / 2));
            if (n > rectangle.width / 2 + this.hitDistance) {
                return false;
            }
            if (n2 > rectangle.height / 2 + this.hitDistance) {
                return false;
            }
            if (n <= rectangle.width / 2 || n2 <= rectangle.height / 2) {
                return true;
            }
            double d = (n - rectangle.width / 2) * (n - rectangle.width / 2) + (n2 - rectangle.height / 2) * (n2 - rectangle.height / 2);
            return d <= (double)this.hitDistanceSq;
        }

        @Override
        public Nuc getModel() {
            return this.nuc;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        @Override
        public int getZOrder() {
            return this.zorder;
        }
    }

    public static abstract class Colors {
        public static Color hot = new Color(16711758);
        public static Color warm = new Color(0xFF9900);
        public static Color cool = new Color(2339839);
        public static Color cold = new Color(2642333);
        public static Color earth = new Color(6698771);
        public static Color sand = new Color(11183649);
        public static Color grass = new Color(541192);
    }

    private static class NucGroup
    implements INucGroup {
        public final Collection<Nuc> list;

        public NucGroup(Collection<Nuc> collection) {
            this.list = collection;
        }

        public NucGroup() {
            this.list = new ArrayList<Nuc>();
        }

        @Override
        public Collection<Nuc> getBases() {
            return this.list;
        }
    }

    private class MouseHandler
    extends InputAdapter.Mouse {
        static final int SELECTING = 1;
        static final int DRAGGING = 2;
        static final int EDITING = 3;
        static final int FORMATTING = 4;
        boolean dragIsValid;
        int state;
        int prevModifiers;
        Point prevPos;
        Point curPos;
        Point startPos;
        Object dragObject = null;
        Nuc hoverNuc = null;
        Nuc deselectNuc;

        private MouseHandler() {
        }

        void storeMouse(MouseEvent mouseEvent) {
            this.prevPos = this.curPos = mouseEvent.getPoint();
            this.startPos = this.curPos;
            this.dragIsValid = false;
            this.deselectNuc = null;
            this.prevModifiers = mouseEvent.getModifiers();
        }

        void updateMousePos(MouseEvent mouseEvent) {
            this.prevPos = this.curPos;
            this.curPos = mouseEvent.getPoint();
        }

        @Override
        protected void onMouseInput(InputAdapter.InputType inputType, MouseEvent mouseEvent) {
            block24: {
                int n = mouseEvent.getModifiers();
                if (this.state == 2 && this.prevModifiers != n && inputType == InputAdapter.InputType.Drag && !(this.dragObject instanceof DrawHandle)) {
                    this.completeAction(this.prevModifiers);
                    this.storeMouse(mouseEvent);
                    RnaDrawController.this.storeRnaCoords();
                }
                block0 : switch (inputType) {
                    case Move: {
                        this.updateMousePos(mouseEvent);
                        IScreenObject iScreenObject = RnaDrawController.this.hitTest(RnaDrawController.this.screenObjects, this.curPos, true);
                        if (iScreenObject == null) {
                            this.hoverNuc = null;
                            ((JComponent)RnaDrawController.this.canvasComponent).setToolTipText(null);
                            break;
                        }
                        Nuc nuc = (Nuc)iScreenObject.getModel();
                        if (nuc == this.hoverNuc) break;
                        this.hoverNuc = nuc;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(nuc.symbol).append(' ').append(nuc.indexInStrand() + 1);
                        if (!nuc.isPaired()) {
                            stringBuilder.append(" Loop: ").append(nuc.getLoop().getType().name());
                        }
                        ((JComponent)RnaDrawController.this.canvasComponent).setToolTipText(stringBuilder.toString());
                        break;
                    }
                    case MouseDown: {
                        this.storeMouse(mouseEvent);
                        if (mouseEvent.getButton() != 1) break;
                        IScreenObject iScreenObject = RnaDrawController.this.hitTest(RnaDrawController.this.screenObjects, this.curPos, false);
                        Object object = this.dragObject = iScreenObject == null ? null : iScreenObject.getModel();
                        if (this.dragObject == null) {
                            this.state = 1;
                            RnaDrawController.this.selectionBand.setFrameFromDiagonal(this.startPos, this.startPos);
                            break;
                        }
                        if ((n & EDIT_CLICK_MASK) == EDIT_CLICK_MASK) {
                            this.state = 3;
                            if (!(this.dragObject instanceof Nuc)) break;
                            RnaDrawController.this.focused = (Nuc)this.dragObject;
                            Point2D point2D = RnaDrawController.this.canvas.getView().toScreen(RnaDrawController.this.focused.location, new Point2D.Float());
                            RnaDrawController.this.editBond.setLine(point2D, this.curPos);
                            break;
                        }
                        if (this.dragObject instanceof Number) {
                            this.state = 4;
                            break;
                        }
                        this.state = 2;
                        RnaDrawController.this.storeRnaCoords();
                        if (this.dragObject instanceof Nuc) {
                            boolean bl = 0 != (n & SELECTION_ADD_MASK);
                            this.deselectNuc = RnaDrawController.this.updateSelection(bl, (Nuc)this.dragObject, SELECT_ONLY);
                            break;
                        }
                        if (!(this.dragObject instanceof DrawHandle)) break;
                        ((DrawHandle)this.dragObject).dragStarted(this.startPos);
                        break;
                    }
                    case Drag: {
                        this.updateMousePos(mouseEvent);
                        if (!this.dragIsValid) {
                            int n2 = Math.abs(this.curPos.x - this.startPos.x);
                            int n3 = Math.abs(this.curPos.y - this.startPos.y);
                            this.dragIsValid = n2 > 2 || n3 > 2 || n2 + n3 > 3;
                        }
                        switch (this.state) {
                            case 2: {
                                if (this.dragIsValid) {
                                    RnaDrawController.this.resetRnaCoords();
                                    SceneController.DragOpts dragOpts = new SceneController.DragOpts(0 != (n & DRAG_EXPANDED_MOTIF_MASK), 0 != (n & DRAG_SPECIAL_MASK), RnaDrawController.this.programSettings().ShowHints);
                                    if (this.dragObject instanceof Nuc) {
                                        RnaDrawController.this.dragNucs((Nuc)this.dragObject, this.startPos, this.prevPos, this.curPos, dragOpts);
                                        break;
                                    }
                                    if (!(this.dragObject instanceof DrawHandle)) break block0;
                                    ((DrawHandle)this.dragObject).drag(this.startPos, this.prevPos, this.curPos, dragOpts);
                                    break;
                                }
                                break block24;
                            }
                            case 1: {
                                RnaDrawController.this.selectionBand.setFrameFromDiagonal(this.startPos, this.curPos);
                                RnaDrawController.this.redraw();
                                break;
                            }
                            case 3: {
                                RnaDrawController.this.editBond.setLine(RnaDrawController.this.editBond.x1, RnaDrawController.this.editBond.y1, this.curPos.x, this.curPos.y);
                                RnaDrawController.this.redraw();
                                break;
                            }
                            case 4: {
                                if (this.dragIsValid) {
                                    if (this.dragObject instanceof Number) {
                                        RnaDrawController.this.rotateNumber(RnaDrawController.this.scene.getNuc((Integer)this.dragObject - 1), RnaDrawController.this.canvas.getView().toModel(this.curPos));
                                    }
                                    RnaDrawController.this.redraw();
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case MouseUp: {
                        this.updateMousePos(mouseEvent);
                        this.completeAction(n);
                        this.dragObject = null;
                        this.state = 0;
                        RnaDrawController.this.redraw();
                    }
                }
            }
        }

        private void completeAction(int n) {
            if (this.state == 1) {
                boolean bl = 0 != (n & SELECTION_ADD_MASK);
                RnaDrawController.this.updateSelection(bl, Rectangles.fromPoints(this.startPos, this.curPos));
            } else if (this.state == 3) {
                IScreenObject iScreenObject = RnaDrawController.this.hitTest(RnaDrawController.this.screenObjects, this.curPos, true);
                if (iScreenObject != null && iScreenObject.getModel() != this.dragObject) {
                    RnaDrawController.this.addBond((Nuc)this.dragObject, (Nuc)iScreenObject.getModel());
                }
            } else if (this.state == 4) {
                RnaDrawController.this.addUndo(SceneUpdateInfo.FormatBases.subType("Rotated Number Label"));
            } else if (this.state == 2) {
                if (this.dragIsValid && !this.startPos.equals(this.curPos)) {
                    if (this.dragObject instanceof Nuc) {
                        boolean bl = 0 != (n & DRAG_SPECIAL_MASK);
                        RnaDrawController.this.addUndo(bl ? SceneUpdateInfo.Rotate : SceneUpdateInfo.Layout);
                    } else if (this.dragObject instanceof DrawHandle) {
                        ((DrawHandle)this.dragObject).dragComplete(true);
                    }
                } else {
                    if (!this.dragIsValid && this.deselectNuc != null && 0 != (n & SELECTION_ADD_MASK)) {
                        RnaDrawController.this.updateSelection(true, this.deselectNuc, DESELECT_ONLY);
                    }
                    if (this.dragObject instanceof DrawHandle) {
                        ((DrawHandle)this.dragObject).dragComplete(false);
                    }
                }
            }
        }
    }

    public static enum BehaviorMode {
        NUC,
        BRANCH;

    }
}

