/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import ur_rna.StructureEditor.AppActions;
import ur_rna.StructureEditor.services.RecentFileList;
import ur_rna.Utilities.swing.MergeItem;
import ur_rna.Utilities.swing.MergeMenu;

public class RecentFileMenuManager {
    private final MergeMenu parent;
    public HashMap<MergeItem, RecentFileList.RecentFile> menuMap = new HashMap();

    public Container getComponent() {
        return this.parent;
    }

    public MergeMenu getMenu() {
        return this.parent;
    }

    public void setRecent(RecentFileList recentFileList) {
        for (MergeItem object : this.menuMap.keySet()) {
            this.parent.remove(object);
        }
        int n = 100;
        for (RecentFileList.RecentFile recentFile : recentFileList.getFiles()) {
            MergeItem mergeItem = new MergeItem(this.getMenuText(recentFile), n++);
            this.menuMap.put(mergeItem, recentFile);
            mergeItem.addActionListener(this::menuClickListener);
            mergeItem.setVisible(true);
            this.parent.add(mergeItem);
        }
    }

    private void menuClickListener(ActionEvent actionEvent) {
        RecentFileList.RecentFile recentFile = this.menuMap.get(actionEvent.getSource());
        if (recentFile != null) {
            AppActions.openFile(recentFile.path, recentFile.type);
        }
    }

    private String getMenuText(RecentFileList.RecentFile recentFile) {
        File file = new File(recentFile.path);
        return file.getName() + "  in  " + file.getParent() + (String)(recentFile.type == null ? "" : "   [" + recentFile.type.name() + "]");
    }

    public RecentFileMenuManager(MergeMenu mergeMenu) {
        if (mergeMenu == null) {
            throw new IllegalArgumentException("RecentFileMenuManager parent cannot be null.");
        }
        this.parent = mergeMenu;
    }
}

