/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.services;

import java.util.ArrayList;
import java.util.List;

public class History<T> {
    private ArrayList<T> stack = new ArrayList();
    private int pos = -1;

    public void store(T t) {
        if (this.canRedo()) {
            this.clearRedo();
        }
        this.stack.add(t);
        ++this.pos;
    }

    public List<T> entries() {
        return this.stack;
    }

    public int size() {
        return this.stack.size();
    }

    public int position() {
        return this.pos;
    }

    public T get(int n) {
        return this.stack.get(n);
    }

    public T current() {
        if (this.pos == -1) {
            throw new IndexOutOfBoundsException();
        }
        return this.stack.get(this.pos);
    }

    private void clearRedo() {
        for (int i = this.stack.size() - 1; i > this.pos; --i) {
            this.stack.remove(i);
        }
    }

    public void clear() {
        this.stack.clear();
        this.pos = -1;
    }

    public T undo() {
        if (!this.canUndo()) {
            throw new IndexOutOfBoundsException();
        }
        return this.stack.get(--this.pos);
    }

    public T redo() {
        if (!this.canRedo()) {
            throw new IndexOutOfBoundsException();
        }
        return this.stack.get(++this.pos);
    }

    public boolean canUndo() {
        return this.pos > 0;
    }

    public boolean canRedo() {
        return this.pos < this.stack.size() - 1;
    }
}

