/*
 * Decompiled with CFR 0.152.
 */
package ur_rna.StructureEditor.models;

import java.util.ArrayList;
import java.util.Arrays;
import ur_rna.StructureEditor.FileType;
import ur_rna.StructureEditor.models.DrawSettings;
import ur_rna.StructureEditor.models.RnaScene;
import ur_rna.StructureEditor.services.fileIO.RnaFileIO;
import ur_rna.Utilities.PathTools;
import ur_rna.Utilities.Strings;

public class RnaSceneGroup
extends ArrayList<RnaScene> {
    private String filePath;
    private FileType originalType = FileType.AnyOpenable;
    private String title;
    public DrawSettings settings;

    public String getFilePath() {
        return this.filePath;
    }

    public FileType getFileType() {
        return this.originalType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int structureCount() {
        return this.size();
    }

    public void setSource(String string, FileType fileType) {
        this.filePath = string;
        this.originalType = fileType;
    }

    public static RnaSceneGroup from(RnaScene ... rnaSceneArray) {
        RnaSceneGroup rnaSceneGroup = new RnaSceneGroup();
        rnaSceneGroup.addAll(Arrays.asList(rnaSceneArray));
        rnaSceneGroup.guessTitle();
        return rnaSceneGroup;
    }

    public void guessTitle() {
        if (!Strings.isEmpty(this.title)) {
            return;
        }
        for (RnaScene rnaScene : this) {
            if (Strings.isEmpty(rnaScene.title)) continue;
            this.title = RnaFileIO.stripEnergyTitle(rnaScene.title);
            return;
        }
        if (!Strings.isEmpty(this.filePath)) {
            this.title = PathTools.getBaseName(this.filePath);
        }
    }

    public RnaSceneGroup subset(RnaScene ... rnaSceneArray) {
        RnaSceneGroup rnaSceneGroup = this.copyProps();
        rnaSceneGroup.addAll(Arrays.asList(rnaSceneArray));
        rnaSceneGroup.guessTitle();
        return rnaSceneGroup;
    }

    public RnaSceneGroup subset(int ... nArray) {
        RnaSceneGroup rnaSceneGroup = this.copyProps();
        for (int i = 0; i < nArray.length; ++i) {
            rnaSceneGroup.add((RnaScene)this.get(i));
        }
        rnaSceneGroup.guessTitle();
        return rnaSceneGroup;
    }

    private RnaSceneGroup copyProps() {
        RnaSceneGroup rnaSceneGroup = new RnaSceneGroup();
        rnaSceneGroup.filePath = this.filePath;
        rnaSceneGroup.originalType = this.originalType;
        rnaSceneGroup.title = this.title;
        rnaSceneGroup.settings = this.settings;
        return rnaSceneGroup;
    }
}

